/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services;

import io.qase.api.enums.Filters;
import io.qase.api.enums.RunResultStatus;
import io.qase.api.inner.RouteFilter;
import io.qase.api.models.v1.testrunresults.Step;
import io.qase.api.models.v1.testrunresults.TestRunResult;
import io.qase.api.models.v1.testrunresults.TestRunResults;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public interface TestRunResultService {
    public TestRunResults getAll(String var1, int var2, int var3, RouteFilter var4);

    public TestRunResults getAll(String var1);

    public TestRunResult get(String var1, String var2);

    public String create(String var1, long var2, long var4, RunResultStatus var6, Duration var7, Integer var8, String var9, Boolean var10, Step ... var11);

    public String create(String var1, long var2, long var4, RunResultStatus var6, Duration var7, Integer var8, String var9, String var10, Boolean var11, Step ... var12);

    public String create(String var1, long var2, long var4, RunResultStatus var6);

    public String update(String var1, long var2, String var4, RunResultStatus var5, Duration var6, Integer var7, String var8, Boolean var9, Step ... var10);

    public String update(String var1, long var2, String var4, RunResultStatus var5, Duration var6);

    public String update(String var1, long var2, String var4, RunResultStatus var5);

    public boolean delete(String var1, long var2, String var4);

    default public Filter filter() {
        return new Filter();
    }

    public static class Filter
    implements RouteFilter {
        private final Map<Filters, String> filters = new EnumMap<Filters, String>(Filters.class);
        private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

        private Filter() {
        }

        @Override
        public Map<Filters, String> getFilters() {
            return Collections.unmodifiableMap(this.filters);
        }

        public Filter status(RunResultStatus status) {
            this.filters.put(Filters.status, status.name());
            return this;
        }

        public Filter member(int id) {
            this.filters.put(Filters.member, String.valueOf(id));
            return this;
        }

        public Filter run(int id) {
            this.filters.put(Filters.run, String.valueOf(id));
            return this;
        }

        public Filter caseId(int id) {
            this.filters.put(Filters.case_id, String.valueOf(id));
            return this;
        }

        public Filter fromEndTime(LocalDateTime fromEndTime) {
            this.filters.put(Filters.from_end_time, this.dateTimeFormatter.format(fromEndTime));
            return this;
        }

        public Filter toEndTime(LocalDateTime toEndTime) {
            this.filters.put(Filters.to_end_time, this.dateTimeFormatter.format(toEndTime));
            return this;
        }
    }
}

