/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services.v1;

import io.qase.api.QaseApiClient;
import io.qase.api.models.v1.attachments.Attachment;
import io.qase.api.models.v1.attachments.Attachments;
import io.qase.api.services.AttachmentService;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class AttachmentServiceImpl
implements AttachmentService {
    private final QaseApiClient qaseApiClient;

    public AttachmentServiceImpl(QaseApiClient qaseApiClient) {
        this.qaseApiClient = qaseApiClient;
    }

    @Override
    public Attachments getAll(int limit, int offset) {
        return this.qaseApiClient.get(Attachments.class, "/attachment", Collections.emptyMap(), null, limit, offset);
    }

    @Override
    public Attachments getAll() {
        return this.getAll(100, 0);
    }

    @Override
    public Attachment get(String hash) {
        return this.qaseApiClient.get(Attachment.class, "/attachment/{hash}", Collections.singletonMap("hash", hash), Collections.emptyMap());
    }

    @Override
    public List<Attachment> add(String projectCode, File file) {
        return Arrays.asList((Object[])this.qaseApiClient.post(Attachment[].class, "/attachment/{code}", Collections.singletonMap("code", projectCode), file));
    }

    @Override
    public boolean delete(String hash) {
        return (Boolean)this.qaseApiClient.delete("/attachment/{hash}", Collections.singletonMap("hash", hash)).get("status");
    }
}

