/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services.v1;

import io.qase.api.QaseApiClient;
import io.qase.api.inner.RouteFilter;
import io.qase.api.models.v1.defects.Defect;
import io.qase.api.models.v1.defects.Defects;
import io.qase.api.services.DefectService;
import java.util.Collections;
import java.util.HashMap;

public final class DefectServiceImpl
implements DefectService {
    private final QaseApiClient qaseApiClient;

    public DefectServiceImpl(QaseApiClient qaseApiClient) {
        this.qaseApiClient = qaseApiClient;
    }

    @Override
    public Defects getAll(String projectCode, int limit, int offset, RouteFilter filter) {
        return this.qaseApiClient.get(Defects.class, "/defect/{code}", Collections.singletonMap("code", projectCode), filter, limit, offset);
    }

    @Override
    public Defects getAll(String projectCode) {
        return this.getAll(projectCode, 100, 0, this.filter());
    }

    @Override
    public Defect get(String projectCode, long id) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("id", id);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        return this.qaseApiClient.get(Defect.class, "/defect/{code}/{id}", routeParams, queryParams);
    }

    @Override
    public boolean resolve(String projectCode, long defectId) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("id", defectId);
        return (Boolean)this.qaseApiClient.patch("/defect/{code}/resolve/{id}", routeParams).get("status");
    }

    @Override
    public boolean delete(String projectCode, long defectId) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("id", defectId);
        return (Boolean)this.qaseApiClient.delete("/defect/{code}/{id}", routeParams).get("status");
    }
}

