/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services.v1;

import io.qase.api.QaseApiClient;
import io.qase.api.inner.RouteFilter;
import io.qase.api.models.v1.milestones.Milestone;
import io.qase.api.models.v1.milestones.Milestones;
import io.qase.api.models.v1.milestones.NewMilestone;
import io.qase.api.services.MilestoneService;
import java.util.Collections;
import java.util.HashMap;

public final class MilestoneServiceImpl
implements MilestoneService {
    private final QaseApiClient qaseApiClient;

    public MilestoneServiceImpl(QaseApiClient qaseApiClient) {
        this.qaseApiClient = qaseApiClient;
    }

    @Override
    public Milestones getAll(String projectCode, int limit, int offset, RouteFilter filter) {
        return this.qaseApiClient.get(Milestones.class, "/milestone/{code}", Collections.singletonMap("code", projectCode), filter, limit, offset);
    }

    @Override
    public Milestones getAll(String projectCode, RouteFilter filter) {
        return this.getAll(projectCode, 100, 0, filter);
    }

    @Override
    public Milestones getAll(String projectCode) {
        return this.getAll(projectCode, 100, 0, this.filter());
    }

    @Override
    public Milestone get(String projectCode, long milestoneId) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("id", milestoneId);
        return this.qaseApiClient.get(Milestone.class, "/milestone/{code}/{id}", routeParams);
    }

    @Override
    public long create(String projectCode, String title, String description) {
        NewMilestone createUpdateMilestonesRequest = new NewMilestone(title);
        createUpdateMilestonesRequest.setDescription(description);
        return this.qaseApiClient.post(Milestone.class, "/milestone/{code}", Collections.singletonMap("code", projectCode), createUpdateMilestonesRequest).getId();
    }

    @Override
    public long create(String projectCode, String title) {
        return this.create(projectCode, title, null);
    }

    @Override
    public boolean delete(String projectCode, long id) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("id", id);
        return (Boolean)this.qaseApiClient.delete("/milestone/{code}/{id}", routeParams).get("status");
    }

    @Override
    public long update(String projectCode, long id, String title, String description) {
        NewMilestone createUpdateMilestonesRequest = new NewMilestone(title);
        createUpdateMilestonesRequest.setDescription(description);
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("id", id);
        return this.qaseApiClient.patch(Milestone.class, "/milestone/{code}/{id}", routeParams, createUpdateMilestonesRequest).getId();
    }

    @Override
    public long update(String projectCode, long id, String title) {
        return this.update(projectCode, id, title, null);
    }
}

