/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services.v1;

import io.qase.api.QaseApiClient;
import io.qase.api.inner.RouteFilter;
import io.qase.api.models.v1.shared_steps.NewSharedStep;
import io.qase.api.models.v1.shared_steps.SharedStep;
import io.qase.api.models.v1.shared_steps.SharedSteps;
import io.qase.api.services.SharedStepService;
import java.util.Collections;
import java.util.HashMap;

public final class SharedStepServiceImpl
implements SharedStepService {
    private final QaseApiClient qaseApiClient;

    public SharedStepServiceImpl(QaseApiClient qaseApiClient) {
        this.qaseApiClient = qaseApiClient;
    }

    @Override
    public SharedSteps getAll(String projectCode, int limit, int offset, RouteFilter filter) {
        return this.qaseApiClient.get(SharedSteps.class, "/shared_step/{code}", Collections.singletonMap("code", projectCode), filter, limit, offset);
    }

    @Override
    public SharedSteps getAll(String projectCode, RouteFilter filter) {
        return this.getAll(projectCode, 100, 0, filter);
    }

    @Override
    public SharedSteps getAll(String projectCode) {
        return this.getAll(projectCode, 100, 0, this.filter());
    }

    @Override
    public SharedStep get(String projectCode, String hash) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("hash", hash);
        return this.qaseApiClient.get(SharedStep.class, "/shared_step/{code}/{hash}", routeParams);
    }

    @Override
    public String create(String projectCode, String title, String action, String expectedResult) {
        NewSharedStep createUpdateSharedStepRequest = new NewSharedStep(title, action);
        createUpdateSharedStepRequest.setExpectedResult(expectedResult);
        return this.qaseApiClient.post(SharedStep.class, "/shared_step/{code}", Collections.singletonMap("code", projectCode), createUpdateSharedStepRequest).getHash();
    }

    @Override
    public String create(String projectCode, String title, String action) {
        return this.create(projectCode, title, action, null);
    }

    @Override
    public boolean delete(String projectCode, String hash) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("hash", hash);
        return (Boolean)this.qaseApiClient.delete("/shared_step/{code}/{hash}", routeParams).get("status");
    }

    @Override
    public String update(String projectCode, String hash, String title, String action, String expectedResult) {
        NewSharedStep createUpdateSharedStepRequest = new NewSharedStep(title, action);
        createUpdateSharedStepRequest.setExpectedResult(expectedResult);
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("hash", hash);
        return this.qaseApiClient.patch(SharedStep.class, "/shared_step/{code}/{hash}", routeParams, createUpdateSharedStepRequest).getHash();
    }

    @Override
    public String update(String projectCode, String hash, String title, String action) {
        return this.update(projectCode, hash, title, action, null);
    }
}

