/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services.v1;

import io.qase.api.QaseApiClient;
import io.qase.api.enums.RunResultStatus;
import io.qase.api.inner.RouteFilter;
import io.qase.api.models.v1.testrunresults.NewTestRunResults;
import io.qase.api.models.v1.testrunresults.Step;
import io.qase.api.models.v1.testrunresults.TestRunResult;
import io.qase.api.models.v1.testrunresults.TestRunResults;
import io.qase.api.services.TestRunResultService;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

public final class TestRunResultServiceImpl
implements TestRunResultService {
    private final QaseApiClient qaseApiClient;

    public TestRunResultServiceImpl(QaseApiClient qaseApiClient) {
        this.qaseApiClient = qaseApiClient;
    }

    @Override
    public TestRunResults getAll(String projectCode, int limit, int offset, RouteFilter filter) {
        return this.qaseApiClient.get(TestRunResults.class, "/result/{code}", Collections.singletonMap("code", projectCode), filter, limit, offset);
    }

    @Override
    public TestRunResults getAll(String projectCode) {
        return this.getAll(projectCode, 100, 0, this.filter());
    }

    @Override
    public TestRunResult get(String projectCode, String hash) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("hash", hash);
        return this.qaseApiClient.get(TestRunResult.class, "/result/{code}/{hash}", routeParams);
    }

    @Override
    public String create(String projectCode, long runId, long caseId, RunResultStatus status, Duration timeSpent, Integer memberId, String comment, Boolean isDefect, Step ... steps) {
        return this.create(projectCode, runId, caseId, status, timeSpent, memberId, comment, null, isDefect, steps);
    }

    @Override
    public String create(String projectCode, long runId, long caseId, RunResultStatus status, Duration timeSpent, Integer memberId, String comment, String stacktrace, Boolean isDefect, Step ... steps) {
        NewTestRunResults newTestRunResults = NewTestRunResults.builder().caseId(caseId).status(status).time(timeSpent == null ? null : Long.valueOf(timeSpent.getSeconds())).memberId(memberId).comment(comment).stacktrace(stacktrace).defect(isDefect).steps(Arrays.asList(steps)).build();
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("run_id", runId);
        return this.qaseApiClient.post(TestRunResult.class, "/result/{code}/{run_id}", routeParams, newTestRunResults).getHash();
    }

    @Override
    public String create(String projectCode, long runId, long caseId, RunResultStatus status) {
        return this.create(projectCode, runId, caseId, status, null, null, null, null, new Step[0]);
    }

    @Override
    public String update(String projectCode, long runId, String hash, RunResultStatus status, Duration timeSpent, Integer memberId, String comment, Boolean isDefect, Step ... steps) {
        NewTestRunResults newTestRunResults = NewTestRunResults.builder().status(status).time(timeSpent == null ? null : Long.valueOf(timeSpent.getSeconds())).memberId(memberId).comment(comment).defect(isDefect).steps(steps == null ? null : Arrays.asList(steps)).build();
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("run_id", runId);
        routeParams.put("hash", hash);
        return this.qaseApiClient.patch(TestRunResult.class, "/result/{code}/{run_id}/{hash}", routeParams, newTestRunResults).getHash();
    }

    @Override
    public String update(String projectCode, long runId, String hash, RunResultStatus status, Duration timeSpent) {
        return this.update(projectCode, runId, hash, status, timeSpent, null, null, null, new Step[0]);
    }

    @Override
    public String update(String projectCode, long runId, String hash, RunResultStatus status) {
        return this.update(projectCode, runId, hash, status, null, null, null, null, new Step[0]);
    }

    @Override
    public boolean delete(String projectCode, long runId, String hash) {
        HashMap<String, Object> routeParams = new HashMap<String, Object>();
        routeParams.put("code", projectCode);
        routeParams.put("run_id", runId);
        routeParams.put("hash", hash);
        return (Boolean)this.qaseApiClient.delete("/result/{code}/{run_id}/{hash}", routeParams).get("status");
    }
}

