/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.CustomFieldCreate;
import io.qase.client.model.CustomFieldResponse;
import io.qase.client.model.CustomFieldUpdate;
import io.qase.client.model.CustomFieldsResponse;
import io.qase.client.model.Filters1;
import io.qase.client.model.IdResponse;
import io.qase.client.model.Response;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CustomFieldsApi {
    private ApiClient localVarApiClient;

    public CustomFieldsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomFieldsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createCustomFieldCall(CustomFieldCreate customFieldCreate, ApiCallback _callback) throws QaseException {
        CustomFieldCreate localVarPostBody = customFieldCreate;
        String localVarPath = "/custom_field";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCustomFieldValidateBeforeCall(CustomFieldCreate customFieldCreate, ApiCallback _callback) throws QaseException {
        if (customFieldCreate == null) {
            throw new QaseException("Missing the required parameter 'customFieldCreate' when calling createCustomField(Async)");
        }
        Call localVarCall = this.createCustomFieldCall(customFieldCreate, _callback);
        return localVarCall;
    }

    public IdResponse createCustomField(CustomFieldCreate customFieldCreate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.createCustomFieldWithHttpInfo(customFieldCreate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> createCustomFieldWithHttpInfo(CustomFieldCreate customFieldCreate) throws QaseException {
        Call localVarCall = this.createCustomFieldValidateBeforeCall(customFieldCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCustomFieldAsync(CustomFieldCreate customFieldCreate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.createCustomFieldValidateBeforeCall(customFieldCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCustomFieldCall(Integer id, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/custom_field/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCustomFieldValidateBeforeCall(Integer id, ApiCallback _callback) throws QaseException {
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling deleteCustomField(Async)");
        }
        Call localVarCall = this.deleteCustomFieldCall(id, _callback);
        return localVarCall;
    }

    public Response deleteCustomField(Integer id) throws QaseException {
        ApiResponse<Response> localVarResp = this.deleteCustomFieldWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Response> deleteCustomFieldWithHttpInfo(Integer id) throws QaseException {
        Call localVarCall = this.deleteCustomFieldValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCustomFieldAsync(Integer id, ApiCallback<Response> _callback) throws QaseException {
        Call localVarCall = this.deleteCustomFieldValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCustomFieldCall(Integer id, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/custom_field/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomFieldValidateBeforeCall(Integer id, ApiCallback _callback) throws QaseException {
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling getCustomField(Async)");
        }
        Call localVarCall = this.getCustomFieldCall(id, _callback);
        return localVarCall;
    }

    public CustomFieldResponse getCustomField(Integer id) throws QaseException {
        ApiResponse<CustomFieldResponse> localVarResp = this.getCustomFieldWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<CustomFieldResponse> getCustomFieldWithHttpInfo(Integer id) throws QaseException {
        Call localVarCall = this.getCustomFieldValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<CustomFieldResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCustomFieldAsync(Integer id, ApiCallback<CustomFieldResponse> _callback) throws QaseException {
        Call localVarCall = this.getCustomFieldValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<CustomFieldResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCustomFieldsCall(Filters1 filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/custom_field";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomFieldsValidateBeforeCall(Filters1 filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        Call localVarCall = this.getCustomFieldsCall(filters, limit, offset, _callback);
        return localVarCall;
    }

    public CustomFieldsResponse getCustomFields(Filters1 filters, Integer limit, Integer offset) throws QaseException {
        ApiResponse<CustomFieldsResponse> localVarResp = this.getCustomFieldsWithHttpInfo(filters, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<CustomFieldsResponse> getCustomFieldsWithHttpInfo(Filters1 filters, Integer limit, Integer offset) throws QaseException {
        Call localVarCall = this.getCustomFieldsValidateBeforeCall(filters, limit, offset, null);
        Type localVarReturnType = new TypeToken<CustomFieldsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCustomFieldsAsync(Filters1 filters, Integer limit, Integer offset, ApiCallback<CustomFieldsResponse> _callback) throws QaseException {
        Call localVarCall = this.getCustomFieldsValidateBeforeCall(filters, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<CustomFieldsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCustomFieldCall(Integer id, CustomFieldUpdate customFieldUpdate, ApiCallback _callback) throws QaseException {
        CustomFieldUpdate localVarPostBody = customFieldUpdate;
        String localVarPath = "/custom_field/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCustomFieldValidateBeforeCall(Integer id, CustomFieldUpdate customFieldUpdate, ApiCallback _callback) throws QaseException {
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling updateCustomField(Async)");
        }
        if (customFieldUpdate == null) {
            throw new QaseException("Missing the required parameter 'customFieldUpdate' when calling updateCustomField(Async)");
        }
        Call localVarCall = this.updateCustomFieldCall(id, customFieldUpdate, _callback);
        return localVarCall;
    }

    public Response updateCustomField(Integer id, CustomFieldUpdate customFieldUpdate) throws QaseException {
        ApiResponse<Response> localVarResp = this.updateCustomFieldWithHttpInfo(id, customFieldUpdate);
        return localVarResp.getData();
    }

    public ApiResponse<Response> updateCustomFieldWithHttpInfo(Integer id, CustomFieldUpdate customFieldUpdate) throws QaseException {
        Call localVarCall = this.updateCustomFieldValidateBeforeCall(id, customFieldUpdate, null);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateCustomFieldAsync(Integer id, CustomFieldUpdate customFieldUpdate, ApiCallback<Response> _callback) throws QaseException {
        Call localVarCall = this.updateCustomFieldValidateBeforeCall(id, customFieldUpdate, _callback);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

