/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.DefectCreate;
import io.qase.client.model.DefectListResponse;
import io.qase.client.model.DefectResponse;
import io.qase.client.model.DefectStatus;
import io.qase.client.model.DefectUpdate;
import io.qase.client.model.Filters2;
import io.qase.client.model.IdResponse;
import io.qase.client.model.Response;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class DefectsApi {
    private ApiClient localVarApiClient;

    public DefectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefectsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createDefectCall(String code, DefectCreate defectCreate, ApiCallback _callback) throws QaseException {
        DefectCreate localVarPostBody = defectCreate;
        String localVarPath = "/defect/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDefectValidateBeforeCall(String code, DefectCreate defectCreate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createDefect(Async)");
        }
        if (defectCreate == null) {
            throw new QaseException("Missing the required parameter 'defectCreate' when calling createDefect(Async)");
        }
        Call localVarCall = this.createDefectCall(code, defectCreate, _callback);
        return localVarCall;
    }

    public IdResponse createDefect(String code, DefectCreate defectCreate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.createDefectWithHttpInfo(code, defectCreate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> createDefectWithHttpInfo(String code, DefectCreate defectCreate) throws QaseException {
        Call localVarCall = this.createDefectValidateBeforeCall(code, defectCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createDefectAsync(String code, DefectCreate defectCreate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.createDefectValidateBeforeCall(code, defectCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteDefectCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/defect/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDefectValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling deleteDefect(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling deleteDefect(Async)");
        }
        Call localVarCall = this.deleteDefectCall(code, id, _callback);
        return localVarCall;
    }

    public IdResponse deleteDefect(String code, Integer id) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.deleteDefectWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> deleteDefectWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.deleteDefectValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteDefectAsync(String code, Integer id, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.deleteDefectValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDefectCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/defect/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDefectValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getDefect(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling getDefect(Async)");
        }
        Call localVarCall = this.getDefectCall(code, id, _callback);
        return localVarCall;
    }

    public DefectResponse getDefect(String code, Integer id) throws QaseException {
        ApiResponse<DefectResponse> localVarResp = this.getDefectWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<DefectResponse> getDefectWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.getDefectValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<DefectResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDefectAsync(String code, Integer id, ApiCallback<DefectResponse> _callback) throws QaseException {
        Call localVarCall = this.getDefectValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<DefectResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDefectsCall(String code, Filters2 filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/defect/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDefectsValidateBeforeCall(String code, Filters2 filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getDefects(Async)");
        }
        Call localVarCall = this.getDefectsCall(code, filters, limit, offset, _callback);
        return localVarCall;
    }

    public DefectListResponse getDefects(String code, Filters2 filters, Integer limit, Integer offset) throws QaseException {
        ApiResponse<DefectListResponse> localVarResp = this.getDefectsWithHttpInfo(code, filters, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<DefectListResponse> getDefectsWithHttpInfo(String code, Filters2 filters, Integer limit, Integer offset) throws QaseException {
        Call localVarCall = this.getDefectsValidateBeforeCall(code, filters, limit, offset, null);
        Type localVarReturnType = new TypeToken<DefectListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDefectsAsync(String code, Filters2 filters, Integer limit, Integer offset, ApiCallback<DefectListResponse> _callback) throws QaseException {
        Call localVarCall = this.getDefectsValidateBeforeCall(code, filters, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<DefectListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resolveDefectCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/defect/{code}/resolve/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resolveDefectValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling resolveDefect(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling resolveDefect(Async)");
        }
        Call localVarCall = this.resolveDefectCall(code, id, _callback);
        return localVarCall;
    }

    public IdResponse resolveDefect(String code, Integer id) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.resolveDefectWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> resolveDefectWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.resolveDefectValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call resolveDefectAsync(String code, Integer id, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.resolveDefectValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateDefectCall(String code, Integer id, DefectUpdate defectUpdate, ApiCallback _callback) throws QaseException {
        DefectUpdate localVarPostBody = defectUpdate;
        String localVarPath = "/defect/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDefectValidateBeforeCall(String code, Integer id, DefectUpdate defectUpdate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updateDefect(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling updateDefect(Async)");
        }
        if (defectUpdate == null) {
            throw new QaseException("Missing the required parameter 'defectUpdate' when calling updateDefect(Async)");
        }
        Call localVarCall = this.updateDefectCall(code, id, defectUpdate, _callback);
        return localVarCall;
    }

    public IdResponse updateDefect(String code, Integer id, DefectUpdate defectUpdate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.updateDefectWithHttpInfo(code, id, defectUpdate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> updateDefectWithHttpInfo(String code, Integer id, DefectUpdate defectUpdate) throws QaseException {
        Call localVarCall = this.updateDefectValidateBeforeCall(code, id, defectUpdate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateDefectAsync(String code, Integer id, DefectUpdate defectUpdate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.updateDefectValidateBeforeCall(code, id, defectUpdate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateDefectStatusCall(String code, Integer id, DefectStatus defectStatus, ApiCallback _callback) throws QaseException {
        DefectStatus localVarPostBody = defectStatus;
        String localVarPath = "/defect/{code}/status/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDefectStatusValidateBeforeCall(String code, Integer id, DefectStatus defectStatus, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updateDefectStatus(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling updateDefectStatus(Async)");
        }
        if (defectStatus == null) {
            throw new QaseException("Missing the required parameter 'defectStatus' when calling updateDefectStatus(Async)");
        }
        Call localVarCall = this.updateDefectStatusCall(code, id, defectStatus, _callback);
        return localVarCall;
    }

    public Response updateDefectStatus(String code, Integer id, DefectStatus defectStatus) throws QaseException {
        ApiResponse<Response> localVarResp = this.updateDefectStatusWithHttpInfo(code, id, defectStatus);
        return localVarResp.getData();
    }

    public ApiResponse<Response> updateDefectStatusWithHttpInfo(String code, Integer id, DefectStatus defectStatus) throws QaseException {
        Call localVarCall = this.updateDefectStatusValidateBeforeCall(code, id, defectStatus, null);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateDefectStatusAsync(String code, Integer id, DefectStatus defectStatus, ApiCallback<Response> _callback) throws QaseException {
        Call localVarCall = this.updateDefectStatusValidateBeforeCall(code, id, defectStatus, _callback);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

