/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.IdResponse;
import io.qase.client.model.PlanCreate;
import io.qase.client.model.PlanListResponse;
import io.qase.client.model.PlanResponse;
import io.qase.client.model.PlanUpdate;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class PlansApi {
    private ApiClient localVarApiClient;

    public PlansApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PlansApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createPlanCall(String code, PlanCreate planCreate, ApiCallback _callback) throws QaseException {
        PlanCreate localVarPostBody = planCreate;
        String localVarPath = "/plan/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPlanValidateBeforeCall(String code, PlanCreate planCreate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createPlan(Async)");
        }
        if (planCreate == null) {
            throw new QaseException("Missing the required parameter 'planCreate' when calling createPlan(Async)");
        }
        Call localVarCall = this.createPlanCall(code, planCreate, _callback);
        return localVarCall;
    }

    public IdResponse createPlan(String code, PlanCreate planCreate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.createPlanWithHttpInfo(code, planCreate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> createPlanWithHttpInfo(String code, PlanCreate planCreate) throws QaseException {
        Call localVarCall = this.createPlanValidateBeforeCall(code, planCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createPlanAsync(String code, PlanCreate planCreate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.createPlanValidateBeforeCall(code, planCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deletePlanCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/plan/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePlanValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling deletePlan(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling deletePlan(Async)");
        }
        Call localVarCall = this.deletePlanCall(code, id, _callback);
        return localVarCall;
    }

    public IdResponse deletePlan(String code, Integer id) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.deletePlanWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> deletePlanWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.deletePlanValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deletePlanAsync(String code, Integer id, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.deletePlanValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPlanCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/plan/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPlanValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getPlan(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling getPlan(Async)");
        }
        Call localVarCall = this.getPlanCall(code, id, _callback);
        return localVarCall;
    }

    public PlanResponse getPlan(String code, Integer id) throws QaseException {
        ApiResponse<PlanResponse> localVarResp = this.getPlanWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<PlanResponse> getPlanWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.getPlanValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<PlanResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPlanAsync(String code, Integer id, ApiCallback<PlanResponse> _callback) throws QaseException {
        Call localVarCall = this.getPlanValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<PlanResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPlansCall(String code, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/plan/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPlansValidateBeforeCall(String code, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getPlans(Async)");
        }
        Call localVarCall = this.getPlansCall(code, limit, offset, _callback);
        return localVarCall;
    }

    public PlanListResponse getPlans(String code, Integer limit, Integer offset) throws QaseException {
        ApiResponse<PlanListResponse> localVarResp = this.getPlansWithHttpInfo(code, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<PlanListResponse> getPlansWithHttpInfo(String code, Integer limit, Integer offset) throws QaseException {
        Call localVarCall = this.getPlansValidateBeforeCall(code, limit, offset, null);
        Type localVarReturnType = new TypeToken<PlanListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPlansAsync(String code, Integer limit, Integer offset, ApiCallback<PlanListResponse> _callback) throws QaseException {
        Call localVarCall = this.getPlansValidateBeforeCall(code, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<PlanListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updatePlanCall(String code, Integer id, PlanUpdate planUpdate, ApiCallback _callback) throws QaseException {
        PlanUpdate localVarPostBody = planUpdate;
        String localVarPath = "/plan/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePlanValidateBeforeCall(String code, Integer id, PlanUpdate planUpdate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updatePlan(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling updatePlan(Async)");
        }
        if (planUpdate == null) {
            throw new QaseException("Missing the required parameter 'planUpdate' when calling updatePlan(Async)");
        }
        Call localVarCall = this.updatePlanCall(code, id, planUpdate, _callback);
        return localVarCall;
    }

    public IdResponse updatePlan(String code, Integer id, PlanUpdate planUpdate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.updatePlanWithHttpInfo(code, id, planUpdate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> updatePlanWithHttpInfo(String code, Integer id, PlanUpdate planUpdate) throws QaseException {
        Call localVarCall = this.updatePlanValidateBeforeCall(code, id, planUpdate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updatePlanAsync(String code, Integer id, PlanUpdate planUpdate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.updatePlanValidateBeforeCall(code, id, planUpdate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

