/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.Filters4;
import io.qase.client.model.HashResponse;
import io.qase.client.model.Response;
import io.qase.client.model.ResultCreate;
import io.qase.client.model.ResultCreateBulk;
import io.qase.client.model.ResultListResponse;
import io.qase.client.model.ResultResponse;
import io.qase.client.model.ResultUpdate;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ResultsApi {
    private ApiClient localVarApiClient;

    public ResultsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResultsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createResultCall(String code, Integer id, ResultCreate resultCreate, ApiCallback _callback) throws QaseException {
        ResultCreate localVarPostBody = resultCreate;
        String localVarPath = "/result/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createResultValidateBeforeCall(String code, Integer id, ResultCreate resultCreate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createResult(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling createResult(Async)");
        }
        if (resultCreate == null) {
            throw new QaseException("Missing the required parameter 'resultCreate' when calling createResult(Async)");
        }
        Call localVarCall = this.createResultCall(code, id, resultCreate, _callback);
        return localVarCall;
    }

    public Response createResult(String code, Integer id, ResultCreate resultCreate) throws QaseException {
        ApiResponse<Response> localVarResp = this.createResultWithHttpInfo(code, id, resultCreate);
        return localVarResp.getData();
    }

    public ApiResponse<Response> createResultWithHttpInfo(String code, Integer id, ResultCreate resultCreate) throws QaseException {
        Call localVarCall = this.createResultValidateBeforeCall(code, id, resultCreate, null);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createResultAsync(String code, Integer id, ResultCreate resultCreate, ApiCallback<Response> _callback) throws QaseException {
        Call localVarCall = this.createResultValidateBeforeCall(code, id, resultCreate, _callback);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createResultBulkCall(String code, Integer id, ResultCreateBulk resultCreateBulk, ApiCallback _callback) throws QaseException {
        ResultCreateBulk localVarPostBody = resultCreateBulk;
        String localVarPath = "/result/{code}/{id}/bulk".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createResultBulkValidateBeforeCall(String code, Integer id, ResultCreateBulk resultCreateBulk, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createResultBulk(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling createResultBulk(Async)");
        }
        if (resultCreateBulk == null) {
            throw new QaseException("Missing the required parameter 'resultCreateBulk' when calling createResultBulk(Async)");
        }
        Call localVarCall = this.createResultBulkCall(code, id, resultCreateBulk, _callback);
        return localVarCall;
    }

    public Response createResultBulk(String code, Integer id, ResultCreateBulk resultCreateBulk) throws QaseException {
        ApiResponse<Response> localVarResp = this.createResultBulkWithHttpInfo(code, id, resultCreateBulk);
        return localVarResp.getData();
    }

    public ApiResponse<Response> createResultBulkWithHttpInfo(String code, Integer id, ResultCreateBulk resultCreateBulk) throws QaseException {
        Call localVarCall = this.createResultBulkValidateBeforeCall(code, id, resultCreateBulk, null);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createResultBulkAsync(String code, Integer id, ResultCreateBulk resultCreateBulk, ApiCallback<Response> _callback) throws QaseException {
        Call localVarCall = this.createResultBulkValidateBeforeCall(code, id, resultCreateBulk, _callback);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteResultCall(String code, Integer id, String hash, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/result/{code}/{id}/{hash}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{hash\\}", this.localVarApiClient.escapeString(hash));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteResultValidateBeforeCall(String code, Integer id, String hash, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling deleteResult(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling deleteResult(Async)");
        }
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling deleteResult(Async)");
        }
        Call localVarCall = this.deleteResultCall(code, id, hash, _callback);
        return localVarCall;
    }

    public HashResponse deleteResult(String code, Integer id, String hash) throws QaseException {
        ApiResponse<HashResponse> localVarResp = this.deleteResultWithHttpInfo(code, id, hash);
        return localVarResp.getData();
    }

    public ApiResponse<HashResponse> deleteResultWithHttpInfo(String code, Integer id, String hash) throws QaseException {
        Call localVarCall = this.deleteResultValidateBeforeCall(code, id, hash, null);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteResultAsync(String code, Integer id, String hash, ApiCallback<HashResponse> _callback) throws QaseException {
        Call localVarCall = this.deleteResultValidateBeforeCall(code, id, hash, _callback);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getResultCall(String code, String hash, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/result/{code}/{hash}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{hash\\}", this.localVarApiClient.escapeString(hash));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getResultValidateBeforeCall(String code, String hash, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getResult(Async)");
        }
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling getResult(Async)");
        }
        Call localVarCall = this.getResultCall(code, hash, _callback);
        return localVarCall;
    }

    public ResultResponse getResult(String code, String hash) throws QaseException {
        ApiResponse<ResultResponse> localVarResp = this.getResultWithHttpInfo(code, hash);
        return localVarResp.getData();
    }

    public ApiResponse<ResultResponse> getResultWithHttpInfo(String code, String hash) throws QaseException {
        Call localVarCall = this.getResultValidateBeforeCall(code, hash, null);
        Type localVarReturnType = new TypeToken<ResultResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getResultAsync(String code, String hash, ApiCallback<ResultResponse> _callback) throws QaseException {
        Call localVarCall = this.getResultValidateBeforeCall(code, hash, _callback);
        Type localVarReturnType = new TypeToken<ResultResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getResultsCall(String code, Filters4 filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/result/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getResultsValidateBeforeCall(String code, Filters4 filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getResults(Async)");
        }
        Call localVarCall = this.getResultsCall(code, filters, limit, offset, _callback);
        return localVarCall;
    }

    public ResultListResponse getResults(String code, Filters4 filters, Integer limit, Integer offset) throws QaseException {
        ApiResponse<ResultListResponse> localVarResp = this.getResultsWithHttpInfo(code, filters, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ResultListResponse> getResultsWithHttpInfo(String code, Filters4 filters, Integer limit, Integer offset) throws QaseException {
        Call localVarCall = this.getResultsValidateBeforeCall(code, filters, limit, offset, null);
        Type localVarReturnType = new TypeToken<ResultListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getResultsAsync(String code, Filters4 filters, Integer limit, Integer offset, ApiCallback<ResultListResponse> _callback) throws QaseException {
        Call localVarCall = this.getResultsValidateBeforeCall(code, filters, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ResultListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateResultCall(String code, Integer id, String hash, ResultUpdate resultUpdate, ApiCallback _callback) throws QaseException {
        ResultUpdate localVarPostBody = resultUpdate;
        String localVarPath = "/result/{code}/{id}/{hash}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{hash\\}", this.localVarApiClient.escapeString(hash));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateResultValidateBeforeCall(String code, Integer id, String hash, ResultUpdate resultUpdate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updateResult(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling updateResult(Async)");
        }
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling updateResult(Async)");
        }
        if (resultUpdate == null) {
            throw new QaseException("Missing the required parameter 'resultUpdate' when calling updateResult(Async)");
        }
        Call localVarCall = this.updateResultCall(code, id, hash, resultUpdate, _callback);
        return localVarCall;
    }

    public HashResponse updateResult(String code, Integer id, String hash, ResultUpdate resultUpdate) throws QaseException {
        ApiResponse<HashResponse> localVarResp = this.updateResultWithHttpInfo(code, id, hash, resultUpdate);
        return localVarResp.getData();
    }

    public ApiResponse<HashResponse> updateResultWithHttpInfo(String code, Integer id, String hash, ResultUpdate resultUpdate) throws QaseException {
        Call localVarCall = this.updateResultValidateBeforeCall(code, id, hash, resultUpdate, null);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateResultAsync(String code, Integer id, String hash, ResultUpdate resultUpdate, ApiCallback<HashResponse> _callback) throws QaseException {
        Call localVarCall = this.updateResultValidateBeforeCall(code, id, hash, resultUpdate, _callback);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

