/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.Filters5;
import io.qase.client.model.IdResponse;
import io.qase.client.model.Response;
import io.qase.client.model.RunCreate;
import io.qase.client.model.RunListResponse;
import io.qase.client.model.RunPublic;
import io.qase.client.model.RunPublicResponse;
import io.qase.client.model.RunResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class RunsApi {
    private ApiClient localVarApiClient;

    public RunsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RunsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call completeRunCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/run/{code}/{id}/complete".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call completeRunValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling completeRun(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling completeRun(Async)");
        }
        Call localVarCall = this.completeRunCall(code, id, _callback);
        return localVarCall;
    }

    public Response completeRun(String code, Integer id) throws QaseException {
        ApiResponse<Response> localVarResp = this.completeRunWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<Response> completeRunWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.completeRunValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call completeRunAsync(String code, Integer id, ApiCallback<Response> _callback) throws QaseException {
        Call localVarCall = this.completeRunValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createRunCall(String code, RunCreate runCreate, ApiCallback _callback) throws QaseException {
        RunCreate localVarPostBody = runCreate;
        String localVarPath = "/run/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createRunValidateBeforeCall(String code, RunCreate runCreate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createRun(Async)");
        }
        if (runCreate == null) {
            throw new QaseException("Missing the required parameter 'runCreate' when calling createRun(Async)");
        }
        Call localVarCall = this.createRunCall(code, runCreate, _callback);
        return localVarCall;
    }

    public IdResponse createRun(String code, RunCreate runCreate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.createRunWithHttpInfo(code, runCreate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> createRunWithHttpInfo(String code, RunCreate runCreate) throws QaseException {
        Call localVarCall = this.createRunValidateBeforeCall(code, runCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createRunAsync(String code, RunCreate runCreate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.createRunValidateBeforeCall(code, runCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteRunCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/run/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRunValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling deleteRun(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling deleteRun(Async)");
        }
        Call localVarCall = this.deleteRunCall(code, id, _callback);
        return localVarCall;
    }

    public IdResponse deleteRun(String code, Integer id) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.deleteRunWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> deleteRunWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.deleteRunValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteRunAsync(String code, Integer id, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.deleteRunValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRunCall(String code, Integer id, String include, ApiCallback _callback) throws QaseException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/run/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (include != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include", include));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRunValidateBeforeCall(String code, Integer id, String include, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getRun(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling getRun(Async)");
        }
        Call localVarCall = this.getRunCall(code, id, include, _callback);
        return localVarCall;
    }

    public RunResponse getRun(String code, Integer id, String include) throws QaseException {
        ApiResponse<RunResponse> localVarResp = this.getRunWithHttpInfo(code, id, include);
        return localVarResp.getData();
    }

    public ApiResponse<RunResponse> getRunWithHttpInfo(String code, Integer id, String include) throws QaseException {
        Call localVarCall = this.getRunValidateBeforeCall(code, id, include, null);
        Type localVarReturnType = new TypeToken<RunResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRunAsync(String code, Integer id, String include, ApiCallback<RunResponse> _callback) throws QaseException {
        Call localVarCall = this.getRunValidateBeforeCall(code, id, include, _callback);
        Type localVarReturnType = new TypeToken<RunResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRunsCall(String code, Filters5 filters, Integer limit, Integer offset, String include, ApiCallback _callback) throws QaseException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/run/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (include != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include", include));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRunsValidateBeforeCall(String code, Filters5 filters, Integer limit, Integer offset, String include, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getRuns(Async)");
        }
        Call localVarCall = this.getRunsCall(code, filters, limit, offset, include, _callback);
        return localVarCall;
    }

    public RunListResponse getRuns(String code, Filters5 filters, Integer limit, Integer offset, String include) throws QaseException {
        ApiResponse<RunListResponse> localVarResp = this.getRunsWithHttpInfo(code, filters, limit, offset, include);
        return localVarResp.getData();
    }

    public ApiResponse<RunListResponse> getRunsWithHttpInfo(String code, Filters5 filters, Integer limit, Integer offset, String include) throws QaseException {
        Call localVarCall = this.getRunsValidateBeforeCall(code, filters, limit, offset, include, null);
        Type localVarReturnType = new TypeToken<RunListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRunsAsync(String code, Filters5 filters, Integer limit, Integer offset, String include, ApiCallback<RunListResponse> _callback) throws QaseException {
        Call localVarCall = this.getRunsValidateBeforeCall(code, filters, limit, offset, include, _callback);
        Type localVarReturnType = new TypeToken<RunListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateRunPublicityCall(String code, Integer id, RunPublic runPublic, ApiCallback _callback) throws QaseException {
        RunPublic localVarPostBody = runPublic;
        String localVarPath = "/run/{code}/{id}/public".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateRunPublicityValidateBeforeCall(String code, Integer id, RunPublic runPublic, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updateRunPublicity(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling updateRunPublicity(Async)");
        }
        if (runPublic == null) {
            throw new QaseException("Missing the required parameter 'runPublic' when calling updateRunPublicity(Async)");
        }
        Call localVarCall = this.updateRunPublicityCall(code, id, runPublic, _callback);
        return localVarCall;
    }

    public RunPublicResponse updateRunPublicity(String code, Integer id, RunPublic runPublic) throws QaseException {
        ApiResponse<RunPublicResponse> localVarResp = this.updateRunPublicityWithHttpInfo(code, id, runPublic);
        return localVarResp.getData();
    }

    public ApiResponse<RunPublicResponse> updateRunPublicityWithHttpInfo(String code, Integer id, RunPublic runPublic) throws QaseException {
        Call localVarCall = this.updateRunPublicityValidateBeforeCall(code, id, runPublic, null);
        Type localVarReturnType = new TypeToken<RunPublicResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateRunPublicityAsync(String code, Integer id, RunPublic runPublic, ApiCallback<RunPublicResponse> _callback) throws QaseException {
        Call localVarCall = this.updateRunPublicityValidateBeforeCall(code, id, runPublic, _callback);
        Type localVarReturnType = new TypeToken<RunPublicResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

