/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.Filters6;
import io.qase.client.model.HashResponse;
import io.qase.client.model.SharedStepCreate;
import io.qase.client.model.SharedStepListResponse;
import io.qase.client.model.SharedStepResponse;
import io.qase.client.model.SharedStepUpdate;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SharedStepsApi {
    private ApiClient localVarApiClient;

    public SharedStepsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SharedStepsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createSharedStepCall(String code, SharedStepCreate sharedStepCreate, ApiCallback _callback) throws QaseException {
        SharedStepCreate localVarPostBody = sharedStepCreate;
        String localVarPath = "/shared_step/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSharedStepValidateBeforeCall(String code, SharedStepCreate sharedStepCreate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createSharedStep(Async)");
        }
        if (sharedStepCreate == null) {
            throw new QaseException("Missing the required parameter 'sharedStepCreate' when calling createSharedStep(Async)");
        }
        Call localVarCall = this.createSharedStepCall(code, sharedStepCreate, _callback);
        return localVarCall;
    }

    public HashResponse createSharedStep(String code, SharedStepCreate sharedStepCreate) throws QaseException {
        ApiResponse<HashResponse> localVarResp = this.createSharedStepWithHttpInfo(code, sharedStepCreate);
        return localVarResp.getData();
    }

    public ApiResponse<HashResponse> createSharedStepWithHttpInfo(String code, SharedStepCreate sharedStepCreate) throws QaseException {
        Call localVarCall = this.createSharedStepValidateBeforeCall(code, sharedStepCreate, null);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSharedStepAsync(String code, SharedStepCreate sharedStepCreate, ApiCallback<HashResponse> _callback) throws QaseException {
        Call localVarCall = this.createSharedStepValidateBeforeCall(code, sharedStepCreate, _callback);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSharedStepCall(String code, String hash, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/shared_step/{code}/{hash}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{hash\\}", this.localVarApiClient.escapeString(hash));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSharedStepValidateBeforeCall(String code, String hash, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling deleteSharedStep(Async)");
        }
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling deleteSharedStep(Async)");
        }
        Call localVarCall = this.deleteSharedStepCall(code, hash, _callback);
        return localVarCall;
    }

    public HashResponse deleteSharedStep(String code, String hash) throws QaseException {
        ApiResponse<HashResponse> localVarResp = this.deleteSharedStepWithHttpInfo(code, hash);
        return localVarResp.getData();
    }

    public ApiResponse<HashResponse> deleteSharedStepWithHttpInfo(String code, String hash) throws QaseException {
        Call localVarCall = this.deleteSharedStepValidateBeforeCall(code, hash, null);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSharedStepAsync(String code, String hash, ApiCallback<HashResponse> _callback) throws QaseException {
        Call localVarCall = this.deleteSharedStepValidateBeforeCall(code, hash, _callback);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSharedStepCall(String code, String hash, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/shared_step/{code}/{hash}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{hash\\}", this.localVarApiClient.escapeString(hash));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSharedStepValidateBeforeCall(String code, String hash, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getSharedStep(Async)");
        }
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling getSharedStep(Async)");
        }
        Call localVarCall = this.getSharedStepCall(code, hash, _callback);
        return localVarCall;
    }

    public SharedStepResponse getSharedStep(String code, String hash) throws QaseException {
        ApiResponse<SharedStepResponse> localVarResp = this.getSharedStepWithHttpInfo(code, hash);
        return localVarResp.getData();
    }

    public ApiResponse<SharedStepResponse> getSharedStepWithHttpInfo(String code, String hash) throws QaseException {
        Call localVarCall = this.getSharedStepValidateBeforeCall(code, hash, null);
        Type localVarReturnType = new TypeToken<SharedStepResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSharedStepAsync(String code, String hash, ApiCallback<SharedStepResponse> _callback) throws QaseException {
        Call localVarCall = this.getSharedStepValidateBeforeCall(code, hash, _callback);
        Type localVarReturnType = new TypeToken<SharedStepResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSharedStepsCall(String code, Filters6 filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/shared_step/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSharedStepsValidateBeforeCall(String code, Filters6 filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getSharedSteps(Async)");
        }
        Call localVarCall = this.getSharedStepsCall(code, filters, limit, offset, _callback);
        return localVarCall;
    }

    public SharedStepListResponse getSharedSteps(String code, Filters6 filters, Integer limit, Integer offset) throws QaseException {
        ApiResponse<SharedStepListResponse> localVarResp = this.getSharedStepsWithHttpInfo(code, filters, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<SharedStepListResponse> getSharedStepsWithHttpInfo(String code, Filters6 filters, Integer limit, Integer offset) throws QaseException {
        Call localVarCall = this.getSharedStepsValidateBeforeCall(code, filters, limit, offset, null);
        Type localVarReturnType = new TypeToken<SharedStepListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSharedStepsAsync(String code, Filters6 filters, Integer limit, Integer offset, ApiCallback<SharedStepListResponse> _callback) throws QaseException {
        Call localVarCall = this.getSharedStepsValidateBeforeCall(code, filters, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<SharedStepListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSharedStepCall(String code, String hash, SharedStepUpdate sharedStepUpdate, ApiCallback _callback) throws QaseException {
        SharedStepUpdate localVarPostBody = sharedStepUpdate;
        String localVarPath = "/shared_step/{code}/{hash}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{hash\\}", this.localVarApiClient.escapeString(hash));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSharedStepValidateBeforeCall(String code, String hash, SharedStepUpdate sharedStepUpdate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updateSharedStep(Async)");
        }
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling updateSharedStep(Async)");
        }
        if (sharedStepUpdate == null) {
            throw new QaseException("Missing the required parameter 'sharedStepUpdate' when calling updateSharedStep(Async)");
        }
        Call localVarCall = this.updateSharedStepCall(code, hash, sharedStepUpdate, _callback);
        return localVarCall;
    }

    public HashResponse updateSharedStep(String code, String hash, SharedStepUpdate sharedStepUpdate) throws QaseException {
        ApiResponse<HashResponse> localVarResp = this.updateSharedStepWithHttpInfo(code, hash, sharedStepUpdate);
        return localVarResp.getData();
    }

    public ApiResponse<HashResponse> updateSharedStepWithHttpInfo(String code, String hash, SharedStepUpdate sharedStepUpdate) throws QaseException {
        Call localVarCall = this.updateSharedStepValidateBeforeCall(code, hash, sharedStepUpdate, null);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSharedStepAsync(String code, String hash, SharedStepUpdate sharedStepUpdate, ApiCallback<HashResponse> _callback) throws QaseException {
        Call localVarCall = this.updateSharedStepValidateBeforeCall(code, hash, sharedStepUpdate, _callback);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

