/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services.impl;

import com.google.inject.Inject;
import io.qase.api.QaseClient;
import io.qase.api.exceptions.QaseException;
import io.qase.api.services.ReportersResultOperations;
import io.qase.client.api.ResultsApi;
import io.qase.client.model.ResultCreate;
import io.qase.client.model.ResultCreateBulk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportersResultOperationsImpl
implements ReportersResultOperations {
    private static final Logger log = LoggerFactory.getLogger(ReportersResultOperationsImpl.class);
    private final ResultCreateBulk resultCreateBulk = new ResultCreateBulk();
    private final ResultsApi resultsApi;

    @Override
    public void addBulkResult(ResultCreate resultCreate) {
        this.resultCreateBulk.addResultsItem(resultCreate);
    }

    @Override
    public void send(ResultCreate resultCreate) {
        try {
            this.resultsApi.createResult(QaseClient.getConfig().projectCode(), QaseClient.getConfig().runId(), resultCreate);
        }
        catch (QaseException e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public void sendBulkResult() {
        try {
            this.resultsApi.createResultBulk(QaseClient.getConfig().projectCode(), QaseClient.getConfig().runId(), this.resultCreateBulk);
            this.resultCreateBulk.getResults().clear();
        }
        catch (QaseException e) {
            log.error(e.getMessage());
        }
    }

    @Inject
    public ReportersResultOperationsImpl(ResultsApi resultsApi) {
        this.resultsApi = resultsApi;
    }
}

