/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.qase.client.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProjectCreate {
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private String code;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ACCESS = "access";
    @SerializedName(value="access")
    private AccessEnum access;
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ProjectCreate title(String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Project title.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ProjectCreate code(String code) {
        this.code = code;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Project code. Unique for team. Digits and special characters are not allowed.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ProjectCreate description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Project description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProjectCreate access(AccessEnum access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccessEnum getAccess() {
        return this.access;
    }

    public void setAccess(AccessEnum access) {
        this.access = access;
    }

    public ProjectCreate group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Team group hash. Required if access param is set to group.")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectCreate projectCreate = (ProjectCreate)o;
        return Objects.equals(this.title, projectCreate.title) && Objects.equals(this.code, projectCreate.code) && Objects.equals(this.description, projectCreate.description) && Objects.equals((Object)this.access, (Object)projectCreate.access) && Objects.equals(this.group, projectCreate.group);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.title, this.code, this.description, this.access, this.group});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectCreate {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    access: ").append(this.toIndentedString((Object)this.access)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ProjectCreate fromJson(String jsonString) throws IOException {
        return (ProjectCreate)JSON.getGson().fromJson(jsonString, ProjectCreate.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_CODE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_GROUP);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TITLE);
        openapiRequiredFields.add(SERIALIZED_NAME_CODE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ProjectCreate.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ProjectCreate.class));
            return new TypeAdapter<ProjectCreate>(){

                public void write(JsonWriter out, ProjectCreate value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ProjectCreate read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    return (ProjectCreate)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AccessEnum {
        ALL("all"),
        GROUP("group"),
        NONE("none");

        private String value;

        private AccessEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AccessEnum fromValue(String value) {
            for (AccessEnum b : AccessEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AccessEnum> {
            public void write(JsonWriter jsonWriter, AccessEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AccessEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AccessEnum.fromValue(value);
            }
        }
    }
}

