/*
 * Decompiled with CFR 0.152.
 */
package io.qase.guice.module;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.qase.api.QaseClient;
import io.qase.api.config.apiclient.ApiClientConfigurer;
import io.qase.api.services.QaseTestCaseListener;
import io.qase.api.services.ReportersResultOperations;
import io.qase.api.services.impl.QaseTestCaseListenerImpl;
import io.qase.api.services.impl.ReportersResultOperationsImpl;
import io.qase.client.ApiClient;
import io.qase.client.api.AttachmentsApi;
import io.qase.client.api.ResultsApi;
import io.qase.client.api.RunsApi;

public class QaseModule
extends AbstractModule {
    protected void configure() {
        this.requireBinding(ApiClientConfigurer.class);
        this.bind(ReportersResultOperations.class).to(ReportersResultOperationsImpl.class);
        this.bind(QaseTestCaseListener.class).to(QaseTestCaseListenerImpl.class);
    }

    @Provides
    @Singleton
    public ApiClient apiClient(ApiClientConfigurer apiClientConfigurer) {
        ApiClient apiClient = QaseClient.getApiClient();
        apiClientConfigurer.configure(apiClient);
        return apiClient;
    }

    @Provides
    @Singleton
    public ResultsApi resultsApi(ApiClient apiClient) {
        return new ResultsApi(apiClient);
    }

    @Provides
    @Singleton
    public RunsApi runsApi(ApiClient apiClient) {
        return new RunsApi(apiClient);
    }

    @Provides
    @Singleton
    public AttachmentsApi attachmentsApi(ApiClient apiClient) {
        return new AttachmentsApi(apiClient);
    }
}

