/*
 * Qase.io API
 * Qase API Specification.
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: support@qase.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.qase.client;

import com.google.gson.*;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.GsonFireBuilder;
import io.qase.client.model.*;
import okio.ByteString;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;

/*
 * A JSON utility class
 *
 * NOTE: in the future, this class may be converted to static, which may break
 *       backward-compatibility
 */
public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson = false;
    private static DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
    private static SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
    private static LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();
    private static ByteArrayAdapter byteArrayAdapter = new ByteArrayAdapter();

    @SuppressWarnings("unchecked")
    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder()
        ;
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    /**
     * Returns the Java class that implements the OpenAPI schema for the specified discriminator value.
     *
     * @param classByDiscriminatorValue The map of discriminator values to Java classes.
     * @param discriminatorValue The value of the OpenAPI discriminator in the input data.
     * @return The Java class that implements the OpenAPI schema
     */
    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class) classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    {
        GsonBuilder gsonBuilder = createGson();
        gsonBuilder.registerTypeAdapter(Date.class, dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(java.sql.Date.class, sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(OffsetDateTime.class, offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter(LocalDate.class, localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new Attachment.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttachmentGet.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttachmentHash.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttachmentListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttachmentListResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttachmentListResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttachmentResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttachmentResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttachmentUploadsResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttachmentUploadsResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CreateResult200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CreateResult200ResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CreateResult200ResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CustomField.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CustomFieldCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CustomFieldCreateValueInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CustomFieldResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CustomFieldResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CustomFieldUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CustomFieldValue.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CustomFieldsResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CustomFieldsResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new CustomFieldsResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Defect.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DefectCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DefectListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DefectListResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DefectListResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DefectResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DefectResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DefectStatus.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DefectUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Environment.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new EnvironmentCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new EnvironmentListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new EnvironmentListResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new EnvironmentListResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new EnvironmentResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new EnvironmentResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new EnvironmentUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GetCasesFiltersParameter.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GetCustomFieldsFiltersParameter.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GetDefectsFiltersParameter.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GetMilestonesFiltersParameter.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GetResultsFiltersParameter.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GetRunsFiltersParameter.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new HashResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new HashResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new HashResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new IdResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new IdResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new IdResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Milestone.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MilestoneCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MilestoneListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MilestoneListResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MilestoneListResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MilestoneResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MilestoneResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MilestoneUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Plan.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PlanCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PlanDetailed.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PlanDetailedAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PlanDetailedAllOfCases.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PlanListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PlanListResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PlanListResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PlanResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PlanResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PlanUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Project.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectAccess.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectCodeResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectCodeResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectCodeResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectCounts.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectCountsDefects.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectCountsRuns.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectListResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectListResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ProjectResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new QqlDefect.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new QqlPlan.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new QqlTestCase.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Requirement.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Result.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultCreateBulk.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultCreateCase.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultCreateStepsInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultListResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultListResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultStepsInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResultUpdateStepsInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Run.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunEnvironment.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunListResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunListResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunMilestone.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunPublic.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunPublicResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunPublicResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunPublicResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RunStats.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SearchResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SearchResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SearchResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SharedStep.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SharedStepCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SharedStepCreateStepsInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SharedStepListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SharedStepListResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SharedStepListResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SharedStepResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SharedStepResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SharedStepStepsInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SharedStepUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Suite.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SuiteCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SuiteDelete.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SuiteListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SuiteListResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SuiteListResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SuiteResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SuiteResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SuiteUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TagValue.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TestCase.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TestCaseCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TestCaseCreateStepsInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TestCaseListResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TestCaseListResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TestCaseListResponseAllOfResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TestCaseParams.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TestCaseResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TestCaseResponseAllOf.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TestCaseUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TestStep.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    /**
     * Get Gson.
     *
     * @return Gson
     */
    public static Gson getGson() {
        return gson;
    }

    /**
     * Set Gson.
     *
     * @param gson Gson
     */
    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    /**
     * Serialize the given Java object into JSON string.
     *
     * @param obj Object
     * @return String representation of the JSON
     */
    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    /**
     * Deserialize the given JSON string to Java object.
     *
     * @param <T>        Type
     * @param body       The JSON string
     * @param returnType The type to deserialize into
     * @return The deserialized Java object
     */
    @SuppressWarnings("unchecked")
    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                // see https://google-gson.googlecode.com/svn/trunk/gson/docs/javadocs/com/google/gson/stream/JsonReader.html#setLenient(boolean)
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            } else {
                return gson.fromJson(body, returnType);
            }
        } catch (JsonParseException e) {
            // Fallback processing when failed to parse JSON form response body:
            // return the response body string directly for the String return type;
            if (returnType.equals(String.class)) {
                return (T) body;
            } else {
                throw (e);
            }
        }
    }

    /**
     * Gson TypeAdapter for Byte Array type
     */
    public static class ByteArrayAdapter extends TypeAdapter<byte[]> {

        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of(value).base64());
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String bytesAsBase64 = in.nextString();
                    ByteString byteString = ByteString.decodeBase64(bytesAsBase64);
                    return byteString.toByteArray();
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 OffsetDateTime type
     */
    public static class OffsetDateTimeTypeAdapter extends TypeAdapter<OffsetDateTime> {

        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    if (date.endsWith("+0000")) {
                        date = date.substring(0, date.length()-5) + "Z";
                    }
                    return OffsetDateTime.parse(date, formatter);
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 LocalDate type
     */
    public static class LocalDateTypeAdapter extends TypeAdapter<LocalDate> {

        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    return LocalDate.parse(date, formatter);
            }
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    /**
     * Gson TypeAdapter for java.sql.Date type
     * If the dateFormat is null, a simple "yyyy-MM-dd" format will be used
     * (more efficient than SimpleDateFormat).
     */
    public static class SqlDateTypeAdapter extends TypeAdapter<java.sql.Date> {

        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {}

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = date.toString();
                }
                out.value(value);
            }
        }

        @Override
        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    try {
                        if (dateFormat != null) {
                            return new java.sql.Date(dateFormat.parse(date).getTime());
                        }
                        return new java.sql.Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
                    } catch (ParseException e) {
                        throw new JsonParseException(e);
                    }
            }
        }
    }

    /**
     * Gson TypeAdapter for java.util.Date type
     * If the dateFormat is null, ISO8601Utils will be used.
     */
    public static class DateTypeAdapter extends TypeAdapter<Date> {

        private DateFormat dateFormat;

        public DateTypeAdapter() {}

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = ISO8601Utils.format(date, true);
                }
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL:
                        in.nextNull();
                        return null;
                    default:
                        String date = in.nextString();
                        try {
                            if (dateFormat != null) {
                                return dateFormat.parse(date);
                            }
                            return ISO8601Utils.parse(date, new ParsePosition(0));
                        } catch (ParseException e) {
                            throw new JsonParseException(e);
                        }
                }
            } catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }
}
