/*
 * Qase.io API
 * Qase API Specification.
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: support@qase.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.*;
import io.qase.client.model.*;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnvironmentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public EnvironmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EnvironmentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createEnvironment
     * @param code Code of project, where to search entities. (required)
     * @param environmentCreate  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws QaseException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createEnvironmentCall(String code, EnvironmentCreate environmentCreate, final ApiCallback _callback) throws QaseException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = environmentCreate;

        // create path and map variables
        String localVarPath = "/environment/{code}"
            .replace("{" + "code" + "}", localVarApiClient.escapeString(code.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "TokenAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createEnvironmentValidateBeforeCall(String code, EnvironmentCreate environmentCreate, final ApiCallback _callback) throws QaseException {
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createEnvironment(Async)");
        }

        // verify the required parameter 'environmentCreate' is set
        if (environmentCreate == null) {
            throw new QaseException("Missing the required parameter 'environmentCreate' when calling createEnvironment(Async)");
        }

        return createEnvironmentCall(code, environmentCreate, _callback);

    }

    /**
     * Create a new environment.
     * This method allows to create an environment in selected project. 
     * @param code Code of project, where to search entities. (required)
     * @param environmentCreate  (required)
     * @return IdResponse
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public IdResponse createEnvironment(String code, EnvironmentCreate environmentCreate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = createEnvironmentWithHttpInfo(code, environmentCreate);
        return localVarResp.getData();
    }

    /**
     * Create a new environment.
     * This method allows to create an environment in selected project. 
     * @param code Code of project, where to search entities. (required)
     * @param environmentCreate  (required)
     * @return ApiResponse&lt;IdResponse&gt;
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IdResponse> createEnvironmentWithHttpInfo(String code, EnvironmentCreate environmentCreate) throws QaseException {
        okhttp3.Call localVarCall = createEnvironmentValidateBeforeCall(code, environmentCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a new environment. (asynchronously)
     * This method allows to create an environment in selected project. 
     * @param code Code of project, where to search entities. (required)
     * @param environmentCreate  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws QaseException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createEnvironmentAsync(String code, EnvironmentCreate environmentCreate, final ApiCallback<IdResponse> _callback) throws QaseException {

        okhttp3.Call localVarCall = createEnvironmentValidateBeforeCall(code, environmentCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteEnvironment
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws QaseException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A Result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteEnvironmentCall(String code, Integer id, final ApiCallback _callback) throws QaseException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/environment/{code}/{id}"
            .replace("{" + "code" + "}", localVarApiClient.escapeString(code.toString()))
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "TokenAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteEnvironmentValidateBeforeCall(String code, Integer id, final ApiCallback _callback) throws QaseException {
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling deleteEnvironment(Async)");
        }

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling deleteEnvironment(Async)");
        }

        return deleteEnvironmentCall(code, id, _callback);

    }

    /**
     * Delete environment.
     * This method completely deletes an environment from repository. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @return IdResponse
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A Result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public IdResponse deleteEnvironment(String code, Integer id) throws QaseException {
        ApiResponse<IdResponse> localVarResp = deleteEnvironmentWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    /**
     * Delete environment.
     * This method completely deletes an environment from repository. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @return ApiResponse&lt;IdResponse&gt;
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A Result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IdResponse> deleteEnvironmentWithHttpInfo(String code, Integer id) throws QaseException {
        okhttp3.Call localVarCall = deleteEnvironmentValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete environment. (asynchronously)
     * This method completely deletes an environment from repository. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws QaseException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A Result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteEnvironmentAsync(String code, Integer id, final ApiCallback<IdResponse> _callback) throws QaseException {

        okhttp3.Call localVarCall = deleteEnvironmentValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEnvironment
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws QaseException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An environment. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEnvironmentCall(String code, Integer id, final ApiCallback _callback) throws QaseException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/environment/{code}/{id}"
            .replace("{" + "code" + "}", localVarApiClient.escapeString(code.toString()))
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "TokenAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEnvironmentValidateBeforeCall(String code, Integer id, final ApiCallback _callback) throws QaseException {
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getEnvironment(Async)");
        }

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling getEnvironment(Async)");
        }

        return getEnvironmentCall(code, id, _callback);

    }

    /**
     * Get a specific environment.
     * This method allows to retrieve a specific environment. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @return EnvironmentResponse
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An environment. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public EnvironmentResponse getEnvironment(String code, Integer id) throws QaseException {
        ApiResponse<EnvironmentResponse> localVarResp = getEnvironmentWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    /**
     * Get a specific environment.
     * This method allows to retrieve a specific environment. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @return ApiResponse&lt;EnvironmentResponse&gt;
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An environment. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EnvironmentResponse> getEnvironmentWithHttpInfo(String code, Integer id) throws QaseException {
        okhttp3.Call localVarCall = getEnvironmentValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<EnvironmentResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a specific environment. (asynchronously)
     * This method allows to retrieve a specific environment. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws QaseException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> An environment. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEnvironmentAsync(String code, Integer id, final ApiCallback<EnvironmentResponse> _callback) throws QaseException {

        okhttp3.Call localVarCall = getEnvironmentValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<EnvironmentResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEnvironments
     * @param code Code of project, where to search entities. (required)
     * @param limit A number of entities in result set. (optional, default to 10)
     * @param offset How many entities should be skipped. (optional, default to 0)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws QaseException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of all environments. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEnvironmentsCall(String code, Integer limit, Integer offset, final ApiCallback _callback) throws QaseException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/environment/{code}"
            .replace("{" + "code" + "}", localVarApiClient.escapeString(code.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "TokenAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEnvironmentsValidateBeforeCall(String code, Integer limit, Integer offset, final ApiCallback _callback) throws QaseException {
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getEnvironments(Async)");
        }

        return getEnvironmentsCall(code, limit, offset, _callback);

    }

    /**
     * Get all environments.
     * This method allows to retrieve all environments stored in selected project. 
     * @param code Code of project, where to search entities. (required)
     * @param limit A number of entities in result set. (optional, default to 10)
     * @param offset How many entities should be skipped. (optional, default to 0)
     * @return EnvironmentListResponse
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of all environments. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public EnvironmentListResponse getEnvironments(String code, Integer limit, Integer offset) throws QaseException {
        ApiResponse<EnvironmentListResponse> localVarResp = getEnvironmentsWithHttpInfo(code, limit, offset);
        return localVarResp.getData();
    }

    /**
     * Get all environments.
     * This method allows to retrieve all environments stored in selected project. 
     * @param code Code of project, where to search entities. (required)
     * @param limit A number of entities in result set. (optional, default to 10)
     * @param offset How many entities should be skipped. (optional, default to 0)
     * @return ApiResponse&lt;EnvironmentListResponse&gt;
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of all environments. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EnvironmentListResponse> getEnvironmentsWithHttpInfo(String code, Integer limit, Integer offset) throws QaseException {
        okhttp3.Call localVarCall = getEnvironmentsValidateBeforeCall(code, limit, offset, null);
        Type localVarReturnType = new TypeToken<EnvironmentListResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all environments. (asynchronously)
     * This method allows to retrieve all environments stored in selected project. 
     * @param code Code of project, where to search entities. (required)
     * @param limit A number of entities in result set. (optional, default to 10)
     * @param offset How many entities should be skipped. (optional, default to 0)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws QaseException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of all environments. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEnvironmentsAsync(String code, Integer limit, Integer offset, final ApiCallback<EnvironmentListResponse> _callback) throws QaseException {

        okhttp3.Call localVarCall = getEnvironmentsValidateBeforeCall(code, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<EnvironmentListResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateEnvironment
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param environmentUpdate  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws QaseException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateEnvironmentCall(String code, Integer id, EnvironmentUpdate environmentUpdate, final ApiCallback _callback) throws QaseException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = environmentUpdate;

        // create path and map variables
        String localVarPath = "/environment/{code}/{id}"
            .replace("{" + "code" + "}", localVarApiClient.escapeString(code.toString()))
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "TokenAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateEnvironmentValidateBeforeCall(String code, Integer id, EnvironmentUpdate environmentUpdate, final ApiCallback _callback) throws QaseException {
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updateEnvironment(Async)");
        }

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling updateEnvironment(Async)");
        }

        // verify the required parameter 'environmentUpdate' is set
        if (environmentUpdate == null) {
            throw new QaseException("Missing the required parameter 'environmentUpdate' when calling updateEnvironment(Async)");
        }

        return updateEnvironmentCall(code, id, environmentUpdate, _callback);

    }

    /**
     * Update environment.
     * This method updates an environment. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param environmentUpdate  (required)
     * @return IdResponse
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public IdResponse updateEnvironment(String code, Integer id, EnvironmentUpdate environmentUpdate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = updateEnvironmentWithHttpInfo(code, id, environmentUpdate);
        return localVarResp.getData();
    }

    /**
     * Update environment.
     * This method updates an environment. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param environmentUpdate  (required)
     * @return ApiResponse&lt;IdResponse&gt;
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IdResponse> updateEnvironmentWithHttpInfo(String code, Integer id, EnvironmentUpdate environmentUpdate) throws QaseException {
        okhttp3.Call localVarCall = updateEnvironmentValidateBeforeCall(code, id, environmentUpdate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update environment. (asynchronously)
     * This method updates an environment. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param environmentUpdate  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws QaseException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateEnvironmentAsync(String code, Integer id, EnvironmentUpdate environmentUpdate, final ApiCallback<IdResponse> _callback) throws QaseException {

        okhttp3.Call localVarCall = updateEnvironmentValidateBeforeCall(code, id, environmentUpdate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
