/*
 * Qase.io API
 * Qase API Specification.
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: support@qase.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.*;
import io.qase.client.model.*;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SuitesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SuitesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SuitesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createSuite
     * @param code Code of project, where to search entities. (required)
     * @param suiteCreate  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws QaseException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSuiteCall(String code, SuiteCreate suiteCreate, final ApiCallback _callback) throws QaseException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = suiteCreate;

        // create path and map variables
        String localVarPath = "/suite/{code}"
            .replace("{" + "code" + "}", localVarApiClient.escapeString(code.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "TokenAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createSuiteValidateBeforeCall(String code, SuiteCreate suiteCreate, final ApiCallback _callback) throws QaseException {
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createSuite(Async)");
        }

        // verify the required parameter 'suiteCreate' is set
        if (suiteCreate == null) {
            throw new QaseException("Missing the required parameter 'suiteCreate' when calling createSuite(Async)");
        }

        return createSuiteCall(code, suiteCreate, _callback);

    }

    /**
     * Create a new test suite.
     * This method is used to create a new test suite through API. 
     * @param code Code of project, where to search entities. (required)
     * @param suiteCreate  (required)
     * @return IdResponse
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public IdResponse createSuite(String code, SuiteCreate suiteCreate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = createSuiteWithHttpInfo(code, suiteCreate);
        return localVarResp.getData();
    }

    /**
     * Create a new test suite.
     * This method is used to create a new test suite through API. 
     * @param code Code of project, where to search entities. (required)
     * @param suiteCreate  (required)
     * @return ApiResponse&lt;IdResponse&gt;
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IdResponse> createSuiteWithHttpInfo(String code, SuiteCreate suiteCreate) throws QaseException {
        okhttp3.Call localVarCall = createSuiteValidateBeforeCall(code, suiteCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a new test suite. (asynchronously)
     * This method is used to create a new test suite through API. 
     * @param code Code of project, where to search entities. (required)
     * @param suiteCreate  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws QaseException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSuiteAsync(String code, SuiteCreate suiteCreate, final ApiCallback<IdResponse> _callback) throws QaseException {

        okhttp3.Call localVarCall = createSuiteValidateBeforeCall(code, suiteCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteSuite
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param suiteDelete  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws QaseException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result of operation. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteSuiteCall(String code, Integer id, SuiteDelete suiteDelete, final ApiCallback _callback) throws QaseException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = suiteDelete;

        // create path and map variables
        String localVarPath = "/suite/{code}/{id}"
            .replace("{" + "code" + "}", localVarApiClient.escapeString(code.toString()))
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "TokenAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteSuiteValidateBeforeCall(String code, Integer id, SuiteDelete suiteDelete, final ApiCallback _callback) throws QaseException {
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling deleteSuite(Async)");
        }

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling deleteSuite(Async)");
        }

        return deleteSuiteCall(code, id, suiteDelete, _callback);

    }

    /**
     * Delete test suite.
     * This method completely deletes a test suite with test cases from repository. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param suiteDelete  (optional)
     * @return IdResponse
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result of operation. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public IdResponse deleteSuite(String code, Integer id, SuiteDelete suiteDelete) throws QaseException {
        ApiResponse<IdResponse> localVarResp = deleteSuiteWithHttpInfo(code, id, suiteDelete);
        return localVarResp.getData();
    }

    /**
     * Delete test suite.
     * This method completely deletes a test suite with test cases from repository. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param suiteDelete  (optional)
     * @return ApiResponse&lt;IdResponse&gt;
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result of operation. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IdResponse> deleteSuiteWithHttpInfo(String code, Integer id, SuiteDelete suiteDelete) throws QaseException {
        okhttp3.Call localVarCall = deleteSuiteValidateBeforeCall(code, id, suiteDelete, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete test suite. (asynchronously)
     * This method completely deletes a test suite with test cases from repository. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param suiteDelete  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws QaseException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result of operation. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteSuiteAsync(String code, Integer id, SuiteDelete suiteDelete, final ApiCallback<IdResponse> _callback) throws QaseException {

        okhttp3.Call localVarCall = deleteSuiteValidateBeforeCall(code, id, suiteDelete, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSuite
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws QaseException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A Test Case. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSuiteCall(String code, Integer id, final ApiCallback _callback) throws QaseException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/suite/{code}/{id}"
            .replace("{" + "code" + "}", localVarApiClient.escapeString(code.toString()))
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "TokenAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSuiteValidateBeforeCall(String code, Integer id, final ApiCallback _callback) throws QaseException {
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getSuite(Async)");
        }

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling getSuite(Async)");
        }

        return getSuiteCall(code, id, _callback);

    }

    /**
     * Get a specific test suite.
     * This method allows to retrieve a specific test suite. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @return SuiteResponse
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A Test Case. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public SuiteResponse getSuite(String code, Integer id) throws QaseException {
        ApiResponse<SuiteResponse> localVarResp = getSuiteWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    /**
     * Get a specific test suite.
     * This method allows to retrieve a specific test suite. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @return ApiResponse&lt;SuiteResponse&gt;
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A Test Case. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SuiteResponse> getSuiteWithHttpInfo(String code, Integer id) throws QaseException {
        okhttp3.Call localVarCall = getSuiteValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<SuiteResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a specific test suite. (asynchronously)
     * This method allows to retrieve a specific test suite. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws QaseException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A Test Case. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSuiteAsync(String code, Integer id, final ApiCallback<SuiteResponse> _callback) throws QaseException {

        okhttp3.Call localVarCall = getSuiteValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<SuiteResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSuites
     * @param code Code of project, where to search entities. (required)
     * @param filters  (optional)
     * @param limit A number of entities in result set. (optional, default to 10)
     * @param offset How many entities should be skipped. (optional, default to 0)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws QaseException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of all suites of project. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSuitesCall(String code, GetMilestonesFiltersParameter filters, Integer limit, Integer offset, final ApiCallback _callback) throws QaseException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/suite/{code}"
            .replace("{" + "code" + "}", localVarApiClient.escapeString(code.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "TokenAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSuitesValidateBeforeCall(String code, GetMilestonesFiltersParameter filters, Integer limit, Integer offset, final ApiCallback _callback) throws QaseException {
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getSuites(Async)");
        }

        return getSuitesCall(code, filters, limit, offset, _callback);

    }

    /**
     * Get all test suites.
     * This method allows to retrieve all test suites stored in selected project. 
     * @param code Code of project, where to search entities. (required)
     * @param filters  (optional)
     * @param limit A number of entities in result set. (optional, default to 10)
     * @param offset How many entities should be skipped. (optional, default to 0)
     * @return SuiteListResponse
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of all suites of project. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public SuiteListResponse getSuites(String code, GetMilestonesFiltersParameter filters, Integer limit, Integer offset) throws QaseException {
        ApiResponse<SuiteListResponse> localVarResp = getSuitesWithHttpInfo(code, filters, limit, offset);
        return localVarResp.getData();
    }

    /**
     * Get all test suites.
     * This method allows to retrieve all test suites stored in selected project. 
     * @param code Code of project, where to search entities. (required)
     * @param filters  (optional)
     * @param limit A number of entities in result set. (optional, default to 10)
     * @param offset How many entities should be skipped. (optional, default to 0)
     * @return ApiResponse&lt;SuiteListResponse&gt;
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of all suites of project. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SuiteListResponse> getSuitesWithHttpInfo(String code, GetMilestonesFiltersParameter filters, Integer limit, Integer offset) throws QaseException {
        okhttp3.Call localVarCall = getSuitesValidateBeforeCall(code, filters, limit, offset, null);
        Type localVarReturnType = new TypeToken<SuiteListResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all test suites. (asynchronously)
     * This method allows to retrieve all test suites stored in selected project. 
     * @param code Code of project, where to search entities. (required)
     * @param filters  (optional)
     * @param limit A number of entities in result set. (optional, default to 10)
     * @param offset How many entities should be skipped. (optional, default to 0)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws QaseException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of all suites of project. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSuitesAsync(String code, GetMilestonesFiltersParameter filters, Integer limit, Integer offset, final ApiCallback<SuiteListResponse> _callback) throws QaseException {

        okhttp3.Call localVarCall = getSuitesValidateBeforeCall(code, filters, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<SuiteListResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateSuite
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param suiteUpdate  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws QaseException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result of operation. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuiteCall(String code, Integer id, SuiteUpdate suiteUpdate, final ApiCallback _callback) throws QaseException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = suiteUpdate;

        // create path and map variables
        String localVarPath = "/suite/{code}/{id}"
            .replace("{" + "code" + "}", localVarApiClient.escapeString(code.toString()))
            .replace("{" + "id" + "}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "TokenAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateSuiteValidateBeforeCall(String code, Integer id, SuiteUpdate suiteUpdate, final ApiCallback _callback) throws QaseException {
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updateSuite(Async)");
        }

        // verify the required parameter 'id' is set
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling updateSuite(Async)");
        }

        // verify the required parameter 'suiteUpdate' is set
        if (suiteUpdate == null) {
            throw new QaseException("Missing the required parameter 'suiteUpdate' when calling updateSuite(Async)");
        }

        return updateSuiteCall(code, id, suiteUpdate, _callback);

    }

    /**
     * Update test suite.
     * This method is used to update a test suite through API. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param suiteUpdate  (required)
     * @return IdResponse
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result of operation. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public IdResponse updateSuite(String code, Integer id, SuiteUpdate suiteUpdate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = updateSuiteWithHttpInfo(code, id, suiteUpdate);
        return localVarResp.getData();
    }

    /**
     * Update test suite.
     * This method is used to update a test suite through API. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param suiteUpdate  (required)
     * @return ApiResponse&lt;IdResponse&gt;
     * @throws QaseException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result of operation. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IdResponse> updateSuiteWithHttpInfo(String code, Integer id, SuiteUpdate suiteUpdate) throws QaseException {
        okhttp3.Call localVarCall = updateSuiteValidateBeforeCall(code, id, suiteUpdate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update test suite. (asynchronously)
     * This method is used to update a test suite through API. 
     * @param code Code of project, where to search entities. (required)
     * @param id Identifier. (required)
     * @param suiteUpdate  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws QaseException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A result of operation. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable Entity. </td><td>  -  </td></tr>
        <tr><td> 429 </td><td> Too Many Requests. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuiteAsync(String code, Integer id, SuiteUpdate suiteUpdate, final ApiCallback<IdResponse> _callback) throws QaseException {

        okhttp3.Call localVarCall = updateSuiteValidateBeforeCall(code, id, suiteUpdate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
