/*
 * Qase.io API
 * Qase API Specification.
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: support@qase.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.qase.client.model;

import com.google.gson.*;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.qase.client.JSON;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;

import java.io.IOException;
import java.util.*;

/**
 * ResultCreate
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-04T01:02:11.281898+03:00[Europe/Moscow]")
public class ResultCreate {
  public static final String SERIALIZED_NAME_CASE_ID = "case_id";
  @SerializedName(SERIALIZED_NAME_CASE_ID)
  private Long caseId;

  public static final String SERIALIZED_NAME_CASE = "case";
  @SerializedName(SERIALIZED_NAME_CASE)
  private ResultCreateCase _case;

  /**
   * Gets or Sets status
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    IN_PROGRESS("in_progress"),
    
    PASSED("passed"),
    
    FAILED("failed"),
    
    BLOCKED("blocked"),
    
    SKIPPED("skipped"),
    
    INVALID("invalid");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_TIME = "time";
  @SerializedName(SERIALIZED_NAME_TIME)
  private Long time;

  public static final String SERIALIZED_NAME_TIME_MS = "time_ms";
  @SerializedName(SERIALIZED_NAME_TIME_MS)
  private Long timeMs;

  public static final String SERIALIZED_NAME_DEFECT = "defect";
  @SerializedName(SERIALIZED_NAME_DEFECT)
  private Boolean defect;

  public static final String SERIALIZED_NAME_ATTACHMENTS = "attachments";
  @SerializedName(SERIALIZED_NAME_ATTACHMENTS)
  private List<String> attachments = null;

  public static final String SERIALIZED_NAME_STACKTRACE = "stacktrace";
  @SerializedName(SERIALIZED_NAME_STACKTRACE)
  private String stacktrace;

  public static final String SERIALIZED_NAME_COMMENT = "comment";
  @SerializedName(SERIALIZED_NAME_COMMENT)
  private String comment;

  public static final String SERIALIZED_NAME_PARAM = "param";
  @SerializedName(SERIALIZED_NAME_PARAM)
  private Map<String, String> param = null;

  public static final String SERIALIZED_NAME_STEPS = "steps";
  @SerializedName(SERIALIZED_NAME_STEPS)
  private List<ResultCreateStepsInner> steps = null;

  public ResultCreate() {
  }

  public ResultCreate caseId(Long caseId) {
    
    this.caseId = caseId;
    return this;
  }

   /**
   * Get caseId
   * @return caseId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getCaseId() {
    return caseId;
  }


  public void setCaseId(Long caseId) {
    this.caseId = caseId;
  }


  public ResultCreate _case(ResultCreateCase _case) {
    
    this._case = _case;
    return this;
  }

   /**
   * Get _case
   * @return _case
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ResultCreateCase getCase() {
    return _case;
  }


  public void setCase(ResultCreateCase _case) {
    this._case = _case;
  }


  public ResultCreate status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public ResultCreate time(Long time) {
    
    this.time = time;
    return this;
  }

   /**
   * Get time
   * minimum: 0
   * maximum: 31536000
   * @return time
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getTime() {
    return time;
  }


  public void setTime(Long time) {
    this.time = time;
  }


  public ResultCreate timeMs(Long timeMs) {
    
    this.timeMs = timeMs;
    return this;
  }

   /**
   * Get timeMs
   * minimum: 0
   * maximum: 31536000000
   * @return timeMs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getTimeMs() {
    return timeMs;
  }


  public void setTimeMs(Long timeMs) {
    this.timeMs = timeMs;
  }


  public ResultCreate defect(Boolean defect) {
    
    this.defect = defect;
    return this;
  }

   /**
   * Get defect
   * @return defect
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getDefect() {
    return defect;
  }


  public void setDefect(Boolean defect) {
    this.defect = defect;
  }


  public ResultCreate attachments(List<String> attachments) {
    
    this.attachments = attachments;
    return this;
  }

  public ResultCreate addAttachmentsItem(String attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

   /**
   * Get attachments
   * @return attachments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getAttachments() {
    return attachments;
  }


  public void setAttachments(List<String> attachments) {
    this.attachments = attachments;
  }


  public ResultCreate stacktrace(String stacktrace) {
    
    this.stacktrace = stacktrace;
    return this;
  }

   /**
   * Get stacktrace
   * @return stacktrace
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getStacktrace() {
    return stacktrace;
  }


  public void setStacktrace(String stacktrace) {
    this.stacktrace = stacktrace;
  }


  public ResultCreate comment(String comment) {
    
    this.comment = comment;
    return this;
  }

   /**
   * Get comment
   * @return comment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getComment() {
    return comment;
  }


  public void setComment(String comment) {
    this.comment = comment;
  }


  public ResultCreate param(Map<String, String> param) {
    
    this.param = param;
    return this;
  }

  public ResultCreate putParamItem(String key, String paramItem) {
    if (this.param == null) {
      this.param = new HashMap<>();
    }
    this.param.put(key, paramItem);
    return this;
  }

   /**
   * A map of parameters (name &#x3D;&gt; value)
   * @return param
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A map of parameters (name => value)")

  public Map<String, String> getParam() {
    return param;
  }


  public void setParam(Map<String, String> param) {
    this.param = param;
  }


  public ResultCreate steps(List<ResultCreateStepsInner> steps) {
    
    this.steps = steps;
    return this;
  }

  public ResultCreate addStepsItem(ResultCreateStepsInner stepsItem) {
    if (this.steps == null) {
      this.steps = new ArrayList<>();
    }
    this.steps.add(stepsItem);
    return this;
  }

   /**
   * Get steps
   * @return steps
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<ResultCreateStepsInner> getSteps() {
    return steps;
  }


  public void setSteps(List<ResultCreateStepsInner> steps) {
    this.steps = steps;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResultCreate resultCreate = (ResultCreate) o;
    return Objects.equals(this.caseId, resultCreate.caseId) &&
        Objects.equals(this._case, resultCreate._case) &&
        Objects.equals(this.status, resultCreate.status) &&
        Objects.equals(this.time, resultCreate.time) &&
        Objects.equals(this.timeMs, resultCreate.timeMs) &&
        Objects.equals(this.defect, resultCreate.defect) &&
        Objects.equals(this.attachments, resultCreate.attachments) &&
        Objects.equals(this.stacktrace, resultCreate.stacktrace) &&
        Objects.equals(this.comment, resultCreate.comment) &&
        Objects.equals(this.param, resultCreate.param) &&
        Objects.equals(this.steps, resultCreate.steps);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(caseId, _case, status, time, timeMs, defect, attachments, stacktrace, comment, param, steps);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResultCreate {\n");
    sb.append("    caseId: ").append(toIndentedString(caseId)).append("\n");
    sb.append("    _case: ").append(toIndentedString(_case)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    time: ").append(toIndentedString(time)).append("\n");
    sb.append("    timeMs: ").append(toIndentedString(timeMs)).append("\n");
    sb.append("    defect: ").append(toIndentedString(defect)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    stacktrace: ").append(toIndentedString(stacktrace)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    param: ").append(toIndentedString(param)).append("\n");
    sb.append("    steps: ").append(toIndentedString(steps)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("case_id");
    openapiFields.add("case");
    openapiFields.add("status");
    openapiFields.add("time");
    openapiFields.add("time_ms");
    openapiFields.add("defect");
    openapiFields.add("attachments");
    openapiFields.add("stacktrace");
    openapiFields.add("comment");
    openapiFields.add("param");
    openapiFields.add("steps");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("status");
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ResultCreate.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ResultCreate' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ResultCreate> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ResultCreate.class));

       return (TypeAdapter<T>) new TypeAdapter<ResultCreate>() {
           @Override
           public void write(JsonWriter out, ResultCreate value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ResultCreate read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ResultCreate given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ResultCreate
  * @throws IOException if the JSON string is invalid with respect to ResultCreate
  */
  public static ResultCreate fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ResultCreate.class);
  }

 /**
  * Convert an instance of ResultCreate to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

