/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.config.apiclient;

import io.qase.api.QaseClient;
import io.qase.api.config.apiclient.ApiClientConfigurer;
import io.qase.api.utils.StringUtils;
import io.qase.client.ApiClient;
import io.qase.utils.CommonUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultHeadersApiConfigurer
implements ApiClientConfigurer {
    private static final Logger log = LoggerFactory.getLogger(DefaultHeadersApiConfigurer.class);
    public static final String QASE_API = "qaseapi";
    public static final String OS = "os";
    public static final String ARCH = "arch";
    public static final String LANGUAGE = "java";
    protected static final String UNKNOWN = "unknown";

    public static ApiClientConfigurer createDefaultConfigurer() {
        return new DefaultHeadersApiConfigurer(){

            @Override
            protected String getFrameworkName() {
                return DefaultHeadersApiConfigurer.UNKNOWN;
            }

            @Override
            protected String getFrameworkVersion() {
                return DefaultHeadersApiConfigurer.UNKNOWN;
            }
        };
    }

    @Override
    public void configure(ApiClient apiClient) {
        apiClient.addDefaultHeader("X-CLIENT-REPORTER", QaseClient.getConfig().clientReporterName());
        String xClientHeaderValue = this.buildXClientHeaderValue();
        this.addDefaultHeaderIfNotBlank(apiClient, "X-Client", xClientHeaderValue);
        this.addDefaultHeaderIfNotBlank(apiClient, "X-Platform", this.buildXPlatformHeaderValue());
    }

    protected abstract String getFrameworkName();

    protected abstract String getFrameworkVersion();

    protected String getFrameworkVersionByClassOrUnknown(Class<?> frameworkClass) {
        return this.getFrameworkVersionByPackageOrUnknown(frameworkClass.getPackage());
    }

    private String getFrameworkVersionByPackageOrUnknown(Package frameworkPackage) {
        return this.findFirstNonNullPackageVersionOrUnknown(frameworkPackage);
    }

    private String getReporterVersion() {
        return this.findFirstNonNullPackageVersionOrUnknown(this.getClass().getPackage());
    }

    private String getReporterName() {
        return this.findFirstNonNullPackageTitleOrUnknown(this.getClass().getPackage());
    }

    private String findFirstNonNullPackageInfoOrUnknown(Package aPackage, List<Function<Package, String>> packageInfoGetters) {
        return CommonUtils.getFirstNonNullResult(aPackage, packageInfoGetters).orElse(UNKNOWN);
    }

    private String findFirstNonNullPackageVersionOrUnknown(Package aPackage) {
        return this.findFirstNonNullPackageInfoOrUnknown(aPackage, Arrays.asList(Package::getImplementationVersion, Package::getSpecificationVersion));
    }

    private String findFirstNonNullPackageTitleOrUnknown(Package aPackage) {
        return this.findFirstNonNullPackageInfoOrUnknown(aPackage, Arrays.asList(Package::getImplementationTitle, Package::getImplementationTitle));
    }

    private String buildXPlatformHeaderValue() {
        return new HeaderFormatter(new HeaderPartFormatter(OS, System.getProperty("os.name")), new HeaderPartFormatter(ARCH, System.getProperty("os.arch")), new HeaderPartFormatter(LANGUAGE, System.getProperty("java.version"))).format();
    }

    private String buildXClientHeaderValue() {
        return new HeaderFormatter(new HeaderPartFormatter(QASE_API, this.findFirstNonNullPackageVersionOrUnknown(DefaultHeadersApiConfigurer.class.getPackage())), new HeaderPartFormatter(this.getReporterName(), this.getReporterVersion()), new HeaderPartFormatter(this.getFrameworkName(), this.getFrameworkVersion())).format();
    }

    private void addDefaultHeaderIfNotBlank(ApiClient apiClient, String headerName, String headerValue) {
        if (!StringUtils.isBlank(headerName)) {
            apiClient.addDefaultHeader(headerName, headerValue);
        } else {
            log.warn("'{}' header value happens to be blank. Ignoring the header.", (Object)headerName);
        }
    }

    private static class HeaderPartFormatter {
        private static final String HEADER_PART_FORMAT = "%s=%s";
        private final String partName;
        private final String partValue;

        private static String orUnknown(String string) {
            return Optional.ofNullable(string).orElse(DefaultHeadersApiConfigurer.UNKNOWN);
        }

        public String format() {
            return String.format(HEADER_PART_FORMAT, HeaderPartFormatter.orUnknown(this.partName), HeaderPartFormatter.orUnknown(this.partValue));
        }

        public HeaderPartFormatter(String partName, String partValue) {
            this.partName = partName;
            this.partValue = partValue;
        }
    }

    private static class HeaderFormatter {
        private static final String DELIMITER = ";";
        private final List<HeaderPartFormatter> headerPartFormatters;

        public HeaderFormatter(HeaderPartFormatter ... headerPartFormatters) {
            this.headerPartFormatters = Arrays.asList(headerPartFormatters);
        }

        public String format() {
            return this.headerPartFormatters.stream().map(HeaderPartFormatter::format).collect(Collectors.joining(DELIMITER));
        }
    }
}

