/*
 * Decompiled with CFR 0.152.
 */
package io.qase.api.services;

import io.qase.api.CasesStorage;
import io.qase.api.StepStorage;
import io.qase.api.annotation.QaseId;
import io.qase.api.annotation.Step;
import io.qase.api.exceptions.QaseException;
import io.qase.api.exceptions.UncheckedQaseException;
import io.qase.client.api.AttachmentsApi;
import io.qase.client.model.AttachmentGet;
import io.qase.client.model.AttachmentUploadsResponse;
import io.qase.guice.Injectors;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Attachments {
    private static final AttachmentsApi ATTACHMENTS_API = Attachments.createAttachmentsApi();

    public static void addAttachmentsToCurrentContext(Collection<File> attachments) throws QaseException {
        AttachmentContext attachmentContext = Attachments.lookupCurrentContext();
        AttachmentUploadsResponse attachmentUploadsResponse = ATTACHMENTS_API.uploadAttachment(System.getProperty("QASE_PROJECT_CODE"), new ArrayList<File>(attachments));
        Collection attachmentIds = Optional.ofNullable(attachmentUploadsResponse.getResult()).orElseGet(ArrayList::new).stream().map(AttachmentGet::getHash).collect(Collectors.toList());
        switch (attachmentContext) {
            case TEST_STEP: {
                Attachments.addAttachmentsToCurrentTestStep(attachmentIds);
                break;
            }
            case TEST_CASE: {
                Attachments.addAttachmentsToCurrentTestCase(attachmentIds);
            }
        }
    }

    public static void addAttachmentsToCurrentContext(File ... attachments) throws QaseException {
        Attachments.addAttachmentsToCurrentContext(Arrays.asList(attachments));
    }

    private static void addAttachmentsToCurrentTestCase(Collection<String> attachmentIds) {
        Attachments.addAttachmentsToCollection(() -> CasesStorage.getCurrentCase().getAttachments(), absolutePaths -> CasesStorage.getCurrentCase().setAttachments((List<String>)absolutePaths), attachmentIds);
    }

    private static void addAttachmentsToCurrentTestStep(Collection<String> attachmentsIds) {
        Attachments.addAttachmentsToCollection(() -> StepStorage.getCurrentStep().getAttachments(), absolutePaths -> StepStorage.getCurrentStep().setAttachments((List<String>)absolutePaths), attachmentsIds);
    }

    private static void addAttachmentsToCollection(Supplier<List<String>> collectionGetter, Consumer<List<String>> collectionSetter, Collection<String> attachmentsIds) {
        List currentStepAttachments = Optional.ofNullable(collectionGetter.get()).orElseGet(ArrayList::new);
        currentStepAttachments.addAll(attachmentsIds);
        collectionSetter.accept(currentStepAttachments);
    }

    private static AttachmentContext lookupCurrentContext() {
        if (StepStorage.isStepInProgress()) {
            return AttachmentContext.TEST_STEP;
        }
        if (CasesStorage.getCurrentCase() != null) {
            return AttachmentContext.TEST_CASE;
        }
        throw new UncheckedQaseException(new QaseException(String.format("It is expected either %s or %s-annotated method be called.", Step.class.getName(), QaseId.class.getName())));
    }

    private static AttachmentsApi createAttachmentsApi() {
        return (AttachmentsApi)Injectors.createDefaultInjector().getInstance(AttachmentsApi.class);
    }

    private static enum AttachmentContext {
        TEST_CASE,
        TEST_STEP;

    }
}

