/*
 * Decompiled with CFR 0.152.
 */
package io.qase.junit5;

import io.qase.commons.reporters.CoreReporterFactory;
import io.qase.commons.utils.IntegrationUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.PostDiscoveryFilter;

public class Junit5PostDiscoveryFilter
implements PostDiscoveryFilter {
    private final List<Long> caseIds = CoreReporterFactory.getInstance().getTestCaseIdsForExecution();

    public FilterResult apply(TestDescriptor testDescriptor) {
        if (this.caseIds.isEmpty()) {
            return FilterResult.includedIf((boolean)true);
        }
        if (!testDescriptor.getChildren().isEmpty()) {
            return FilterResult.included((String)"filter only applied for tests");
        }
        Optional testSource = testDescriptor.getSource();
        if (!testSource.isPresent()) {
            return FilterResult.includedIf((boolean)false);
        }
        MethodSource methodSource = (MethodSource)testSource.get();
        List ids = IntegrationUtils.getCaseIds((Method)methodSource.getJavaMethod());
        if (ids == null) {
            return FilterResult.includedIf((boolean)false);
        }
        for (Long id : ids) {
            if (!this.caseIds.contains(id)) continue;
            return FilterResult.includedIf((boolean)true);
        }
        return FilterResult.includedIf((boolean)false);
    }
}

