/*
 * Decompiled with CFR 0.152.
 */
package io.qase.junit5;

import io.qase.commons.CasesStorage;
import io.qase.commons.StepStorage;
import io.qase.commons.models.domain.Relations;
import io.qase.commons.models.domain.SuiteData;
import io.qase.commons.models.domain.TestResult;
import io.qase.commons.models.domain.TestResultStatus;
import io.qase.commons.reporters.CoreReporterFactory;
import io.qase.commons.reporters.Reporter;
import io.qase.commons.utils.ExceptionUtils;
import io.qase.commons.utils.IntegrationUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;

public class QaseListener
implements TestExecutionListener,
Extension,
BeforeAllCallback,
AfterAllCallback,
InvocationInterceptor,
TestWatcher {
    private final Reporter qaseTestCaseListener = CoreReporterFactory.getInstance();

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.qaseTestCaseListener.startTestRun();
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.qaseTestCaseListener.uploadResults();
        this.qaseTestCaseListener.completeTestRun();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        TestResult result = this.startTestCase(extensionContext.getRequiredTestMethod(), invocationContext);
        CasesStorage.startCase((TestResult)result);
        invocation.proceed();
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        TestResult result = this.startTestCase(extensionContext.getRequiredTestMethod(), invocationContext);
        CasesStorage.startCase((TestResult)result);
        invocation.proceed();
    }

    private TestResult startTestCase(Method method, ReflectiveInvocationContext<Method> invocationContext) {
        TestResult resultCreate = new TestResult();
        boolean ignore = IntegrationUtils.getQaseIgnore((Method)method);
        if (ignore) {
            resultCreate.ignore = true;
            return resultCreate;
        }
        List caseIds = IntegrationUtils.getCaseIds((Method)method);
        String caseTitle = IntegrationUtils.getCaseTitle((Method)method);
        Map<String, String> parameters = this.getParameters(invocationContext);
        Map fields = IntegrationUtils.getQaseFields((Method)method);
        String suite = IntegrationUtils.getQaseSuite((Method)method);
        Relations relations = new Relations();
        if (suite != null) {
            String[] parts;
            for (String part : parts = suite.split("\t")) {
                SuiteData data = new SuiteData();
                data.title = part;
                relations.suite.data.add(data);
            }
        } else {
            SuiteData className = new SuiteData();
            className.title = method.getDeclaringClass().getName();
            relations.suite.data.add(className);
        }
        resultCreate.execution.startTime = Instant.now().toEpochMilli();
        resultCreate.execution.thread = Thread.currentThread().getName();
        resultCreate.testopsIds = caseIds;
        resultCreate.title = caseTitle;
        resultCreate.params = parameters;
        resultCreate.fields = fields;
        resultCreate.relations = relations;
        resultCreate.signature = IntegrationUtils.generateSignature((Method)method, (List)caseIds, parameters);
        return resultCreate;
    }

    private Map<String, String> getParameters(ReflectiveInvocationContext<Method> invocationContext) {
        Parameter[] parameters = ((Method)invocationContext.getExecutable()).getParameters();
        HashMap<String, String> testParameters = new HashMap<String, String>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Class<?> parameterType = parameter.getType();
            if (parameterType.getCanonicalName().startsWith("org.junit.jupiter.api")) continue;
            String name = parameter.getName();
            String value = invocationContext.getArguments().get(i).toString();
            testParameters.put(name, value);
        }
        return testParameters;
    }

    public void testSuccessful(ExtensionContext context) {
        this.stopTestCase(TestResultStatus.PASSED, null);
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        this.stopTestCase(TestResultStatus.SKIPPED, cause);
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        TestResultStatus status = ExceptionUtils.isAssertionFailure((Throwable)cause) ? TestResultStatus.FAILED : TestResultStatus.INVALID;
        this.stopTestCase(status, cause);
    }

    private void stopTestCase(TestResultStatus status, Throwable cause) {
        TestResult resultCreate = CasesStorage.getCurrentCase();
        if (resultCreate.ignore) {
            CasesStorage.stopCase();
            return;
        }
        Optional<Throwable> resultThrowable = Optional.ofNullable(cause);
        String comment = resultThrowable.flatMap(throwable -> Optional.of(throwable.toString())).orElse(null);
        String stacktrace = resultThrowable.flatMap(throwable -> Optional.of(IntegrationUtils.getStacktrace((Throwable)throwable))).orElse(null);
        LinkedList steps = StepStorage.stopSteps();
        resultCreate.execution.status = status;
        resultCreate.execution.endTime = Instant.now().toEpochMilli();
        resultCreate.execution.duration = (int)(resultCreate.execution.endTime - resultCreate.execution.startTime);
        resultCreate.execution.stacktrace = stacktrace;
        resultCreate.steps = steps;
        if (comment != null) {
            resultCreate.message = resultCreate.message != null ? resultCreate.message + "\n\n" + comment : comment;
        }
        this.qaseTestCaseListener.addResult(resultCreate);
        CasesStorage.stopCase();
    }
}

