/*
 * Decompiled with CFR 0.152.
 */
package io.qase.junit5;

import io.qameta.allure.TmsLink;
import io.qase.api.QaseApi;
import io.qase.api.annotation.CaseId;
import io.qase.api.enums.RunResultStatus;
import io.qase.api.exceptions.QaseException;
import io.qase.api.models.v1.testrunresults.Step;
import io.qase.api.utils.IntegrationUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QaseExtension
implements TestExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(QaseExtension.class);
    private boolean isEnabled;
    private String projectCode;
    private String runId;
    private QaseApi qaseApi;
    private final Map<TestIdentifier, Long> startTime = new ConcurrentHashMap<TestIdentifier, Long>();

    public QaseExtension() {
        this.isEnabled = Boolean.parseBoolean(System.getProperty("qase.enable", "false"));
        if (!this.isEnabled) {
            return;
        }
        String apiToken = System.getProperty("qase.api.token", System.getenv("qase.api.token"));
        if (apiToken == null) {
            logger.error("Required parameter '{}' not specified", (Object)"qase.api.token");
            this.isEnabled = false;
            return;
        }
        String qaseUrl = System.getProperty("qase.url");
        this.qaseApi = qaseUrl != null ? new QaseApi(apiToken, qaseUrl) : new QaseApi(apiToken);
        this.projectCode = System.getProperty("qase.project.code", System.getenv("qase.project.code"));
        if (this.projectCode == null) {
            logger.error("Required parameter '{}' not specified", (Object)"qase.project.code");
            this.isEnabled = false;
            return;
        }
        logger.info("Qase project code - {}", (Object)this.projectCode);
        this.runId = System.getProperty("qase.run.id", System.getenv("qase.run.id"));
        if (this.runId == null) {
            logger.error("Required parameter '{}' not specified", (Object)"qase.run.id");
            this.isEnabled = false;
            return;
        }
        logger.info("Qase run id - {}", (Object)this.runId);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (this.isEnabled && testIdentifier.isTest()) {
            this.startTime.put(testIdentifier, System.currentTimeMillis());
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (this.isEnabled && testIdentifier.isTest()) {
            Duration duration = Duration.ofMillis(System.currentTimeMillis() - this.startTime.remove(testIdentifier));
            TestSource testSource = testIdentifier.getSource().orElse(null);
            if (testSource instanceof MethodSource) {
                try {
                    Method testMethod = this.getMethod((MethodSource)testSource);
                    this.sendResults(testExecutionResult, duration, testMethod);
                }
                catch (QaseException e) {
                    logger.error(e.getMessage());
                }
                catch (NumberFormatException e) {
                    logger.error("String could not be parsed as Long", (Throwable)e);
                }
            }
        }
    }

    private void sendResults(TestExecutionResult testExecutionResult, Duration duration, Method testMethod) {
        if (testMethod != null) {
            CaseId caseId = testMethod.getAnnotation(CaseId.class);
            TmsLink tmsLink = testMethod.getAnnotation(TmsLink.class);
            if (caseId != null || tmsLink != null) {
                RunResultStatus runResultStatus = testExecutionResult.getStatus() == TestExecutionResult.Status.SUCCESSFUL ? RunResultStatus.passed : RunResultStatus.failed;
                String comment = testExecutionResult.getThrowable().flatMap(throwable -> Optional.of(throwable.toString())).orElse(null);
                Boolean isDefect = testExecutionResult.getThrowable().flatMap(throwable -> Optional.of(throwable instanceof AssertionError)).orElse(false);
                String stacktrace = testExecutionResult.getThrowable().flatMap(throwable -> Optional.of(IntegrationUtils.getStacktrace((Throwable)throwable))).orElse(null);
                try {
                    this.qaseApi.testRunResults().create(this.projectCode, Long.parseLong(this.runId), caseId != null ? caseId.value() : Long.parseLong(tmsLink.value()), runResultStatus, duration, null, comment, stacktrace, isDefect, new Step[0]);
                }
                catch (QaseException e) {
                    logger.error(e.getMessage());
                }
                catch (NumberFormatException e) {
                    logger.error("String could not be parsed as Long", (Throwable)e);
                }
            }
        }
    }

    private Method getMethod(MethodSource testSource) {
        try {
            Class<?> testClass = Class.forName(testSource.getClassName());
            return Arrays.stream(testClass.getDeclaredMethods()).filter(method -> MethodSource.from((Method)method).equals((Object)testSource)).findFirst().orElse(null);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
            return null;
        }
    }
}

