/*
 * Decompiled with CFR 0.152.
 */
package io.qdrant.client;

import com.google.common.primitives.Floats;
import io.qdrant.client.grpc.Points;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class VectorFactory {
    private VectorFactory() {
    }

    public static Points.Vector vector(List<Float> values) {
        return Points.Vector.newBuilder().setDense(Points.DenseVector.newBuilder().addAllData(values).build()).build();
    }

    public static Points.Vector vector(float ... values) {
        return Points.Vector.newBuilder().setDense(Points.DenseVector.newBuilder().addAllData(Floats.asList((float[])values)).build()).build();
    }

    public static Points.Vector vector(List<Float> vector, List<Integer> indices) {
        return Points.Vector.newBuilder().setSparse(Points.SparseVector.newBuilder().addAllValues(vector).addAllIndices(indices).build()).build();
    }

    public static Points.Vector vector(Points.Document document) {
        return Points.Vector.newBuilder().setDocument(document).build();
    }

    public static Points.Vector vector(Points.Image image) {
        return Points.Vector.newBuilder().setImage(image).build();
    }

    public static Points.Vector vector(Points.InferenceObject object) {
        return Points.Vector.newBuilder().setObject(object).build();
    }

    public static Points.Vector multiVector(List<List<Float>> vectors) {
        List denseVectors = vectors.stream().map(v -> Points.DenseVector.newBuilder().addAllData((Iterable<? extends Float>)v).build()).collect(Collectors.toList());
        return Points.Vector.newBuilder().setMultiDense(Points.MultiDenseVector.newBuilder().addAllVectors(denseVectors).build()).build();
    }

    public static Points.Vector multiVector(float[][] vectors) {
        ArrayList<Points.DenseVector> denseVectors = new ArrayList<Points.DenseVector>();
        for (float[] vector : vectors) {
            denseVectors.add(Points.DenseVector.newBuilder().addAllData(Floats.asList((float[])vector)).build());
        }
        return Points.Vector.newBuilder().setMultiDense(Points.MultiDenseVector.newBuilder().addAllVectors(denseVectors).build()).build();
    }
}

