/*
 * Decompiled with CFR 0.152.
 */
package io.qdrant.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.qdrant.client.QdrantException;
import io.qdrant.client.QdrantGrpcClient;
import io.qdrant.client.WithPayloadSelectorFactory;
import io.qdrant.client.WithVectorsSelectorFactory;
import io.qdrant.client.grpc.Collections;
import io.qdrant.client.grpc.CollectionsGrpc;
import io.qdrant.client.grpc.JsonWithInt;
import io.qdrant.client.grpc.Points;
import io.qdrant.client.grpc.PointsGrpc;
import io.qdrant.client.grpc.QdrantGrpc;
import io.qdrant.client.grpc.QdrantOuterClass;
import io.qdrant.client.grpc.SnapshotsGrpc;
import io.qdrant.client.grpc.SnapshotsService;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QdrantClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(QdrantClient.class);
    private final QdrantGrpcClient grpcClient;

    public QdrantClient(QdrantGrpcClient grpcClient) {
        this.grpcClient = grpcClient;
    }

    public QdrantGrpcClient grpcClient() {
        return this.grpcClient;
    }

    public ListenableFuture<QdrantOuterClass.HealthCheckReply> healthCheckAsync() {
        return this.healthCheckAsync(null);
    }

    public ListenableFuture<QdrantOuterClass.HealthCheckReply> healthCheckAsync(@Nullable Duration timeout) {
        QdrantGrpc.QdrantFutureStub qdrant = timeout != null ? (QdrantGrpc.QdrantFutureStub)this.grpcClient.qdrant().withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS) : this.grpcClient.qdrant();
        return qdrant.healthCheck(QdrantOuterClass.HealthCheckRequest.getDefaultInstance());
    }

    public ListenableFuture<Collections.CollectionOperationResponse> createCollectionAsync(String collectionName, Collections.VectorParams vectorParams) {
        return this.createCollectionAsync(collectionName, vectorParams, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> createCollectionAsync(String collectionName, Collections.VectorParams vectorParams, @Nullable Duration timeout) {
        return this.createCollectionAsync(Collections.CreateCollection.newBuilder().setCollectionName(collectionName).setVectorsConfig(Collections.VectorsConfig.newBuilder().setParams(vectorParams).build()).build(), timeout);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> createCollectionAsync(String collectionName, Map<String, Collections.VectorParams> namedVectorParams) {
        return this.createCollectionAsync(collectionName, namedVectorParams, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> createCollectionAsync(String collectionName, Map<String, Collections.VectorParams> namedVectorParams, @Nullable Duration timeout) {
        return this.createCollectionAsync(Collections.CreateCollection.newBuilder().setCollectionName(collectionName).setVectorsConfig(Collections.VectorsConfig.newBuilder().setParamsMap(Collections.VectorParamsMap.newBuilder().putAllMap(namedVectorParams).build()).build()).build(), timeout);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> createCollectionAsync(Collections.CreateCollection createCollection) {
        return this.createCollectionAsync(createCollection, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> createCollectionAsync(Collections.CreateCollection createCollection, @Nullable Duration timeout) {
        String collectionName = createCollection.getCollectionName();
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Create collection '{}'", (Object)collectionName);
        ListenableFuture<Collections.CollectionOperationResponse> future = this.getCollections(timeout).create(createCollection);
        this.addLogFailureCallback(future, "Create collection");
        return Futures.transform(future, response -> {
            if (!response.getResult()) {
                logger.error("Collection '{}' could not be created", (Object)collectionName);
                throw new QdrantException("Collection '" + collectionName + "' could not be created");
            }
            return response;
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Collections.CollectionOperationResponse> recreateCollectionAsync(String collectionName, Collections.VectorParams vectorParams) {
        return this.recreateCollectionAsync(collectionName, vectorParams, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> recreateCollectionAsync(String collectionName, Collections.VectorParams vectorParams, @Nullable Duration timeout) {
        return this.recreateCollectionAsync(Collections.CreateCollection.newBuilder().setCollectionName(collectionName).setVectorsConfig(Collections.VectorsConfig.newBuilder().setParams(vectorParams).build()).build(), timeout);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> recreateCollectionAsync(String collectionName, Map<String, Collections.VectorParams> namedVectorParams) {
        return this.recreateCollectionAsync(collectionName, namedVectorParams, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> recreateCollectionAsync(String collectionName, Map<String, Collections.VectorParams> namedVectorParams, @Nullable Duration timeout) {
        return this.recreateCollectionAsync(Collections.CreateCollection.newBuilder().setCollectionName(collectionName).setVectorsConfig(Collections.VectorsConfig.newBuilder().setParamsMap(Collections.VectorParamsMap.newBuilder().putAllMap(namedVectorParams).build()).build()).build(), timeout);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> recreateCollectionAsync(Collections.CreateCollection createCollection) {
        return this.recreateCollectionAsync(createCollection, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> recreateCollectionAsync(Collections.CreateCollection createCollection, @Nullable Duration timeout) {
        return Futures.transformAsync(this.deleteCollectionAsync(createCollection.getCollectionName(), timeout), input -> this.createCollectionAsync(createCollection, timeout), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Collections.CollectionInfo> getCollectionInfoAsync(String collectionName) {
        return this.getCollectionInfoAsync(collectionName, null);
    }

    public ListenableFuture<Collections.CollectionInfo> getCollectionInfoAsync(String collectionName, @Nullable Duration timeout) {
        logger.debug("Get collection info for '{}'", (Object)collectionName);
        Collections.GetCollectionInfoRequest request = Collections.GetCollectionInfoRequest.newBuilder().setCollectionName(collectionName).build();
        ListenableFuture<Collections.GetCollectionInfoResponse> future = this.getCollections(timeout).get(request);
        this.addLogFailureCallback(future, "Get collection info");
        return Futures.transform(future, Collections.GetCollectionInfoResponse::getResult, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Collections.CollectionOperationResponse> deleteCollectionAsync(String collectionName) {
        return this.deleteCollectionAsync(collectionName, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> deleteCollectionAsync(String collectionName, @Nullable Duration timeout) {
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Delete collection '{}'", (Object)collectionName);
        Collections.DeleteCollection deleteCollection = Collections.DeleteCollection.newBuilder().setCollectionName(collectionName).build();
        ListenableFuture<Collections.CollectionOperationResponse> future = this.getCollections(timeout).delete(deleteCollection);
        this.addLogFailureCallback(future, "Delete collection");
        return Futures.transform(future, response -> {
            if (!response.getResult()) {
                logger.error("Collection '{}' could not be deleted", (Object)collectionName);
                throw new QdrantException("Collection '" + collectionName + "' could not be deleted");
            }
            return response;
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<String>> listCollectionsAsync() {
        return this.listCollectionsAsync(null);
    }

    public ListenableFuture<List<String>> listCollectionsAsync(@Nullable Duration timeout) {
        logger.debug("List collections");
        ListenableFuture<Collections.ListCollectionsResponse> future = this.getCollections(timeout).list(Collections.ListCollectionsRequest.getDefaultInstance());
        this.addLogFailureCallback(future, "List collection");
        return Futures.transform(future, response -> response.getCollectionsList().stream().map(Collections.CollectionDescription::getName).collect(Collectors.toList()), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Collections.CollectionOperationResponse> updateCollectionAsync(Collections.UpdateCollection updateCollection) {
        return this.updateCollectionAsync(updateCollection, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> updateCollectionAsync(Collections.UpdateCollection updateCollection, @Nullable Duration timeout) {
        String collectionName = updateCollection.getCollectionName();
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Update collection '{}'", (Object)collectionName);
        ListenableFuture<Collections.CollectionOperationResponse> future = this.getCollections(timeout).update(updateCollection);
        this.addLogFailureCallback(future, "Update collection");
        return Futures.transform(future, response -> {
            if (!response.getResult()) {
                logger.error("Collection '{}' could not be updated", (Object)collectionName);
                throw new QdrantException("Collection '" + collectionName + "' could not be updated");
            }
            return response;
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Boolean> collectionExistsAsync(String collectionName) {
        return this.collectionExistsAsync(collectionName, null);
    }

    public ListenableFuture<Boolean> collectionExistsAsync(String collectionName, @Nullable Duration timeout) {
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Collection exists '{}'", (Object)collectionName);
        ListenableFuture<Collections.CollectionExistsResponse> future = this.getCollections(timeout).collectionExists(Collections.CollectionExistsRequest.newBuilder().setCollectionName(collectionName).build());
        this.addLogFailureCallback(future, "Collection exists");
        return Futures.transform(future, response -> response.getResult().getExists(), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Collections.CollectionOperationResponse> createAliasAsync(String aliasName, String collectionName) {
        return this.createAliasAsync(aliasName, collectionName, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> createAliasAsync(String aliasName, String collectionName, @Nullable Duration timeout) {
        return this.updateAliasesAsync((List<Collections.AliasOperations>)ImmutableList.of((Object)Collections.AliasOperations.newBuilder().setCreateAlias(Collections.CreateAlias.newBuilder().setAliasName(aliasName).setCollectionName(collectionName).build()).build()), timeout);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> renameAliasAsync(String oldAliasName, String newAliasName) {
        return this.renameAliasAsync(oldAliasName, newAliasName, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> renameAliasAsync(String oldAliasName, String newAliasName, @Nullable Duration timeout) {
        return this.updateAliasesAsync((List<Collections.AliasOperations>)ImmutableList.of((Object)Collections.AliasOperations.newBuilder().setRenameAlias(Collections.RenameAlias.newBuilder().setOldAliasName(oldAliasName).setNewAliasName(newAliasName).build()).build()), timeout);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> deleteAliasAsync(String aliasName) {
        return this.deleteAliasAsync(aliasName, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> deleteAliasAsync(String aliasName, @Nullable Duration timeout) {
        return this.updateAliasesAsync((List<Collections.AliasOperations>)ImmutableList.of((Object)Collections.AliasOperations.newBuilder().setDeleteAlias(Collections.DeleteAlias.newBuilder().setAliasName(aliasName).build()).build()), timeout);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> updateAliasesAsync(List<Collections.AliasOperations> aliasOperations) {
        return this.updateAliasesAsync(aliasOperations, null);
    }

    public ListenableFuture<Collections.CollectionOperationResponse> updateAliasesAsync(List<Collections.AliasOperations> aliasOperations, @Nullable Duration timeout) {
        Collections.ChangeAliases request = Collections.ChangeAliases.newBuilder().addAllActions(aliasOperations).build();
        if (logger.isDebugEnabled()) {
            for (Collections.AliasOperations aliasOperation : aliasOperations) {
                switch (aliasOperation.getActionCase()) {
                    case CREATE_ALIAS: {
                        Collections.CreateAlias createAlias = aliasOperation.getCreateAlias();
                        logger.debug("Create alias '{}' for collection '{}'", (Object)createAlias.getAliasName(), (Object)createAlias.getCollectionName());
                        break;
                    }
                    case RENAME_ALIAS: {
                        Collections.RenameAlias renameAlias = aliasOperation.getRenameAlias();
                        logger.debug("Rename alias '{}' to '{}'", (Object)renameAlias.getOldAliasName(), (Object)renameAlias.getNewAliasName());
                        break;
                    }
                    case DELETE_ALIAS: {
                        Collections.DeleteAlias deleteAlias = aliasOperation.getDeleteAlias();
                        logger.debug("Delete alias '{}'", (Object)deleteAlias.getAliasName());
                        break;
                    }
                }
            }
        }
        ListenableFuture<Collections.CollectionOperationResponse> future = this.getCollections(timeout).updateAliases(request);
        this.addLogFailureCallback(future, "Update aliases");
        return Futures.transform(future, response -> {
            if (!response.getResult()) {
                logger.error("Alias update operation could not be performed");
                throw new QdrantException("Alias update could not be performed");
            }
            return response;
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<String>> listCollectionAliasesAsync(String collectionName) {
        return this.listCollectionAliasesAsync(collectionName, null);
    }

    public ListenableFuture<List<String>> listCollectionAliasesAsync(String collectionName, @Nullable Duration timeout) {
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("List aliases for collection '{}'", (Object)collectionName);
        Collections.ListCollectionAliasesRequest request = Collections.ListCollectionAliasesRequest.newBuilder().setCollectionName(collectionName).build();
        ListenableFuture<Collections.ListAliasesResponse> future = this.getCollections(timeout).listCollectionAliases(request);
        this.addLogFailureCallback(future, "List collection aliases");
        return Futures.transform(future, response -> response.getAliasesList().stream().map(Collections.AliasDescription::getAliasName).collect(Collectors.toList()), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<Collections.AliasDescription>> listAliasesAsync() {
        return this.listAliasesAsync(null);
    }

    public ListenableFuture<List<Collections.AliasDescription>> listAliasesAsync(@Nullable Duration timeout) {
        logger.debug("List all aliases");
        ListenableFuture<Collections.ListAliasesResponse> future = this.getCollections(timeout).listAliases(Collections.ListAliasesRequest.getDefaultInstance());
        this.addLogFailureCallback(future, "List aliases");
        return Futures.transform(future, Collections.ListAliasesResponse::getAliasesList, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Collections.CreateShardKeyResponse> createShardKeyAsync(Collections.CreateShardKeyRequest createShardKey) {
        return this.createShardKeyAsync(createShardKey, null);
    }

    public ListenableFuture<Collections.CreateShardKeyResponse> createShardKeyAsync(Collections.CreateShardKeyRequest createShardKey, @Nullable Duration timeout) {
        String collectionName = createShardKey.getCollectionName();
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        Collections.ShardKey shardKey = createShardKey.getRequest().getShardKey();
        logger.debug("Create shard key '{}' for '{}'", (Object)shardKey, (Object)collectionName);
        ListenableFuture<Collections.CreateShardKeyResponse> future = this.getCollections(timeout).createShardKey(createShardKey);
        this.addLogFailureCallback(future, "Create shard key");
        return Futures.transform(future, response -> {
            if (!response.getResult()) {
                logger.error("Shard key could not be created for '{}'", (Object)collectionName);
                throw new QdrantException("Shard key " + shardKey + " could not be created for " + collectionName);
            }
            return response;
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Collections.DeleteShardKeyResponse> deleteShardKeyAsync(Collections.DeleteShardKeyRequest deleteShardKey) {
        return this.deleteShardKeyAsync(deleteShardKey, null);
    }

    public ListenableFuture<Collections.DeleteShardKeyResponse> deleteShardKeyAsync(Collections.DeleteShardKeyRequest deleteShardKey, @Nullable Duration timeout) {
        String collectionName = deleteShardKey.getCollectionName();
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        Collections.ShardKey shardKey = deleteShardKey.getRequest().getShardKey();
        logger.debug("Delete shard key '{}' for '{}'", (Object)shardKey, (Object)collectionName);
        ListenableFuture<Collections.DeleteShardKeyResponse> future = this.getCollections(timeout).deleteShardKey(deleteShardKey);
        this.addLogFailureCallback(future, "Delete shard key");
        return Futures.transform(future, response -> {
            if (!response.getResult()) {
                logger.error("Shard key '{}' could not be deleted for '{}'", (Object)shardKey, (Object)collectionName);
                throw new QdrantException("Shard key " + shardKey + " could not be created for " + collectionName);
            }
            return response;
        }, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Points.UpdateResult> upsertAsync(String collectionName, List<Points.PointStruct> points) {
        return this.upsertAsync(collectionName, points, null);
    }

    public ListenableFuture<Points.UpdateResult> upsertAsync(String collectionName, List<Points.PointStruct> points, @Nullable Duration timeout) {
        return this.upsertAsync(Points.UpsertPoints.newBuilder().setCollectionName(collectionName).addAllPoints(points).setWait(true).build(), timeout);
    }

    public ListenableFuture<Points.UpdateResult> upsertAsync(Points.UpsertPoints request) {
        return this.upsertAsync(request, null);
    }

    public ListenableFuture<Points.UpdateResult> upsertAsync(Points.UpsertPoints request, @Nullable Duration timeout) {
        String collectionName = request.getCollectionName();
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Upsert {} points into '{}'", (Object)request.getPointsList().size(), (Object)collectionName);
        ListenableFuture<Points.PointsOperationResponse> future = this.getPoints(timeout).upsert(request);
        this.addLogFailureCallback(future, "Upsert");
        return Futures.transform(future, Points.PointsOperationResponse::getResult, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Points.UpdateResult> deleteAsync(String collectionName, List<Points.PointId> ids) {
        return this.deleteAsync(collectionName, ids, null);
    }

    public ListenableFuture<Points.UpdateResult> deleteAsync(String collectionName, List<Points.PointId> ids, @Nullable Duration timeout) {
        return this.deleteAsync(Points.DeletePoints.newBuilder().setCollectionName(collectionName).setPoints(Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addAllIds(ids).build()).build()).setWait(true).build(), timeout);
    }

    public ListenableFuture<Points.UpdateResult> deleteAsync(String collectionName, Points.Filter filter) {
        return this.deleteAsync(collectionName, filter, null);
    }

    public ListenableFuture<Points.UpdateResult> deleteAsync(String collectionName, Points.Filter filter, @Nullable Duration timeout) {
        return this.deleteAsync(Points.DeletePoints.newBuilder().setCollectionName(collectionName).setPoints(Points.PointsSelector.newBuilder().setFilter(filter).build()).setWait(true).build(), timeout);
    }

    public ListenableFuture<Points.UpdateResult> deleteAsync(Points.DeletePoints request) {
        return this.deleteAsync(request, null);
    }

    public ListenableFuture<Points.UpdateResult> deleteAsync(Points.DeletePoints request, @Nullable Duration timeout) {
        String collectionName = request.getCollectionName();
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Delete from '{}'", (Object)collectionName);
        ListenableFuture<Points.PointsOperationResponse> future = this.getPoints(timeout).delete(request);
        this.addLogFailureCallback(future, "Delete");
        return Futures.transform(future, Points.PointsOperationResponse::getResult, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<Points.RetrievedPoint>> retrieveAsync(String collectionName, Points.PointId id, @Nullable Points.ReadConsistency readConsistency) {
        return this.retrieveAsync(collectionName, id, true, false, readConsistency);
    }

    public ListenableFuture<List<Points.RetrievedPoint>> retrieveAsync(String collectionName, Points.PointId id, boolean withPayload, boolean withVectors, @Nullable Points.ReadConsistency readConsistency) {
        return this.retrieveAsync(collectionName, (List<Points.PointId>)ImmutableList.of((Object)id), WithPayloadSelectorFactory.enable(withPayload), WithVectorsSelectorFactory.enable(withVectors), readConsistency);
    }

    public ListenableFuture<List<Points.RetrievedPoint>> retrieveAsync(String collectionName, List<Points.PointId> ids, @Nullable Points.ReadConsistency readConsistency) {
        return this.retrieveAsync(collectionName, ids, true, false, readConsistency);
    }

    public ListenableFuture<List<Points.RetrievedPoint>> retrieveAsync(String collectionName, List<Points.PointId> ids, boolean withPayload, boolean withVectors, @Nullable Points.ReadConsistency readConsistency) {
        return this.retrieveAsync(collectionName, ids, WithPayloadSelectorFactory.enable(withPayload), WithVectorsSelectorFactory.enable(withVectors), readConsistency);
    }

    public ListenableFuture<List<Points.RetrievedPoint>> retrieveAsync(String collectionName, List<Points.PointId> ids, Points.WithPayloadSelector payloadSelector, Points.WithVectorsSelector vectorsSelector, @Nullable Points.ReadConsistency readConsistency) {
        return this.retrieveAsync(collectionName, ids, payloadSelector, vectorsSelector, readConsistency, null);
    }

    public ListenableFuture<List<Points.RetrievedPoint>> retrieveAsync(String collectionName, List<Points.PointId> ids, Points.WithPayloadSelector payloadSelector, Points.WithVectorsSelector vectorsSelector, @Nullable Points.ReadConsistency readConsistency, @Nullable Duration timeout) {
        logger.debug("Retrieve points from '{}'", (Object)collectionName);
        Points.GetPoints.Builder requestBuilder = Points.GetPoints.newBuilder().setCollectionName(collectionName).addAllIds(ids).setWithPayload(payloadSelector).setWithVectors(vectorsSelector);
        if (readConsistency != null) {
            requestBuilder.setReadConsistency(readConsistency);
        }
        return this.retrieveAsync(requestBuilder.build(), timeout);
    }

    public ListenableFuture<List<Points.RetrievedPoint>> retrieveAsync(Points.GetPoints request, @Nullable Duration timeout) {
        Preconditions.checkArgument((!request.getCollectionName().isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Retrieve points from '{}'", (Object)request.getCollectionName());
        ListenableFuture<Points.GetResponse> future = this.getPoints(timeout).get(request);
        this.addLogFailureCallback(future, "Retrieve");
        return Futures.transform(future, Points.GetResponse::getResultList, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Points.UpdateResult> updateVectorsAsync(String collectionName, List<Points.PointVectors> points) {
        return this.updateVectorsAsync(collectionName, points, null, null, null);
    }

    public ListenableFuture<Points.UpdateResult> updateVectorsAsync(String collectionName, List<Points.PointVectors> points, @Nullable Duration timeout) {
        return this.updateVectorsAsync(collectionName, points, null, null, timeout);
    }

    public ListenableFuture<Points.UpdateResult> updateVectorsAsync(String collectionName, List<Points.PointVectors> points, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        logger.debug("Update vectors in '{}'", (Object)collectionName);
        Points.UpdatePointVectors.Builder requestBuilder = Points.UpdatePointVectors.newBuilder().setCollectionName(collectionName).addAllPoints(points).setWait(wait == null || wait != false);
        if (ordering != null) {
            requestBuilder.setOrdering(Points.WriteOrdering.newBuilder().setType(ordering).build());
        }
        return this.updateVectorsAsync(requestBuilder.build(), timeout);
    }

    public ListenableFuture<Points.UpdateResult> updateVectorsAsync(Points.UpdatePointVectors request, @Nullable Duration timeout) {
        Preconditions.checkArgument((!request.getCollectionName().isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Update vectors in '{}'", (Object)request.getCollectionName());
        ListenableFuture<Points.PointsOperationResponse> future = this.getPoints(timeout).updateVectors(request);
        this.addLogFailureCallback(future, "Update vectors");
        return Futures.transform(future, Points.PointsOperationResponse::getResult, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Points.UpdateResult> deleteVectorsAsync(String collectionName, List<String> vectors, Points.Filter filter) {
        return this.deleteVectorsAsync(collectionName, vectors, Points.PointsSelector.newBuilder().setFilter(filter).build(), null, null, null);
    }

    public ListenableFuture<Points.UpdateResult> deleteVectorsAsync(String collectionName, List<String> vectors, Points.Filter filter, @Nullable Duration timeout) {
        return this.deleteVectorsAsync(collectionName, vectors, Points.PointsSelector.newBuilder().setFilter(filter).build(), null, null, timeout);
    }

    public ListenableFuture<Points.UpdateResult> deleteVectorsAsync(String collectionName, List<String> vectors, Points.Filter filter, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.deleteVectorsAsync(collectionName, vectors, Points.PointsSelector.newBuilder().setFilter(filter).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> deleteVectorsAsync(String collectionName, List<String> vectors, List<Points.PointId> ids) {
        return this.deleteVectorsAsync(collectionName, vectors, Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addAllIds(ids).build()).build(), null, null, null);
    }

    public ListenableFuture<Points.UpdateResult> deleteVectorsAsync(String collectionName, List<String> vectors, List<Points.PointId> ids, @Nullable Duration timeout) {
        return this.deleteVectorsAsync(collectionName, vectors, Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addAllIds(ids).build()).build(), null, null, timeout);
    }

    public ListenableFuture<Points.UpdateResult> deleteVectorsAsync(String collectionName, List<String> vectors, List<Points.PointId> ids, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.deleteVectorsAsync(collectionName, vectors, Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addAllIds(ids).build()).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> deleteVectorsAsync(String collectionName, List<String> vectors, Points.PointsSelector pointsSelector, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        logger.debug("Delete vectors in '{}'", (Object)collectionName);
        Points.DeletePointVectors.Builder requestBuilder = Points.DeletePointVectors.newBuilder().setCollectionName(collectionName).setVectors(Points.VectorsSelector.newBuilder().addAllNames(vectors).build()).setPointsSelector(pointsSelector).setWait(wait == null || wait != false);
        if (ordering != null) {
            requestBuilder.setOrdering(Points.WriteOrdering.newBuilder().setType(ordering).build());
        }
        return this.deleteVectorsAsync(requestBuilder.build(), timeout);
    }

    public ListenableFuture<Points.UpdateResult> deleteVectorsAsync(Points.DeletePointVectors request, @Nullable Duration timeout) {
        Preconditions.checkArgument((!request.getCollectionName().isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Delete vectors in '{}'", (Object)request.getCollectionName());
        ListenableFuture<Points.PointsOperationResponse> future = this.getPoints(timeout).deleteVectors(request);
        this.addLogFailureCallback(future, "Delete vectors");
        return Futures.transform(future, Points.PointsOperationResponse::getResult, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Points.UpdateResult> setPayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.setPayloadAsync(collectionName, payload, (Points.PointsSelector)null, wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> setPayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, Points.PointId id, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.setPayloadAsync(collectionName, payload, Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addIds(id).build()).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> setPayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, List<Points.PointId> ids, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.setPayloadAsync(collectionName, payload, Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addAllIds(ids).build()).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> setPayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, Points.Filter filter, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.setPayloadAsync(collectionName, payload, Points.PointsSelector.newBuilder().setFilter(filter).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> setPayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, @Nullable Points.PointsSelector pointsSelector, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.setPayloadAsync(collectionName, payload, pointsSelector, wait, null, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> setPayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, @Nullable Points.PointsSelector pointsSelector, @Nullable Boolean wait, @Nullable String key, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        Points.SetPayloadPoints.Builder requestBuilder = Points.SetPayloadPoints.newBuilder().setCollectionName(collectionName).setWait(wait == null || wait != false).putAllPayload(payload);
        if (pointsSelector != null) {
            requestBuilder.setPointsSelector(pointsSelector);
        }
        if (ordering != null) {
            requestBuilder.setOrdering(Points.WriteOrdering.newBuilder().setType(ordering).build());
        }
        if (key != null) {
            requestBuilder.setKey(key);
        }
        return this.setPayloadAsync(requestBuilder.build(), timeout);
    }

    public ListenableFuture<Points.UpdateResult> setPayloadAsync(Points.SetPayloadPoints request, @Nullable Duration timeout) {
        Preconditions.checkArgument((!request.getCollectionName().isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Set payload in '{}'", (Object)request.getCollectionName());
        ListenableFuture<Points.PointsOperationResponse> future = this.getPoints(timeout).setPayload(request);
        this.addLogFailureCallback(future, "Set payload");
        return Futures.transform(future, Points.PointsOperationResponse::getResult, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Points.UpdateResult> overwritePayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.overwritePayloadAsync(collectionName, payload, (Points.PointsSelector)null, wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> overwritePayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, Points.PointId id, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.overwritePayloadAsync(collectionName, payload, Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addIds(id).build()).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> overwritePayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, List<Points.PointId> ids, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.overwritePayloadAsync(collectionName, payload, Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addAllIds(ids).build()).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> overwritePayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, Points.Filter filter, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.overwritePayloadAsync(collectionName, payload, Points.PointsSelector.newBuilder().setFilter(filter).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> overwritePayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, @Nullable Points.PointsSelector pointsSelector, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.overwritePayloadAsync(collectionName, payload, pointsSelector, wait, null, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> overwritePayloadAsync(String collectionName, Map<String, JsonWithInt.Value> payload, @Nullable Points.PointsSelector pointsSelector, @Nullable Boolean wait, @Nullable String key, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        Points.SetPayloadPoints.Builder requestBuilder = Points.SetPayloadPoints.newBuilder().setCollectionName(collectionName).setWait(wait == null || wait != false).putAllPayload(payload);
        if (pointsSelector != null) {
            requestBuilder.setPointsSelector(pointsSelector);
        }
        if (ordering != null) {
            requestBuilder.setOrdering(Points.WriteOrdering.newBuilder().setType(ordering).build());
        }
        if (key != null) {
            requestBuilder.setKey(key);
        }
        return this.overwritePayloadAsync(requestBuilder.build(), timeout);
    }

    public ListenableFuture<Points.UpdateResult> overwritePayloadAsync(Points.SetPayloadPoints request, @Nullable Duration timeout) {
        Preconditions.checkArgument((!request.getCollectionName().isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Set payload in '{}'", (Object)request.getCollectionName());
        ListenableFuture<Points.PointsOperationResponse> future = this.getPoints(timeout).overwritePayload(request);
        this.addLogFailureCallback(future, "Overwrite payload");
        return Futures.transform(future, Points.PointsOperationResponse::getResult, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Points.UpdateResult> deletePayloadAsync(String collectionName, List<String> keys, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.deletePayloadAsync(collectionName, keys, (Points.PointsSelector)null, wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> deletePayloadAsync(String collectionName, List<String> keys, Points.PointId id, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.deletePayloadAsync(collectionName, keys, Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addIds(id).build()).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> deletePayloadAsync(String collectionName, List<String> keys, List<Points.PointId> ids, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.deletePayloadAsync(collectionName, keys, Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addAllIds(ids).build()).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> deletePayloadAsync(String collectionName, List<String> keys, Points.Filter filter, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.deletePayloadAsync(collectionName, keys, Points.PointsSelector.newBuilder().setFilter(filter).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> deletePayloadAsync(String collectionName, List<String> keys, @Nullable Points.PointsSelector pointsSelector, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        Points.DeletePayloadPoints.Builder requestBuilder = Points.DeletePayloadPoints.newBuilder().setCollectionName(collectionName).setWait(wait == null || wait != false).addAllKeys(keys);
        if (pointsSelector != null) {
            requestBuilder.setPointsSelector(pointsSelector);
        }
        if (ordering != null) {
            requestBuilder.setOrdering(Points.WriteOrdering.newBuilder().setType(ordering).build());
        }
        return this.deletePayloadAsync(requestBuilder.build(), timeout);
    }

    public ListenableFuture<Points.UpdateResult> deletePayloadAsync(Points.DeletePayloadPoints request, @Nullable Duration timeout) {
        Preconditions.checkArgument((!request.getCollectionName().isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Delete payload in '{}'", (Object)request.getCollectionName());
        ListenableFuture<Points.PointsOperationResponse> future = this.getPoints(timeout).deletePayload(request);
        this.addLogFailureCallback(future, "Delete payload");
        return Futures.transform(future, Points.PointsOperationResponse::getResult, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Points.UpdateResult> clearPayloadAsync(String collectionName, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.clearPayloadAsync(collectionName, (Points.PointsSelector)null, wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> clearPayloadAsync(String collectionName, Points.PointId id, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.clearPayloadAsync(collectionName, Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addIds(id).build()).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> clearPayloadAsync(String collectionName, List<Points.PointId> ids, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.clearPayloadAsync(collectionName, Points.PointsSelector.newBuilder().setPoints(Points.PointsIdsList.newBuilder().addAllIds(ids).build()).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> clearPayloadAsync(String collectionName, Points.Filter filter, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        return this.clearPayloadAsync(collectionName, Points.PointsSelector.newBuilder().setFilter(filter).build(), wait, ordering, timeout);
    }

    public ListenableFuture<Points.UpdateResult> clearPayloadAsync(String collectionName, @Nullable Points.PointsSelector pointsSelector, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        Points.ClearPayloadPoints.Builder requestBuilder = Points.ClearPayloadPoints.newBuilder().setCollectionName(collectionName).setWait(wait == null || wait != false);
        if (pointsSelector != null) {
            requestBuilder.setPoints(pointsSelector);
        }
        if (ordering != null) {
            requestBuilder.setOrdering(Points.WriteOrdering.newBuilder().setType(ordering).build());
        }
        return this.clearPayloadAsync(requestBuilder.build(), timeout);
    }

    public ListenableFuture<Points.UpdateResult> clearPayloadAsync(Points.ClearPayloadPoints request, @Nullable Duration timeout) {
        Preconditions.checkArgument((!request.getCollectionName().isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Clear payload in '{}'", (Object)request.getCollectionName());
        ListenableFuture<Points.PointsOperationResponse> future = this.getPoints(timeout).clearPayload(request);
        this.addLogFailureCallback(future, "Clear payload");
        return Futures.transform(future, Points.PointsOperationResponse::getResult, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Points.UpdateResult> createPayloadIndexAsync(String collectionName, String field, Collections.PayloadSchemaType schemaType, @Nullable Collections.PayloadIndexParams indexParams, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        Points.CreateFieldIndexCollection.Builder requestBuilder = Points.CreateFieldIndexCollection.newBuilder().setCollectionName(collectionName).setFieldName(field).setWait(wait == null || wait != false);
        switch (schemaType) {
            case Keyword: {
                requestBuilder.setFieldType(Points.FieldType.FieldTypeKeyword);
                break;
            }
            case Integer: {
                requestBuilder.setFieldType(Points.FieldType.FieldTypeInteger);
                break;
            }
            case Float: {
                requestBuilder.setFieldType(Points.FieldType.FieldTypeFloat);
                break;
            }
            case Geo: {
                requestBuilder.setFieldType(Points.FieldType.FieldTypeGeo);
                break;
            }
            case Text: {
                requestBuilder.setFieldType(Points.FieldType.FieldTypeText);
                break;
            }
            case Bool: {
                requestBuilder.setFieldType(Points.FieldType.FieldTypeBool);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid schemaType: '" + (Object)((Object)schemaType) + "'");
            }
        }
        if (indexParams != null) {
            requestBuilder.setFieldIndexParams(indexParams);
        }
        if (ordering != null) {
            requestBuilder.setOrdering(Points.WriteOrdering.newBuilder().setType(ordering).build());
        }
        logger.debug("Create payload field index for '{}' in '{}'", (Object)field, (Object)collectionName);
        ListenableFuture<Points.PointsOperationResponse> future = this.getPoints(timeout).createFieldIndex(requestBuilder.build());
        this.addLogFailureCallback(future, "Create payload field index");
        return Futures.transform(future, Points.PointsOperationResponse::getResult, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Points.UpdateResult> deletePayloadIndexAsync(String collectionName, String field, @Nullable Boolean wait, @Nullable Points.WriteOrderingType ordering, @Nullable Duration timeout) {
        Points.DeleteFieldIndexCollection.Builder requestBuilder = Points.DeleteFieldIndexCollection.newBuilder().setCollectionName(collectionName).setFieldName(field).setWait(wait == null || wait != false);
        if (ordering != null) {
            requestBuilder.setOrdering(Points.WriteOrdering.newBuilder().setType(ordering).build());
        }
        logger.debug("Delete payload field index for '{}' in '{}'", (Object)field, (Object)collectionName);
        ListenableFuture<Points.PointsOperationResponse> future = this.getPoints(timeout).deleteFieldIndex(requestBuilder.build());
        this.addLogFailureCallback(future, "Delete payload field index");
        return Futures.transform(future, Points.PointsOperationResponse::getResult, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<Points.ScoredPoint>> searchAsync(Points.SearchPoints request) {
        return this.searchAsync(request, null);
    }

    public ListenableFuture<List<Points.ScoredPoint>> searchAsync(Points.SearchPoints request, @Nullable Duration timeout) {
        Preconditions.checkArgument((!request.getCollectionName().isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        Preconditions.checkArgument((!request.getVectorList().isEmpty() ? 1 : 0) != 0, (Object)"Vector must not be empty");
        logger.debug("Search on '{}'", (Object)request.getCollectionName());
        ListenableFuture<Points.SearchResponse> future = this.getPoints(timeout).search(request);
        this.addLogFailureCallback(future, "Search");
        return Futures.transform(future, Points.SearchResponse::getResultList, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<Points.BatchResult>> searchBatchAsync(String collectionName, List<Points.SearchPoints> searches, @Nullable Points.ReadConsistency readConsistency) {
        return this.searchBatchAsync(collectionName, searches, readConsistency, null);
    }

    public ListenableFuture<List<Points.BatchResult>> searchBatchAsync(String collectionName, List<Points.SearchPoints> searches, @Nullable Points.ReadConsistency readConsistency, @Nullable Duration timeout) {
        searches = Lists.transform(searches, searchPoints -> searchPoints.toBuilder().setCollectionName(collectionName).build());
        Points.SearchBatchPoints.Builder requestBuilder = Points.SearchBatchPoints.newBuilder().setCollectionName(collectionName).addAllSearchPoints(searches);
        if (readConsistency != null) {
            requestBuilder.setReadConsistency(readConsistency);
        }
        logger.debug("Search batch on '{}'", (Object)collectionName);
        ListenableFuture<Points.SearchBatchResponse> future = this.getPoints(timeout).searchBatch(requestBuilder.build());
        this.addLogFailureCallback(future, "Search batch");
        return Futures.transform(future, Points.SearchBatchResponse::getResultList, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<Points.PointGroup>> searchGroupsAsync(Points.SearchPointGroups request) {
        return this.searchGroupsAsync(request, null);
    }

    public ListenableFuture<List<Points.PointGroup>> searchGroupsAsync(Points.SearchPointGroups request, @Nullable Duration timeout) {
        Preconditions.checkArgument((!request.getCollectionName().isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Search groups on '{}'", (Object)request.getCollectionName());
        ListenableFuture<Points.SearchGroupsResponse> future = this.getPoints(timeout).searchGroups(request);
        this.addLogFailureCallback(future, "Search groups");
        return Futures.transform(future, response -> response.getResult().getGroupsList(), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Points.ScrollResponse> scrollAsync(Points.ScrollPoints request) {
        return this.scrollAsync(request, null);
    }

    public ListenableFuture<Points.ScrollResponse> scrollAsync(Points.ScrollPoints request, @Nullable Duration timeout) {
        Preconditions.checkArgument((!request.getCollectionName().isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Scroll on '{}'", (Object)request.getCollectionName());
        ListenableFuture<Points.ScrollResponse> future = this.getPoints(timeout).scroll(request);
        this.addLogFailureCallback(future, "Scroll");
        return future;
    }

    public ListenableFuture<List<Points.ScoredPoint>> recommendAsync(Points.RecommendPoints request) {
        return this.recommendAsync(request, null);
    }

    public ListenableFuture<List<Points.ScoredPoint>> recommendAsync(Points.RecommendPoints request, @Nullable Duration timeout) {
        Preconditions.checkArgument((!request.getCollectionName().isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Recommend on '{}'", (Object)request.getCollectionName());
        ListenableFuture<Points.RecommendResponse> future = this.getPoints(timeout).recommend(request);
        this.addLogFailureCallback(future, "Recommend");
        return Futures.transform(future, Points.RecommendResponse::getResultList, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<Points.BatchResult>> recommendBatchAsync(String collectionName, List<Points.RecommendPoints> recommendSearches, @Nullable Points.ReadConsistency readConsistency) {
        return this.recommendBatchAsync(collectionName, recommendSearches, readConsistency, null);
    }

    public ListenableFuture<List<Points.BatchResult>> recommendBatchAsync(String collectionName, List<Points.RecommendPoints> recommendSearches, @Nullable Points.ReadConsistency readConsistency, @Nullable Duration timeout) {
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        recommendSearches = Lists.transform(recommendSearches, recommendPoints -> recommendPoints.toBuilder().setCollectionName(collectionName).build());
        Points.RecommendBatchPoints.Builder requestBuilder = Points.RecommendBatchPoints.newBuilder().setCollectionName(collectionName).addAllRecommendPoints(recommendSearches);
        if (readConsistency != null) {
            requestBuilder.setReadConsistency(readConsistency);
        }
        logger.debug("Recommend batch on '{}'", (Object)collectionName);
        ListenableFuture<Points.RecommendBatchResponse> future = this.getPoints(timeout).recommendBatch(requestBuilder.build());
        this.addLogFailureCallback(future, "Recommend batch");
        return Futures.transform(future, Points.RecommendBatchResponse::getResultList, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<Points.UpdateResult>> batchUpdateAsync(String collectionName, List<Points.PointsUpdateOperation> operations) {
        return this.batchUpdateAsync(collectionName, operations, null, null, null);
    }

    public ListenableFuture<List<Points.UpdateResult>> batchUpdateAsync(String collectionName, List<Points.PointsUpdateOperation> operations, @Nullable Boolean wait, @Nullable Points.WriteOrdering ordering, @Nullable Duration timeout) {
        Points.UpdateBatchPoints.Builder requestBuilder = Points.UpdateBatchPoints.newBuilder().setCollectionName(collectionName).addAllOperations(operations).setWait(wait == null || wait != false);
        if (ordering != null) {
            requestBuilder.setOrdering(ordering);
        }
        return this.batchUpdateAsync(requestBuilder.build(), timeout);
    }

    public ListenableFuture<List<Points.UpdateResult>> batchUpdateAsync(Points.UpdateBatchPoints request, @Nullable Duration timeout) {
        String collectionName = request.getCollectionName();
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Batch update points on '{}'", (Object)collectionName);
        ListenableFuture<Points.UpdateBatchResponse> future = this.getPoints(timeout).updateBatch(request);
        this.addLogFailureCallback(future, "Batch update points");
        return Futures.transform(future, Points.UpdateBatchResponse::getResultList, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<Points.PointGroup>> recommendGroupsAsync(Points.RecommendPointGroups request) {
        return this.recommendGroupsAsync(request, null);
    }

    public ListenableFuture<List<Points.PointGroup>> recommendGroupsAsync(Points.RecommendPointGroups request, @Nullable Duration timeout) {
        String collectionName = request.getCollectionName();
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Recommend groups on '{}'", (Object)collectionName);
        ListenableFuture<Points.RecommendGroupsResponse> future = this.getPoints(timeout).recommendGroups(request);
        this.addLogFailureCallback(future, "Recommend groups");
        return Futures.transform(future, response -> response.getResult().getGroupsList(), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<Points.ScoredPoint>> discoverAsync(Points.DiscoverPoints request) {
        return this.discoverAsync(request, null);
    }

    public ListenableFuture<List<Points.ScoredPoint>> discoverAsync(Points.DiscoverPoints request, @Nullable Duration timeout) {
        String collectionName = request.getCollectionName();
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Discover on '{}'", (Object)collectionName);
        ListenableFuture<Points.DiscoverResponse> future = this.getPoints(timeout).discover(request);
        this.addLogFailureCallback(future, "Discover");
        return Futures.transform(future, Points.DiscoverResponse::getResultList, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<Points.BatchResult>> discoverBatchAsync(String collectionName, List<Points.DiscoverPoints> discoverSearches, @Nullable Points.ReadConsistency readConsistency) {
        return this.discoverBatchAsync(collectionName, discoverSearches, readConsistency, null);
    }

    public ListenableFuture<List<Points.BatchResult>> discoverBatchAsync(String collectionName, List<Points.DiscoverPoints> discoverSearches, @Nullable Points.ReadConsistency readConsistency, @Nullable Duration timeout) {
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        Points.DiscoverBatchPoints.Builder requestBuilder = Points.DiscoverBatchPoints.newBuilder().setCollectionName(collectionName).addAllDiscoverPoints(discoverSearches);
        if (readConsistency != null) {
            requestBuilder.setReadConsistency(readConsistency);
        }
        logger.debug("Discover batch on '{}'", (Object)collectionName);
        ListenableFuture<Points.DiscoverBatchResponse> future = this.getPoints(timeout).discoverBatch(requestBuilder.build());
        this.addLogFailureCallback(future, "Discover batch");
        return Futures.transform(future, Points.DiscoverBatchResponse::getResultList, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Long> countAsync(String collectionName) {
        return this.countAsync(collectionName, null, null, null);
    }

    public ListenableFuture<Long> countAsync(String collectionName, @Nullable Duration timeout) {
        return this.countAsync(collectionName, null, null, timeout);
    }

    public ListenableFuture<Long> countAsync(String collectionName, @Nullable Points.Filter filter, @Nullable Boolean exact) {
        return this.countAsync(collectionName, filter, exact, null);
    }

    public ListenableFuture<Long> countAsync(String collectionName, @Nullable Points.Filter filter, @Nullable Boolean exact, @Nullable Duration timeout) {
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        Points.CountPoints.Builder requestBuilder = Points.CountPoints.newBuilder().setCollectionName(collectionName).setExact(exact == null || exact != false);
        if (filter != null) {
            requestBuilder.setFilter(filter);
        }
        logger.debug("Count on '{}'", (Object)collectionName);
        ListenableFuture<Points.CountResponse> future = this.getPoints(timeout).count(requestBuilder.build());
        this.addLogFailureCallback(future, "Count");
        return Futures.transform(future, response -> response.getResult().getCount(), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<SnapshotsService.SnapshotDescription> createSnapshotAsync(String collectionName) {
        return this.createSnapshotAsync(collectionName, null);
    }

    public ListenableFuture<SnapshotsService.SnapshotDescription> createSnapshotAsync(String collectionName, @Nullable Duration timeout) {
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("Create snapshot of '{}'", (Object)collectionName);
        ListenableFuture<SnapshotsService.CreateSnapshotResponse> future = this.getSnapshots(timeout).create(SnapshotsService.CreateSnapshotRequest.newBuilder().setCollectionName(collectionName).build());
        this.addLogFailureCallback(future, "Create snapshot");
        return Futures.transform(future, SnapshotsService.CreateSnapshotResponse::getSnapshotDescription, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<SnapshotsService.SnapshotDescription>> listSnapshotAsync(String collectionName) {
        return this.listSnapshotAsync(collectionName, null);
    }

    public ListenableFuture<List<SnapshotsService.SnapshotDescription>> listSnapshotAsync(String collectionName, @Nullable Duration timeout) {
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        logger.debug("List snapshots of '{}'", (Object)collectionName);
        ListenableFuture<SnapshotsService.ListSnapshotsResponse> future = this.getSnapshots(timeout).list(SnapshotsService.ListSnapshotsRequest.newBuilder().setCollectionName(collectionName).build());
        this.addLogFailureCallback(future, "List snapshots");
        return Futures.transform(future, SnapshotsService.ListSnapshotsResponse::getSnapshotDescriptionsList, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<SnapshotsService.DeleteSnapshotResponse> deleteSnapshotAsync(String collectionName, String snapshotName) {
        return this.deleteSnapshotAsync(collectionName, snapshotName, null);
    }

    public ListenableFuture<SnapshotsService.DeleteSnapshotResponse> deleteSnapshotAsync(String collectionName, String snapshotName, @Nullable Duration timeout) {
        Preconditions.checkArgument((!collectionName.isEmpty() ? 1 : 0) != 0, (Object)"Collection name must not be empty");
        Preconditions.checkArgument((!snapshotName.isEmpty() ? 1 : 0) != 0, (Object)"Snapshot name must not be empty");
        logger.debug("Delete snapshot '{}' of '{}'", (Object)snapshotName, (Object)collectionName);
        ListenableFuture<SnapshotsService.DeleteSnapshotResponse> future = this.getSnapshots(timeout).delete(SnapshotsService.DeleteSnapshotRequest.newBuilder().setCollectionName(collectionName).setSnapshotName(snapshotName).build());
        this.addLogFailureCallback(future, "Delete snapshot");
        return future;
    }

    public ListenableFuture<SnapshotsService.SnapshotDescription> createFullSnapshotAsync() {
        return this.createFullSnapshotAsync(null);
    }

    public ListenableFuture<SnapshotsService.SnapshotDescription> createFullSnapshotAsync(@Nullable Duration timeout) {
        logger.debug("Create full snapshot for a whole storage");
        ListenableFuture<SnapshotsService.CreateSnapshotResponse> future = this.getSnapshots(timeout).createFull(SnapshotsService.CreateFullSnapshotRequest.getDefaultInstance());
        this.addLogFailureCallback(future, "Create full snapshot");
        return Futures.transform(future, SnapshotsService.CreateSnapshotResponse::getSnapshotDescription, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<List<SnapshotsService.SnapshotDescription>> listFullSnapshotAsync() {
        return this.listFullSnapshotAsync(null);
    }

    public ListenableFuture<List<SnapshotsService.SnapshotDescription>> listFullSnapshotAsync(@Nullable Duration timeout) {
        logger.debug("List full snapshots for a whole storage");
        ListenableFuture<SnapshotsService.ListSnapshotsResponse> future = this.getSnapshots(timeout).listFull(SnapshotsService.ListFullSnapshotsRequest.getDefaultInstance());
        this.addLogFailureCallback(future, "List full snapshots");
        return Futures.transform(future, SnapshotsService.ListSnapshotsResponse::getSnapshotDescriptionsList, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<SnapshotsService.DeleteSnapshotResponse> deleteFullSnapshotAsync(String snapshotName) {
        return this.deleteFullSnapshotAsync(snapshotName, null);
    }

    public ListenableFuture<SnapshotsService.DeleteSnapshotResponse> deleteFullSnapshotAsync(String snapshotName, @Nullable Duration timeout) {
        Preconditions.checkArgument((!snapshotName.isEmpty() ? 1 : 0) != 0, (Object)"Snapshot name must not be empty");
        logger.debug("Delete full snapshot '{}'", (Object)snapshotName);
        ListenableFuture<SnapshotsService.DeleteSnapshotResponse> future = this.getSnapshots(timeout).deleteFull(SnapshotsService.DeleteFullSnapshotRequest.newBuilder().setSnapshotName(snapshotName).build());
        this.addLogFailureCallback(future, "Delete full snapshot");
        return future;
    }

    @Override
    public void close() {
        this.grpcClient.close();
    }

    private <V> void addLogFailureCallback(ListenableFuture<V> future, final String message) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<V>(){

            public void onSuccess(V result) {
            }

            public void onFailure(Throwable t) {
                logger.error(message + " operation failed", t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private CollectionsGrpc.CollectionsFutureStub getCollections(@Nullable Duration timeout) {
        return timeout != null ? (CollectionsGrpc.CollectionsFutureStub)this.grpcClient.collections().withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS) : this.grpcClient.collections();
    }

    private PointsGrpc.PointsFutureStub getPoints(@Nullable Duration timeout) {
        return timeout != null ? (PointsGrpc.PointsFutureStub)this.grpcClient.points().withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS) : this.grpcClient.points();
    }

    private SnapshotsGrpc.SnapshotsFutureStub getSnapshots(@Nullable Duration timeout) {
        return timeout != null ? (SnapshotsGrpc.SnapshotsFutureStub)this.grpcClient.snapshots().withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS) : this.grpcClient.snapshots();
    }
}

