#include "QAbstractFileEngine_shell.h"
#include <QtJambi/Cast>

void deleter_QAbstractFileEngine(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QAbstractFileEngine")
    QAbstractFileEngine *_ptr = reinterpret_cast<QAbstractFileEngine *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QAbstractFileEngine_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QAbstractFileEngine_shell) ); }

jmethodID QAbstractFileEngine_oshell::__shell_javaMethod(int pos) const { return QAbstractFileEngine_shell::__shell()->javaMethod(typeid(QAbstractFileEngine), pos); }

// emitting (writeShellDestructor)
QAbstractFileEngine_shell::~QAbstractFileEngine_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QAbstractFileEngine::~QAbstractFileEngine()", this)
    QAbstractFileEngine_shell::__shell()->destructed(typeid(QAbstractFileEngine));
}

// emitting (writeShellConstructor)
QAbstractFileEngine_shell::QAbstractFileEngine_shell()
    : QAbstractFileEngine()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QAbstractFileEngine::QAbstractFileEngine_shell()", this)
    QAbstractFileEngine_shell::__shell()->constructed(typeid(QAbstractFileEngine));
}

void QAbstractFileEngine_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QAbstractFileEngine_shell*>(ptr)->QAbstractFileEngine_shell::__shell()->tryDeleteShell(typeid(QAbstractFileEngine));
}

void QAbstractFileEngine_oshell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QAbstractFileEngine_oshell*>(ptr)->QAbstractFileEngine_oshell::__shell()->tryDeleteShell(typeid(QAbstractFileEngine));
}

// emitting Virtual overrides (virtualFunctions)
QAbstractFileEngineIterator* QAbstractFileEngine_oshell::beginEntryList(QDir::Filters filters0, const QStringList& filterNames1)
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::beginEntryList(QDir::Filters,QStringList)", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAbstractFileEngineIterator*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_filters0 = qtjambi_cast<jobject>(__jni_env, filters0);
                    jobject __java_filterNames1 = qtjambi_cast<jobject>(__jni_env, filterNames1);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_filters0, __java_filterNames1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAbstractFileEngineIterator*>(__jni_env, __java_return_value);
                    QtJambiAPI::setCppOwnershipAndInvalidate(__jni_env, __java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::beginEntryList(QDir::Filters,QStringList)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::beginEntryList(QDir::Filters,QStringList)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::beginEntryList(QDir::Filters(filters0), filterNames1);
        }
    }else{
        return QAbstractFileEngine::beginEntryList(QDir::Filters(filters0), filterNames1);
    }
}

bool QAbstractFileEngine_oshell::caseSensitive() const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::caseSensitive()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::caseSensitive()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::caseSensitive()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::caseSensitive();
        }
    }else{
        return QAbstractFileEngine::caseSensitive();
    }
}

bool QAbstractFileEngine_oshell::cloneTo(QAbstractFileEngine* target0)
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::cloneTo(QAbstractFileEngine*)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_target0 = qtjambi_cast<jobject>(__jni_env, target0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_target0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_target0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::cloneTo(QAbstractFileEngine*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::cloneTo(QAbstractFileEngine*)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::cloneTo(target0);
        }
    }else{
        return QAbstractFileEngine::cloneTo(target0);
    }
}

bool QAbstractFileEngine_oshell::close()
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::close()", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::close()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::close()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::close();
        }
    }else{
        return QAbstractFileEngine::close();
    }
}

bool QAbstractFileEngine_oshell::copy(const QString& newName0)
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::copy(QString)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_newName0 = qtjambi_cast<jstring>(__jni_env, newName0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_newName0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::copy(QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::copy(QString)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::copy(newName0);
        }
    }else{
        return QAbstractFileEngine::copy(newName0);
    }
}

QAbstractFileEngineIterator* QAbstractFileEngine_oshell::endEntryList()
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::endEntryList()", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAbstractFileEngineIterator*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAbstractFileEngineIterator*>(__jni_env, __java_return_value);
                    QtJambiAPI::setCppOwnershipAndInvalidate(__jni_env, __java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::endEntryList()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::endEntryList()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::endEntryList();
        }
    }else{
        return QAbstractFileEngine::endEntryList();
    }
}

QStringList QAbstractFileEngine_oshell::entryList(QDir::Filters filters0, const QStringList& filterNames1) const
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::entryList(QDir::Filters,QStringList)const", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QStringList  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    QtJambiScope __qtjambi_scope(QAbstractFileEngine_shell::__shell());
                    jobject __java_filters0 = qtjambi_cast<jobject>(__jni_env, filters0);
                    jobject __java_filterNames1 = qtjambi_cast<jobject>(__jni_env, filterNames1);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_filters0, __java_filterNames1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QStringList >(__jni_env, __qtjambi_scope, __java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::entryList(QDir::Filters,QStringList)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::entryList(QDir::Filters,QStringList)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::entryList(QDir::Filters(filters0), filterNames1);
        }
    }else{
        return QAbstractFileEngine::entryList(QDir::Filters(filters0), filterNames1);
    }
}

QAbstractFileEngine::FileFlags QAbstractFileEngine_oshell::fileFlags(QAbstractFileEngine::FileFlags type0) const
{
    if(jmethodID method_id = __shell_javaMethod(7)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::fileFlags(QAbstractFileEngine::FileFlags)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAbstractFileEngine::FileFlags  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_type0 = qtjambi_cast<jobject>(__jni_env, type0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_type0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAbstractFileEngine::FileFlags>(__jni_env, __java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::fileFlags(QAbstractFileEngine::FileFlags)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::fileFlags(QAbstractFileEngine::FileFlags)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::fileFlags(QAbstractFileEngine::FileFlags(type0));
        }
    }else{
        return QAbstractFileEngine::fileFlags(QAbstractFileEngine::FileFlags(type0));
    }
}

QString QAbstractFileEngine_oshell::fileName(QAbstractFileEngine::FileName file0) const
{
    if(jmethodID method_id = __shell_javaMethod(8)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::fileName(QAbstractFileEngine::FileName)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_file0 = qtjambi_cast<jobject>(__jni_env, file0);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, __java_file0));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::fileName(QAbstractFileEngine::FileName)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::fileName(QAbstractFileEngine::FileName)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::fileName(QAbstractFileEngine::FileName(file0));
        }
    }else{
        return QAbstractFileEngine::fileName(QAbstractFileEngine::FileName(file0));
    }
}

QDateTime QAbstractFileEngine_oshell::fileTime(QAbstractFileEngine::FileTime time0) const
{
    if(jmethodID method_id = __shell_javaMethod(9)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::fileTime(QAbstractFileEngine::FileTime)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QDateTime  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_time0 = qtjambi_cast<jobject>(__jni_env, time0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_time0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QDateTime>(__jni_env, __java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::fileTime(QAbstractFileEngine::FileTime)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::fileTime(QAbstractFileEngine::FileTime)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::fileTime(QAbstractFileEngine::FileTime(time0));
        }
    }else{
        return QAbstractFileEngine::fileTime(QAbstractFileEngine::FileTime(time0));
    }
}

bool QAbstractFileEngine_oshell::flush()
{
    if(jmethodID method_id = __shell_javaMethod(10)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::flush()", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::flush()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::flush()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::flush();
        }
    }else{
        return QAbstractFileEngine::flush();
    }
}

int QAbstractFileEngine_oshell::handle() const
{
    if(jmethodID method_id = __shell_javaMethod(11)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::handle()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::handle()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::handle()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::handle();
        }
    }else{
        return QAbstractFileEngine::handle();
    }
}

QByteArray QAbstractFileEngine_oshell::id() const
{
    if(jmethodID method_id = __shell_javaMethod(12)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::id()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QByteArray  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QByteArray>(__jni_env, __java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::id()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::id()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::id();
        }
    }else{
        return QAbstractFileEngine::id();
    }
}

bool QAbstractFileEngine_oshell::isRelativePath() const
{
    if(jmethodID method_id = __shell_javaMethod(13)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::isRelativePath()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::isRelativePath()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::isRelativePath()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::isRelativePath();
        }
    }else{
        return QAbstractFileEngine::isRelativePath();
    }
}

bool QAbstractFileEngine_oshell::isSequential() const
{
    if(jmethodID method_id = __shell_javaMethod(14)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::isSequential()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::isSequential()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::isSequential()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::isSequential();
        }
    }else{
        return QAbstractFileEngine::isSequential();
    }
}

bool QAbstractFileEngine_oshell::link(const QString& newName0)
{
    if(jmethodID method_id = __shell_javaMethod(15)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::link(QString)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_newName0 = qtjambi_cast<jstring>(__jni_env, newName0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_newName0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::link(QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::link(QString)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::link(newName0);
        }
    }else{
        return QAbstractFileEngine::link(newName0);
    }
}

bool QAbstractFileEngine_oshell::mkdir(const QString& dirName0, bool createParentDirectories1, std::optional<QFileDevice::Permissions> permissions2) const
{
    if(jmethodID method_id = __shell_javaMethod(16)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::mkdir(QString,bool,std::optional<QFile::Permissions>)const", this)
        if(JniEnvironment __jni_env{500}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_dirName0 = qtjambi_cast<jstring>(__jni_env, dirName0);
                    jobject __java_permissions2 = qtjambi_cast<jobject>(__jni_env, permissions2);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_dirName0, createParentDirectories1, __java_permissions2);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::mkdir(QString,bool,std::optional<QFile::Permissions>)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::mkdir(QString,bool,std::optional<QFile::Permissions>)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::mkdir(dirName0, static_cast<bool>(createParentDirectories1), permissions2);
        }
    }else{
        return QAbstractFileEngine::mkdir(dirName0, static_cast<bool>(createParentDirectories1), permissions2);
    }
}

bool QAbstractFileEngine_oshell::open(QIODeviceBase::OpenMode openMode0, std::optional<QFileDevice::Permissions> permissions1)
{
    if(jmethodID method_id = __shell_javaMethod(17)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::open(QIODevice::OpenMode,std::optional<QFile::Permissions>)", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_openMode0 = qtjambi_cast<jobject>(__jni_env, openMode0);
                    jobject __java_permissions1 = qtjambi_cast<jobject>(__jni_env, permissions1);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_openMode0, __java_permissions1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::open(QIODevice::OpenMode,std::optional<QFile::Permissions>)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::open(QIODevice::OpenMode,std::optional<QFile::Permissions>)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::open(QIODeviceBase::OpenMode(openMode0), permissions1);
        }
    }else{
        return QAbstractFileEngine::open(QIODeviceBase::OpenMode(openMode0), permissions1);
    }
}

QString QAbstractFileEngine_oshell::owner(QAbstractFileEngine::FileOwner arg__1) const
{
    if(jmethodID method_id = __shell_javaMethod(18)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::owner(QAbstractFileEngine::FileOwner)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_arg__1 = qtjambi_cast<jobject>(__jni_env, arg__1);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, __java_arg__1));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::owner(QAbstractFileEngine::FileOwner)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::owner(QAbstractFileEngine::FileOwner)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::owner(QAbstractFileEngine::FileOwner(arg__1));
        }
    }else{
        return QAbstractFileEngine::owner(QAbstractFileEngine::FileOwner(arg__1));
    }
}

uint QAbstractFileEngine_oshell::ownerId(QAbstractFileEngine::FileOwner arg__1) const
{
    if(jmethodID method_id = __shell_javaMethod(19)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::ownerId(QAbstractFileEngine::FileOwner)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            uint  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_arg__1 = qtjambi_cast<jobject>(__jni_env, arg__1);
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_arg__1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<uint>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::ownerId(QAbstractFileEngine::FileOwner)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::ownerId(QAbstractFileEngine::FileOwner)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::ownerId(QAbstractFileEngine::FileOwner(arg__1));
        }
    }else{
        return QAbstractFileEngine::ownerId(QAbstractFileEngine::FileOwner(arg__1));
    }
}

qint64 QAbstractFileEngine_oshell::pos() const
{
    if(jmethodID method_id = __shell_javaMethod(20)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::pos()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            qint64  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jlong __java_return_value = __jni_env->CallLongMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<qint64>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::pos()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::pos()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::pos();
        }
    }else{
        return QAbstractFileEngine::pos();
    }
}

qint64 QAbstractFileEngine_oshell::read(char* data0, qint64 maxlen1)
{
    if(jmethodID method_id = __shell_javaMethod(21)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::read(char*,qint64)", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            qint64  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    DataJBuffer __java_data0_buffer(__jni_env, data0, maxlen1);
                    jobject __java_data0 = __java_data0_buffer.buffer();
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_data0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<qint64>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::read(char*,qint64)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::read(char*,qint64)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::read(data0, static_cast<qint64>(maxlen1));
        }
    }else{
        return QAbstractFileEngine::read(data0, static_cast<qint64>(maxlen1));
    }
}

qint64 QAbstractFileEngine_oshell::readLine(char* data0, qint64 maxlen1)
{
    if(jmethodID method_id = __shell_javaMethod(22)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::readLine(char*,qint64)", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            qint64  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    DataJBuffer __java_data0_buffer(__jni_env, data0, maxlen1);
                    jobject __java_data0 = __java_data0_buffer.buffer();
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_data0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<qint64>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::readLine(char*,qint64)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::readLine(char*,qint64)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::readLine(data0, static_cast<qint64>(maxlen1));
        }
    }else{
        return QAbstractFileEngine::readLine(data0, static_cast<qint64>(maxlen1));
    }
}

bool QAbstractFileEngine_oshell::remove()
{
    if(jmethodID method_id = __shell_javaMethod(23)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::remove()", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::remove()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::remove()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::remove();
        }
    }else{
        return QAbstractFileEngine::remove();
    }
}

bool QAbstractFileEngine_oshell::rename(const QString& newName0)
{
    if(jmethodID method_id = __shell_javaMethod(24)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::rename(QString)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_newName0 = qtjambi_cast<jstring>(__jni_env, newName0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_newName0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::rename(QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::rename(QString)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::rename(newName0);
        }
    }else{
        return QAbstractFileEngine::rename(newName0);
    }
}

bool QAbstractFileEngine_oshell::renameOverwrite(const QString& newName0)
{
    if(jmethodID method_id = __shell_javaMethod(25)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::renameOverwrite(QString)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_newName0 = qtjambi_cast<jstring>(__jni_env, newName0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_newName0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::renameOverwrite(QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::renameOverwrite(QString)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::renameOverwrite(newName0);
        }
    }else{
        return QAbstractFileEngine::renameOverwrite(newName0);
    }
}

bool QAbstractFileEngine_oshell::rmdir(const QString& dirName0, bool recurseParentDirectories1) const
{
    if(jmethodID method_id = __shell_javaMethod(26)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::rmdir(QString,bool)const", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_dirName0 = qtjambi_cast<jstring>(__jni_env, dirName0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_dirName0, recurseParentDirectories1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::rmdir(QString,bool)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::rmdir(QString,bool)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::rmdir(dirName0, static_cast<bool>(recurseParentDirectories1));
        }
    }else{
        return QAbstractFileEngine::rmdir(dirName0, static_cast<bool>(recurseParentDirectories1));
    }
}

bool QAbstractFileEngine_oshell::seek(qint64 pos0)
{
    if(jmethodID method_id = __shell_javaMethod(27)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::seek(qint64)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, pos0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::seek(qint64)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::seek(qint64)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::seek(static_cast<qint64>(pos0));
        }
    }else{
        return QAbstractFileEngine::seek(static_cast<qint64>(pos0));
    }
}

void QAbstractFileEngine_oshell::setFileName(const QString& file0)
{
    if(jmethodID method_id = __shell_javaMethod(28)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::setFileName(QString)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_file0 = qtjambi_cast<jstring>(__jni_env, file0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_file0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::setFileName(QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::setFileName(QString)");
            } QTJAMBI_TRY_END
        }else{
            QAbstractFileEngine::setFileName(file0);
        }
    }else{
        QAbstractFileEngine::setFileName(file0);
    }
}

bool QAbstractFileEngine_oshell::setFileTime(const QDateTime& newDate0, QAbstractFileEngine::FileTime time1)
{
    if(jmethodID method_id = __shell_javaMethod(29)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::setFileTime(QDateTime,QAbstractFileEngine::FileTime)", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_newDate0 = qtjambi_cast<jobject>(__jni_env, newDate0);
                    jobject __java_time1 = qtjambi_cast<jobject>(__jni_env, time1);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_newDate0, __java_time1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::setFileTime(QDateTime,QAbstractFileEngine::FileTime)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::setFileTime(QDateTime,QAbstractFileEngine::FileTime)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::setFileTime(newDate0, QAbstractFileEngine::FileTime(time1));
        }
    }else{
        return QAbstractFileEngine::setFileTime(newDate0, QAbstractFileEngine::FileTime(time1));
    }
}

bool QAbstractFileEngine_oshell::setPermissions(uint perms0)
{
    if(jmethodID method_id = __shell_javaMethod(30)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::setPermissions(uint)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, perms0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::setPermissions(uint)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::setPermissions(uint)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::setPermissions(static_cast<uint>(perms0));
        }
    }else{
        return QAbstractFileEngine::setPermissions(static_cast<uint>(perms0));
    }
}

bool QAbstractFileEngine_oshell::setSize(qint64 size0)
{
    if(jmethodID method_id = __shell_javaMethod(31)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::setSize(qint64)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, size0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::setSize(qint64)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::setSize(qint64)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::setSize(static_cast<qint64>(size0));
        }
    }else{
        return QAbstractFileEngine::setSize(static_cast<qint64>(size0));
    }
}

qint64 QAbstractFileEngine_oshell::size() const
{
    if(jmethodID method_id = __shell_javaMethod(32)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::size()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            qint64  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jlong __java_return_value = __jni_env->CallLongMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<qint64>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::size()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::size()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::size();
        }
    }else{
        return QAbstractFileEngine::size();
    }
}

bool QAbstractFileEngine_oshell::syncToDisk()
{
    if(jmethodID method_id = __shell_javaMethod(33)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::syncToDisk()", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::syncToDisk()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::syncToDisk()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::syncToDisk();
        }
    }else{
        return QAbstractFileEngine::syncToDisk();
    }
}

qint64 QAbstractFileEngine_oshell::write(const char* data0, qint64 len1)
{
    if(jmethodID method_id = __shell_javaMethod(34)){
        QTJAMBI_JAVA_METHOD_CALL("QAbstractFileEngine::write(const char*,qint64)", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            qint64  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAbstractFileEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    DataJBuffer __java_data0_buffer(__jni_env, data0, len1);
                    jobject __java_data0 = __java_data0_buffer.buffer();
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_data0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<qint64>(__java_return_value);
                } else {
                    QAbstractFileEngine_shell::__shell()->warnForMethod("QAbstractFileEngine::write(const char*,qint64)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAbstractFileEngine::write(const char*,qint64)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAbstractFileEngine::write(data0, static_cast<qint64>(len1));
        }
    }else{
        return QAbstractFileEngine::write(data0, static_cast<qint64>(len1));
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
void QAbstractFileEngine_access::__qt_setError_QFileDevice_FileError_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint error0, jstring str1)
{
    Q_UNUSED(__jni_env)
    Q_UNUSED(__this_nativeId)
    QFileDevice::FileError __qt_error0 = qtjambi_cast<QFileDevice::FileError>(__jni_env, error0);
    QString  __qt_str1 = qtjambi_cast<QString>(__jni_env, str1);
    QAbstractFileEngine::setError(__qt_error0, __qt_str1);
}

// emitting Virtual Override Functions (virtualOverrideFunctions)
jobject QAbstractFileEngine_access::__qt_beginEntryList_QDir_Filters_cref_QStringList(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint filters0, jobject filterNames1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QDir::Filters __qt_filters0 = qtjambi_cast<QDir::Filters>(__jni_env, filters0);
    const QStringList&  __qt_filterNames1 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, filterNames1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAbstractFileEngineIterator* __qt_return_value = QAbstractFileEngine::beginEntryList(__qt_filters0, __qt_filterNames1);
        jobject __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnership(__jni_env, __java_return_value);
        return __java_return_value;
    } else {
        QAbstractFileEngineIterator* __qt_return_value = beginEntryList(__qt_filters0, __qt_filterNames1);
        jobject __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnership(__jni_env, __java_return_value);
        return __java_return_value;
    }
}

jboolean QAbstractFileEngine_access::__qt_caseSensitive_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::caseSensitive();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = caseSensitive();
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_cloneTo_QAbstractFileEngine_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID target0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine* __qt_target0 = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(target0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::cloneTo(__qt_target0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = cloneTo(__qt_target0);
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_close(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::close();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = close();
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_copy_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring newName0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_newName0 = qtjambi_cast<QString>(__jni_env, newName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::copy(__qt_newName0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = copy(__qt_newName0);
        return jboolean(__qt_return_value);
    }
}

jobject QAbstractFileEngine_access::__qt_endEntryList(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAbstractFileEngineIterator* __qt_return_value = QAbstractFileEngine::endEntryList();
        jobject __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnership(__jni_env, __java_return_value);
        return __java_return_value;
    } else {
        QAbstractFileEngineIterator* __qt_return_value = endEntryList();
        jobject __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnership(__jni_env, __java_return_value);
        return __java_return_value;
    }
}

jobject QAbstractFileEngine_access::__qt_entryList_QDir_Filters_cref_QStringList_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint filters0, jobject filterNames1) const
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QDir::Filters __qt_filters0 = qtjambi_cast<QDir::Filters>(__jni_env, filters0);
    const QStringList&  __qt_filterNames1 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, filterNames1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QStringList __qt_return_value = QAbstractFileEngine::entryList(__qt_filters0, __qt_filterNames1);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QStringList __qt_return_value = entryList(__qt_filters0, __qt_filterNames1);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QAbstractFileEngine_access::__qt_fileFlags_QAbstractFileEngine_FileFlags_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint type0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine::FileFlags __qt_type0 = qtjambi_cast<QAbstractFileEngine::FileFlags>(__jni_env, type0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAbstractFileEngine::FileFlags __qt_return_value = QAbstractFileEngine::fileFlags(__qt_type0);
        return __qt_return_value;
    } else {
        QAbstractFileEngine::FileFlags __qt_return_value = fileFlags(__qt_type0);
        return __qt_return_value;
    }
}

jstring QAbstractFileEngine_access::__qt_fileName_QAbstractFileEngine_FileName_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint file0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine::FileName __qt_file0 = qtjambi_cast<QAbstractFileEngine::FileName>(__jni_env, file0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QAbstractFileEngine::fileName(__qt_file0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = fileName(__qt_file0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jobject QAbstractFileEngine_access::__qt_fileTime_QAbstractFileEngine_FileTime_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint time0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine::FileTime __qt_time0 = qtjambi_cast<QAbstractFileEngine::FileTime>(__jni_env, time0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QDateTime __qt_return_value = QAbstractFileEngine::fileTime(__qt_time0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QDateTime __qt_return_value = fileTime(__qt_time0);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_flush(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::flush();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = flush();
        return jboolean(__qt_return_value);
    }
}

jint QAbstractFileEngine_access::__qt_handle_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QAbstractFileEngine::handle();
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = handle();
        return jint(__qt_return_value);
    }
}

jobject QAbstractFileEngine_access::__qt_id_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QByteArray __qt_return_value = QAbstractFileEngine::id();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QByteArray __qt_return_value = id();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_isRelativePath_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::isRelativePath();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = isRelativePath();
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_isSequential_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::isSequential();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = isSequential();
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_link_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring newName0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_newName0 = qtjambi_cast<QString>(__jni_env, newName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::link(__qt_newName0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = link(__qt_newName0);
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_mkdir_cref_QString_bool_std_optional_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring dirName0, jboolean createParentDirectories1, jobject permissions2) const
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_dirName0 = qtjambi_cast<QString>(__jni_env, dirName0);
    std::optional<QFileDevice::Permissions>  __qt_permissions2 = qtjambi_cast<std::optional<QFileDevice::Permissions> >(__jni_env, __qtjambi_scope, permissions2);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::mkdir(__qt_dirName0, static_cast<bool>(createParentDirectories1), __qt_permissions2);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = mkdir(__qt_dirName0, static_cast<bool>(createParentDirectories1), __qt_permissions2);
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_open_QIODeviceBase_OpenMode_std_optional(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint openMode0, jobject permissions1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QIODeviceBase::OpenMode __qt_openMode0 = qtjambi_cast<QIODeviceBase::OpenMode>(__jni_env, openMode0);
    std::optional<QFileDevice::Permissions>  __qt_permissions1 = qtjambi_cast<std::optional<QFileDevice::Permissions> >(__jni_env, __qtjambi_scope, permissions1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::open(__qt_openMode0, __qt_permissions1);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = open(__qt_openMode0, __qt_permissions1);
        return jboolean(__qt_return_value);
    }
}

jstring QAbstractFileEngine_access::__qt_owner_QAbstractFileEngine_FileOwner_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint arg__1) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine::FileOwner __qt_arg__1 = qtjambi_cast<QAbstractFileEngine::FileOwner>(__jni_env, arg__1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QAbstractFileEngine::owner(__qt_arg__1);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = owner(__qt_arg__1);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jint QAbstractFileEngine_access::__qt_ownerId_QAbstractFileEngine_FileOwner_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint arg__1) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAbstractFileEngine::FileOwner __qt_arg__1 = qtjambi_cast<QAbstractFileEngine::FileOwner>(__jni_env, arg__1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        uint __qt_return_value = QAbstractFileEngine::ownerId(__qt_arg__1);
        return jint(__qt_return_value);
    } else {
        uint __qt_return_value = ownerId(__qt_arg__1);
        return jint(__qt_return_value);
    }
}

jlong QAbstractFileEngine_access::__qt_pos_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        qint64 __qt_return_value = QAbstractFileEngine::pos();
        return jlong(__qt_return_value);
    } else {
        qint64 __qt_return_value = pos();
        return jlong(__qt_return_value);
    }
}

jint QAbstractFileEngine_access::__qt_read_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject data0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    qint64 maxlen1{0};
    JBufferData __qt_data0_buffer(__jni_env, data0);
    char* __qt_data0 = __qt_data0_buffer.data<char>();
    maxlen1 = __qt_data0_buffer.size<char>();
    if (QtJambiAPI::isShell(__this_nativeId)) {
        qint64 __qt_return_value = QAbstractFileEngine::read(__qt_data0, static_cast<qint64>(maxlen1));
        return jint(__qt_return_value);
    } else {
        qint64 __qt_return_value = read(__qt_data0, static_cast<qint64>(maxlen1));
        return jint(__qt_return_value);
    }
}

jint QAbstractFileEngine_access::__qt_readLine_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject data0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    qint64 maxlen1{0};
    JBufferData __qt_data0_buffer(__jni_env, data0);
    char* __qt_data0 = __qt_data0_buffer.data<char>();
    maxlen1 = __qt_data0_buffer.size<char>();
    if (QtJambiAPI::isShell(__this_nativeId)) {
        qint64 __qt_return_value = QAbstractFileEngine::readLine(__qt_data0, static_cast<qint64>(maxlen1));
        return jint(__qt_return_value);
    } else {
        qint64 __qt_return_value = readLine(__qt_data0, static_cast<qint64>(maxlen1));
        return jint(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_remove(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::remove();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = remove();
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_rename_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring newName0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_newName0 = qtjambi_cast<QString>(__jni_env, newName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::rename(__qt_newName0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = rename(__qt_newName0);
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_renameOverwrite_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring newName0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_newName0 = qtjambi_cast<QString>(__jni_env, newName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::renameOverwrite(__qt_newName0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = renameOverwrite(__qt_newName0);
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_rmdir_cref_QString_bool_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring dirName0, jboolean recurseParentDirectories1) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_dirName0 = qtjambi_cast<QString>(__jni_env, dirName0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::rmdir(__qt_dirName0, static_cast<bool>(recurseParentDirectories1));
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = rmdir(__qt_dirName0, static_cast<bool>(recurseParentDirectories1));
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_seek_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jlong pos0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::seek(static_cast<qint64>(pos0));
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = seek(static_cast<qint64>(pos0));
        return jboolean(__qt_return_value);
    }
}

void QAbstractFileEngine_access::__qt_setFileName_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring file0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_file0 = qtjambi_cast<QString>(__jni_env, file0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAbstractFileEngine::setFileName(__qt_file0);
    } else {
        setFileName(__qt_file0);
    }
}

jboolean QAbstractFileEngine_access::__qt_setFileTime_cref_QDateTime_QAbstractFileEngine_FileTime(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID newDate0, jint time1)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QDateTime& __qt_newDate0 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(newDate0);
    QAbstractFileEngine::FileTime __qt_time1 = qtjambi_cast<QAbstractFileEngine::FileTime>(__jni_env, time1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::setFileTime(__qt_newDate0, __qt_time1);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = setFileTime(__qt_newDate0, __qt_time1);
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_setPermissions_uint(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint perms0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::setPermissions(static_cast<uint>(perms0));
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = setPermissions(static_cast<uint>(perms0));
        return jboolean(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_setSize_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jlong size0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::setSize(static_cast<qint64>(size0));
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = setSize(static_cast<qint64>(size0));
        return jboolean(__qt_return_value);
    }
}

jlong QAbstractFileEngine_access::__qt_size_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        qint64 __qt_return_value = QAbstractFileEngine::size();
        return jlong(__qt_return_value);
    } else {
        qint64 __qt_return_value = size();
        return jlong(__qt_return_value);
    }
}

jboolean QAbstractFileEngine_access::__qt_syncToDisk(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QAbstractFileEngine::syncToDisk();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = syncToDisk();
        return jboolean(__qt_return_value);
    }
}

jint QAbstractFileEngine_access::__qt_write_const_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject data0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    qint64 len1{0};
    JBufferConstData __qt_data0_buffer(__jni_env, data0);
    const char* __qt_data0 = __qt_data0_buffer.data<char>();
    len1 = __qt_data0_buffer.size<char>();
    if (QtJambiAPI::isShell(__this_nativeId)) {
        qint64 __qt_return_value = QAbstractFileEngine::write(__qt_data0, static_cast<qint64>(len1));
        return jint(__qt_return_value);
    } else {
        qint64 __qt_return_value = write(__qt_data0, static_cast<qint64>(len1));
        return jint(__qt_return_value);
    }
}

// emitting (writeConstructors)
// new QAbstractFileEngine()
void __qt_construct_QAbstractFileEngine(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool __qtjambi_has_overrides, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAbstractFileEngine()")
    Q_UNUSED(__java_arguments)
    QAbstractFileEngine *__qt_this;
    if(__qtjambi_has_overrides)
        __qt_this = new(__qtjambi_ptr) QAbstractFileEngine_oshell();
    else
        __qt_this = new(__qtjambi_ptr) QAbstractFileEngine_shell();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QAbstractFileEngine::QAbstractFileEngine()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_initialize_1native__Lio_qt_core_internal_QAbstractFileEngine_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAbstractFileEngine::QAbstractFileEngine()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAbstractFileEngine, sizeof(QAbstractFileEngine_shell), typeid(QAbstractFileEngine), 0, true, &deleter_QAbstractFileEngine, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QAbstractFileEngine_shell
void __qt_destruct_QAbstractFileEngine(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QAbstractFileEngine")
    reinterpret_cast<QAbstractFileEngine_shell*>(ptr)->~QAbstractFileEngine_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QAbstractFileEngine::atEnd()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_atEnd_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::atEnd()const", __this_nativeId)
        __java_return_value = __qt_this->atEnd();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::error()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_error_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::error()const", __this_nativeId)
        QFileDevice::FileError __qt_return_value = __qt_this->error();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::errorString()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_errorString_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::errorString()const", __this_nativeId)
        QString __qt_return_value = __qt_this->errorString();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::map(qint64,qint64,QFile::MemoryMapFlags)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_map_1native_1qint64_1qint64_1QFileDevice_1MemoryMapFlags__JJJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong offset0,
 jlong size1,
 jint flags2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::map(qint64,qint64,QFile::MemoryMapFlags)", __this_nativeId)
        QFileDevice::MemoryMapFlags __qt_flags2 = qtjambi_cast<QFileDevice::MemoryMapFlags>(__jni_env, flags2);
        uchar* __qt_return_value = __qt_this->map(static_cast<qint64>(offset0), static_cast<qint64>(size1), QFileDevice::MemoryMapFlags(__qt_flags2));
        DataJBuffer __java_return_value_buffer(__jni_env, __qt_return_value, qMin<qsizetype>(size1, __qt_this->size()-offset0));
        __java_return_value = __java_return_value_buffer.take();
        QtJambiAPI::registerDependency(__jni_env, __java_return_value, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::setError(QFile::FileError,QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_setError_1native_1QFileDevice_1FileError_1cref_1QString__JILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint error0,
 jstring str1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::setError(QFile::FileError,QString)", __this_nativeId)
        static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_setError_QFileDevice_FileError_cref_QString(__jni_env, __this_nativeId, error0, str1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAbstractFileEngine::unmap(uchar*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_unmap_1native_1uchar_1ptr__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject ptr0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::unmap(uchar*)", __this_nativeId)
        JBufferData __qt_ptr0_buffer(__jni_env, ptr0);
        uchar* __qt_ptr0 = __qt_ptr0_buffer.data<uchar>();
        __java_return_value = __qt_this->unmap(__qt_ptr0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::beginEntryList(QDir::Filters,QStringList)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_beginEntryList_1native_1QDir_1Filters_1cref_1QStringList__JILjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint filters0,
 jobject filterNames1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::beginEntryList(QDir::Filters,QStringList)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_beginEntryList_QDir_Filters_cref_QStringList(__jni_env, __this_nativeId, filters0, filterNames1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::caseSensitive()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_caseSensitive_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::caseSensitive()const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_caseSensitive_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::cloneTo(QAbstractFileEngine*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_cloneTo_1native_1QAbstractFileEngine_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID target0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::cloneTo(QAbstractFileEngine*)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_cloneTo_QAbstractFileEngine_ptr(__jni_env, __this_nativeId, target0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::close()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_close_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::close()", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_close(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::copy(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_copy_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring newName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::copy(QString)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_copy_cref_QString(__jni_env, __this_nativeId, newName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::endEntryList()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_endEntryList_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::endEntryList()", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_endEntryList(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::entryList(QDir::Filters,QStringList)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_entryList_1native_1QDir_1Filters_1cref_1QStringList_1constfct__JILjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint filters0,
 jobject filterNames1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::entryList(QDir::Filters,QStringList)const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_entryList_QDir_Filters_cref_QStringList_constfct(__jni_env, __this_nativeId, filters0, filterNames1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::fileFlags(QAbstractFileEngine::FileFlags)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_fileFlags_1native_1QAbstractFileEngine_1FileFlags_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint type0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::fileFlags(QAbstractFileEngine::FileFlags)const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_fileFlags_QAbstractFileEngine_FileFlags_constfct(__jni_env, __this_nativeId, type0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::fileName(QAbstractFileEngine::FileName)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_fileName_1native_1QAbstractFileEngine_1FileName_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint file0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::fileName(QAbstractFileEngine::FileName)const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_fileName_QAbstractFileEngine_FileName_constfct(__jni_env, __this_nativeId, file0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::fileTime(QAbstractFileEngine::FileTime)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_fileTime_1native_1QAbstractFileEngine_1FileTime_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint time0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::fileTime(QAbstractFileEngine::FileTime)const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_fileTime_QAbstractFileEngine_FileTime_constfct(__jni_env, __this_nativeId, time0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::flush()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_flush_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::flush()", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_flush(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::handle()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_handle_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::handle()const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_handle_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::id()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_id_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::id()const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_id_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::isRelativePath()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_isRelativePath_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::isRelativePath()const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_isRelativePath_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::isSequential()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_isSequential_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::isSequential()const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_isSequential_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::link(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_link_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring newName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::link(QString)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_link_cref_QString(__jni_env, __this_nativeId, newName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::mkdir(QString,bool,std::optional<QFile::Permissions>)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_mkdir_1native_1cref_1QString_1bool_1std_1optional_1constfct__JLjava_lang_String_2ZLjava_util_Optional_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring dirName0,
 jboolean createParentDirectories1,
 jobject permissions2)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::mkdir(QString,bool,std::optional<QFile::Permissions>)const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_mkdir_cref_QString_bool_std_optional_constfct(__jni_env, __this_nativeId, dirName0, createParentDirectories1, permissions2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::open(QIODevice::OpenMode,std::optional<QFile::Permissions>)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_open_1native_1QIODeviceBase_1OpenMode_1std_1optional__JILjava_util_Optional_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint openMode0,
 jobject permissions1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::open(QIODevice::OpenMode,std::optional<QFile::Permissions>)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_open_QIODeviceBase_OpenMode_std_optional(__jni_env, __this_nativeId, openMode0, permissions1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::owner(QAbstractFileEngine::FileOwner)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_owner_1native_1QAbstractFileEngine_1FileOwner_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::owner(QAbstractFileEngine::FileOwner)const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_owner_QAbstractFileEngine_FileOwner_constfct(__jni_env, __this_nativeId, arg__1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::ownerId(QAbstractFileEngine::FileOwner)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_ownerId_1native_1QAbstractFileEngine_1FileOwner_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::ownerId(QAbstractFileEngine::FileOwner)const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_ownerId_QAbstractFileEngine_FileOwner_constfct(__jni_env, __this_nativeId, arg__1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::pos()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_pos_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::pos()const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_pos_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::read(char*,qint64)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_read_1native_1char_1ptr_1qint64__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject data0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::read(char*,qint64)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_read_char_ptr_qint64(__jni_env, __this_nativeId, data0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::readLine(char*,qint64)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_readLine_1native_1char_1ptr_1qint64__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject data0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::readLine(char*,qint64)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_readLine_char_ptr_qint64(__jni_env, __this_nativeId, data0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::remove()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_remove_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::remove()", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_remove(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::rename(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_rename_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring newName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::rename(QString)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_rename_cref_QString(__jni_env, __this_nativeId, newName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::renameOverwrite(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_renameOverwrite_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring newName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::renameOverwrite(QString)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_renameOverwrite_cref_QString(__jni_env, __this_nativeId, newName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::rmdir(QString,bool)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_rmdir_1native_1cref_1QString_1bool_1constfct__JLjava_lang_String_2Z)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring dirName0,
 jboolean recurseParentDirectories1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::rmdir(QString,bool)const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_rmdir_cref_QString_bool_constfct(__jni_env, __this_nativeId, dirName0, recurseParentDirectories1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::seek(qint64)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_seek_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong pos0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::seek(qint64)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_seek_qint64(__jni_env, __this_nativeId, pos0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::setFileName(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_setFileName_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring file0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::setFileName(QString)", __this_nativeId)
        static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_setFileName_cref_QString(__jni_env, __this_nativeId, file0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAbstractFileEngine::setFileTime(QDateTime,QAbstractFileEngine::FileTime)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_setFileTime_1native_1cref_1QDateTime_1QAbstractFileEngine_1FileTime__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID newDate0,
 jint time1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::setFileTime(QDateTime,QAbstractFileEngine::FileTime)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_setFileTime_cref_QDateTime_QAbstractFileEngine_FileTime(__jni_env, __this_nativeId, newDate0, time1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::setPermissions(uint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_setPermissions_1native_1uint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint perms0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::setPermissions(uint)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_setPermissions_uint(__jni_env, __this_nativeId, perms0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::setSize(qint64)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_setSize_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong size0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::setSize(qint64)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_setSize_qint64(__jni_env, __this_nativeId, size0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::size()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::size()const", __this_nativeId)
        __java_return_value = static_cast<const QAbstractFileEngine_access*>(__qt_this)->__qt_size_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::syncToDisk()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_syncToDisk_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::syncToDisk()", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_syncToDisk(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::write(const char*,qint64)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_write_1native_1const_1char_1ptr_1qint64__JLjava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring data0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QAbstractFileEngine *__qt_this = QtJambiAPI::objectFromNativeId<QAbstractFileEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAbstractFileEngine::write(const char*,qint64)", __this_nativeId)
        __java_return_value = static_cast<QAbstractFileEngine_access*>(__qt_this)->__qt_write_const_char_ptr_qint64(__jni_env, __this_nativeId, data0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAbstractFileEngine::create(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_internal_QAbstractFileEngine_create__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring fileName0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAbstractFileEngine::create(QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        QAbstractFileEngine* __qt_return_value = QAbstractFileEngine::create(__qt_fileName0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnership(__jni_env, __java_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QAbstractFileEngine(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QAbstractFileEngine>("QAbstractFileEngine", "io/qt/core/internal/QAbstractFileEngine");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/*  0 */ "beginEntryList", "(Lio/qt/core/QDir$Filters;Ljava/util/Collection;)Lio/qt/core/internal/QAbstractFileEngineIterator;"),
        FunctionInfo(/*  1 */ "caseSensitive", "()Z"),
        FunctionInfo(/*  2 */ "cloneTo", "(Lio/qt/core/internal/QAbstractFileEngine;)Z"),
        FunctionInfo(/*  3 */ "close", "()Z"),
        FunctionInfo(/*  4 */ "copy", "(Ljava/lang/String;)Z"),
        FunctionInfo(/*  5 */ "endEntryList", "()Lio/qt/core/internal/QAbstractFileEngineIterator;"),
        FunctionInfo(/*  6 */ "entryList", "(Lio/qt/core/QDir$Filters;Ljava/util/Collection;)Ljava/util/List;"),
        FunctionInfo(/*  7 */ "fileFlags", "(Lio/qt/core/internal/QAbstractFileEngine$FileFlags;)Lio/qt/core/internal/QAbstractFileEngine$FileFlags;"),
        FunctionInfo(/*  8 */ "fileName", "(Lio/qt/core/internal/QAbstractFileEngine$FileName;)Ljava/lang/String;"),
        FunctionInfo(/*  9 */ "fileTime", "(Lio/qt/core/internal/QAbstractFileEngine$FileTime;)Lio/qt/core/QDateTime;"),
        FunctionInfo(/* 10 */ "flush", "()Z"),
        FunctionInfo(/* 11 */ "handle", "()I"),
        FunctionInfo(/* 12 */ "id", "()Lio/qt/core/QByteArray;"),
        FunctionInfo(/* 13 */ "isRelativePath", "()Z"),
        FunctionInfo(/* 14 */ "isSequential", "()Z"),
        FunctionInfo(/* 15 */ "link", "(Ljava/lang/String;)Z"),
        FunctionInfo(/* 16 */ "mkdir", "(Ljava/lang/String;ZLjava/util/Optional;)Z"),
        FunctionInfo(/* 17 */ "open", "(Lio/qt/core/QIODeviceBase$OpenMode;Ljava/util/Optional;)Z"),
        FunctionInfo(/* 18 */ "owner", "(Lio/qt/core/internal/QAbstractFileEngine$FileOwner;)Ljava/lang/String;"),
        FunctionInfo(/* 19 */ "ownerId", "(Lio/qt/core/internal/QAbstractFileEngine$FileOwner;)I"),
        FunctionInfo(/* 20 */ "pos", "()J"),
        FunctionInfo(/* 21 */ "read", "(Ljava/nio/ByteBuffer;)I"),
        FunctionInfo(/* 22 */ "readLine", "(Ljava/nio/ByteBuffer;)I"),
        FunctionInfo(/* 23 */ "remove", "()Z"),
        FunctionInfo(/* 24 */ "rename", "(Ljava/lang/String;)Z"),
        FunctionInfo(/* 25 */ "renameOverwrite", "(Ljava/lang/String;)Z"),
        FunctionInfo(/* 26 */ "rmdir", "(Ljava/lang/String;Z)Z"),
        FunctionInfo(/* 27 */ "seek", "(J)Z"),
        FunctionInfo(/* 28 */ "setFileName", "(Ljava/lang/String;)V"),
        FunctionInfo(/* 29 */ "setFileTime", "(Lio/qt/core/QDateTime;Lio/qt/core/internal/QAbstractFileEngine$FileTime;)Z"),
        FunctionInfo(/* 30 */ "setPermissions", "(I)Z"),
        FunctionInfo(/* 31 */ "setSize", "(J)Z"),
        FunctionInfo(/* 32 */ "size", "()J"),
        FunctionInfo(/* 33 */ "syncToDisk", "()Z"),
        FunctionInfo(/* 34 */ "write", "(Ljava/nio/ByteBuffer;)I")});
    registerConstructorInfos(typeId, 0, &__qt_destruct_QAbstractFileEngine, {
        ConstructorInfo(&__qt_construct_QAbstractFileEngine, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QAbstractFileEngine);
    registerSizeOfShell(typeId, sizeof(QAbstractFileEngine_shell));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QAbstractFileEngine::FileFlag>("QAbstractFileEngine::FileFlag", "io/qt/core/internal/QAbstractFileEngine$FileFlag", "QAbstractFileEngine::FileFlags", "QFlags<QAbstractFileEngine::FileFlag>", "io/qt/core/internal/QAbstractFileEngine$FileFlags");
    registerEnumTypeInfo<QAbstractFileEngine::FileName>("QAbstractFileEngine::FileName", "io/qt/core/internal/QAbstractFileEngine$FileName");
    registerEnumTypeInfo<QAbstractFileEngine::FileOwner>("QAbstractFileEngine::FileOwner", "io/qt/core/internal/QAbstractFileEngine$FileOwner");
    registerEnumTypeInfo<QAbstractFileEngine::FileTime>("QAbstractFileEngine::FileTime", "io/qt/core/internal/QAbstractFileEngine$FileTime");
// END: enums and flags
}
