#include <QtCore/QtGlobal>
#include <QtCore/qbytearrayview.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qbytearrayalgorithms.h>
#include <QtCore/qhashfunctions.h>
#include <QtCore/qnamespace.h>
#include "utils_p.h"

#include <QtJambi/QtJambiAPI>
#include <QtJambi/JavaAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QByteArrayView(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QByteArrayView")
    QByteArrayView *_ptr = reinterpret_cast<QByteArrayView *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QByteArrayView()
void __qt_construct_QByteArrayView(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QByteArrayView()")
    Q_UNUSED(__java_arguments)
    QByteArrayView *__qt_this = new(__qtjambi_ptr) QByteArrayView();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QByteArrayView::QByteArrayView()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_initialize_1native__Lio_qt_core_QByteArrayView_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArrayView::QByteArrayView()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QByteArrayView, sizeof(QByteArrayView), typeid(QByteArrayView), 0, false, &deleter_QByteArrayView, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QByteArrayView(QByteArrayView)
void __qt_construct_QByteArrayView_cref_QByteArrayView(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QByteArrayView(QByteArrayView)")
    jobject other0 = __java_arguments[0].l;
    const QByteArrayView& __qt_other0 = qtjambi_cast<const QByteArrayView&>(__jni_env, other0);
    QByteArrayView *__qt_this = new(__qtjambi_ptr) QByteArrayView(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QByteArrayView::QByteArrayView(QByteArrayView)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_initialize_1native__Lio_qt_core_QByteArrayView_2Lio_qt_core_QByteArrayView_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArrayView::QByteArrayView(QByteArrayView)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QByteArrayView_cref_QByteArrayView, sizeof(QByteArrayView), typeid(QByteArrayView), 0, false, &deleter_QByteArrayView, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QByteArrayView
void __qt_destruct_QByteArrayView(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QByteArrayView")
    reinterpret_cast<QByteArrayView*>(ptr)->~QByteArrayView();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QByteArrayView::at(qsizetype)const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_at_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong n0)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::at(qsizetype)const", __this_nativeId)
        __java_return_value = __qt_this->at(static_cast<qsizetype>(n0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::begin()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_begin_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::begin()const", __this_nativeId)
        QByteArrayView::const_iterator __qt_return_value = __qt_this->begin();
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::chop(qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_chop_1native_1qsizetype__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong n0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::chop(qsizetype)", __this_nativeId)
        __qt_this->chop(static_cast<qsizetype>(n0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArrayView::chopped(qsizetype)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_chopped_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong len0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::chopped(qsizetype)const", __this_nativeId)
        QByteArrayView __qt_return_value = __qt_this->chopped(static_cast<qsizetype>(len0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::compare(QByteArrayView,Qt::CaseSensitivity)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_compare_1native_1QByteArrayView_1Qt_1CaseSensitivity_1constfct__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0,
 jint cs1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::compare(QByteArrayView,Qt::CaseSensitivity)const", __this_nativeId)
        QByteArrayView __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(a0);
        Qt::CaseSensitivity __qt_cs1 = qtjambi_cast<Qt::CaseSensitivity>(__jni_env, cs1);
        __java_return_value = __qt_this->compare(__qt_a0, Qt::CaseSensitivity(__qt_cs1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::constData()const
extern "C" Q_DECL_EXPORT jbyteArray JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_toArray_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jbyteArray __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::constData()const", __this_nativeId)
        const char* __qt_return_value = __qt_this->constData();
        __java_return_value = qtjambi_array_cast<jbyteArray>(__jni_env, __qtjambi_scope, __qt_return_value, jsize(__qt_this->size()));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::contains(QByteArrayView)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_contains_1native_1QByteArrayView_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::contains(QByteArrayView)const", __this_nativeId)
        QByteArrayView __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(a0);
        __java_return_value = __qt_this->contains(__qt_a0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::contains(char)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_contains_1native_1char_1constfct__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::contains(char)const", __this_nativeId)
        __java_return_value = __qt_this->contains(static_cast<char>(c0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::count(QByteArrayView)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_count_1native_1QByteArrayView_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::count(QByteArrayView)const", __this_nativeId)
        QByteArrayView __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(a0);
        qsizetype __qt_return_value = __qt_this->count(__qt_a0);
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::count(char)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_count_1native_1char_1constfct__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte ch0)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::count(char)const", __this_nativeId)
        qsizetype __qt_return_value = __qt_this->count(static_cast<char>(ch0));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::data()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_data_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::data()const", __this_nativeId)
        const char* __qt_return_value = __qt_this->data();
        DataJBuffer __java_return_value_buffer(__jni_env, __qt_return_value, __qt_this->size());
        __java_return_value = __java_return_value_buffer.take();
        QtJambiAPI::registerDependency(__jni_env, __java_return_value, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::end()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_end_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::end()const", __this_nativeId)
        QByteArrayView::const_iterator __qt_return_value = __qt_this->end();
        __java_return_value = qtjambi_cast_sequential_iterator(__jni_env, __qtjambi_scope, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::endsWith(QByteArrayView)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_endsWith_1native_1QByteArrayView_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::endsWith(QByteArrayView)const", __this_nativeId)
        QByteArrayView __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(other0);
        __java_return_value = __qt_this->endsWith(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::endsWith(char)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_endsWith_1native_1char_1constfct__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::endsWith(char)const", __this_nativeId)
        __java_return_value = __qt_this->endsWith(static_cast<char>(c0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::first()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_first_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::first()const", __this_nativeId)
        __java_return_value = __qt_this->first();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::first(qsizetype)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_first_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong n0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::first(qsizetype)const", __this_nativeId)
        QByteArrayView __qt_return_value = __qt_this->first(static_cast<qsizetype>(n0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::indexOf(QByteArrayView,qsizetype)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_indexOf_1native_1QByteArrayView_1qsizetype_1constfct__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0,
 jlong from1)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::indexOf(QByteArrayView,qsizetype)const", __this_nativeId)
        QByteArrayView __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(a0);
        qsizetype __qt_return_value = __qt_this->indexOf(__qt_a0, static_cast<qsizetype>(from1));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::indexOf(char,qsizetype)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_indexOf_1native_1char_1qsizetype_1constfct__JBJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte ch0,
 jlong from1)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::indexOf(char,qsizetype)const", __this_nativeId)
        qsizetype __qt_return_value = __qt_this->indexOf(static_cast<char>(ch0), static_cast<qsizetype>(from1));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::isEmpty()const", __this_nativeId)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::isNull()const", __this_nativeId)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::isValidUtf8()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_isValidUtf8_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::isValidUtf8()const", __this_nativeId)
        __java_return_value = __qt_this->isValidUtf8();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::last()const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_last_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::last()const", __this_nativeId)
        __java_return_value = __qt_this->last();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::last(qsizetype)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_last_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong n0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::last(qsizetype)const", __this_nativeId)
        QByteArrayView __qt_return_value = __qt_this->last(static_cast<qsizetype>(n0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::lastIndexOf(QByteArrayView)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_lastIndexOf_1native_1QByteArrayView_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::lastIndexOf(QByteArrayView)const", __this_nativeId)
        QByteArrayView __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(a0);
        qsizetype __qt_return_value = __qt_this->lastIndexOf(__qt_a0);
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::lastIndexOf(QByteArrayView,qsizetype)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_lastIndexOf_1native_1QByteArrayView_1qsizetype_1constfct__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID a0,
 jlong from1)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::lastIndexOf(QByteArrayView,qsizetype)const", __this_nativeId)
        QByteArrayView __qt_a0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(a0);
        qsizetype __qt_return_value = __qt_this->lastIndexOf(__qt_a0, static_cast<qsizetype>(from1));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::lastIndexOf(char,qsizetype)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_lastIndexOf_1native_1char_1qsizetype_1constfct__JBJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte ch0,
 jlong from1)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::lastIndexOf(char,qsizetype)const", __this_nativeId)
        qsizetype __qt_return_value = __qt_this->lastIndexOf(static_cast<char>(ch0), static_cast<qsizetype>(from1));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::left(qsizetype)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_left_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong n0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::left(qsizetype)const", __this_nativeId)
        QByteArrayView __qt_return_value = __qt_this->left(static_cast<qsizetype>(n0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::length()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_length_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::length()const", __this_nativeId)
        qsizetype __qt_return_value = __qt_this->length();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::mid(qsizetype,qsizetype)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_mid_1native_1qsizetype_1qsizetype_1constfct__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong pos0,
 jlong n1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::mid(qsizetype,qsizetype)const", __this_nativeId)
        QByteArrayView __qt_return_value = __qt_this->mid(static_cast<qsizetype>(pos0), static_cast<qsizetype>(n1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::operator<(QByteArrayView,QByteArrayView)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_operator_1less_1native_1QByteArrayView__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::operator<(QByteArrayView,QByteArrayView)", __this_nativeId)
        QByteArrayView __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(rhs1);
        __java_return_value = (*__qt_this) < __qt_rhs1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::operator==(QByteArrayView,QByteArrayView)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_equals_1native_1QByteArrayView__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::operator==(QByteArrayView,QByteArrayView)", __this_nativeId)
        QByteArrayView __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(rhs1);
        __java_return_value = (*__qt_this) == __qt_rhs1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::operator[](qsizetype)const
extern "C" Q_DECL_EXPORT jbyte JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_get_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong n0)
{
    Q_UNUSED(__this)
    jbyte __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::operator[](qsizetype)const", __this_nativeId)
        __java_return_value = (*__qt_this)[static_cast<qsizetype>(n0)];
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::right(qsizetype)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_right_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong n0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::right(qsizetype)const", __this_nativeId)
        QByteArrayView __qt_return_value = __qt_this->right(static_cast<qsizetype>(n0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::size()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::size()const", __this_nativeId)
        qsizetype __qt_return_value = __qt_this->size();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::sliced(qsizetype)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_sliced_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong pos0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::sliced(qsizetype)const", __this_nativeId)
        QByteArrayView __qt_return_value = __qt_this->sliced(static_cast<qsizetype>(pos0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::sliced(qsizetype,qsizetype)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_sliced_1native_1qsizetype_1qsizetype_1constfct__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong pos0,
 jlong n1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::sliced(qsizetype,qsizetype)const", __this_nativeId)
        QByteArrayView __qt_return_value = __qt_this->sliced(static_cast<qsizetype>(pos0), static_cast<qsizetype>(n1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::startsWith(QByteArrayView)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_startsWith_1native_1QByteArrayView_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::startsWith(QByteArrayView)const", __this_nativeId)
        QByteArrayView __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(other0);
        __java_return_value = __qt_this->startsWith(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::startsWith(char)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_startsWith_1native_1char_1constfct__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::startsWith(char)const", __this_nativeId)
        __java_return_value = __qt_this->startsWith(static_cast<char>(c0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::toByteArray()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_toByteArray_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::toByteArray()const", __this_nativeId)
        QByteArray __qt_return_value = __qt_this->toByteArray();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::toDouble(bool*)const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_toDouble_1native_1bool_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::toDouble(bool*)const", __this_nativeId)
        bool ok(false);
        bool* __qt_ok0 = &ok;
        __java_return_value = __qt_this->toDouble(__qt_ok0);


        if(!ok)
            Java::Runtime::NumberFormatException::throwNew(__jni_env, "Unable to parse number." QTJAMBI_STACKTRACEINFO );
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::toFloat(bool*)const
extern "C" Q_DECL_EXPORT jfloat JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_toFloat_1native_1bool_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jfloat __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::toFloat(bool*)const", __this_nativeId)
        bool ok(false);
        bool* __qt_ok0 = &ok;
        __java_return_value = __qt_this->toFloat(__qt_ok0);


        if(!ok)
            Java::Runtime::NumberFormatException::throwNew(__jni_env, "Unable to parse number." QTJAMBI_STACKTRACEINFO );
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::toInt(bool*,int)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_toInt_1native_1bool_1ptr_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint base1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::toInt(bool*,int)const", __this_nativeId)
        bool ok(false);
        bool* __qt_ok0 = &ok;
        __java_return_value = __qt_this->toInt(__qt_ok0, static_cast<int>(base1));


        if(!ok)
            Java::Runtime::NumberFormatException::throwNew(__jni_env, "Unable to parse number." QTJAMBI_STACKTRACEINFO );
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::toShort(bool*,int)const
extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_toShort_1native_1bool_1ptr_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint base1)
{
    Q_UNUSED(__this)
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::toShort(bool*,int)const", __this_nativeId)
        bool ok(false);
        bool* __qt_ok0 = &ok;
        __java_return_value = __qt_this->toShort(__qt_ok0, static_cast<int>(base1));


        if(!ok)
            Java::Runtime::NumberFormatException::throwNew(__jni_env, "Unable to parse number." QTJAMBI_STACKTRACEINFO );
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::trimmed()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_trimmed_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::trimmed()const", __this_nativeId)
        QByteArrayView __qt_return_value = __qt_this->trimmed();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QByteArrayView::truncate(qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_truncate_1native_1qsizetype__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong n0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QByteArrayView::truncate(qsizetype)", __this_nativeId)
        __qt_this->truncate(static_cast<qsizetype>(n0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QByteArrayView::qChecksum(QByteArrayView,Qt::ChecksumType)
extern "C" Q_DECL_EXPORT jshort JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_qChecksum_1native_1QByteArrayView_1Qt_1ChecksumType__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID data0,
 jint standard1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QByteArrayView::qChecksum(QByteArrayView,Qt::ChecksumType)")
    jshort __java_return_value{0};
    QTJAMBI_TRY {
        QByteArrayView __qt_data0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(data0);
        Qt::ChecksumType __qt_standard1 = qtjambi_cast<Qt::ChecksumType>(__jni_env, standard1);
        quint16 __qt_return_value = qChecksum(__qt_data0, Qt::ChecksumType(__qt_standard1));
        __java_return_value = jshort(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QByteArrayView_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QByteArrayView *__qt_this = QtJambiAPI::objectFromNativeId<QByteArrayView>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QByteArrayView(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QByteArrayView>("QByteArrayView", "io/qt/core/QByteArrayView");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QByteArrayView, {
        ConstructorInfo(&__qt_construct_QByteArrayView, nullptr)
       ,ConstructorInfo(&__qt_construct_QByteArrayView_cref_QByteArrayView, "Lio/qt/core/QByteArrayView;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QByteArrayView);
    registerMetaType<QByteArrayView>("QByteArrayView");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
