#include <QtCore/QtGlobal>
#include <QtCore/qdatetime.h>
#include <QtCore/QVariant>
#include <QtCore/qcalendar.h>
#include <QtCore/qdatastream.h>
#include <QtCore/qnamespace.h>
#include <QtCore/qtimezone.h>
#include "utils_p.h"

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QDate(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QDate")
    QDate *_ptr = reinterpret_cast<QDate *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QDate()
void __qt_construct_QDate(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDate()")
    Q_UNUSED(__java_arguments)
    QDate *__qt_this = new(__qtjambi_ptr) QDate();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QDate::QDate()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_initialize_1native__Lio_qt_core_QDate_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDate::QDate()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDate, sizeof(QDate), typeid(QDate), 0, false, &deleter_QDate, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDate(QDate)
void __qt_construct_QDate_cref_QDate(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDate(QDate)")
    jobject other0 = __java_arguments[0].l;
    const QDate& __qt_other0 = qtjambi_cast<const QDate&>(__jni_env, other0);
    QDate *__qt_this = new(__qtjambi_ptr) QDate(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QDate::QDate(QDate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_initialize_1native__Lio_qt_core_QDate_2Lio_qt_core_QDate_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDate::QDate(QDate)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDate_cref_QDate, sizeof(QDate), typeid(QDate), 0, false, &deleter_QDate, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDate(int,int,int)
void __qt_construct_QDate_int_int_int(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDate(int,int,int)")
    jint y0 = __java_arguments[0].i;
    Q_UNUSED(y0)
    jint m1 = __java_arguments[1].i;
    Q_UNUSED(m1)
    jint d2 = __java_arguments[2].i;
    Q_UNUSED(d2)
    QDate *__qt_this = new(__qtjambi_ptr) QDate(static_cast<int>(y0), static_cast<int>(m1), static_cast<int>(d2));
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QDate::QDate(int,int,int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_initialize_1native__Lio_qt_core_QDate_2III)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint y0,
 jint m1,
 jint d2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDate::QDate(int,int,int)")
    QTJAMBI_TRY {
        jvalue arguments[3];
        arguments[0].i = y0;
        arguments[1].i = m1;
        arguments[2].i = d2;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDate_int_int_int, sizeof(QDate), typeid(QDate), 0, false, &deleter_QDate, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDate(int,int,int,QCalendar)
void __qt_construct_QDate_int_int_int_QCalendar(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDate(int,int,int,QCalendar)")
    jint y0 = __java_arguments[0].i;
    Q_UNUSED(y0)
    jint m1 = __java_arguments[1].i;
    Q_UNUSED(m1)
    jint d2 = __java_arguments[2].i;
    Q_UNUSED(d2)
    jobject cal3 = __java_arguments[3].l;
    QCalendar __qt_cal3 = qtjambi_cast<QCalendar>(__jni_env, cal3);
    QDate *__qt_this = new(__qtjambi_ptr) QDate(static_cast<int>(y0), static_cast<int>(m1), static_cast<int>(d2), __qt_cal3);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QDate::QDate(int,int,int,QCalendar)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_initialize_1native__Lio_qt_core_QDate_2IIILio_qt_core_QCalendar_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint y0,
 jint m1,
 jint d2,
 jobject cal3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDate::QDate(int,int,int,QCalendar)")
    QTJAMBI_TRY {
        jvalue arguments[4];
        arguments[0].i = y0;
        arguments[1].i = m1;
        arguments[2].i = d2;
        arguments[3].l = cal3;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDate_int_int_int_QCalendar, sizeof(QDate), typeid(QDate), 0, false, &deleter_QDate, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QDate
void __qt_destruct_QDate(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QDate")
    reinterpret_cast<QDate*>(ptr)->~QDate();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QDate::addDays(qint64)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_addDays_1native_1qint64_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong days0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::addDays(qint64)const", __this_nativeId)
        QDate __qt_return_value = __qt_this->addDays(static_cast<qint64>(days0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::addMonths(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_addMonths_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint months0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::addMonths(int)const", __this_nativeId)
        QDate __qt_return_value = __qt_this->addMonths(static_cast<int>(months0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::addMonths(int,QCalendar)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_addMonths_1native_1int_1QCalendar_1constfct__JIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint months0,
 QtJambiNativeID cal1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::addMonths(int,QCalendar)const", __this_nativeId)
        QCalendar __qt_cal1 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal1);
        QDate __qt_return_value = __qt_this->addMonths(static_cast<int>(months0), __qt_cal1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::addYears(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_addYears_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint years0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::addYears(int)const", __this_nativeId)
        QDate __qt_return_value = __qt_this->addYears(static_cast<int>(years0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::addYears(int,QCalendar)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_addYears_1native_1int_1QCalendar_1constfct__JIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint years0,
 QtJambiNativeID cal1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::addYears(int,QCalendar)const", __this_nativeId)
        QCalendar __qt_cal1 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal1);
        QDate __qt_return_value = __qt_this->addYears(static_cast<int>(years0), __qt_cal1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::day()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_day_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::day()const", __this_nativeId)
        __java_return_value = __qt_this->day();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::day(QCalendar)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_day_1native_1QCalendar_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID cal0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::day(QCalendar)const", __this_nativeId)
        QCalendar __qt_cal0 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal0);
        __java_return_value = __qt_this->day(__qt_cal0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::dayOfWeek()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_dayOfWeek_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::dayOfWeek()const", __this_nativeId)
        __java_return_value = __qt_this->dayOfWeek();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::dayOfWeek(QCalendar)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_dayOfWeek_1native_1QCalendar_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID cal0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::dayOfWeek(QCalendar)const", __this_nativeId)
        QCalendar __qt_cal0 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal0);
        __java_return_value = __qt_this->dayOfWeek(__qt_cal0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::dayOfYear()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_dayOfYear_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::dayOfYear()const", __this_nativeId)
        __java_return_value = __qt_this->dayOfYear();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::dayOfYear(QCalendar)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_dayOfYear_1native_1QCalendar_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID cal0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::dayOfYear(QCalendar)const", __this_nativeId)
        QCalendar __qt_cal0 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal0);
        __java_return_value = __qt_this->dayOfYear(__qt_cal0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::daysInMonth()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_daysInMonth_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::daysInMonth()const", __this_nativeId)
        __java_return_value = __qt_this->daysInMonth();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::daysInMonth(QCalendar)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_daysInMonth_1native_1QCalendar_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID cal0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::daysInMonth(QCalendar)const", __this_nativeId)
        QCalendar __qt_cal0 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal0);
        __java_return_value = __qt_this->daysInMonth(__qt_cal0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::daysInYear()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_daysInYear_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::daysInYear()const", __this_nativeId)
        __java_return_value = __qt_this->daysInYear();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::daysInYear(QCalendar)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_daysInYear_1native_1QCalendar_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID cal0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::daysInYear(QCalendar)const", __this_nativeId)
        QCalendar __qt_cal0 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal0);
        __java_return_value = __qt_this->daysInYear(__qt_cal0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::daysTo(QDate)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_daysTo_1native_1QDate_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID d0)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::daysTo(QDate)const", __this_nativeId)
        QDate __qt_d0 = QtJambiAPI::valueReferenceFromNativeId<QDate>(d0);
        qint64 __qt_return_value = __qt_this->daysTo(__qt_d0);
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::endOfDay()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_endOfDay_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::endOfDay()const", __this_nativeId)
        QDateTime __qt_return_value = __qt_this->endOfDay();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::endOfDay(QTimeZone)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_endOfDay_1native_1cref_1QTimeZone_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID zone0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::endOfDay(QTimeZone)const", __this_nativeId)
        const QTimeZone& __qt_zone0 = QtJambiAPI::valueReferenceFromNativeId<QTimeZone>(zone0);
        QDateTime __qt_return_value = __qt_this->endOfDay(__qt_zone0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::endOfDay(Qt::TimeSpec,int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_endOfDay_1native_1Qt_1TimeSpec_1int_1constfct__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint spec0,
 jint offsetSeconds1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::endOfDay(Qt::TimeSpec,int)const", __this_nativeId)
        Qt::TimeSpec __qt_spec0 = qtjambi_cast<Qt::TimeSpec>(__jni_env, spec0);
        QDateTime __qt_return_value = __qt_this->endOfDay(Qt::TimeSpec(__qt_spec0), static_cast<int>(offsetSeconds1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::isNull()const", __this_nativeId)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::isValid()const", __this_nativeId)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::month()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_month_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::month()const", __this_nativeId)
        __java_return_value = __qt_this->month();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::month(QCalendar)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_month_1native_1QCalendar_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID cal0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::month(QCalendar)const", __this_nativeId)
        QCalendar __qt_cal0 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal0);
        __java_return_value = __qt_this->month(__qt_cal0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::operator<(QDate,QDate)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_operator_1less_1native_1QDate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::operator<(QDate,QDate)", __this_nativeId)
        QDate __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QDate>(rhs1);
        __java_return_value = (*__qt_this) < __qt_rhs1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::operator<<(QDataStream&,QDate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::operator<<(QDataStream&,QDate)", __this_nativeId)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDate::operator==(QDate,QDate)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_equals_1native_1QDate__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::operator==(QDate,QDate)", __this_nativeId)
        QDate __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QDate>(rhs1);
        __java_return_value = (*__qt_this) == __qt_rhs1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::operator>>(QDataStream&,QDate&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::operator>>(QDataStream&,QDate&)", __this_nativeId)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDate::setDate(int,int,int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_setDate_1native_1int_1int_1int__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint year0,
 jint month1,
 jint day2)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::setDate(int,int,int)", __this_nativeId)
        __java_return_value = __qt_this->setDate(static_cast<int>(year0), static_cast<int>(month1), static_cast<int>(day2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::setDate(int,int,int,QCalendar)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_setDate_1native_1int_1int_1int_1QCalendar__JIIIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint year0,
 jint month1,
 jint day2,
 QtJambiNativeID cal3)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::setDate(int,int,int,QCalendar)", __this_nativeId)
        QCalendar __qt_cal3 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal3);
        __java_return_value = __qt_this->setDate(static_cast<int>(year0), static_cast<int>(month1), static_cast<int>(day2), __qt_cal3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::startOfDay()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_startOfDay_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::startOfDay()const", __this_nativeId)
        QDateTime __qt_return_value = __qt_this->startOfDay();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::startOfDay(QTimeZone)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_startOfDay_1native_1cref_1QTimeZone_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID zone0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::startOfDay(QTimeZone)const", __this_nativeId)
        const QTimeZone& __qt_zone0 = QtJambiAPI::valueReferenceFromNativeId<QTimeZone>(zone0);
        QDateTime __qt_return_value = __qt_this->startOfDay(__qt_zone0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::startOfDay(Qt::TimeSpec,int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_startOfDay_1native_1Qt_1TimeSpec_1int_1constfct__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint spec0,
 jint offsetSeconds1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::startOfDay(Qt::TimeSpec,int)const", __this_nativeId)
        Qt::TimeSpec __qt_spec0 = qtjambi_cast<Qt::TimeSpec>(__jni_env, spec0);
        QDateTime __qt_return_value = __qt_this->startOfDay(Qt::TimeSpec(__qt_spec0), static_cast<int>(offsetSeconds1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::toJulianDay()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_toJulianDay_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::toJulianDay()const", __this_nativeId)
        qint64 __qt_return_value = __qt_this->toJulianDay();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::toString(QString,QCalendar)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_toString_1native_1cref_1QString_1QCalendar_1constfct__JLjava_lang_String_2J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring format0,
 QtJambiNativeID cal1)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::toString(QString,QCalendar)const", __this_nativeId)
        QString  __qt_format0 = qtjambi_cast<QString>(__jni_env, format0);
        QCalendar __qt_cal1 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal1);
        QString __qt_return_value = __qt_this->toString(__qt_format0, __qt_cal1);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::toString(Qt::DateFormat)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_toString_1native_1Qt_1DateFormat_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint format0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::toString(Qt::DateFormat)const", __this_nativeId)
        Qt::DateFormat __qt_format0 = qtjambi_cast<Qt::DateFormat>(__jni_env, format0);
        QString __qt_return_value = __qt_this->toString(Qt::DateFormat(__qt_format0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::weekNumber(int*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_weekNumber_1native_1int_1ptr_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::weekNumber(int*)const", __this_nativeId)
        int yearNumber(0);
        int* __qt_yearNum0 = &yearNumber;
        int __qt_return_value = __qt_this->weekNumber(__qt_yearNum0);
        __java_return_value = Java::QtCore::QDate$Week::newInstance(__jni_env, __qt_return_value, yearNumber);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::year()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_year_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::year()const", __this_nativeId)
        __java_return_value = __qt_this->year();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::year(QCalendar)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_year_1native_1QCalendar_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID cal0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDate::year(QCalendar)const", __this_nativeId)
        QCalendar __qt_cal0 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal0);
        __java_return_value = __qt_this->year(__qt_cal0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::currentDate()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_currentDate__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDate::currentDate()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDate __qt_return_value = QDate::currentDate();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::fromJulianDay(qint64)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_fromJulianDay__J)
(JNIEnv *__jni_env,
 jclass,
 jlong jd_0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDate::fromJulianDay(qint64)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDate __qt_return_value = QDate::fromJulianDay(static_cast<qint64>(jd_0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::fromString(QString,QStringView,QCalendar)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_fromString_1native_1cref_1QString_1QStringView_1QCalendar__Ljava_lang_String_2Ljava_lang_String_2J)
(JNIEnv *__jni_env,
 jclass,
 jstring string0,
 jstring format1,
 QtJambiNativeID cal2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDate::fromString(QString,QStringView,QCalendar)")
    QtJambiScope __qtjambi_scope;
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_string0 = qtjambi_cast<QString>(__jni_env, string0);
        QStringView  __qt_format1 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, format1);
        QCalendar __qt_cal2 = QtJambiAPI::valueReferenceFromNativeId<QCalendar>(cal2);
        QDate __qt_return_value = QDate::fromString(__qt_string0, __qt_format1, __qt_cal2);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::fromString(QStringView,Qt::DateFormat)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_fromString_1native_1QStringView_1Qt_1DateFormat__Ljava_lang_String_2I)
(JNIEnv *__jni_env,
 jclass,
 jstring string0,
 jint format1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDate::fromString(QStringView,Qt::DateFormat)")
    QtJambiScope __qtjambi_scope;
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QStringView  __qt_string0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, string0);
        Qt::DateFormat __qt_format1 = qtjambi_cast<Qt::DateFormat>(__jni_env, format1);
        QDate __qt_return_value = QDate::fromString(__qt_string0, Qt::DateFormat(__qt_format1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::isLeapYear(int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_isLeapYear__I)
(JNIEnv *__jni_env,
 jclass,
 jint year0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDate::isLeapYear(int)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QDate::isLeapYear(static_cast<int>(year0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDate::isValid(int,int,int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_isValid__III)
(JNIEnv *__jni_env,
 jclass,
 jint y0,
 jint m1,
 jint d2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDate::isValid(int,int,int)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        __java_return_value = QDate::isValid(static_cast<int>(y0), static_cast<int>(m1), static_cast<int>(d2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDate_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QDate *__qt_this = QtJambiAPI::objectFromNativeId<QDate>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QDate(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QDate>("QDate", "io/qt/core/QDate");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QDate, {
        ConstructorInfo(&__qt_construct_QDate, nullptr)
       ,ConstructorInfo(&__qt_construct_QDate_cref_QDate, "Lio/qt/core/QDate;")
       ,ConstructorInfo(&__qt_construct_QDate_int_int_int, "III")
       ,ConstructorInfo(&__qt_construct_QDate_int_int_int_QCalendar, "IIILio/qt/core/QCalendar;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QDate);
    registerMetaType<QDate>("QDate");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
