#include <QtCore/QtGlobal>
#include <QtCore/qdir.h>
#include <QtCore/QList>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtCore/qfileinfo.h>
#include <QtCore/qnamespace.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QDir(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QDir")
    QDir *_ptr = reinterpret_cast<QDir *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QDir(QDir)
void __qt_construct_QDir_cref_QDir(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDir(QDir)")
    jobject arg__1 = __java_arguments[0].l;
    const QDir& __qt_arg__1 = qtjambi_cast<const QDir&>(__jni_env, arg__1);
    QDir *__qt_this = new(__qtjambi_ptr) QDir(__qt_arg__1);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QDir::QDir(QDir)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_initialize_1native__Lio_qt_core_QDir_2Lio_qt_core_QDir_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::QDir(QDir)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = arg__1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDir_cref_QDir, sizeof(QDir), typeid(QDir), 0, false, &deleter_QDir, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDir(QString)
void __qt_construct_QDir(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDir(QString)")
    Q_UNUSED(__java_arguments)
    QDir *__qt_this = new(__qtjambi_ptr) QDir();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// new QDir(QString)
void __qt_construct_QDir_cref_QString(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDir(QString)")
    jstring path0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
    QDir *__qt_this = new(__qtjambi_ptr) QDir(__qt_path0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QDir::QDir(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_initialize_1native__Lio_qt_core_QDir_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring path0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::QDir(QString)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = path0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDir_cref_QString, sizeof(QDir), typeid(QDir), 0, false, &deleter_QDir, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDir(QString,QString,QDir::SortFlags,QDir::Filters)
void __qt_construct_QDir_cref_QString_cref_QString(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDir(QString,QString,QDir::SortFlags,QDir::Filters)")
    jstring path0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
    jstring nameFilter1 = static_cast<jstring>(__java_arguments[1].l);
    QString  __qt_nameFilter1 = qtjambi_cast<QString>(__jni_env, nameFilter1);
    QDir *__qt_this = new(__qtjambi_ptr) QDir(__qt_path0, __qt_nameFilter1);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// new QDir(QString,QString,QDir::SortFlags,QDir::Filters)
void __qt_construct_QDir_cref_QString_cref_QString_QDir_SortFlags(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDir(QString,QString,QDir::SortFlags,QDir::Filters)")
    jstring path0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
    jstring nameFilter1 = static_cast<jstring>(__java_arguments[1].l);
    QString  __qt_nameFilter1 = qtjambi_cast<QString>(__jni_env, nameFilter1);
    jobject sort2 = __java_arguments[2].l;
    QDir::SortFlags __qt_sort2 = qtjambi_cast<QDir::SortFlags>(__jni_env, sort2);
    QDir *__qt_this = new(__qtjambi_ptr) QDir(__qt_path0, __qt_nameFilter1, QDir::SortFlags(__qt_sort2));
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// new QDir(QString,QString,QDir::SortFlags,QDir::Filters)
void __qt_construct_QDir_cref_QString_cref_QString_QDir_SortFlags_QDir_Filters(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDir(QString,QString,QDir::SortFlags,QDir::Filters)")
    jstring path0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
    jstring nameFilter1 = static_cast<jstring>(__java_arguments[1].l);
    QString  __qt_nameFilter1 = qtjambi_cast<QString>(__jni_env, nameFilter1);
    jobject sort2 = __java_arguments[2].l;
    QDir::SortFlags __qt_sort2 = qtjambi_cast<QDir::SortFlags>(__jni_env, sort2);
    jobject filter3 = __java_arguments[3].l;
    QDir::Filters __qt_filter3 = qtjambi_cast<QDir::Filters>(__jni_env, filter3);
    QDir *__qt_this = new(__qtjambi_ptr) QDir(__qt_path0, __qt_nameFilter1, QDir::SortFlags(__qt_sort2), QDir::Filters(__qt_filter3));
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QDir::QDir(QString,QString,QDir::SortFlags,QDir::Filters)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_initialize_1native__Lio_qt_core_QDir_2Ljava_lang_String_2Ljava_lang_String_2Lio_qt_core_QDir_00024SortFlags_2Lio_qt_core_QDir_00024Filters_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring path0,
 jstring nameFilter1,
 jobject sort2,
 jobject filter3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::QDir(QString,QString,QDir::SortFlags,QDir::Filters)")
    QTJAMBI_TRY {
        jvalue arguments[4];
        arguments[0].l = path0;
        arguments[1].l = nameFilter1;
        arguments[2].l = sort2;
        arguments[3].l = filter3;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDir_cref_QString_cref_QString_QDir_SortFlags_QDir_Filters, sizeof(QDir), typeid(QDir), 0, false, &deleter_QDir, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QDir
void __qt_destruct_QDir(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QDir")
    reinterpret_cast<QDir*>(ptr)->~QDir();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QDir::absoluteFilePath(QString)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_absoluteFilePath_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::absoluteFilePath(QString)const", __this_nativeId)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        QString __qt_return_value = __qt_this->absoluteFilePath(__qt_fileName0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::absolutePath()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_absolutePath_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::absolutePath()const", __this_nativeId)
        QString __qt_return_value = __qt_this->absolutePath();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::canonicalPath()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_canonicalPath_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::canonicalPath()const", __this_nativeId)
        QString __qt_return_value = __qt_this->canonicalPath();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::cd(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_cd_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring dirName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::cd(QString)", __this_nativeId)
        QString  __qt_dirName0 = qtjambi_cast<QString>(__jni_env, dirName0);
        __java_return_value = __qt_this->cd(__qt_dirName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::cdUp()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_cdUp_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::cdUp()", __this_nativeId)
        __java_return_value = __qt_this->cdUp();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::count(Qt::Disambiguated_t)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_count_1native_1Qt_1Disambiguated_1t_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::count(Qt::Disambiguated_t)const", __this_nativeId)
        constexpr Qt::Disambiguated_t __qt_arg__1 = Qt::Disambiguated;
        qsizetype __qt_return_value = __qt_this->count(__qt_arg__1);
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::dirName()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_dirName_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::dirName()const", __this_nativeId)
        QString __qt_return_value = __qt_this->dirName();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::entryInfoList(QDir::Filters,QDir::SortFlags)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_entryInfoList_1native_1QDir_1Filters_1QDir_1SortFlags_1constfct__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint filters0,
 jint sort1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::entryInfoList(QDir::Filters,QDir::SortFlags)const", __this_nativeId)
        QDir::Filters __qt_filters0 = qtjambi_cast<QDir::Filters>(__jni_env, filters0);
        QDir::SortFlags __qt_sort1 = qtjambi_cast<QDir::SortFlags>(__jni_env, sort1);
        QList<QFileInfo> __qt_return_value = __qt_this->entryInfoList(QDir::Filters(__qt_filters0), QDir::SortFlags(__qt_sort1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::entryInfoList(QStringList,QDir::Filters,QDir::SortFlags)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_entryInfoList_1native_1cref_1QStringList_1QDir_1Filters_1QDir_1SortFlags_1constfct__JLjava_util_Collection_2II)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject nameFilters0,
 jint filters1,
 jint sort2)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::entryInfoList(QStringList,QDir::Filters,QDir::SortFlags)const", __this_nativeId)
        const QStringList&  __qt_nameFilters0 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, nameFilters0);
        QDir::Filters __qt_filters1 = qtjambi_cast<QDir::Filters>(__jni_env, filters1);
        QDir::SortFlags __qt_sort2 = qtjambi_cast<QDir::SortFlags>(__jni_env, sort2);
        QList<QFileInfo> __qt_return_value = __qt_this->entryInfoList(__qt_nameFilters0, QDir::Filters(__qt_filters1), QDir::SortFlags(__qt_sort2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::entryList(QDir::Filters,QDir::SortFlags)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_entryList_1native_1QDir_1Filters_1QDir_1SortFlags_1constfct__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint filters0,
 jint sort1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::entryList(QDir::Filters,QDir::SortFlags)const", __this_nativeId)
        QDir::Filters __qt_filters0 = qtjambi_cast<QDir::Filters>(__jni_env, filters0);
        QDir::SortFlags __qt_sort1 = qtjambi_cast<QDir::SortFlags>(__jni_env, sort1);
        QStringList __qt_return_value = __qt_this->entryList(QDir::Filters(__qt_filters0), QDir::SortFlags(__qt_sort1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::entryList(QStringList,QDir::Filters,QDir::SortFlags)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_entryList_1native_1cref_1QStringList_1QDir_1Filters_1QDir_1SortFlags_1constfct__JLjava_util_Collection_2II)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject nameFilters0,
 jint filters1,
 jint sort2)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::entryList(QStringList,QDir::Filters,QDir::SortFlags)const", __this_nativeId)
        const QStringList&  __qt_nameFilters0 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, nameFilters0);
        QDir::Filters __qt_filters1 = qtjambi_cast<QDir::Filters>(__jni_env, filters1);
        QDir::SortFlags __qt_sort2 = qtjambi_cast<QDir::SortFlags>(__jni_env, sort2);
        QStringList __qt_return_value = __qt_this->entryList(__qt_nameFilters0, QDir::Filters(__qt_filters1), QDir::SortFlags(__qt_sort2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::exists()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_exists_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::exists()const", __this_nativeId)
        __java_return_value = __qt_this->exists();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::exists(QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_exists_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::exists(QString)const", __this_nativeId)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        __java_return_value = __qt_this->exists(__qt_name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::filePath(QString)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_filePath_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::filePath(QString)const", __this_nativeId)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        QString __qt_return_value = __qt_this->filePath(__qt_fileName0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::filter()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_filter_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::filter()const", __this_nativeId)
        QDir::Filters __qt_return_value = __qt_this->filter();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::isAbsolute()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_isAbsolute_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::isAbsolute()const", __this_nativeId)
        __java_return_value = __qt_this->isAbsolute();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::isEmpty(QDir::Filters)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_isEmpty_1native_1QDir_1Filters_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint filters0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::isEmpty(QDir::Filters)const", __this_nativeId)
        QDir::Filters __qt_filters0 = qtjambi_cast<QDir::Filters>(__jni_env, filters0);
        __java_return_value = __qt_this->isEmpty(QDir::Filters(__qt_filters0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::isReadable()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_isReadable_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::isReadable()const", __this_nativeId)
        __java_return_value = __qt_this->isReadable();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::isRelative()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_isRelative_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::isRelative()const", __this_nativeId)
        __java_return_value = __qt_this->isRelative();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::isRoot()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_isRoot_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::isRoot()const", __this_nativeId)
        __java_return_value = __qt_this->isRoot();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::makeAbsolute()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_makeAbsolute_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::makeAbsolute()", __this_nativeId)
        __java_return_value = __qt_this->makeAbsolute();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::mkdir(QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_mkdir_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring dirName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::mkdir(QString)const", __this_nativeId)
        QString  __qt_dirName0 = qtjambi_cast<QString>(__jni_env, dirName0);
        __java_return_value = __qt_this->mkdir(__qt_dirName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::mkdir(QString,QFile::Permissions)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_mkdir_1native_1cref_1QString_1QFileDevice_1Permissions_1constfct__JLjava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring dirName0,
 jint permissions1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::mkdir(QString,QFile::Permissions)const", __this_nativeId)
        QString  __qt_dirName0 = qtjambi_cast<QString>(__jni_env, dirName0);
        QFileDevice::Permissions __qt_permissions1 = qtjambi_cast<QFileDevice::Permissions>(__jni_env, permissions1);
        __java_return_value = __qt_this->mkdir(__qt_dirName0, QFileDevice::Permissions(__qt_permissions1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::mkpath(QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_mkpath_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring dirPath0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::mkpath(QString)const", __this_nativeId)
        QString  __qt_dirPath0 = qtjambi_cast<QString>(__jni_env, dirPath0);
        __java_return_value = __qt_this->mkpath(__qt_dirPath0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::nameFilters()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_nameFilters_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::nameFilters()const", __this_nativeId)
        QStringList __qt_return_value = __qt_this->nameFilters();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::operator=(QDir)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_assign_1native_1cref_1QDir__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::operator=(QDir)", __this_nativeId)
        const QDir& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDir>(__jni_env, arg__1);
        (*__qt_this) = __qt_arg__1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDir::operator==(QDir)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_equals_1native_1cref_1QDir_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID dir0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::operator==(QDir)const", __this_nativeId)
        const QDir& __qt_dir0 = QtJambiAPI::objectReferenceFromNativeId<QDir>(__jni_env, dir0);
        __java_return_value = (*__qt_this) == __qt_dir0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::operator[](qsizetype)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_get_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong arg__1)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::operator[](qsizetype)const", __this_nativeId)
        const QString __qt_return_value = (*__qt_this)[static_cast<qsizetype>(arg__1)];
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::path()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_path_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::path()const", __this_nativeId)
        QString __qt_return_value = __qt_this->path();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::refresh()const
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_refresh_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::refresh()const", __this_nativeId)
        __qt_this->refresh();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDir::relativeFilePath(QString)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_relativeFilePath_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::relativeFilePath(QString)const", __this_nativeId)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        QString __qt_return_value = __qt_this->relativeFilePath(__qt_fileName0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::remove(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_remove_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::remove(QString)", __this_nativeId)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        __java_return_value = __qt_this->remove(__qt_fileName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::removeRecursively()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_removeRecursively_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::removeRecursively()", __this_nativeId)
        __java_return_value = __qt_this->removeRecursively();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::rename(QString,QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_rename_1native_1cref_1QString_1cref_1QString__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring oldName0,
 jstring newName1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::rename(QString,QString)", __this_nativeId)
        QString  __qt_oldName0 = qtjambi_cast<QString>(__jni_env, oldName0);
        QString  __qt_newName1 = qtjambi_cast<QString>(__jni_env, newName1);
        __java_return_value = __qt_this->rename(__qt_oldName0, __qt_newName1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::rmdir(QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_rmdir_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring dirName0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::rmdir(QString)const", __this_nativeId)
        QString  __qt_dirName0 = qtjambi_cast<QString>(__jni_env, dirName0);
        __java_return_value = __qt_this->rmdir(__qt_dirName0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::rmpath(QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_rmpath_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring dirPath0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::rmpath(QString)const", __this_nativeId)
        QString  __qt_dirPath0 = qtjambi_cast<QString>(__jni_env, dirPath0);
        __java_return_value = __qt_this->rmpath(__qt_dirPath0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::setFilter(QDir::Filters)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_setFilter_1native_1QDir_1Filters__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint filter0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::setFilter(QDir::Filters)", __this_nativeId)
        QDir::Filters __qt_filter0 = qtjambi_cast<QDir::Filters>(__jni_env, filter0);
        __qt_this->setFilter(QDir::Filters(__qt_filter0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDir::setNameFilters(QStringList)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_setNameFilters_1native_1cref_1QStringList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject nameFilters0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::setNameFilters(QStringList)", __this_nativeId)
        const QStringList&  __qt_nameFilters0 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, nameFilters0);
        __qt_this->setNameFilters(__qt_nameFilters0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDir::setPath(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_setPath_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring path0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::setPath(QString)", __this_nativeId)
        QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
        __qt_this->setPath(__qt_path0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDir::setSorting(QDir::SortFlags)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_setSorting_1native_1QDir_1SortFlags__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sort0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::setSorting(QDir::SortFlags)", __this_nativeId)
        QDir::SortFlags __qt_sort0 = qtjambi_cast<QDir::SortFlags>(__jni_env, sort0);
        __qt_this->setSorting(QDir::SortFlags(__qt_sort0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDir::sorting()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_sorting_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::sorting()const", __this_nativeId)
        QDir::SortFlags __qt_return_value = __qt_this->sorting();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::swap(QDir&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_swap_1native_1ref_1QDir__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDir::swap(QDir&)", __this_nativeId)
        QDir& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QDir>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDir::addSearchPath(QString,QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_addSearchPath__Ljava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring prefix0,
 jstring path1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::addSearchPath(QString,QString)")
    QTJAMBI_TRY {
        QString  __qt_prefix0 = qtjambi_cast<QString>(__jni_env, prefix0);
        QString  __qt_path1 = qtjambi_cast<QString>(__jni_env, path1);
        QDir::addSearchPath(__qt_prefix0, __qt_path1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDir::cleanPath(QString)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_cleanPath__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring path0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::cleanPath(QString)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
        QString __qt_return_value = QDir::cleanPath(__qt_path0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::current()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_current__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::current()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDir __qt_return_value = QDir::current();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::currentPath()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_currentPath__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::currentPath()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QDir::currentPath();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::drives()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_drives__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::drives()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QList<QFileInfo> __qt_return_value = QDir::drives();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::fromNativeSeparators(QString)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_fromNativeSeparators__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring pathName0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::fromNativeSeparators(QString)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_pathName0 = qtjambi_cast<QString>(__jni_env, pathName0);
        QString __qt_return_value = QDir::fromNativeSeparators(__qt_pathName0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::home()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_home__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::home()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDir __qt_return_value = QDir::home();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::homePath()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_homePath__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::homePath()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QDir::homePath();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::isAbsolutePath(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_isAbsolutePath__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring path0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::isAbsolutePath(QString)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
        __java_return_value = QDir::isAbsolutePath(__qt_path0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::isRelativePath(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_isRelativePath__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring path0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::isRelativePath(QString)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
        __java_return_value = QDir::isRelativePath(__qt_path0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::listSeparator()
extern "C" Q_DECL_EXPORT jchar JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_listSeparator__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::listSeparator()")
    jchar __java_return_value{0};
    QTJAMBI_TRY {
        QChar __qt_return_value = QDir::listSeparator();
        __java_return_value = __qt_return_value.unicode();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::match(QString,QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_match__Ljava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring filter0,
 jstring fileName1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::match(QString,QString)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_filter0 = qtjambi_cast<QString>(__jni_env, filter0);
        QString  __qt_fileName1 = qtjambi_cast<QString>(__jni_env, fileName1);
        __java_return_value = QDir::match(__qt_filter0, __qt_fileName1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::match(QStringList,QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_match__Ljava_util_Collection_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jobject filters0,
 jstring fileName1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::match(QStringList,QString)")
    QtJambiScope __qtjambi_scope;
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QStringList&  __qt_filters0 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, filters0);
        QString  __qt_fileName1 = qtjambi_cast<QString>(__jni_env, fileName1);
        __java_return_value = QDir::match(__qt_filters0, __qt_fileName1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::nameFiltersFromString(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_nameFiltersFromString__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring nameFilter0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::nameFiltersFromString(QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_nameFilter0 = qtjambi_cast<QString>(__jni_env, nameFilter0);
        QStringList __qt_return_value = QDir::nameFiltersFromString(__qt_nameFilter0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::root()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_root__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::root()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDir __qt_return_value = QDir::root();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::rootPath()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_rootPath__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::rootPath()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QDir::rootPath();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::searchPaths(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_searchPaths__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring prefix0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::searchPaths(QString)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_prefix0 = qtjambi_cast<QString>(__jni_env, prefix0);
        QStringList __qt_return_value = QDir::searchPaths(__qt_prefix0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::separator()
extern "C" Q_DECL_EXPORT jchar JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_separator__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::separator()")
    jchar __java_return_value{0};
    QTJAMBI_TRY {
        QChar __qt_return_value = QDir::separator();
        __java_return_value = __qt_return_value.unicode();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::setCurrent(QString)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_setCurrent__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring path0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::setCurrent(QString)")
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_path0 = qtjambi_cast<QString>(__jni_env, path0);
        __java_return_value = QDir::setCurrent(__qt_path0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::setSearchPaths(QString,QStringList)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_setSearchPaths__Ljava_lang_String_2Ljava_util_Collection_2)
(JNIEnv *__jni_env,
 jclass,
 jstring prefix0,
 jobject searchPaths1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::setSearchPaths(QString,QStringList)")
    QtJambiScope __qtjambi_scope;
    QTJAMBI_TRY {
        QString  __qt_prefix0 = qtjambi_cast<QString>(__jni_env, prefix0);
        const QStringList&  __qt_searchPaths1 = qtjambi_cast<const QStringList& >(__jni_env, __qtjambi_scope, searchPaths1);
        QDir::setSearchPaths(__qt_prefix0, __qt_searchPaths1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDir::temp()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_temp__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::temp()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDir __qt_return_value = QDir::temp();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::tempPath()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_tempPath__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::tempPath()")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString __qt_return_value = QDir::tempPath();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDir::toNativeSeparators(QString)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_toNativeSeparators__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass,
 jstring pathName0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDir::toNativeSeparators(QString)")
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QString  __qt_pathName0 = qtjambi_cast<QString>(__jni_env, pathName0);
        QString __qt_return_value = QDir::toNativeSeparators(__qt_pathName0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDir_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QDir *__qt_this = QtJambiAPI::objectFromNativeId<QDir>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QDir(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QDir>("QDir", "io/qt/core/QDir");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QDir, {
        ConstructorInfo(&__qt_construct_QDir_cref_QDir, "Lio/qt/core/QDir;")
       ,ConstructorInfo(&__qt_construct_QDir, nullptr)
       ,ConstructorInfo(&__qt_construct_QDir_cref_QString, "Ljava/lang/String;")
       ,ConstructorInfo(&__qt_construct_QDir_cref_QString_cref_QString, "Ljava/lang/String;Ljava/lang/String;")
       ,ConstructorInfo(&__qt_construct_QDir_cref_QString_cref_QString_QDir_SortFlags, "Ljava/lang/String;Ljava/lang/String;Lio/qt/core/QDir$SortFlags;")
       ,ConstructorInfo(&__qt_construct_QDir_cref_QString_cref_QString_QDir_SortFlags_QDir_Filters, "Ljava/lang/String;Ljava/lang/String;Lio/qt/core/QDir$SortFlags;Lio/qt/core/QDir$Filters;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QDir);
    registerMetaType<QDir>("QDir");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QDir::Filter>("QDir::Filter", "io/qt/core/QDir$Filter", "QDir::Filters", "QFlags<QDir::Filter>", "io/qt/core/QDir$Filters");
    registerEnumTypeInfo<QDir::SortFlag>("QDir::SortFlag", "io/qt/core/QDir$SortFlag", "QDir::SortFlags", "QFlags<QDir::SortFlag>", "io/qt/core/QDir$SortFlags");
// END: enums and flags
}
