#ifndef QPROCESS_SHELL_H
#define QPROCESS_SHELL_H

#include <QtCore/QtGlobal>
#include <QtCore/qcompilerdetection.h>

QT_WARNING_DISABLE_DEPRECATED
QT_WARNING_DISABLE_GCC("-Wdeprecated-declarations")

#include <qtcore-config.h>
#if QT_CONFIG(processenvironment)
#if __has_include(<QtCore/qprocess.h>)
#include <QtCore/qprocess.h>
#endif
#endif //QT_CONFIG(processenvironment)
#include <QtJambi/QtJambiAPI>
#include <QtCore/QList>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtCore/qbindingstorage.h>
#include <QtCore/qbytearray.h>
#include <QtCore/qcoreevent.h>
#include <QtCore/qmetaobject.h>
#include <QtCore/qnamespace.h>
#include <QtCore/qobject.h>
#include <QtCore/qproperty.h>
#if QT_CONFIG(regularexpression)
#include <QtCore/qregularexpression.h>
#endif //QT_CONFIG(regularexpression)
#include <QtCore/qthread.h>
#include <QtCore/qtimer.h>
#include <QtJambi/RegistryAPI>


#if QT_CONFIG(process) && QT_CONFIG(processenvironment)

class QProcess_shell : public QProcess, public QtJambiShellInterface
{
public:
    QProcess_shell(QObject* parent0 = nullptr);
    ~QProcess_shell() override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    friend class QProcess_mshell;
    friend class QProcess_oshell;
};


class QProcess_mshell : public QProcess_shell
{
public:
    using QProcess_shell::QProcess_shell;
    static void operator delete(void * ptr) noexcept;
    const QMetaObject *metaObject() const override final;
    void *qt_metacast(const char *) override final;
    int qt_metacall(QMetaObject::Call, int, void **) override final;
};


class QProcess_oshell : public QProcess_mshell
{
public:
    using QProcess_mshell::QProcess_mshell;
    bool atEnd() const override;
    qint64 bytesAvailable() const override;
    qint64 bytesToWrite() const override;
    bool canReadLine() const override;
    void childEvent(QChildEvent* event0) override;
    void close() override;
    void connectNotify(const QMetaMethod& signal0) override;
    void customEvent(QEvent* event0) override;
    void disconnectNotify(const QMetaMethod& signal0) override;
    bool event(QEvent* event0) override;
    bool eventFilter(QObject* watched0, QEvent* event1) override;
    bool isSequential() const override;
    bool open(QIODeviceBase::OpenMode mode0) override;
    qint64 pos() const override;
    qint64 readData(char* data0, qint64 maxlen1) override;
    qint64 readLineData(char* data0, qint64 maxlen1) override;
    bool reset() override;
    bool seek(qint64 pos0) override;
    qint64 size() const override;
    qint64 skipData(qint64 maxSize0) override;
    void timerEvent(QTimerEvent* event0) override;
    bool waitForBytesWritten(int msecs0) override;
    bool waitForReadyRead(int msecs0) override;
    qint64 writeData(const char* data0, qint64 len1) override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QProcess_access : public QProcess
{
    void __qt_setProcessState_QProcess_ProcessState(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint state0);
    jlong __qt_bytesToWrite_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_close(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jboolean __qt_isSequential_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_open_QIODeviceBase_OpenMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint mode0);
    jint __qt_readData_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject data0);
    jboolean __qt_waitForBytesWritten_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint msecs0);
    jboolean __qt_waitForReadyRead_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint msecs0);
    jint __qt_writeData_const_char_ptr_qint64(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject data0);
};

#endif // QT_CONFIG(process) && QT_CONFIG(processenvironment)
#endif // QPROCESS_SHELL_H
