#include <QtCore/QtGlobal>
#include <qconfig.h>
#if QT_CONFIG(thread)
#include <QtCore/qsemaphore.h>
#endif //QT_CONFIG(thread)
#include <QtCore/QVariant>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

#if QT_CONFIG(thread)


void deleter_QSemaphore(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QSemaphore")
    QSemaphore *_ptr = reinterpret_cast<QSemaphore *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}


#endif // QT_CONFIG(thread)

// emitting (writeConstructors)
// new QSemaphore(int)
void __qt_construct_QSemaphore(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSemaphore(int)")
#if QT_CONFIG(thread)
    Q_UNUSED(__java_arguments)
    QSemaphore *__qt_this = new(__qtjambi_ptr) QSemaphore();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(thread)
}

// new QSemaphore(int)
void __qt_construct_QSemaphore_int(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSemaphore(int)")
#if QT_CONFIG(thread)
    jint n0 = __java_arguments[0].i;
    Q_UNUSED(n0)
    QSemaphore *__qt_this = new(__qtjambi_ptr) QSemaphore(static_cast<int>(n0));
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(thread)
}

// QSemaphore::QSemaphore(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSemaphore_initialize_1native__Lio_qt_core_QSemaphore_2I)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jint n0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSemaphore::QSemaphore(int)")
    QTJAMBI_TRY {
#if QT_CONFIG(thread)
        jvalue arguments;
        arguments.i = n0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSemaphore_int, sizeof(QSemaphore), typeid(QSemaphore), 0, false, &deleter_QSemaphore, &arguments);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        Q_UNUSED(n0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(thread)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QSemaphore
void __qt_destruct_QSemaphore(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QSemaphore")

#if QT_CONFIG(thread)

    reinterpret_cast<QSemaphore*>(ptr)->~QSemaphore();

#else
    Q_UNUSED(ptr)

#endif // QT_CONFIG(thread)

}

// emitting  (functionsInTargetLang writeFinalFunction)
// QSemaphore::acquire(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSemaphore_acquire_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(thread)
        QSemaphore *__qt_this = QtJambiAPI::objectFromNativeId<QSemaphore>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSemaphore::acquire(int)", __this_nativeId)
        __qt_this->acquire(static_cast<int>(n0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(n0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(thread)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSemaphore::available()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSemaphore_available_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(thread)
        const QSemaphore *__qt_this = QtJambiAPI::objectFromNativeId<QSemaphore>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSemaphore::available()const", __this_nativeId)
        __java_return_value = __qt_this->available();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(thread)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSemaphore::release(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSemaphore_release_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
#if QT_CONFIG(thread)
        QSemaphore *__qt_this = QtJambiAPI::objectFromNativeId<QSemaphore>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSemaphore::release(int)", __this_nativeId)
        __qt_this->release(static_cast<int>(n0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(n0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(thread)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSemaphore::tryAcquire(int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSemaphore_tryAcquire_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(thread)
        QSemaphore *__qt_this = QtJambiAPI::objectFromNativeId<QSemaphore>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSemaphore::tryAcquire(int)", __this_nativeId)
        __java_return_value = __qt_this->tryAcquire(static_cast<int>(n0));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(n0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(thread)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSemaphore::tryAcquire(int,int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSemaphore_tryAcquire_1native_1int_1int__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jint timeout1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(thread)
        QSemaphore *__qt_this = QtJambiAPI::objectFromNativeId<QSemaphore>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSemaphore::tryAcquire(int,int)", __this_nativeId)
        __java_return_value = __qt_this->tryAcquire(static_cast<int>(n0), static_cast<int>(timeout1));
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(n0)
        Q_UNUSED(timeout1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(thread)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSemaphore::try_acquire()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSemaphore_try_1acquire_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(thread)
        QSemaphore *__qt_this = QtJambiAPI::objectFromNativeId<QSemaphore>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSemaphore::try_acquire()", __this_nativeId)
        __java_return_value = __qt_this->try_acquire();
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(thread)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QSemaphore(){
    using namespace RegistryAPI;

#if QT_CONFIG(thread)

    const std::type_info& typeId = registerObjectTypeInfo<QSemaphore>("QSemaphore", "io/qt/core/QSemaphore");
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QSemaphore, {
        ConstructorInfo(&__qt_construct_QSemaphore, nullptr)
       ,ConstructorInfo(&__qt_construct_QSemaphore_int, "I")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QSemaphore);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags

#endif //QT_CONFIG(thread)

}
