#include "QAccessibleApplication_shell.h"
#include <QtJambi/Cast>

void deleter_QAccessibleApplication(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QAccessibleApplication")
    QAccessibleApplication *_ptr = reinterpret_cast<QAccessibleApplication *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QAccessibleApplication_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QAccessibleApplication_shell) ); }

jmethodID QAccessibleApplication_oshell::__shell_javaMethod(int pos) const { return QAccessibleApplication_shell::__shell()->javaMethod(typeid(QAccessibleApplication), pos); }

// emitting (writeShellDestructor)
QAccessibleApplication_shell::~QAccessibleApplication_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QAccessibleApplication::~QAccessibleApplication()", this)
    QAccessibleApplication_shell::__shell()->destructed(typeid(QAccessibleApplication));
}

// emitting (writeShellConstructor)
QAccessibleApplication_shell::QAccessibleApplication_shell()
    : QAccessibleApplication()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QAccessibleApplication::QAccessibleApplication_shell()", this)
    QAccessibleApplication_shell::__shell()->constructed(typeid(QAccessibleApplication));
}

void QAccessibleApplication_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QAccessibleApplication_shell*>(ptr)->QAccessibleApplication_shell::__shell()->tryDeleteShell(typeid(QAccessibleApplication));
}

void QAccessibleApplication_oshell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QAccessibleApplication_oshell*>(ptr)->QAccessibleApplication_oshell::__shell()->tryDeleteShell(typeid(QAccessibleApplication));
}

// emitting Virtual overrides (virtualFunctions)
QColor QAccessibleApplication_oshell::backgroundColor() const
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::backgroundColor()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QColor  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QColor>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::backgroundColor()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::backgroundColor()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleInterface::backgroundColor();
        }
    }else{
        return QAccessibleInterface::backgroundColor();
    }
}

QAccessibleInterface* QAccessibleApplication_oshell::child(int index0) const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::child(int)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessibleInterface*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, index0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessibleInterface*>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::child(int)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::child(int)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleApplication::child(static_cast<int>(index0));
        }
    }else{
        return QAccessibleApplication::child(static_cast<int>(index0));
    }
}

QAccessibleInterface* QAccessibleApplication_oshell::childAt(int x0, int y1) const
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::childAt(int,int)const", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessibleInterface*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, x0, y1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessibleInterface*>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::childAt(int,int)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::childAt(int,int)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleObject::childAt(static_cast<int>(x0), static_cast<int>(y1));
        }
    }else{
        return QAccessibleObject::childAt(static_cast<int>(x0), static_cast<int>(y1));
    }
}

int QAccessibleApplication_oshell::childCount() const
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::childCount()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::childCount()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::childCount()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleApplication::childCount();
        }
    }else{
        return QAccessibleApplication::childCount();
    }
}

QAccessibleInterface* QAccessibleApplication_oshell::focusChild() const
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::focusChild()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessibleInterface*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessibleInterface*>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::focusChild()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::focusChild()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleApplication::focusChild();
        }
    }else{
        return QAccessibleApplication::focusChild();
    }
}

QColor QAccessibleApplication_oshell::foregroundColor() const
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::foregroundColor()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QColor  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QColor>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::foregroundColor()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::foregroundColor()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleInterface::foregroundColor();
        }
    }else{
        return QAccessibleInterface::foregroundColor();
    }
}

int QAccessibleApplication_oshell::indexOfChild(const QAccessibleInterface* arg__1) const
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::indexOfChild(const QAccessibleInterface*)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_arg__1 = qtjambi_cast<jobject>(__jni_env, arg__1);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_arg__1);
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id, __java_arg__1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::indexOfChild(const QAccessibleInterface*)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::indexOfChild(const QAccessibleInterface*)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleApplication::indexOfChild(arg__1);
        }
    }else{
        return QAccessibleApplication::indexOfChild(arg__1);
    }
}

bool QAccessibleApplication_oshell::isValid() const
{
    if(jmethodID method_id = __shell_javaMethod(7)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::isValid()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::isValid()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::isValid()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleObject::isValid();
        }
    }else{
        return QAccessibleObject::isValid();
    }
}

QObject* QAccessibleApplication_oshell::object() const
{
    if(jmethodID method_id = __shell_javaMethod(8)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::object()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QObject*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QObject*>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::object()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::object()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleObject::object();
        }
    }else{
        return QAccessibleObject::object();
    }
}

QAccessibleInterface* QAccessibleApplication_oshell::parent() const
{
    if(jmethodID method_id = __shell_javaMethod(9)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::parent()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessibleInterface*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessibleInterface*>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::parent()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::parent()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleApplication::parent();
        }
    }else{
        return QAccessibleApplication::parent();
    }
}

QRect QAccessibleApplication_oshell::rect() const
{
    if(jmethodID method_id = __shell_javaMethod(10)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::rect()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QRect  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QRect>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::rect()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::rect()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleObject::rect();
        }
    }else{
        return QAccessibleObject::rect();
    }
}

QList<QPair<QAccessibleInterface*, QAccessible::Relation> > QAccessibleApplication_oshell::relations(QAccessible::Relation match0) const
{
    if(jmethodID method_id = __shell_javaMethod(11)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::relations(QAccessible::Relation)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QList<QPair<QAccessibleInterface*, QAccessible::Relation> >  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    QtJambiScope __qtjambi_scope(QAccessibleApplication_shell::__shell());
                    jobject __java_match0 = qtjambi_cast<jobject>(__jni_env, match0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_match0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QList<QPair<QAccessibleInterface*, QAccessible::Relation> > >(__jni_env, __qtjambi_scope, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::relations(QAccessible::Relation)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::relations(QAccessible::Relation)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleInterface::relations(QAccessible::Relation(match0));
        }
    }else{
        return QAccessibleInterface::relations(QAccessible::Relation(match0));
    }
}

QAccessible::Role QAccessibleApplication_oshell::role() const
{
    if(jmethodID method_id = __shell_javaMethod(12)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::role()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessible::Role  __qt_return_value = QAccessible::Role(0);
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessible::Role>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::role()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::role()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleApplication::role();
        }
    }else{
        return QAccessibleApplication::role();
    }
}

void QAccessibleApplication_oshell::setText(QAccessible::Text t0, const QString& text1)
{
    if(jmethodID method_id = __shell_javaMethod(13)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::setText(QAccessible::Text,QString)", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_t0 = qtjambi_cast<jobject>(__jni_env, t0);
                    jstring __java_text1 = qtjambi_cast<jstring>(__jni_env, text1);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_t0, __java_text1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::setText(QAccessible::Text,QString)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::setText(QAccessible::Text,QString)");
            } QTJAMBI_TRY_END
        }else{
            QAccessibleObject::setText(QAccessible::Text(t0), text1);
        }
    }else{
        QAccessibleObject::setText(QAccessible::Text(t0), text1);
    }
}

QAccessible::State QAccessibleApplication_oshell::state() const
{
    if(jmethodID method_id = __shell_javaMethod(14)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::state()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessible::State  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessible::State>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::state()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::state()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleApplication::state();
        }
    }else{
        return QAccessibleApplication::state();
    }
}

QString QAccessibleApplication_oshell::text(QAccessible::Text t0) const
{
    if(jmethodID method_id = __shell_javaMethod(15)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::text(QAccessible::Text)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_t0 = qtjambi_cast<jobject>(__jni_env, t0);
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, __java_t0));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::text(QAccessible::Text)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::text(QAccessible::Text)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleApplication::text(QAccessible::Text(t0));
        }
    }else{
        return QAccessibleApplication::text(QAccessible::Text(t0));
    }
}

QWindow* QAccessibleApplication_oshell::window() const
{
    if(jmethodID method_id = __shell_javaMethod(16)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleApplication::window()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QWindow*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleApplication_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QWindow*>(__jni_env, __java_return_value);
                } else {
                    QAccessibleApplication_shell::__shell()->warnForMethod("QAccessibleApplication::window()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleApplication::window()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QAccessibleApplication::window();
        }
    }else{
        return QAccessibleApplication::window();
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
jobject QAccessibleApplication_access::__qt_child_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint index0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAccessibleInterface* __qt_return_value = QAccessibleApplication::child(static_cast<int>(index0));
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QAccessibleInterface* __qt_return_value = child(static_cast<int>(index0));
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QAccessibleApplication_access::__qt_childCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QAccessibleApplication::childCount();
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = childCount();
        return jint(__qt_return_value);
    }
}

jobject QAccessibleApplication_access::__qt_focusChild_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAccessibleInterface* __qt_return_value = QAccessibleApplication::focusChild();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QAccessibleInterface* __qt_return_value = focusChild();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QAccessibleApplication_access::__qt_indexOfChild_const_QAccessibleInterface_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID arg__1) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QAccessibleInterface* __qt_arg__1 = QtJambiAPI::interfaceFromNativeId<QAccessibleInterface>(arg__1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        int __qt_return_value = QAccessibleApplication::indexOfChild(__qt_arg__1);
        return jint(__qt_return_value);
    } else {
        int __qt_return_value = indexOfChild(__qt_arg__1);
        return jint(__qt_return_value);
    }
}

jobject QAccessibleApplication_access::__qt_parent_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAccessibleInterface* __qt_return_value = QAccessibleApplication::parent();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QAccessibleInterface* __qt_return_value = parent();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QAccessibleApplication_access::__qt_role_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAccessible::Role __qt_return_value = QAccessibleApplication::role();
        return __qt_return_value;
    } else {
        QAccessible::Role __qt_return_value = role();
        return __qt_return_value;
    }
}

jobject QAccessibleApplication_access::__qt_state_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QAccessible::State __qt_return_value = QAccessibleApplication::state();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QAccessible::State __qt_return_value = state();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jstring QAccessibleApplication_access::__qt_text_QAccessible_Text_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint t0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAccessible::Text __qt_t0 = qtjambi_cast<QAccessible::Text>(__jni_env, t0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QAccessibleApplication::text(__qt_t0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = text(__qt_t0);
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jobject QAccessibleApplication_access::__qt_window_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QWindow* __qt_return_value = QAccessibleApplication::window();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QWindow* __qt_return_value = window();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

// emitting (writeConstructors)
// new QAccessibleApplication()
void __qt_construct_QAccessibleApplication(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool __qtjambi_has_overrides, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAccessibleApplication()")
    Q_UNUSED(__java_arguments)
    QAccessibleApplication *__qt_this;
    if(__qtjambi_has_overrides)
        __qt_this = new(__qtjambi_ptr) QAccessibleApplication_oshell();
    else
        __qt_this = new(__qtjambi_ptr) QAccessibleApplication_shell();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QAccessibleApplication::QAccessibleApplication()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleApplication_initialize_1native__Lio_qt_gui_QAccessibleApplication_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleApplication::QAccessibleApplication()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAccessibleApplication, sizeof(QAccessibleApplication_shell), typeid(QAccessibleApplication), 0, true, &deleter_QAccessibleApplication, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QAccessibleApplication_shell
void __qt_destruct_QAccessibleApplication(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QAccessibleApplication")
    reinterpret_cast<QAccessibleApplication_shell*>(ptr)->~QAccessibleApplication_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QAccessibleApplication::child(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleApplication_child_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleApplication *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleApplication>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleApplication::child(int)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleApplication_access*>(__qt_this)->__qt_child_int_constfct(__jni_env, __this_nativeId, index0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleApplication::childCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleApplication_childCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleApplication *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleApplication>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleApplication::childCount()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleApplication_access*>(__qt_this)->__qt_childCount_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleApplication::focusChild()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleApplication_focusChild_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleApplication *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleApplication>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleApplication::focusChild()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleApplication_access*>(__qt_this)->__qt_focusChild_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleApplication::indexOfChild(const QAccessibleInterface*)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleApplication_indexOfChild_1native_1const_1QAccessibleInterface_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleApplication *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleApplication>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleApplication::indexOfChild(const QAccessibleInterface*)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleApplication_access*>(__qt_this)->__qt_indexOfChild_const_QAccessibleInterface_ptr_constfct(__jni_env, __this_nativeId, arg__1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleApplication::parent()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleApplication_parent_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleApplication *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleApplication>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleApplication::parent()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleApplication_access*>(__qt_this)->__qt_parent_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleApplication::role()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleApplication_role_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleApplication *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleApplication>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleApplication::role()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleApplication_access*>(__qt_this)->__qt_role_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleApplication::state()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleApplication_state_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleApplication *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleApplication>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleApplication::state()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleApplication_access*>(__qt_this)->__qt_state_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleApplication::text(QAccessible::Text)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleApplication_text_1native_1QAccessible_1Text_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint t0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleApplication *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleApplication>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleApplication::text(QAccessible::Text)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleApplication_access*>(__qt_this)->__qt_text_QAccessible_Text_constfct(__jni_env, __this_nativeId, t0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleApplication::window()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleApplication_window_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleApplication *__qt_this = QtJambiAPI::objectFromNativeId<QAccessibleApplication>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleApplication::window()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleApplication_access*>(__qt_this)->__qt_window_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QAccessibleApplication(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QAccessibleApplication>("QAccessibleApplication", "io/qt/gui/QAccessibleApplication");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/*  0 */ "backgroundColor", "()Lio/qt/gui/QColor;"),
        FunctionInfo(/*  1 */ "child", "(I)Lio/qt/gui/QAccessibleInterface;"),
        FunctionInfo(/*  2 */ "childAt", "(II)Lio/qt/gui/QAccessibleInterface;"),
        FunctionInfo(/*  3 */ "childCount", "()I"),
        FunctionInfo(/*  4 */ "focusChild", "()Lio/qt/gui/QAccessibleInterface;"),
        FunctionInfo(/*  5 */ "foregroundColor", "()Lio/qt/gui/QColor;"),
        FunctionInfo(/*  6 */ "indexOfChild", "(Lio/qt/gui/QAccessibleInterface;)I"),
        FunctionInfo(/*  7 */ "isValid", "()Z"),
        FunctionInfo(/*  8 */ "object", "()Lio/qt/core/QObject;"),
        FunctionInfo(/*  9 */ "parent", "()Lio/qt/gui/QAccessibleInterface;"),
        FunctionInfo(/* 10 */ "rect", "()Lio/qt/core/QRect;"),
        FunctionInfo(/* 11 */ "relations", "(Lio/qt/gui/QAccessible$Relation;)Ljava/util/List;"),
        FunctionInfo(/* 12 */ "role", "()Lio/qt/gui/QAccessible$Role;"),
        FunctionInfo(/* 13 */ "setText", "(Lio/qt/gui/QAccessible$Text;Ljava/lang/String;)V"),
        FunctionInfo(/* 14 */ "state", "()Lio/qt/gui/QAccessible$State;"),
        FunctionInfo(/* 15 */ "text", "(Lio/qt/gui/QAccessible$Text;)Ljava/lang/String;"),
        FunctionInfo(/* 16 */ "window", "()Lio/qt/gui/QWindow;")});
    registerConstructorInfos(typeId, 0, &__qt_destruct_QAccessibleApplication, {
        ConstructorInfo(&__qt_construct_QAccessibleApplication, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QAccessibleApplication);
    registerSizeOfShell(typeId, sizeof(QAccessibleApplication_shell));
// END: type registration

// BEGIN: polymorphic ids
    registerDefaultPolymorphyHandler<QAccessibleObject, QAccessibleApplication>();
// END: polymorphic ids

    registerInterfaceOffset(typeId, typeid(QAccessibleInterface), int(reinterpret_cast<quintptr>(static_cast<QAccessibleInterface *>(reinterpret_cast<QAccessibleApplication *>(0x10000000)))) - 0x10000000);

// BEGIN: enums and flags
// END: enums and flags
}
