#ifndef QACCESSIBLEIMAGEINTERFACE_IMPL_SHELL_H
#define QACCESSIBLEIMAGEINTERFACE_IMPL_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/qaccessible.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qpoint.h>
#include <QtCore/qsize.h>
#include <QtJambi/RegistryAPI>


class QAccessibleImageInterface_shell : public QAccessibleImageInterface, public QtJambiShellInterface
{
public:
    QAccessibleImageInterface_shell();
    ~QAccessibleImageInterface_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QAccessibleImageInterface_oshell;
};


class QAccessibleImageInterface_oshell : public QAccessibleImageInterface_shell
{
public:
    using QAccessibleImageInterface_shell::QAccessibleImageInterface_shell;
    QString imageDescription() const override;
    QPoint imagePosition() const override;
    QSize imageSize() const override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QAccessibleImageInterface_access : public QAccessibleImageInterface
{
    jstring __qt_imageDescription_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_imagePosition_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_imageSize_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QACCESSIBLEIMAGEINTERFACE_IMPL_SHELL_H
