#include "QAccessibleTableInterface_shell.h"
#include <QtJambi/Cast>

void deleter_QAccessibleTableInterface(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QAccessibleTableInterface")
    QAccessibleTableInterface *_ptr = reinterpret_cast<QAccessibleTableInterface *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QAccessibleTableInterface_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QAccessibleTableInterface_shell) ); }

jmethodID QAccessibleTableInterface_oshell::__shell_javaMethod(int pos) const { return QAccessibleTableInterface_shell::__shell()->javaMethod(typeid(QAccessibleTableInterface), pos); }

// emitting (writeShellDestructor)
QAccessibleTableInterface_shell::~QAccessibleTableInterface_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QAccessibleTableInterface::~QAccessibleTableInterface()", this)
    QAccessibleTableInterface_shell::__shell()->destructed(typeid(QAccessibleTableInterface));
}

// emitting (writeShellConstructor)
QAccessibleTableInterface_shell::QAccessibleTableInterface_shell()
    : QAccessibleTableInterface()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QAccessibleTableInterface::QAccessibleTableInterface_shell()", this)
    QAccessibleTableInterface_shell::__shell()->constructed(typeid(QAccessibleTableInterface));
}

void QAccessibleTableInterface_oshell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QAccessibleTableInterface_oshell*>(ptr)->QAccessibleTableInterface_oshell::__shell()->tryDeleteShell(typeid(QAccessibleTableInterface));
}

// emitting Virtual overrides (virtualFunctions)
QAccessibleInterface* QAccessibleTableInterface_oshell::caption() const
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::caption()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessibleInterface*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessibleInterface*>(__jni_env, __java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::caption()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::caption()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return nullptr;
        }
    }else{
        return nullptr;
    }
}

QAccessibleInterface* QAccessibleTableInterface_oshell::cellAt(int row0, int column1) const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::cellAt(int,int)const", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessibleInterface*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, row0, column1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessibleInterface*>(__jni_env, __java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::cellAt(int,int)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::cellAt(int,int)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return nullptr;
        }
    }else{
        return nullptr;
    }
}

int QAccessibleTableInterface_oshell::columnCount() const
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::columnCount()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::columnCount()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::columnCount()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}

QString QAccessibleTableInterface_oshell::columnDescription(int column0) const
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::columnDescription(int)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, column0));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::columnDescription(int)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::columnDescription(int)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QString();
        }
    }else{
        return QString();
    }
}

bool QAccessibleTableInterface_oshell::isColumnSelected(int column0) const
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::isColumnSelected(int)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, column0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::isColumnSelected(int)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::isColumnSelected(int)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

bool QAccessibleTableInterface_oshell::isRowSelected(int row0) const
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::isRowSelected(int)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, row0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::isRowSelected(int)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::isRowSelected(int)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

void QAccessibleTableInterface_oshell::modelChange(QAccessibleTableModelChangeEvent* event0)
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent*)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_event0 = qtjambi_cast<jobject>(__jni_env, event0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_event0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_event0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent*)");
            } QTJAMBI_TRY_END
        }
    }
}

int QAccessibleTableInterface_oshell::rowCount() const
{
    if(jmethodID method_id = __shell_javaMethod(7)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::rowCount()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::rowCount()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::rowCount()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}

QString QAccessibleTableInterface_oshell::rowDescription(int row0) const
{
    if(jmethodID method_id = __shell_javaMethod(8)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::rowDescription(int)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id, row0));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::rowDescription(int)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::rowDescription(int)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QString();
        }
    }else{
        return QString();
    }
}

bool QAccessibleTableInterface_oshell::selectColumn(int column0)
{
    if(jmethodID method_id = __shell_javaMethod(9)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::selectColumn(int)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, column0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::selectColumn(int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::selectColumn(int)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

bool QAccessibleTableInterface_oshell::selectRow(int row0)
{
    if(jmethodID method_id = __shell_javaMethod(10)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::selectRow(int)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, row0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::selectRow(int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::selectRow(int)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

int QAccessibleTableInterface_oshell::selectedCellCount() const
{
    if(jmethodID method_id = __shell_javaMethod(11)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::selectedCellCount()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::selectedCellCount()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::selectedCellCount()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}

QList<QAccessibleInterface*> QAccessibleTableInterface_oshell::selectedCells() const
{
    if(jmethodID method_id = __shell_javaMethod(12)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::selectedCells()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QList<QAccessibleInterface*>  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    QtJambiScope __qtjambi_scope(QAccessibleTableInterface_shell::__shell());
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QList<QAccessibleInterface*> >(__jni_env, __qtjambi_scope, __java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::selectedCells()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::selectedCells()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QList<QAccessibleInterface *>();
        }
    }else{
        return QList<QAccessibleInterface *>();
    }
}

int QAccessibleTableInterface_oshell::selectedColumnCount() const
{
    if(jmethodID method_id = __shell_javaMethod(13)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::selectedColumnCount()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::selectedColumnCount()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::selectedColumnCount()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}

QList<int> QAccessibleTableInterface_oshell::selectedColumns() const
{
    if(jmethodID method_id = __shell_javaMethod(14)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::selectedColumns()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QList<int>  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    QtJambiScope __qtjambi_scope(QAccessibleTableInterface_shell::__shell());
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QList<int> >(__jni_env, __qtjambi_scope, __java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::selectedColumns()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::selectedColumns()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QList<int>();
        }
    }else{
        return QList<int>();
    }
}

int QAccessibleTableInterface_oshell::selectedRowCount() const
{
    if(jmethodID method_id = __shell_javaMethod(15)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::selectedRowCount()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            int  __qt_return_value = 0;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jint __java_return_value = __jni_env->CallIntMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<int>(__java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::selectedRowCount()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::selectedRowCount()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}

QList<int> QAccessibleTableInterface_oshell::selectedRows() const
{
    if(jmethodID method_id = __shell_javaMethod(16)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::selectedRows()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QList<int>  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    QtJambiScope __qtjambi_scope(QAccessibleTableInterface_shell::__shell());
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QList<int> >(__jni_env, __qtjambi_scope, __java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::selectedRows()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::selectedRows()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QList<int>();
        }
    }else{
        return QList<int>();
    }
}

QAccessibleInterface* QAccessibleTableInterface_oshell::summary() const
{
    if(jmethodID method_id = __shell_javaMethod(17)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::summary()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QAccessibleInterface*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QAccessibleInterface*>(__jni_env, __java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::summary()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::summary()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return nullptr;
        }
    }else{
        return nullptr;
    }
}

bool QAccessibleTableInterface_oshell::unselectColumn(int column0)
{
    if(jmethodID method_id = __shell_javaMethod(18)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::unselectColumn(int)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, column0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::unselectColumn(int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::unselectColumn(int)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

bool QAccessibleTableInterface_oshell::unselectRow(int row0)
{
    if(jmethodID method_id = __shell_javaMethod(19)){
        QTJAMBI_JAVA_METHOD_CALL("QAccessibleTableInterface::unselectRow(int)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QAccessibleTableInterface_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, row0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QAccessibleTableInterface_shell::__shell()->warnForMethod("QAccessibleTableInterface::unselectRow(int)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QAccessibleTableInterface::unselectRow(int)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
jobject QAccessibleTableInterface_access::__qt_caption_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::caption() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::caption() const.";
    } else {
        QAccessibleInterface* __qt_return_value = caption();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QAccessibleTableInterface_access::__qt_cellAt_int_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint row0, jint column1) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::cellAt(int row, int column) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::cellAt(int row, int column) const.";
    } else {
        QAccessibleInterface* __qt_return_value = cellAt(static_cast<int>(row0), static_cast<int>(column1));
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QAccessibleTableInterface_access::__qt_columnCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::columnCount() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::columnCount() const.";
    } else {
        int __qt_return_value = columnCount();
        return jint(__qt_return_value);
    }
}

jstring QAccessibleTableInterface_access::__qt_columnDescription_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint column0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::columnDescription(int column) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::columnDescription(int column) const.";
    } else {
        QString __qt_return_value = columnDescription(static_cast<int>(column0));
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jboolean QAccessibleTableInterface_access::__qt_isColumnSelected_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint column0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::isColumnSelected(int column) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::isColumnSelected(int column) const.";
    } else {
        bool __qt_return_value = isColumnSelected(static_cast<int>(column0));
        return jboolean(__qt_return_value);
    }
}

jboolean QAccessibleTableInterface_access::__qt_isRowSelected_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint row0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::isRowSelected(int row) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::isRowSelected(int row) const.";
    } else {
        bool __qt_return_value = isRowSelected(static_cast<int>(row0));
        return jboolean(__qt_return_value);
    }
}

void QAccessibleTableInterface_access::__qt_modelChange_QAccessibleTableModelChangeEvent_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID event0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QAccessibleTableModelChangeEvent* __qt_event0 = QtJambiAPI::objectFromNativeId<QAccessibleTableModelChangeEvent>(event0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent * event)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent * event).";
    } else {
        modelChange(__qt_event0);
    }
}

jint QAccessibleTableInterface_access::__qt_rowCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::rowCount() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::rowCount() const.";
    } else {
        int __qt_return_value = rowCount();
        return jint(__qt_return_value);
    }
}

jstring QAccessibleTableInterface_access::__qt_rowDescription_int_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint row0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::rowDescription(int row) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::rowDescription(int row) const.";
    } else {
        QString __qt_return_value = rowDescription(static_cast<int>(row0));
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jboolean QAccessibleTableInterface_access::__qt_selectColumn_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint column0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::selectColumn(int column)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::selectColumn(int column).";
    } else {
        bool __qt_return_value = selectColumn(static_cast<int>(column0));
        return jboolean(__qt_return_value);
    }
}

jboolean QAccessibleTableInterface_access::__qt_selectRow_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint row0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::selectRow(int row)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::selectRow(int row).";
    } else {
        bool __qt_return_value = selectRow(static_cast<int>(row0));
        return jboolean(__qt_return_value);
    }
}

jint QAccessibleTableInterface_access::__qt_selectedCellCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::selectedCellCount() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::selectedCellCount() const.";
    } else {
        int __qt_return_value = selectedCellCount();
        return jint(__qt_return_value);
    }
}

jobject QAccessibleTableInterface_access::__qt_selectedCells_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::selectedCells() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::selectedCells() const.";
    } else {
        QList<QAccessibleInterface*> __qt_return_value = selectedCells();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QAccessibleTableInterface_access::__qt_selectedColumnCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::selectedColumnCount() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::selectedColumnCount() const.";
    } else {
        int __qt_return_value = selectedColumnCount();
        return jint(__qt_return_value);
    }
}

jobject QAccessibleTableInterface_access::__qt_selectedColumns_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::selectedColumns() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::selectedColumns() const.";
    } else {
        QList<int> __qt_return_value = selectedColumns();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jint QAccessibleTableInterface_access::__qt_selectedRowCount_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::selectedRowCount() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::selectedRowCount() const.";
    } else {
        int __qt_return_value = selectedRowCount();
        return jint(__qt_return_value);
    }
}

jobject QAccessibleTableInterface_access::__qt_selectedRows_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::selectedRows() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::selectedRows() const.";
    } else {
        QList<int> __qt_return_value = selectedRows();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QAccessibleTableInterface_access::__qt_summary_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::summary() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::summary() const.";
    } else {
        QAccessibleInterface* __qt_return_value = summary();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jboolean QAccessibleTableInterface_access::__qt_unselectColumn_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint column0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::unselectColumn(int column)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::unselectColumn(int column).";
    } else {
        bool __qt_return_value = unselectColumn(static_cast<int>(column0));
        return jboolean(__qt_return_value);
    }
}

jboolean QAccessibleTableInterface_access::__qt_unselectRow_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint row0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QAccessibleTableInterface::unselectRow(int row)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QAccessibleTableInterface::unselectRow(int row).";
    } else {
        bool __qt_return_value = unselectRow(static_cast<int>(row0));
        return jboolean(__qt_return_value);
    }
}

// emitting (writeConstructors)
// new QAccessibleTableInterface()
void __qt_construct_QAccessibleTableInterface(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QAccessibleTableInterface()")
    Q_UNUSED(__java_arguments)
    QAccessibleTableInterface *__qt_this = new(__qtjambi_ptr) QAccessibleTableInterface_oshell();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QAccessibleTableInterface::QAccessibleTableInterface()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_initialize_1native__Lio_qt_gui_QAccessibleTableInterface_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QAccessibleTableInterface::QAccessibleTableInterface()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QAccessibleTableInterface, sizeof(QAccessibleTableInterface_shell), typeid(QAccessibleTableInterface), 0, true, &deleter_QAccessibleTableInterface, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QAccessibleTableInterface_shell
void __qt_destruct_QAccessibleTableInterface(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QAccessibleTableInterface")
    reinterpret_cast<QAccessibleTableInterface_shell*>(ptr)->~QAccessibleTableInterface_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QAccessibleTableInterface::caption()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_caption_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::caption()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_caption_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::cellAt(int,int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_cellAt_1native_1int_1int_1constfct__JII)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint row0,
 jint column1)
{
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::cellAt(int,int)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_cellAt_int_int_constfct(__jni_env, __this_nativeId, row0, column1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::columnCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_columnCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::columnCount()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_columnCount_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::columnDescription(int)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_columnDescription_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint column0)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::columnDescription(int)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_columnDescription_int_constfct(__jni_env, __this_nativeId, column0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::isColumnSelected(int)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_isColumnSelected_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint column0)
{
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::isColumnSelected(int)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_isColumnSelected_int_constfct(__jni_env, __this_nativeId, column0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::isRowSelected(int)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_isRowSelected_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint row0)
{
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::isRowSelected(int)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_isRowSelected_int_constfct(__jni_env, __this_nativeId, row0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_modelChange_1native_1QAccessibleTableModelChangeEvent_1ptr__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID event0)
{
    QTJAMBI_TRY {
        QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent*)", __this_nativeId)
        static_cast<QAccessibleTableInterface_access*>(__qt_this)->__qt_modelChange_QAccessibleTableModelChangeEvent_ptr(__jni_env, __this_nativeId, event0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QAccessibleTableInterface::rowCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_rowCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::rowCount()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_rowCount_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::rowDescription(int)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_rowDescription_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint row0)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::rowDescription(int)const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_rowDescription_int_constfct(__jni_env, __this_nativeId, row0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::selectColumn(int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_selectColumn_1native_1int__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint column0)
{
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::selectColumn(int)", __this_nativeId)
        __java_return_value = static_cast<QAccessibleTableInterface_access*>(__qt_this)->__qt_selectColumn_int(__jni_env, __this_nativeId, column0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::selectRow(int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_selectRow_1native_1int__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint row0)
{
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::selectRow(int)", __this_nativeId)
        __java_return_value = static_cast<QAccessibleTableInterface_access*>(__qt_this)->__qt_selectRow_int(__jni_env, __this_nativeId, row0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::selectedCellCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_selectedCellCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::selectedCellCount()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_selectedCellCount_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::selectedCells()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_selectedCells_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::selectedCells()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_selectedCells_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::selectedColumnCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_selectedColumnCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::selectedColumnCount()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_selectedColumnCount_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::selectedColumns()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_selectedColumns_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::selectedColumns()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_selectedColumns_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::selectedRowCount()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_selectedRowCount_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::selectedRowCount()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_selectedRowCount_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::selectedRows()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_selectedRows_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::selectedRows()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_selectedRows_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::summary()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_summary_1native_1constfct__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::summary()const", __this_nativeId)
        __java_return_value = static_cast<const QAccessibleTableInterface_access*>(__qt_this)->__qt_summary_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::unselectColumn(int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_unselectColumn_1native_1int__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint column0)
{
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::unselectColumn(int)", __this_nativeId)
        __java_return_value = static_cast<QAccessibleTableInterface_access*>(__qt_this)->__qt_unselectColumn_int(__jni_env, __this_nativeId, column0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QAccessibleTableInterface::unselectRow(int)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QAccessibleTableInterface_00024Impl_00024ConcreteWrapper_unselectRow_1native_1int__JI)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID __this_nativeId,
 jint row0)
{
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QAccessibleTableInterface *__qt_this = QtJambiAPI::interfaceFromNativeId<QAccessibleTableInterface>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QAccessibleTableInterface::unselectRow(int)", __this_nativeId)
        __java_return_value = static_cast<QAccessibleTableInterface_access*>(__qt_this)->__qt_unselectRow_int(__jni_env, __this_nativeId, row0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QAccessibleTableInterface(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerInterfaceTypeInfo<QAccessibleTableInterface>("QAccessibleTableInterface", "io/qt/gui/QAccessibleTableInterface");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/*  0 */ "caption", "()Lio/qt/gui/QAccessibleInterface;", FunctionInfo::Abstract),
        FunctionInfo(/*  1 */ "cellAt", "(II)Lio/qt/gui/QAccessibleInterface;", FunctionInfo::Abstract),
        FunctionInfo(/*  2 */ "columnCount", "()I", FunctionInfo::Abstract),
        FunctionInfo(/*  3 */ "columnDescription", "(I)Ljava/lang/String;", FunctionInfo::Abstract),
        FunctionInfo(/*  4 */ "isColumnSelected", "(I)Z", FunctionInfo::Abstract),
        FunctionInfo(/*  5 */ "isRowSelected", "(I)Z", FunctionInfo::Abstract),
        FunctionInfo(/*  6 */ "modelChange", "(Lio/qt/gui/QAccessibleTableModelChangeEvent;)V", FunctionInfo::Abstract),
        FunctionInfo(/*  7 */ "rowCount", "()I", FunctionInfo::Abstract),
        FunctionInfo(/*  8 */ "rowDescription", "(I)Ljava/lang/String;", FunctionInfo::Abstract),
        FunctionInfo(/*  9 */ "selectColumn", "(I)Z", FunctionInfo::Abstract),
        FunctionInfo(/* 10 */ "selectRow", "(I)Z", FunctionInfo::Abstract),
        FunctionInfo(/* 11 */ "selectedCellCount", "()I", FunctionInfo::Abstract),
        FunctionInfo(/* 12 */ "selectedCells", "()Ljava/util/List;", FunctionInfo::Abstract),
        FunctionInfo(/* 13 */ "selectedColumnCount", "()I", FunctionInfo::Abstract),
        FunctionInfo(/* 14 */ "selectedColumns", "()Ljava/util/List;", FunctionInfo::Abstract),
        FunctionInfo(/* 15 */ "selectedRowCount", "()I", FunctionInfo::Abstract),
        FunctionInfo(/* 16 */ "selectedRows", "()Ljava/util/List;", FunctionInfo::Abstract),
        FunctionInfo(/* 17 */ "summary", "()Lio/qt/gui/QAccessibleInterface;", FunctionInfo::Abstract),
        FunctionInfo(/* 18 */ "unselectColumn", "(I)Z", FunctionInfo::Abstract),
        FunctionInfo(/* 19 */ "unselectRow", "(I)Z", FunctionInfo::Abstract)});
    registerConstructorInfos(typeId, 0, &__qt_destruct_QAccessibleTableInterface, {
        ConstructorInfo(&__qt_construct_QAccessibleTableInterface, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QAccessibleTableInterface);
    registerSizeOfShell(typeId, sizeof(QAccessibleTableInterface_shell));
// END: type registration

// BEGIN: polymorphic ids
    registerPolymorphyHandler(typeid(QObject), typeId, [](void *ptr, qintptr& offset) -> bool {
            QObject *object = reinterpret_cast<QObject *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QAccessibleTableInterface* _object = dynamic_cast<QAccessibleTableInterface*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
    registerPolymorphyHandler(typeId, typeid(QObject), [](void *ptr, qintptr& offset) -> bool {
            QAccessibleTableInterface *object = reinterpret_cast<QAccessibleTableInterface *>(ptr);
            Q_ASSERT(object);
            bool _result = false;
            QTJAMBI_TRY_ANY {
                if(QObject* _object = dynamic_cast<QObject*>(object)){
                    offset = qintptr(object)-qintptr(_object);
                    _result = true;
                }
            } QTJAMBI_CATCH_ANY{
            } QTJAMBI_TRY_END
            return _result;
        });
    registerOwnerFunction(typeId, [](const void *ptr)->const QObject*{
        const QAccessibleTableInterface *object = reinterpret_cast<const QAccessibleTableInterface *>(ptr);
        const QObject* _result = nullptr;
        QTJAMBI_TRY_ANY {
            _result = dynamic_cast<const QObject*>(object);
        } QTJAMBI_CATCH_ANY{
        } QTJAMBI_TRY_END
        return _result;
    });
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
