#include "QIconEngine_shell.h"
#include <QtJambi/Cast>

void deleter_QIconEngine(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QIconEngine")
    QIconEngine *_ptr = reinterpret_cast<QIconEngine *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QIconEngine_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QIconEngine_shell) ); }

jmethodID QIconEngine_oshell::__shell_javaMethod(int pos) const { return QIconEngine_shell::__shell()->javaMethod(typeid(QIconEngine), pos); }

// emitting (writeShellDestructor)
QIconEngine_shell::~QIconEngine_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QIconEngine::~QIconEngine()", this)
    QIconEngine_shell::__shell()->destructed(typeid(QIconEngine));
}

// emitting (writeShellConstructor)
QIconEngine_shell::QIconEngine_shell()
    : QIconEngine()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QIconEngine::QIconEngine_shell()", this)
    QIconEngine_shell::__shell()->constructed(typeid(QIconEngine));
}

QIconEngine_shell::QIconEngine_shell(const QIconEngine& other0)
    : QIconEngine(other0)
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QIconEngine::QIconEngine_shell(const QIconEngine& other0)", this)
    QIconEngine_shell::__shell()->constructed(typeid(QIconEngine));
}

void QIconEngine_oshell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QIconEngine_oshell*>(ptr)->QIconEngine_oshell::__shell()->tryDeleteShell(typeid(QIconEngine));
}

// emitting Virtual overrides (virtualFunctions)
QSize QIconEngine_oshell::actualSize(const QSize& size0, QIcon::Mode mode1, QIcon::State state2)
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::actualSize(QSize,QIcon::Mode,QIcon::State)", this)
        if(JniEnvironment __jni_env{500}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QSize  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_size0 = qtjambi_cast<jobject>(__jni_env, size0);
                    jobject __java_mode1 = qtjambi_cast<jobject>(__jni_env, mode1);
                    jobject __java_state2 = qtjambi_cast<jobject>(__jni_env, state2);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_size0, __java_mode1, __java_state2);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QSize>(__jni_env, __java_return_value);
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::actualSize(QSize,QIcon::Mode,QIcon::State)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::actualSize(QSize,QIcon::Mode,QIcon::State)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QIconEngine::actualSize(size0, QIcon::Mode(mode1), QIcon::State(state2));
        }
    }else{
        return QIconEngine::actualSize(size0, QIcon::Mode(mode1), QIcon::State(state2));
    }
}

void QIconEngine_oshell::addFile(const QString& fileName0, const QSize& size1, QIcon::Mode mode2, QIcon::State state3)
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::addFile(QString,QSize,QIcon::Mode,QIcon::State)", this)
        if(JniEnvironment __jni_env{600}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_fileName0 = qtjambi_cast<jstring>(__jni_env, fileName0);
                    jobject __java_size1 = qtjambi_cast<jobject>(__jni_env, size1);
                    jobject __java_mode2 = qtjambi_cast<jobject>(__jni_env, mode2);
                    jobject __java_state3 = qtjambi_cast<jobject>(__jni_env, state3);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_fileName0, __java_size1, __java_mode2, __java_state3);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::addFile(QString,QSize,QIcon::Mode,QIcon::State)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::addFile(QString,QSize,QIcon::Mode,QIcon::State)");
            } QTJAMBI_TRY_END
        }else{
            QIconEngine::addFile(fileName0, size1, QIcon::Mode(mode2), QIcon::State(state3));
        }
    }else{
        QIconEngine::addFile(fileName0, size1, QIcon::Mode(mode2), QIcon::State(state3));
    }
}

void QIconEngine_oshell::addPixmap(const QPixmap& pixmap0, QIcon::Mode mode1, QIcon::State state2)
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::addPixmap(QPixmap,QIcon::Mode,QIcon::State)", this)
        if(JniEnvironment __jni_env{500}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_pixmap0 = qtjambi_cast<jobject>(__jni_env, pixmap0);
                    jobject __java_mode1 = qtjambi_cast<jobject>(__jni_env, mode1);
                    jobject __java_state2 = qtjambi_cast<jobject>(__jni_env, state2);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_pixmap0, __java_mode1, __java_state2);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::addPixmap(QPixmap,QIcon::Mode,QIcon::State)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::addPixmap(QPixmap,QIcon::Mode,QIcon::State)");
            } QTJAMBI_TRY_END
        }else{
            QIconEngine::addPixmap(pixmap0, QIcon::Mode(mode1), QIcon::State(state2));
        }
    }else{
        QIconEngine::addPixmap(pixmap0, QIcon::Mode(mode1), QIcon::State(state2));
    }
}

QList<QSize> QIconEngine_oshell::availableSizes(QIcon::Mode mode0, QIcon::State state1)
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::availableSizes(QIcon::Mode,QIcon::State)", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QList<QSize>  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    QtJambiScope __qtjambi_scope(QIconEngine_shell::__shell());
                    jobject __java_mode0 = qtjambi_cast<jobject>(__jni_env, mode0);
                    jobject __java_state1 = qtjambi_cast<jobject>(__jni_env, state1);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_mode0, __java_state1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QList<QSize> >(__jni_env, __qtjambi_scope, __java_return_value);
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::availableSizes(QIcon::Mode,QIcon::State)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::availableSizes(QIcon::Mode,QIcon::State)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QIconEngine::availableSizes(QIcon::Mode(mode0), QIcon::State(state1));
        }
    }else{
        return QIconEngine::availableSizes(QIcon::Mode(mode0), QIcon::State(state1));
    }
}

QIconEngine* QIconEngine_oshell::clone() const
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::clone()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QIconEngine*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QIconEngine*>(__jni_env, __java_return_value);
                    QtJambiAPI::setCppOwnershipAndInvalidate(__jni_env, __java_return_value);
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::clone()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::clone()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return nullptr;
        }
    }else{
        return nullptr;
    }
}

QString QIconEngine_oshell::iconName()
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::iconName()", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::iconName()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::iconName()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QIconEngine::iconName();
        }
    }else{
        return QIconEngine::iconName();
    }
}

bool QIconEngine_oshell::isNull()
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::isNull()", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::isNull()");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::isNull()");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QIconEngine::isNull();
        }
    }else{
        return QIconEngine::isNull();
    }
}

QString QIconEngine_oshell::key() const
{
    if(jmethodID method_id = __shell_javaMethod(7)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::key()const", this)
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QString  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_return_value = jstring(__jni_env->CallObjectMethod(__java_this, method_id));
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QString>(__jni_env, __java_return_value);
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::key()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::key()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QIconEngine::key();
        }
    }else{
        return QIconEngine::key();
    }
}

void QIconEngine_oshell::paint(QPainter* painter0, const QRect& rect1, QIcon::Mode mode2, QIcon::State state3)
{
    if(jmethodID method_id = __shell_javaMethod(8)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::paint(QPainter*,QRect,QIcon::Mode,QIcon::State)", this)
        if(JniEnvironment __jni_env{600}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_painter0 = qtjambi_cast<jobject>(__jni_env, painter0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_painter0);
                    jobject __java_rect1 = qtjambi_cast<jobject>(__jni_env, rect1);
                    jobject __java_mode2 = qtjambi_cast<jobject>(__jni_env, mode2);
                    jobject __java_state3 = qtjambi_cast<jobject>(__jni_env, state3);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_painter0, __java_rect1, __java_mode2, __java_state3);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::paint(QPainter*,QRect,QIcon::Mode,QIcon::State)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::paint(QPainter*,QRect,QIcon::Mode,QIcon::State)");
            } QTJAMBI_TRY_END
        }
    }
}

QPixmap QIconEngine_oshell::pixmap(const QSize& size0, QIcon::Mode mode1, QIcon::State state2)
{
    if(jmethodID method_id = __shell_javaMethod(9)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::pixmap(QSize,QIcon::Mode,QIcon::State)", this)
        if(JniEnvironment __jni_env{500}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPixmap  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_size0 = qtjambi_cast<jobject>(__jni_env, size0);
                    jobject __java_mode1 = qtjambi_cast<jobject>(__jni_env, mode1);
                    jobject __java_state2 = qtjambi_cast<jobject>(__jni_env, state2);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_size0, __java_mode1, __java_state2);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPixmap>(__jni_env, __java_return_value);
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::pixmap(QSize,QIcon::Mode,QIcon::State)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::pixmap(QSize,QIcon::Mode,QIcon::State)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QIconEngine::pixmap(size0, QIcon::Mode(mode1), QIcon::State(state2));
        }
    }else{
        return QIconEngine::pixmap(size0, QIcon::Mode(mode1), QIcon::State(state2));
    }
}

bool QIconEngine_oshell::read(QDataStream& in0)
{
    if(jmethodID method_id = __shell_javaMethod(10)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::read(QDataStream&)", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_in0 = qtjambi_cast<jobject>(__jni_env, &in0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_in0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_in0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::read(QDataStream&)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::read(QDataStream&)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QIconEngine::read(in0);
        }
    }else{
        return QIconEngine::read(in0);
    }
}

QPixmap QIconEngine_oshell::scaledPixmap(const QSize& size0, QIcon::Mode mode1, QIcon::State state2, qreal scale3)
{
    if(jmethodID method_id = __shell_javaMethod(11)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::scaledPixmap(QSize,QIcon::Mode,QIcon::State,qreal)", this)
        if(JniEnvironment __jni_env{600}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QPixmap  __qt_return_value;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_size0 = qtjambi_cast<jobject>(__jni_env, size0);
                    jobject __java_mode1 = qtjambi_cast<jobject>(__jni_env, mode1);
                    jobject __java_state2 = qtjambi_cast<jobject>(__jni_env, state2);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_size0, __java_mode1, __java_state2, scale3);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QPixmap>(__jni_env, __java_return_value);
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::scaledPixmap(QSize,QIcon::Mode,QIcon::State,qreal)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::scaledPixmap(QSize,QIcon::Mode,QIcon::State,qreal)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QIconEngine::scaledPixmap(size0, QIcon::Mode(mode1), QIcon::State(state2), static_cast<qreal>(scale3));
        }
    }else{
        return QIconEngine::scaledPixmap(size0, QIcon::Mode(mode1), QIcon::State(state2), static_cast<qreal>(scale3));
    }
}

void QIconEngine_oshell::virtual_hook(int id0, void* data1)
{
    if(jmethodID method_id = __shell_javaMethod(12)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::virtual_hook(int,void*)", this)
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    QtJambiScope __qtjambi_scope(QIconEngine_shell::__shell());
                    jobject __java_id0 = qtjambi_cast<jobject>(__jni_env, QIconEngine::IconEngineHook(id0));
                    jobject __java_data1{nullptr};
                    switch(id0){
#if QT_VERSION < QT_VERSION_CHECK(6, 0, 0)
                    case QIconEngine::IconNameHook:
                        __java_data1 = QtJambiAPI::convertQStringToJavaObject(__jni_env, reinterpret_cast<QString*>(data1));
                        __qtjambi_scope.addObjectInvalidation(__jni_env, __java_data1);
                        break;
                    case QIconEngine::AvailableSizesHook:
                        __java_data1 = qtjambi_cast<jobject>(__jni_env, reinterpret_cast<QIconEngine::AvailableSizesArgument*>(data1));
                        __qtjambi_scope.addObjectInvalidation(__jni_env, __java_data1);
                        break;
#endif
                    case QIconEngine::IsNullHook:
                        {
                            BoolPointerArray* pointer = new BoolPointerArray(__jni_env, reinterpret_cast<bool*>(data1), 1);
                            __qtjambi_scope.addDeletion(pointer);
                            __java_data1 = pointer->array();
                        }
                        break;
                    case QIconEngine::ScaledPixmapHook:
                        __java_data1 = qtjambi_cast<jobject>(__jni_env, reinterpret_cast<QIconEngine::ScaledPixmapArgument*>(data1));
                        __qtjambi_scope.addObjectInvalidation(__jni_env, __java_data1);
                        break;
                    default:
                        switch(__jni_env->GetObjectRefType(jobject(data1))){
                        case JNILocalRefType:
                        case JNIGlobalRefType:
                        case JNIWeakGlobalRefType:
                            __java_data1 = jobject(data1);
                            break;
                            default:
                            break;
                        }
                        break;
                    }
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_id0, __java_data1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::virtual_hook(int,void*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::virtual_hook(int,void*)");
            } QTJAMBI_TRY_END
        }else{
            QIconEngine::virtual_hook(int(id0), data1);
        }
    }else{
        QIconEngine::virtual_hook(int(id0), data1);
    }
}

bool QIconEngine_oshell::write(QDataStream& out0) const
{
    if(jmethodID method_id = __shell_javaMethod(13)){
        QTJAMBI_JAVA_METHOD_CALL("QIconEngine::write(QDataStream&)const", this)
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QIconEngine_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_out0 = qtjambi_cast<jobject>(__jni_env, &out0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_out0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_out0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QIconEngine_shell::__shell()->warnForMethod("QIconEngine::write(QDataStream&)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QIconEngine::write(QDataStream&)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return QIconEngine::write(out0);
        }
    }else{
        return QIconEngine::write(out0);
    }
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
jobject QIconEngine_access::__qt_actualSize_cref_QSize_QIcon_Mode_QIcon_State(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID size0, jint mode1, jint state2)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QSize& __qt_size0 = QtJambiAPI::valueReferenceFromNativeId<QSize>(size0);
    QIcon::Mode __qt_mode1 = qtjambi_cast<QIcon::Mode>(__jni_env, mode1);
    QIcon::State __qt_state2 = qtjambi_cast<QIcon::State>(__jni_env, state2);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QSize __qt_return_value = QIconEngine::actualSize(__qt_size0, __qt_mode1, __qt_state2);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QSize __qt_return_value = actualSize(__qt_size0, __qt_mode1, __qt_state2);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

void QIconEngine_access::__qt_addFile_cref_QString_cref_QSize_QIcon_Mode_QIcon_State(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring fileName0, QtJambiNativeID size1, jint mode2, jint state3)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
    const QSize& __qt_size1 = QtJambiAPI::valueReferenceFromNativeId<QSize>(size1);
    QIcon::Mode __qt_mode2 = qtjambi_cast<QIcon::Mode>(__jni_env, mode2);
    QIcon::State __qt_state3 = qtjambi_cast<QIcon::State>(__jni_env, state3);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QIconEngine::addFile(__qt_fileName0, __qt_size1, __qt_mode2, __qt_state3);
    } else {
        addFile(__qt_fileName0, __qt_size1, __qt_mode2, __qt_state3);
    }
}

void QIconEngine_access::__qt_addPixmap_cref_QPixmap_QIcon_Mode_QIcon_State(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID pixmap0, jint mode1, jint state2)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QPixmap& __qt_pixmap0 = QtJambiAPI::valueReferenceFromNativeId<QPixmap>(pixmap0);
    QtJambiAPI::checkThreadOnArgumentQPixmap(__jni_env, "pixmap", typeid(QPixmap));
    QIcon::Mode __qt_mode1 = qtjambi_cast<QIcon::Mode>(__jni_env, mode1);
    QIcon::State __qt_state2 = qtjambi_cast<QIcon::State>(__jni_env, state2);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QIconEngine::addPixmap(__qt_pixmap0, __qt_mode1, __qt_state2);
    } else {
        addPixmap(__qt_pixmap0, __qt_mode1, __qt_state2);
    }
}

jobject QIconEngine_access::__qt_availableSizes_QIcon_Mode_QIcon_State(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint mode0, jint state1)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QIcon::Mode __qt_mode0 = qtjambi_cast<QIcon::Mode>(__jni_env, mode0);
    QIcon::State __qt_state1 = qtjambi_cast<QIcon::State>(__jni_env, state1);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QList<QSize> __qt_return_value = QIconEngine::availableSizes(__qt_mode0, __qt_state1);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QList<QSize> __qt_return_value = availableSizes(__qt_mode0, __qt_state1);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QIconEngine_access::__qt_clone_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QIconEngine::clone() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QIconEngine::clone() const.";
    } else {
        QIconEngine* __qt_return_value = clone();
        jobject __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
        QtJambiAPI::setJavaOwnership(__jni_env, __java_return_value);
        return __java_return_value;
    }
}

jstring QIconEngine_access::__qt_iconName(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QIconEngine::iconName();
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = iconName();
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

jboolean QIconEngine_access::__qt_isNull(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QIconEngine::isNull();
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = isNull();
        return jboolean(__qt_return_value);
    }
}

jstring QIconEngine_access::__qt_key_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QString __qt_return_value = QIconEngine::key();
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    } else {
        QString __qt_return_value = key();
        return qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }
}

void QIconEngine_access::__qt_paint_QPainter_ptr_cref_QRect_QIcon_Mode_QIcon_State(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID painter0, QtJambiNativeID rect1, jint mode2, jint state3)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QPainter* __qt_painter0 = QtJambiAPI::objectFromNativeId<QPainter>(painter0);
    const QRect& __qt_rect1 = QtJambiAPI::valueReferenceFromNativeId<QRect>(rect1);
    QIcon::Mode __qt_mode2 = qtjambi_cast<QIcon::Mode>(__jni_env, mode2);
    QIcon::State __qt_state3 = qtjambi_cast<QIcon::State>(__jni_env, state3);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QIconEngine::paint(QPainter * painter, const QRect & rect, QIcon::Mode mode, QIcon::State state)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QIconEngine::paint(QPainter * painter, const QRect & rect, QIcon::Mode mode, QIcon::State state).";
    } else {
        paint(__qt_painter0, __qt_rect1, __qt_mode2, __qt_state3);
    }
}

jobject QIconEngine_access::__qt_pixmap_cref_QSize_QIcon_Mode_QIcon_State(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID size0, jint mode1, jint state2)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QtJambiAPI::checkThreadQPixmap(__jni_env, typeid(QIconEngine));
    const QSize& __qt_size0 = QtJambiAPI::valueReferenceFromNativeId<QSize>(size0);
    QIcon::Mode __qt_mode1 = qtjambi_cast<QIcon::Mode>(__jni_env, mode1);
    QIcon::State __qt_state2 = qtjambi_cast<QIcon::State>(__jni_env, state2);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPixmap __qt_return_value = QIconEngine::pixmap(__qt_size0, __qt_mode1, __qt_state2);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPixmap __qt_return_value = pixmap(__qt_size0, __qt_mode1, __qt_state2);
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jboolean QIconEngine_access::__qt_read_ref_QDataStream(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID in0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QDataStream& __qt_in0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, in0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QIconEngine::read(__qt_in0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = read(__qt_in0);
        return jboolean(__qt_return_value);
    }
}

jobject QIconEngine_access::__qt_scaledPixmap_cref_QSize_QIcon_Mode_QIcon_State_qreal(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID size0, jint mode1, jint state2, jdouble scale3)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QtJambiAPI::checkThreadQPixmap(__jni_env, typeid(QIconEngine));
    const QSize& __qt_size0 = QtJambiAPI::valueReferenceFromNativeId<QSize>(size0);
    QIcon::Mode __qt_mode1 = qtjambi_cast<QIcon::Mode>(__jni_env, mode1);
    QIcon::State __qt_state2 = qtjambi_cast<QIcon::State>(__jni_env, state2);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QPixmap __qt_return_value = QIconEngine::scaledPixmap(__qt_size0, __qt_mode1, __qt_state2, static_cast<qreal>(scale3));
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    } else {
        QPixmap __qt_return_value = scaledPixmap(__qt_size0, __qt_mode1, __qt_state2, static_cast<qreal>(scale3));
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

void QIconEngine_access::__qt_virtual_hook_int_void_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jobject id0, jobject data1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    int __qt_id0 = int(qtjambi_cast<QIconEngine::IconEngineHook>(__jni_env, id0));
    void* __qt_data1{nullptr};
    switch(__qt_id0){
#if QT_VERSION < QT_VERSION_CHECK(6, 0, 0)
    case QIconEngine::IconNameHook:
        __qt_data1 = qtjambi_cast<QString*>(__jni_env, data1);
        break;
    case QIconEngine::AvailableSizesHook:
        __qt_data1 = qtjambi_cast<QIconEngine::AvailableSizesArgument*>(__jni_env, data1);
        break;
#endif
    case QIconEngine::IsNullHook:
        if(JBooleanArrayPointer::isValidArray(__jni_env, data1)){
            JBooleanArrayPointer* pointer = new JBooleanArrayPointer(__jni_env, jbooleanArray(data1));
            __qtjambi_scope.addDeletion(pointer);
            __qt_data1 = pointer->pointer();
        }
        break;
    case QIconEngine::ScaledPixmapHook:
        __qt_data1 = qtjambi_cast<QIconEngine::ScaledPixmapArgument*>(__jni_env, data1);
        break;
    default:
        __qt_data1 = data1;
        break;
    }
    if (QtJambiAPI::isShell(__this_nativeId)) {
        QIconEngine::virtual_hook(int(__qt_id0), __qt_data1);
    } else {
        virtual_hook(int(__qt_id0), __qt_data1);
    }
}

jboolean QIconEngine_access::__qt_write_ref_QDataStream_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID out0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QDataStream& __qt_out0 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, out0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        bool __qt_return_value = QIconEngine::write(__qt_out0);
        return jboolean(__qt_return_value);
    } else {
        bool __qt_return_value = write(__qt_out0);
        return jboolean(__qt_return_value);
    }
}

// emitting (writeConstructors)
// new QIconEngine()
void __qt_construct_QIconEngine(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QIconEngine()")
    Q_UNUSED(__java_arguments)
    QIconEngine *__qt_this = new(__qtjambi_ptr) QIconEngine_oshell();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QIconEngine::QIconEngine()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_initialize_1native__Lio_qt_gui_QIconEngine_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QIconEngine::QIconEngine()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QIconEngine, sizeof(QIconEngine_shell), typeid(QIconEngine), 0, true, &deleter_QIconEngine, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QIconEngine(QIconEngine)
void __qt_construct_QIconEngine_cref_QIconEngine(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QIconEngine(QIconEngine)")
    jobject other0 = __java_arguments[0].l;
    const QIconEngine& __qt_other0 = qtjambi_cast<const QIconEngine&>(__jni_env, other0);
    QIconEngine *__qt_this = new(__qtjambi_ptr) QIconEngine_oshell(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QIconEngine::QIconEngine(QIconEngine)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_initialize_1native__Lio_qt_gui_QIconEngine_2Lio_qt_gui_QIconEngine_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QIconEngine::QIconEngine(QIconEngine)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QIconEngine_cref_QIconEngine, sizeof(QIconEngine_shell), typeid(QIconEngine), 0, true, &deleter_QIconEngine, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QIconEngine_shell
void __qt_destruct_QIconEngine(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QIconEngine")
    reinterpret_cast<QIconEngine_shell*>(ptr)->~QIconEngine_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QIconEngine::actualSize(QSize,QIcon::Mode,QIcon::State)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_actualSize_1native_1cref_1QSize_1QIcon_1Mode_1QIcon_1State__JJII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size0,
 jint mode1,
 jint state2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::actualSize(QSize,QIcon::Mode,QIcon::State)", __this_nativeId)
        __java_return_value = static_cast<QIconEngine_access*>(__qt_this)->__qt_actualSize_cref_QSize_QIcon_Mode_QIcon_State(__jni_env, __this_nativeId, size0, mode1, state2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QIconEngine::addFile(QString,QSize,QIcon::Mode,QIcon::State)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_addFile_1native_1cref_1QString_1cref_1QSize_1QIcon_1Mode_1QIcon_1State__JLjava_lang_String_2JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0,
 QtJambiNativeID size1,
 jint mode2,
 jint state3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::addFile(QString,QSize,QIcon::Mode,QIcon::State)", __this_nativeId)
        static_cast<QIconEngine_access*>(__qt_this)->__qt_addFile_cref_QString_cref_QSize_QIcon_Mode_QIcon_State(__jni_env, __this_nativeId, fileName0, size1, mode2, state3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QIconEngine::addPixmap(QPixmap,QIcon::Mode,QIcon::State)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_addPixmap_1native_1cref_1QPixmap_1QIcon_1Mode_1QIcon_1State__JJII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID pixmap0,
 jint mode1,
 jint state2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::addPixmap(QPixmap,QIcon::Mode,QIcon::State)", __this_nativeId)
        static_cast<QIconEngine_access*>(__qt_this)->__qt_addPixmap_cref_QPixmap_QIcon_Mode_QIcon_State(__jni_env, __this_nativeId, pixmap0, mode1, state2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QIconEngine::availableSizes(QIcon::Mode,QIcon::State)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_availableSizes_1native_1QIcon_1Mode_1QIcon_1State__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0,
 jint state1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::availableSizes(QIcon::Mode,QIcon::State)", __this_nativeId)
        __java_return_value = static_cast<QIconEngine_access*>(__qt_this)->__qt_availableSizes_QIcon_Mode_QIcon_State(__jni_env, __this_nativeId, mode0, state1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QIconEngine::clone()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_00024ConcreteWrapper_clone_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::clone()const", __this_nativeId)
        __java_return_value = static_cast<const QIconEngine_access*>(__qt_this)->__qt_clone_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QIconEngine::iconName()
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_iconName_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::iconName()", __this_nativeId)
        __java_return_value = static_cast<QIconEngine_access*>(__qt_this)->__qt_iconName(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QIconEngine::isNull()
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_isNull_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::isNull()", __this_nativeId)
        __java_return_value = static_cast<QIconEngine_access*>(__qt_this)->__qt_isNull(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QIconEngine::key()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_key_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::key()const", __this_nativeId)
        __java_return_value = static_cast<const QIconEngine_access*>(__qt_this)->__qt_key_constfct(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QIconEngine::paint(QPainter*,QRect,QIcon::Mode,QIcon::State)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_00024ConcreteWrapper_paint_1native_1QPainter_1ptr_1cref_1QRect_1QIcon_1Mode_1QIcon_1State__JJJII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID painter0,
 QtJambiNativeID rect1,
 jint mode2,
 jint state3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::paint(QPainter*,QRect,QIcon::Mode,QIcon::State)", __this_nativeId)
        static_cast<QIconEngine_access*>(__qt_this)->__qt_paint_QPainter_ptr_cref_QRect_QIcon_Mode_QIcon_State(__jni_env, __this_nativeId, painter0, rect1, mode2, state3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QIconEngine::pixmap(QSize,QIcon::Mode,QIcon::State)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_pixmap_1native_1cref_1QSize_1QIcon_1Mode_1QIcon_1State__JJII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size0,
 jint mode1,
 jint state2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::pixmap(QSize,QIcon::Mode,QIcon::State)", __this_nativeId)
        __java_return_value = static_cast<QIconEngine_access*>(__qt_this)->__qt_pixmap_cref_QSize_QIcon_Mode_QIcon_State(__jni_env, __this_nativeId, size0, mode1, state2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QIconEngine::read(QDataStream&)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_read_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID in0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::read(QDataStream&)", __this_nativeId)
        __java_return_value = static_cast<QIconEngine_access*>(__qt_this)->__qt_read_ref_QDataStream(__jni_env, __this_nativeId, in0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QIconEngine::scaledPixmap(QSize,QIcon::Mode,QIcon::State,qreal)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_scaledPixmap_1native_1cref_1QSize_1QIcon_1Mode_1QIcon_1State_1qreal__JJIID)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID size0,
 jint mode1,
 jint state2,
 jdouble scale3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::scaledPixmap(QSize,QIcon::Mode,QIcon::State,qreal)", __this_nativeId)
        __java_return_value = static_cast<QIconEngine_access*>(__qt_this)->__qt_scaledPixmap_cref_QSize_QIcon_Mode_QIcon_State_qreal(__jni_env, __this_nativeId, size0, mode1, state2, scale3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QIconEngine::virtual_hook(int,void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_virtual_1hook_1native_1int_1void_1ptr__JLio_qt_gui_QIconEngine_00024IconEngineHook_2Ljava_lang_Object_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject id0,
 jobject data1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::virtual_hook(int,void*)", __this_nativeId)
        static_cast<QIconEngine_access*>(__qt_this)->__qt_virtual_hook_int_void_ptr(__jni_env, __this_nativeId, id0, data1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QIconEngine::write(QDataStream&)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QIconEngine_write_1native_1ref_1QDataStream_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID out0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QIconEngine *__qt_this = QtJambiAPI::objectFromNativeId<QIconEngine>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QIconEngine::write(QDataStream&)const", __this_nativeId)
        __java_return_value = static_cast<const QIconEngine_access*>(__qt_this)->__qt_write_ref_QDataStream_constfct(__jni_env, __this_nativeId, out0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QIconEngine(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QIconEngine>("QIconEngine", "io/qt/gui/QIconEngine");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/*  0 */ "actualSize", "(Lio/qt/core/QSize;Lio/qt/gui/QIcon$Mode;Lio/qt/gui/QIcon$State;)Lio/qt/core/QSize;"),
        FunctionInfo(/*  1 */ "addFile", "(Ljava/lang/String;Lio/qt/core/QSize;Lio/qt/gui/QIcon$Mode;Lio/qt/gui/QIcon$State;)V"),
        FunctionInfo(/*  2 */ "addPixmap", "(Lio/qt/gui/QPixmap;Lio/qt/gui/QIcon$Mode;Lio/qt/gui/QIcon$State;)V"),
        FunctionInfo(/*  3 */ "availableSizes", "(Lio/qt/gui/QIcon$Mode;Lio/qt/gui/QIcon$State;)Ljava/util/List;"),
        FunctionInfo(/*  4 */ "clone", "()Lio/qt/gui/QIconEngine;", FunctionInfo::Abstract),
        FunctionInfo(/*  5 */ "iconName", "()Ljava/lang/String;"),
        FunctionInfo(/*  6 */ "isNull", "()Z"),
        FunctionInfo(/*  7 */ "key", "()Ljava/lang/String;"),
        FunctionInfo(/*  8 */ "paint", "(Lio/qt/gui/QPainter;Lio/qt/core/QRect;Lio/qt/gui/QIcon$Mode;Lio/qt/gui/QIcon$State;)V", FunctionInfo::Abstract),
        FunctionInfo(/*  9 */ "pixmap", "(Lio/qt/core/QSize;Lio/qt/gui/QIcon$Mode;Lio/qt/gui/QIcon$State;)Lio/qt/gui/QPixmap;"),
        FunctionInfo(/* 10 */ "read", "(Lio/qt/core/QDataStream;)Z"),
        FunctionInfo(/* 11 */ "scaledPixmap", "(Lio/qt/core/QSize;Lio/qt/gui/QIcon$Mode;Lio/qt/gui/QIcon$State;D)Lio/qt/gui/QPixmap;"),
        FunctionInfo(/* 12 */ "virtual_hook", "(Lio/qt/gui/QIconEngine$IconEngineHook;Ljava/lang/Object;)V"),
        FunctionInfo(/* 13 */ "write", "(Lio/qt/core/QDataStream;)Z")});
    registerConstructorInfos(typeId, 0, &__qt_destruct_QIconEngine, {
        ConstructorInfo(&__qt_construct_QIconEngine, nullptr)
       ,ConstructorInfo(&__qt_construct_QIconEngine_cref_QIconEngine, "Lio/qt/gui/QIconEngine;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QIconEngine);
    registerSizeOfShell(typeId, sizeof(QIconEngine_shell));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QIconEngine::IconEngineHook>("QIconEngine::IconEngineHook", "io/qt/gui/QIconEngine$IconEngineHook");
// END: enums and flags
}
