#include <QtCore/QtGlobal>
#include <QtGui/qopenglextrafunctions.h>
#include <QtCore/QSharedPointer>
#include <QtCore/QVariant>
#include <QtGui/qopenglcontext.h>
#include <QtGui/qopenglfunctions.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/JavaAPI>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
#ifndef GL_MAX_LABEL_LENGTH
#define GL_MAX_LABEL_LENGTH 0x82E8
#endif

void deleter_QOpenGLExtraFunctions(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QOpenGLExtraFunctions")
    QOpenGLExtraFunctions *_ptr = reinterpret_cast<QOpenGLExtraFunctions *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QOpenGLExtraFunctions()
void __qt_construct_QOpenGLExtraFunctions(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLExtraFunctions()")
    Q_UNUSED(__java_arguments)
    QOpenGLExtraFunctions *__qt_this = new(__qtjambi_ptr) QOpenGLExtraFunctions();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QOpenGLExtraFunctions::QOpenGLExtraFunctions()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_initialize_1native__Lio_qt_gui_QOpenGLExtraFunctions_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLExtraFunctions::QOpenGLExtraFunctions()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLExtraFunctions, sizeof(QOpenGLExtraFunctions), typeid(QOpenGLExtraFunctions), 0, false, &deleter_QOpenGLExtraFunctions, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QOpenGLExtraFunctions(QOpenGLContext*)
void __qt_construct_QOpenGLExtraFunctions_QOpenGLContext_ptr(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLExtraFunctions(QOpenGLContext*)")
    jobject context0 = __java_arguments[0].l;
    QOpenGLContext* __qt_context0 = qtjambi_cast<QOpenGLContext*>(__jni_env, context0);
    QOpenGLExtraFunctions *__qt_this = new(__qtjambi_ptr) QOpenGLExtraFunctions(__qt_context0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QOpenGLExtraFunctions::QOpenGLExtraFunctions(QOpenGLContext*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_initialize_1native__Lio_qt_gui_QOpenGLExtraFunctions_2Lio_qt_gui_QOpenGLContext_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject context0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLExtraFunctions::QOpenGLExtraFunctions(QOpenGLContext*)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = context0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLExtraFunctions_QOpenGLContext_ptr, sizeof(QOpenGLExtraFunctions), typeid(QOpenGLExtraFunctions), 0, false, &deleter_QOpenGLExtraFunctions, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QOpenGLExtraFunctions(QOpenGLExtraFunctions)
void __qt_construct_QOpenGLExtraFunctions_cref_QOpenGLExtraFunctions(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLExtraFunctions(QOpenGLExtraFunctions)")
    jobject other0 = __java_arguments[0].l;
    const QOpenGLExtraFunctions& __qt_other0 = qtjambi_cast<const QOpenGLExtraFunctions&>(__jni_env, other0);
    QOpenGLExtraFunctions *__qt_this = new(__qtjambi_ptr) QOpenGLExtraFunctions(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QOpenGLExtraFunctions::QOpenGLExtraFunctions(QOpenGLExtraFunctions)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_initialize_1native__Lio_qt_gui_QOpenGLExtraFunctions_2Lio_qt_gui_QOpenGLExtraFunctions_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLExtraFunctions::QOpenGLExtraFunctions(QOpenGLExtraFunctions)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLExtraFunctions_cref_QOpenGLExtraFunctions, sizeof(QOpenGLExtraFunctions), typeid(QOpenGLExtraFunctions), 0, false, &deleter_QOpenGLExtraFunctions, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QOpenGLExtraFunctions
void __qt_destruct_QOpenGLExtraFunctions(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QOpenGLExtraFunctions")
    reinterpret_cast<QOpenGLExtraFunctions*>(ptr)->~QOpenGLExtraFunctions();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QOpenGLExtraFunctions::glActiveShaderProgram(GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glActiveShaderProgram_1native_1GLuint_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pipeline0,
 jint program1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glActiveShaderProgram(GLuint,GLuint)", __this_nativeId)
        __qt_this->glActiveShaderProgram(static_cast<GLuint>(pipeline0), static_cast<GLuint>(program1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBeginQuery(GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBeginQuery_1native_1GLenum_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint id1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBeginQuery(GLenum,GLuint)", __this_nativeId)
        __qt_this->glBeginQuery(static_cast<GLenum>(target0), static_cast<GLuint>(id1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBeginTransformFeedback(GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBeginTransformFeedback_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint primitiveMode0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBeginTransformFeedback(GLenum)", __this_nativeId)
        __qt_this->glBeginTransformFeedback(static_cast<GLenum>(primitiveMode0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBindBufferBase(GLenum,GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBindBufferBase_1native_1GLenum_1GLuint_1GLuint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint index1,
 jint buffer2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBindBufferBase(GLenum,GLuint,GLuint)", __this_nativeId)
        __qt_this->glBindBufferBase(static_cast<GLenum>(target0), static_cast<GLuint>(index1), static_cast<GLuint>(buffer2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBindBufferRange(GLenum,GLuint,GLuint,GLintptr,GLsizeiptr)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBindBufferRange_1native_1GLenum_1GLuint_1GLuint_1GLintptr_1GLsizeiptr__JIIIJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint index1,
 jint buffer2,
 jlong offset3,
 jlong size4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBindBufferRange(GLenum,GLuint,GLuint,GLintptr,GLsizeiptr)", __this_nativeId)
        __qt_this->glBindBufferRange(static_cast<GLenum>(target0), static_cast<GLuint>(index1), static_cast<GLuint>(buffer2), static_cast<GLintptr>(offset3), static_cast<GLsizeiptr>(size4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBindImageTexture(GLuint,GLuint,GLint,GLboolean,GLint,GLenum,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBindImageTexture_1native_1GLuint_1GLuint_1GLint_1GLboolean_1GLint_1GLenum_1GLenum__JIIIZIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint unit0,
 jint texture1,
 jint level2,
 jboolean layered3,
 jint layer4,
 jint access5,
 jint format6)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBindImageTexture(GLuint,GLuint,GLint,GLboolean,GLint,GLenum,GLenum)", __this_nativeId)
        __qt_this->glBindImageTexture(static_cast<GLuint>(unit0), static_cast<GLuint>(texture1), static_cast<GLint>(level2), static_cast<GLboolean>(layered3), static_cast<GLint>(layer4), static_cast<GLenum>(access5), static_cast<GLenum>(format6));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBindProgramPipeline(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBindProgramPipeline_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pipeline0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBindProgramPipeline(GLuint)", __this_nativeId)
        __qt_this->glBindProgramPipeline(static_cast<GLuint>(pipeline0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBindSampler(GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBindSampler_1native_1GLuint_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint unit0,
 jint sampler1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBindSampler(GLuint,GLuint)", __this_nativeId)
        __qt_this->glBindSampler(static_cast<GLuint>(unit0), static_cast<GLuint>(sampler1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBindTransformFeedback(GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBindTransformFeedback_1native_1GLenum_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint id1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBindTransformFeedback(GLenum,GLuint)", __this_nativeId)
        __qt_this->glBindTransformFeedback(static_cast<GLenum>(target0), static_cast<GLuint>(id1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBindVertexArray(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBindVertexArray_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint array0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBindVertexArray(GLuint)", __this_nativeId)
        __qt_this->glBindVertexArray(static_cast<GLuint>(array0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBindVertexBuffer(GLuint,GLuint,GLintptr,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBindVertexBuffer_1native_1GLuint_1GLuint_1GLintptr_1GLsizei__JIIJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint bindingindex0,
 jint buffer1,
 jlong offset2,
 jint stride3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBindVertexBuffer(GLuint,GLuint,GLintptr,GLsizei)", __this_nativeId)
        __qt_this->glBindVertexBuffer(static_cast<GLuint>(bindingindex0), static_cast<GLuint>(buffer1), static_cast<GLintptr>(offset2), static_cast<GLsizei>(stride3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBlendBarrier()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBlendBarrier_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBlendBarrier()", __this_nativeId)
        __qt_this->glBlendBarrier();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBlendEquationSeparatei(GLuint,GLenum,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBlendEquationSeparatei_1native_1GLuint_1GLenum_1GLenum__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint buf0,
 jint modeRGB1,
 jint modeAlpha2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBlendEquationSeparatei(GLuint,GLenum,GLenum)", __this_nativeId)
        __qt_this->glBlendEquationSeparatei(static_cast<GLuint>(buf0), static_cast<GLenum>(modeRGB1), static_cast<GLenum>(modeAlpha2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBlendEquationi(GLuint,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBlendEquationi_1native_1GLuint_1GLenum__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint buf0,
 jint mode1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBlendEquationi(GLuint,GLenum)", __this_nativeId)
        __qt_this->glBlendEquationi(static_cast<GLuint>(buf0), static_cast<GLenum>(mode1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBlendFuncSeparatei(GLuint,GLenum,GLenum,GLenum,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBlendFuncSeparatei_1native_1GLuint_1GLenum_1GLenum_1GLenum_1GLenum__JIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint buf0,
 jint srcRGB1,
 jint dstRGB2,
 jint srcAlpha3,
 jint dstAlpha4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBlendFuncSeparatei(GLuint,GLenum,GLenum,GLenum,GLenum)", __this_nativeId)
        __qt_this->glBlendFuncSeparatei(static_cast<GLuint>(buf0), static_cast<GLenum>(srcRGB1), static_cast<GLenum>(dstRGB2), static_cast<GLenum>(srcAlpha3), static_cast<GLenum>(dstAlpha4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBlendFunci(GLuint,GLenum,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBlendFunci_1native_1GLuint_1GLenum_1GLenum__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint buf0,
 jint src1,
 jint dst2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBlendFunci(GLuint,GLenum,GLenum)", __this_nativeId)
        __qt_this->glBlendFunci(static_cast<GLuint>(buf0), static_cast<GLenum>(src1), static_cast<GLenum>(dst2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glBlitFramebuffer(GLint,GLint,GLint,GLint,GLint,GLint,GLint,GLint,GLbitfield,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glBlitFramebuffer_1native_1GLint_1GLint_1GLint_1GLint_1GLint_1GLint_1GLint_1GLint_1GLbitfield_1GLenum__JIIIIIIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint srcX00,
 jint srcY01,
 jint srcX12,
 jint srcY13,
 jint dstX04,
 jint dstY05,
 jint dstX16,
 jint dstY17,
 jint mask8,
 jint filter9)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glBlitFramebuffer(GLint,GLint,GLint,GLint,GLint,GLint,GLint,GLint,GLbitfield,GLenum)", __this_nativeId)
        __qt_this->glBlitFramebuffer(static_cast<GLint>(srcX00), static_cast<GLint>(srcY01), static_cast<GLint>(srcX12), static_cast<GLint>(srcY13), static_cast<GLint>(dstX04), static_cast<GLint>(dstY05), static_cast<GLint>(dstX16), static_cast<GLint>(dstY17), static_cast<GLbitfield>(mask8), static_cast<GLenum>(filter9));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glClearBufferfi(GLenum,GLint,GLfloat,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glClearBufferfi_1native_1GLenum_1GLint_1GLfloat_1GLint__JIIFI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint buffer0,
 jint drawbuffer1,
 jfloat depth2,
 jint stencil3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glClearBufferfi(GLenum,GLint,GLfloat,GLint)", __this_nativeId)
        __qt_this->glClearBufferfi(static_cast<GLenum>(buffer0), static_cast<GLint>(drawbuffer1), static_cast<GLfloat>(depth2), static_cast<GLint>(stencil3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glClearBufferfv(GLenum,GLint,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glClearBufferfv_1native_1GLenum_1GLint_1const_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint buffer0,
 jint drawbuffer1,
 jobject value2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glClearBufferfv(GLenum,GLint,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value2_buffer(__jni_env, value2);
        const GLfloat* __qt_value2 = __qt_value2_buffer.data<GLfloat>();
        __qt_this->glClearBufferfv(static_cast<GLenum>(buffer0), static_cast<GLint>(drawbuffer1), __qt_value2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glClearBufferiv(GLenum,GLint,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glClearBufferiv_1native_1GLenum_1GLint_1const_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint buffer0,
 jint drawbuffer1,
 jobject value2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glClearBufferiv(GLenum,GLint,const GLint*)", __this_nativeId)
        JBufferConstData __qt_value2_buffer(__jni_env, value2);
        const GLint* __qt_value2 = __qt_value2_buffer.data<GLint>();
        __qt_this->glClearBufferiv(static_cast<GLenum>(buffer0), static_cast<GLint>(drawbuffer1), __qt_value2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glClearBufferuiv(GLenum,GLint,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glClearBufferuiv_1native_1GLenum_1GLint_1const_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint buffer0,
 jint drawbuffer1,
 jobject value2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glClearBufferuiv(GLenum,GLint,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_value2_buffer(__jni_env, value2);
        const GLuint* __qt_value2 = __qt_value2_buffer.data<GLuint>();
        __qt_this->glClearBufferuiv(static_cast<GLenum>(buffer0), static_cast<GLint>(drawbuffer1), __qt_value2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glClientWaitSync(GLsync,GLbitfield,GLuint64)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glClientWaitSync_1native_1_1_1GLsync_1ptr_1GLbitfield_1GLuint64__JJIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID sync0,
 jint flags1,
 jlong timeout2)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glClientWaitSync(GLsync,GLbitfield,GLuint64)", __this_nativeId)
        __GLsync* __qt_sync0 = QtJambiAPI::objectFromNativeId<__GLsync>(sync0);
        GLenum __qt_return_value = __qt_this->glClientWaitSync(__qt_sync0, static_cast<GLbitfield>(flags1), static_cast<GLuint64>(timeout2));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glColorMaski(GLuint,GLboolean,GLboolean,GLboolean,GLboolean)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glColorMaski_1native_1GLuint_1GLboolean_1GLboolean_1GLboolean_1GLboolean__JIZZZZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jboolean r1,
 jboolean g2,
 jboolean b3,
 jboolean a4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glColorMaski(GLuint,GLboolean,GLboolean,GLboolean,GLboolean)", __this_nativeId)
        __qt_this->glColorMaski(static_cast<GLuint>(index0), static_cast<GLboolean>(r1), static_cast<GLboolean>(g2), static_cast<GLboolean>(b3), static_cast<GLboolean>(a4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glCompressedTexImage3D(GLenum,GLint,GLenum,GLsizei,GLsizei,GLsizei,GLint,GLsizei,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glCompressedTexImage3D_1native_1GLenum_1GLint_1GLenum_1GLsizei_1GLsizei_1GLsizei_1GLint_1GLsizei_1const_1void_1ptr__JIIIIIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint internalformat2,
 jint width3,
 jint height4,
 jint depth5,
 jint border6,
 jint imageSize7,
 jobject data8)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glCompressedTexImage3D(GLenum,GLint,GLenum,GLsizei,GLsizei,GLsizei,GLint,GLsizei,const void*)", __this_nativeId)
        JBufferConstData __qt_data8_buffer(__jni_env, data8);
        const void* __qt_data8 = __qt_data8_buffer.data<void>();
        __qt_this->glCompressedTexImage3D(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLenum>(internalformat2), static_cast<GLsizei>(width3), static_cast<GLsizei>(height4), static_cast<GLsizei>(depth5), static_cast<GLint>(border6), static_cast<GLsizei>(imageSize7), __qt_data8);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glCompressedTexSubImage3D(GLenum,GLint,GLint,GLint,GLint,GLsizei,GLsizei,GLsizei,GLenum,GLsizei,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glCompressedTexSubImage3D_1native_1GLenum_1GLint_1GLint_1GLint_1GLint_1GLsizei_1GLsizei_1GLsizei_1GLenum_1GLsizei_1const_1void_1ptr__JIIIIIIIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint xoffset2,
 jint yoffset3,
 jint zoffset4,
 jint width5,
 jint height6,
 jint depth7,
 jint format8,
 jint imageSize9,
 jobject data10)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glCompressedTexSubImage3D(GLenum,GLint,GLint,GLint,GLint,GLsizei,GLsizei,GLsizei,GLenum,GLsizei,const void*)", __this_nativeId)
        JBufferConstData __qt_data10_buffer(__jni_env, data10);
        const void* __qt_data10 = __qt_data10_buffer.data<void>();
        __qt_this->glCompressedTexSubImage3D(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLint>(xoffset2), static_cast<GLint>(yoffset3), static_cast<GLint>(zoffset4), static_cast<GLsizei>(width5), static_cast<GLsizei>(height6), static_cast<GLsizei>(depth7), static_cast<GLenum>(format8), static_cast<GLsizei>(imageSize9), __qt_data10);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glCopyBufferSubData(GLenum,GLenum,GLintptr,GLintptr,GLsizeiptr)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glCopyBufferSubData_1native_1GLenum_1GLenum_1GLintptr_1GLintptr_1GLsizeiptr__JIIJJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint readTarget0,
 jint writeTarget1,
 jlong readOffset2,
 jlong writeOffset3,
 jlong size4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glCopyBufferSubData(GLenum,GLenum,GLintptr,GLintptr,GLsizeiptr)", __this_nativeId)
        __qt_this->glCopyBufferSubData(static_cast<GLenum>(readTarget0), static_cast<GLenum>(writeTarget1), static_cast<GLintptr>(readOffset2), static_cast<GLintptr>(writeOffset3), static_cast<GLsizeiptr>(size4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glCopyImageSubData(GLuint,GLenum,GLint,GLint,GLint,GLint,GLuint,GLenum,GLint,GLint,GLint,GLint,GLsizei,GLsizei,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glCopyImageSubData_1native_1GLuint_1GLenum_1GLint_1GLint_1GLint_1GLint_1GLuint_1GLenum_1GLint_1GLint_1GLint_1GLint_1GLsizei_1GLsizei_1GLsizei__JIIIIIIIIIIIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint srcName0,
 jint srcTarget1,
 jint srcLevel2,
 jint srcX3,
 jint srcY4,
 jint srcZ5,
 jint dstName6,
 jint dstTarget7,
 jint dstLevel8,
 jint dstX9,
 jint dstY10,
 jint dstZ11,
 jint srcWidth12,
 jint srcHeight13,
 jint srcDepth14)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glCopyImageSubData(GLuint,GLenum,GLint,GLint,GLint,GLint,GLuint,GLenum,GLint,GLint,GLint,GLint,GLsizei,GLsizei,GLsizei)", __this_nativeId)
        __qt_this->glCopyImageSubData(static_cast<GLuint>(srcName0), static_cast<GLenum>(srcTarget1), static_cast<GLint>(srcLevel2), static_cast<GLint>(srcX3), static_cast<GLint>(srcY4), static_cast<GLint>(srcZ5), static_cast<GLuint>(dstName6), static_cast<GLenum>(dstTarget7), static_cast<GLint>(dstLevel8), static_cast<GLint>(dstX9), static_cast<GLint>(dstY10), static_cast<GLint>(dstZ11), static_cast<GLsizei>(srcWidth12), static_cast<GLsizei>(srcHeight13), static_cast<GLsizei>(srcDepth14));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glCopyTexSubImage3D(GLenum,GLint,GLint,GLint,GLint,GLint,GLint,GLsizei,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glCopyTexSubImage3D_1native_1GLenum_1GLint_1GLint_1GLint_1GLint_1GLint_1GLint_1GLsizei_1GLsizei__JIIIIIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint xoffset2,
 jint yoffset3,
 jint zoffset4,
 jint x5,
 jint y6,
 jint width7,
 jint height8)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glCopyTexSubImage3D(GLenum,GLint,GLint,GLint,GLint,GLint,GLint,GLsizei,GLsizei)", __this_nativeId)
        __qt_this->glCopyTexSubImage3D(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLint>(xoffset2), static_cast<GLint>(yoffset3), static_cast<GLint>(zoffset4), static_cast<GLint>(x5), static_cast<GLint>(y6), static_cast<GLsizei>(width7), static_cast<GLsizei>(height8));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glCreateShaderProgramv(GLenum,GLsizei,const GLchar*const*)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glCreateShaderProgramv_1native_1GLenum_1GLsizei_1const_1GLchar_1cptr_1ptr__JI_3Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint type0,
 jobjectArray strings2)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glCreateShaderProgramv(GLenum,GLsizei,const GLchar*const*)", __this_nativeId)
        jsize __qt_count1 = __jni_env->GetArrayLength(jarray(strings2));
        QVector<QSharedPointer<J2CStringBuffer>> strings2Vec;
        const char** __qt_strings2 = nullptr;
        QScopedArrayPointer<const char*> __qt_strings2Ptr(__qt_strings2 = new const char*[quint32(__qt_count1)]);
        for(jsize i=0; i<__qt_count1; ++i){
            J2CStringBuffer* b = new J2CStringBuffer(__jni_env, jstring(__jni_env->GetObjectArrayElement(jobjectArray(strings2), i)));
            __qt_strings2[i] = *b;
            strings2Vec << QSharedPointer<J2CStringBuffer>(b);
        }
        GLuint __qt_return_value = __qt_this->glCreateShaderProgramv(static_cast<GLenum>(type0), GLsizei(__qt_count1), __qt_strings2);
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glDebugMessageCallback(GLDEBUGPROC,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDebugMessageCallback_1native_1GLDEBUGPROC_1const_1void_1ptr__JLio_qt_gui_gl_GLDEBUGPROC_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject callback0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDebugMessageCallback(GLDEBUGPROC,const void*)", __this_nativeId)
        GLDEBUGPROC __qt_callback0 = qtjambi_cast<GLDEBUGPROC>(__jni_env, callback0);
        const void * __qt_userParam1 = nullptr;
        __qt_this->glDebugMessageCallback(__qt_callback0, __qt_userParam1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDebugMessageControl(GLenum,GLenum,GLenum,GLsizei,const GLuint*,GLboolean)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDebugMessageControl_1native_1GLenum_1GLenum_1GLenum_1GLsizei_1const_1GLuint_1ptr_1GLboolean__JIIIILjava_nio_IntBuffer_2Z)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint source0,
 jint type1,
 jint severity2,
 jint count3,
 jobject ids4,
 jboolean enabled5)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDebugMessageControl(GLenum,GLenum,GLenum,GLsizei,const GLuint*,GLboolean)", __this_nativeId)
        JBufferConstData __qt_ids4_buffer(__jni_env, ids4);
        const GLuint* __qt_ids4 = __qt_ids4_buffer.data<GLuint>();
        __qt_this->glDebugMessageControl(static_cast<GLenum>(source0), static_cast<GLenum>(type1), static_cast<GLenum>(severity2), static_cast<GLsizei>(count3), __qt_ids4, static_cast<GLboolean>(enabled5));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDebugMessageInsert(GLenum,GLenum,GLuint,GLenum,GLsizei,const GLchar*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDebugMessageInsert_1native_1GLenum_1GLenum_1GLuint_1GLenum_1GLsizei_1const_1GLchar_1ptr__JIIIIILjava_nio_CharBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint source0,
 jint type1,
 jint id2,
 jint severity3,
 jint length4,
 jobject buf5)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDebugMessageInsert(GLenum,GLenum,GLuint,GLenum,GLsizei,const GLchar*)", __this_nativeId)
        JBufferConstData __qt_buf5_buffer(__jni_env, buf5);
        const GLchar* __qt_buf5 = __qt_buf5_buffer.data<GLchar>();
        __qt_this->glDebugMessageInsert(static_cast<GLenum>(source0), static_cast<GLenum>(type1), static_cast<GLuint>(id2), static_cast<GLenum>(severity3), static_cast<GLsizei>(length4), __qt_buf5);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDeleteProgramPipelines(GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDeleteProgramPipelines_1native_1GLsizei_1const_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject pipelines1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDeleteProgramPipelines(GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_pipelines1_buffer(__jni_env, pipelines1);
        const GLuint* __qt_pipelines1 = __qt_pipelines1_buffer.data<GLuint>();
        __qt_this->glDeleteProgramPipelines(static_cast<GLsizei>(n0), __qt_pipelines1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDeleteQueries(GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDeleteQueries_1native_1GLsizei_1const_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject ids1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDeleteQueries(GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_ids1_buffer(__jni_env, ids1);
        const GLuint* __qt_ids1 = __qt_ids1_buffer.data<GLuint>();
        __qt_this->glDeleteQueries(static_cast<GLsizei>(n0), __qt_ids1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDeleteSamplers(GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDeleteSamplers_1native_1GLsizei_1const_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint count0,
 jobject samplers1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDeleteSamplers(GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_samplers1_buffer(__jni_env, samplers1);
        const GLuint* __qt_samplers1 = __qt_samplers1_buffer.data<GLuint>();
        __qt_this->glDeleteSamplers(static_cast<GLsizei>(count0), __qt_samplers1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDeleteSync(GLsync)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDeleteSync_1native_1_1_1GLsync_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID sync0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDeleteSync(GLsync)", __this_nativeId)
        __GLsync* __qt_sync0 = QtJambiAPI::objectFromNativeId<__GLsync>(sync0);
        __qt_this->glDeleteSync(__qt_sync0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDeleteTransformFeedbacks(GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDeleteTransformFeedbacks_1native_1GLsizei_1const_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject ids1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDeleteTransformFeedbacks(GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_ids1_buffer(__jni_env, ids1);
        const GLuint* __qt_ids1 = __qt_ids1_buffer.data<GLuint>();
        __qt_this->glDeleteTransformFeedbacks(static_cast<GLsizei>(n0), __qt_ids1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDeleteVertexArrays(GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDeleteVertexArrays_1native_1GLsizei_1const_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject arrays1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDeleteVertexArrays(GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_arrays1_buffer(__jni_env, arrays1);
        const GLuint* __qt_arrays1 = __qt_arrays1_buffer.data<GLuint>();
        __qt_this->glDeleteVertexArrays(static_cast<GLsizei>(n0), __qt_arrays1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDisablei(GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDisablei_1native_1GLenum_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint index1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDisablei(GLenum,GLuint)", __this_nativeId)
        __qt_this->glDisablei(static_cast<GLenum>(target0), static_cast<GLuint>(index1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDispatchCompute(GLuint,GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDispatchCompute_1native_1GLuint_1GLuint_1GLuint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint num_groups_x0,
 jint num_groups_y1,
 jint num_groups_z2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDispatchCompute(GLuint,GLuint,GLuint)", __this_nativeId)
        __qt_this->glDispatchCompute(static_cast<GLuint>(num_groups_x0), static_cast<GLuint>(num_groups_y1), static_cast<GLuint>(num_groups_z2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDispatchComputeIndirect(GLintptr)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDispatchComputeIndirect_1native_1GLintptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong indirect0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDispatchComputeIndirect(GLintptr)", __this_nativeId)
        __qt_this->glDispatchComputeIndirect(static_cast<GLintptr>(indirect0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDrawArraysIndirect(GLenum,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDrawArraysIndirect_1native_1GLenum_1const_1void_1ptr__JILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0,
 jobject indirect1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDrawArraysIndirect(GLenum,const void*)", __this_nativeId)
        JBufferConstData __qt_indirect1_buffer(__jni_env, indirect1);
        const void* __qt_indirect1 = __qt_indirect1_buffer.data<void>();
        __qt_this->glDrawArraysIndirect(static_cast<GLenum>(mode0), __qt_indirect1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDrawArraysInstanced(GLenum,GLint,GLsizei,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDrawArraysInstanced_1native_1GLenum_1GLint_1GLsizei_1GLsizei__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0,
 jint first1,
 jint count2,
 jint instancecount3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDrawArraysInstanced(GLenum,GLint,GLsizei,GLsizei)", __this_nativeId)
        __qt_this->glDrawArraysInstanced(static_cast<GLenum>(mode0), static_cast<GLint>(first1), static_cast<GLsizei>(count2), static_cast<GLsizei>(instancecount3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDrawBuffers(GLsizei,const GLenum*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDrawBuffers_1native_1GLsizei_1const_1GLenum_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject bufs1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDrawBuffers(GLsizei,const GLenum*)", __this_nativeId)
        JBufferConstData __qt_bufs1_buffer(__jni_env, bufs1);
        const GLenum* __qt_bufs1 = __qt_bufs1_buffer.data<GLenum>();
        __qt_this->glDrawBuffers(static_cast<GLsizei>(n0), __qt_bufs1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDrawElementsBaseVertex(GLenum,GLsizei,GLenum,const void*,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDrawElementsBaseVertex_1native_1GLenum_1GLsizei_1GLenum_1const_1void_1ptr_1GLint__JIIILjava_nio_Buffer_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0,
 jint count1,
 jint type2,
 jobject indices3,
 jint basevertex4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDrawElementsBaseVertex(GLenum,GLsizei,GLenum,const void*,GLint)", __this_nativeId)
        JBufferConstData __qt_indices3_buffer(__jni_env, indices3);
        const void* __qt_indices3 = __qt_indices3_buffer.data<void>();
        __qt_this->glDrawElementsBaseVertex(static_cast<GLenum>(mode0), static_cast<GLsizei>(count1), static_cast<GLenum>(type2), __qt_indices3, static_cast<GLint>(basevertex4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDrawElementsIndirect(GLenum,GLenum,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDrawElementsIndirect_1native_1GLenum_1GLenum_1const_1void_1ptr__JIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0,
 jint type1,
 jobject indirect2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDrawElementsIndirect(GLenum,GLenum,const void*)", __this_nativeId)
        JBufferConstData __qt_indirect2_buffer(__jni_env, indirect2);
        const void* __qt_indirect2 = __qt_indirect2_buffer.data<void>();
        __qt_this->glDrawElementsIndirect(static_cast<GLenum>(mode0), static_cast<GLenum>(type1), __qt_indirect2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDrawElementsInstanced(GLenum,GLsizei,GLenum,const void*,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDrawElementsInstanced_1native_1GLenum_1GLsizei_1GLenum_1const_1void_1ptr_1GLsizei__JIIILjava_nio_Buffer_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0,
 jint count1,
 jint type2,
 jobject indices3,
 jint instancecount4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDrawElementsInstanced(GLenum,GLsizei,GLenum,const void*,GLsizei)", __this_nativeId)
        JBufferConstData __qt_indices3_buffer(__jni_env, indices3);
        const void* __qt_indices3 = __qt_indices3_buffer.data<void>();
        __qt_this->glDrawElementsInstanced(static_cast<GLenum>(mode0), static_cast<GLsizei>(count1), static_cast<GLenum>(type2), __qt_indices3, static_cast<GLsizei>(instancecount4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDrawElementsInstancedBaseVertex(GLenum,GLsizei,GLenum,const void*,GLsizei,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDrawElementsInstancedBaseVertex_1native_1GLenum_1GLsizei_1GLenum_1const_1void_1ptr_1GLsizei_1GLint__JIIILjava_nio_Buffer_2II)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0,
 jint count1,
 jint type2,
 jobject indices3,
 jint instancecount4,
 jint basevertex5)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDrawElementsInstancedBaseVertex(GLenum,GLsizei,GLenum,const void*,GLsizei,GLint)", __this_nativeId)
        JBufferConstData __qt_indices3_buffer(__jni_env, indices3);
        const void* __qt_indices3 = __qt_indices3_buffer.data<void>();
        __qt_this->glDrawElementsInstancedBaseVertex(static_cast<GLenum>(mode0), static_cast<GLsizei>(count1), static_cast<GLenum>(type2), __qt_indices3, static_cast<GLsizei>(instancecount4), static_cast<GLint>(basevertex5));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDrawRangeElements(GLenum,GLuint,GLuint,GLsizei,GLenum,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDrawRangeElements_1native_1GLenum_1GLuint_1GLuint_1GLsizei_1GLenum_1const_1void_1ptr__JIIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0,
 jint start1,
 jint end2,
 jint count3,
 jint type4,
 jobject indices5)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDrawRangeElements(GLenum,GLuint,GLuint,GLsizei,GLenum,const void*)", __this_nativeId)
        JBufferConstData __qt_indices5_buffer(__jni_env, indices5);
        const void* __qt_indices5 = __qt_indices5_buffer.data<void>();
        __qt_this->glDrawRangeElements(static_cast<GLenum>(mode0), static_cast<GLuint>(start1), static_cast<GLuint>(end2), static_cast<GLsizei>(count3), static_cast<GLenum>(type4), __qt_indices5);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glDrawRangeElementsBaseVertex(GLenum,GLuint,GLuint,GLsizei,GLenum,const void*,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glDrawRangeElementsBaseVertex_1native_1GLenum_1GLuint_1GLuint_1GLsizei_1GLenum_1const_1void_1ptr_1GLint__JIIIIILjava_nio_Buffer_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0,
 jint start1,
 jint end2,
 jint count3,
 jint type4,
 jobject indices5,
 jint basevertex6)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glDrawRangeElementsBaseVertex(GLenum,GLuint,GLuint,GLsizei,GLenum,const void*,GLint)", __this_nativeId)
        JBufferConstData __qt_indices5_buffer(__jni_env, indices5);
        const void* __qt_indices5 = __qt_indices5_buffer.data<void>();
        __qt_this->glDrawRangeElementsBaseVertex(static_cast<GLenum>(mode0), static_cast<GLuint>(start1), static_cast<GLuint>(end2), static_cast<GLsizei>(count3), static_cast<GLenum>(type4), __qt_indices5, static_cast<GLint>(basevertex6));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glEnablei(GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glEnablei_1native_1GLenum_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint index1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glEnablei(GLenum,GLuint)", __this_nativeId)
        __qt_this->glEnablei(static_cast<GLenum>(target0), static_cast<GLuint>(index1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glEndQuery(GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glEndQuery_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glEndQuery(GLenum)", __this_nativeId)
        __qt_this->glEndQuery(static_cast<GLenum>(target0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glEndTransformFeedback()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glEndTransformFeedback_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glEndTransformFeedback()", __this_nativeId)
        __qt_this->glEndTransformFeedback();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glFenceSync(GLenum,GLbitfield)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glFenceSync_1native_1GLenum_1GLbitfield__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint condition0,
 jint flags1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glFenceSync(GLenum,GLbitfield)", __this_nativeId)
        __GLsync* __qt_return_value = __qt_this->glFenceSync(static_cast<GLenum>(condition0), static_cast<GLbitfield>(flags1));
        __java_return_value = QtJambiAPI::convertNativeToJavaObjectAsWrapper(__jni_env, static_cast<const void *>(__qt_return_value), Java::QtGui::GLsync::getClass(__jni_env));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glFlushMappedBufferRange(GLenum,GLintptr,GLsizeiptr)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glFlushMappedBufferRange_1native_1GLenum_1GLintptr_1GLsizeiptr__JIJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jlong offset1,
 jlong length2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glFlushMappedBufferRange(GLenum,GLintptr,GLsizeiptr)", __this_nativeId)
        __qt_this->glFlushMappedBufferRange(static_cast<GLenum>(target0), static_cast<GLintptr>(offset1), static_cast<GLsizeiptr>(length2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glFramebufferParameteri(GLenum,GLenum,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glFramebufferParameteri_1native_1GLenum_1GLenum_1GLint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jint param2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glFramebufferParameteri(GLenum,GLenum,GLint)", __this_nativeId)
        __qt_this->glFramebufferParameteri(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), static_cast<GLint>(param2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glFramebufferTexture(GLenum,GLenum,GLuint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glFramebufferTexture_1native_1GLenum_1GLenum_1GLuint_1GLint__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint attachment1,
 jint texture2,
 jint level3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glFramebufferTexture(GLenum,GLenum,GLuint,GLint)", __this_nativeId)
        __qt_this->glFramebufferTexture(static_cast<GLenum>(target0), static_cast<GLenum>(attachment1), static_cast<GLuint>(texture2), static_cast<GLint>(level3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glFramebufferTextureLayer(GLenum,GLenum,GLuint,GLint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glFramebufferTextureLayer_1native_1GLenum_1GLenum_1GLuint_1GLint_1GLint__JIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint attachment1,
 jint texture2,
 jint level3,
 jint layer4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glFramebufferTextureLayer(GLenum,GLenum,GLuint,GLint,GLint)", __this_nativeId)
        __qt_this->glFramebufferTextureLayer(static_cast<GLenum>(target0), static_cast<GLenum>(attachment1), static_cast<GLuint>(texture2), static_cast<GLint>(level3), static_cast<GLint>(layer4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGenProgramPipelines(GLsizei,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGenProgramPipelines_1native_1GLsizei_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject pipelines1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGenProgramPipelines(GLsizei,GLuint*)", __this_nativeId)
        JBufferData __qt_pipelines1_buffer(__jni_env, pipelines1);
        GLuint* __qt_pipelines1 = __qt_pipelines1_buffer.data<GLuint>();
        __qt_this->glGenProgramPipelines(static_cast<GLsizei>(n0), __qt_pipelines1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGenQueries(GLsizei,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGenQueries_1native_1GLsizei_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject ids1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGenQueries(GLsizei,GLuint*)", __this_nativeId)
        JBufferData __qt_ids1_buffer(__jni_env, ids1);
        GLuint* __qt_ids1 = __qt_ids1_buffer.data<GLuint>();
        __qt_this->glGenQueries(static_cast<GLsizei>(n0), __qt_ids1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGenSamplers(GLsizei,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGenSamplers_1native_1GLsizei_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint count0,
 jobject samplers1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGenSamplers(GLsizei,GLuint*)", __this_nativeId)
        JBufferData __qt_samplers1_buffer(__jni_env, samplers1);
        GLuint* __qt_samplers1 = __qt_samplers1_buffer.data<GLuint>();
        __qt_this->glGenSamplers(static_cast<GLsizei>(count0), __qt_samplers1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGenTransformFeedbacks(GLsizei,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGenTransformFeedbacks_1native_1GLsizei_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject ids1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGenTransformFeedbacks(GLsizei,GLuint*)", __this_nativeId)
        JBufferData __qt_ids1_buffer(__jni_env, ids1);
        GLuint* __qt_ids1 = __qt_ids1_buffer.data<GLuint>();
        __qt_this->glGenTransformFeedbacks(static_cast<GLsizei>(n0), __qt_ids1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGenVertexArrays(GLsizei,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGenVertexArrays_1native_1GLsizei_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject arrays1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGenVertexArrays(GLsizei,GLuint*)", __this_nativeId)
        JBufferData __qt_arrays1_buffer(__jni_env, arrays1);
        GLuint* __qt_arrays1 = __qt_arrays1_buffer.data<GLuint>();
        __qt_this->glGenVertexArrays(static_cast<GLsizei>(n0), __qt_arrays1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetActiveUniformBlockName(GLuint,GLuint,GLsizei,GLsizei*,GLchar*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetActiveUniformBlockName_1native_1GLuint_1GLuint_1GLsizei_1GLsizei_1ptr_1GLchar_1ptr__JIIILjava_nio_IntBuffer_2Ljava_nio_CharBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint uniformBlockIndex1,
 jint bufSize2,
 jobject length3,
 jobject uniformBlockName4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetActiveUniformBlockName(GLuint,GLuint,GLsizei,GLsizei*,GLchar*)", __this_nativeId)
        JBufferData __qt_length3_buffer(__jni_env, length3);
        GLsizei* __qt_length3 = __qt_length3_buffer.data<GLsizei>();
        JBufferData __qt_uniformBlockName4_buffer(__jni_env, uniformBlockName4);
        GLchar* __qt_uniformBlockName4 = __qt_uniformBlockName4_buffer.data<GLchar>();
        __qt_this->glGetActiveUniformBlockName(static_cast<GLuint>(program0), static_cast<GLuint>(uniformBlockIndex1), static_cast<GLsizei>(bufSize2), __qt_length3, __qt_uniformBlockName4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetActiveUniformBlockiv(GLuint,GLuint,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetActiveUniformBlockiv_1native_1GLuint_1GLuint_1GLenum_1GLint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint uniformBlockIndex1,
 jint pname2,
 jobject params3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetActiveUniformBlockiv(GLuint,GLuint,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params3_buffer(__jni_env, params3);
        GLint* __qt_params3 = __qt_params3_buffer.data<GLint>();
        __qt_this->glGetActiveUniformBlockiv(static_cast<GLuint>(program0), static_cast<GLuint>(uniformBlockIndex1), static_cast<GLenum>(pname2), __qt_params3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetActiveUniformsiv(GLuint,GLsizei,const GLuint*,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetActiveUniformsiv_1native_1GLuint_1GLsizei_1const_1GLuint_1ptr_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2ILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint uniformCount1,
 jobject uniformIndices2,
 jint pname3,
 jobject params4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetActiveUniformsiv(GLuint,GLsizei,const GLuint*,GLenum,GLint*)", __this_nativeId)
        JBufferConstData __qt_uniformIndices2_buffer(__jni_env, uniformIndices2);
        const GLuint* __qt_uniformIndices2 = __qt_uniformIndices2_buffer.data<GLuint>();
        JBufferData __qt_params4_buffer(__jni_env, params4);
        GLint* __qt_params4 = __qt_params4_buffer.data<GLint>();
        __qt_this->glGetActiveUniformsiv(static_cast<GLuint>(program0), static_cast<GLsizei>(uniformCount1), __qt_uniformIndices2, static_cast<GLenum>(pname3), __qt_params4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetBooleani_v(GLenum,GLuint,GLboolean*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetBooleani_1v_1native_1GLenum_1GLuint_1GLboolean_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint index1,
 jobject data2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetBooleani_v(GLenum,GLuint,GLboolean*)", __this_nativeId)
        JBufferData __qt_data2(__jni_env, data2);
        __qt_this->glGetBooleani_v(static_cast<GLenum>(target0), static_cast<GLuint>(index1), __qt_data2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetBufferParameteri64v(GLenum,GLenum,GLint64*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetBufferParameteri64v_1native_1GLenum_1GLenum_1GLint64_1ptr__JIILjava_nio_LongBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetBufferParameteri64v(GLenum,GLenum,GLint64*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint64* __qt_params2 = __qt_params2_buffer.data<GLint64>();
        __qt_this->glGetBufferParameteri64v(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetBufferPointerv(GLenum,GLenum,void**)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetBufferPointerv_1native_1GLenum_1GLenum_1void_1ptr_1ptr__JII_3Ljava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobjectArray params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetBufferPointerv(GLenum,GLenum,void**)", __this_nativeId)
        JObjectArrayPointer<void*> __qt_params2(__jni_env, jobjectArray(params2),
                                        [](void* & pointer,JNIEnv *, jobject){
                                            pointer = nullptr;
                                        },
                                        [](JNIEnv * env, void* const& ptr) -> jobject {
                                            return DataJBuffer(env, ptr, INT_MAX).take();
                                        }
                                    );
        __qt_this->glGetBufferPointerv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetDebugMessageLog(GLuint,GLsizei,GLenum*,GLenum*,GLuint*,GLenum*,GLsizei*,GLchar*)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetDebugMessageLog_1native_1GLuint_1GLsizei_1GLenum_1ptr_1GLenum_1ptr_1GLuint_1ptr_1GLenum_1ptr_1GLsizei_1ptr_1GLchar_1ptr__J_3I_3I_3I_3I_3Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jintArray sources2,
 jintArray types3,
 jintArray ids4,
 jintArray severities5,
 jobjectArray messageLog7)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetDebugMessageLog(GLuint,GLsizei,GLenum*,GLenum*,GLuint*,GLenum*,GLsizei*,GLchar*)", __this_nativeId)
        GLuint __qt_count0 = GLuint(__jni_env->GetArrayLength(jarray(sources2)));
        __qt_count0 = qMin(__qt_count0, GLuint(__jni_env->GetArrayLength(jarray(types3))));
        __qt_count0 = qMin(__qt_count0, GLuint(__jni_env->GetArrayLength(jarray(ids4))));
        __qt_count0 = qMin(__qt_count0, GLuint(__jni_env->GetArrayLength(jarray(messageLog7))));
        GLsizei __qt_bufSize1 = GL_MAX_LABEL_LENGTH;
        GLenum* __qt_sources2 = qtjambi_array_cast<GLenum*>(__jni_env, __qtjambi_scope, sources2, 1);
        GLenum* __qt_types3 = qtjambi_array_cast<GLenum*>(__jni_env, __qtjambi_scope, types3, 1);
        GLuint* __qt_ids4 = qtjambi_array_cast<GLuint*>(__jni_env, __qtjambi_scope, ids4, 1);
        GLenum* __qt_severities5 = qtjambi_array_cast<GLenum*>(__jni_env, __qtjambi_scope, severities5, 1);
        QScopedArrayPointer<GLsizei> lengths6(new GLsizei[__qt_count0]);
        GLsizei* __qt_lengths6 = lengths6.get();
        QByteArray __qt_messageLog7_buffer(GL_MAX_LABEL_LENGTH, '\0');
        char* __qt_messageLog7 = __qt_messageLog7_buffer.data();
        GLuint __qt_return_value = __qt_this->glGetDebugMessageLog(GLuint(__qt_count0), GLsizei(__qt_bufSize1), __qt_sources2, __qt_types3, __qt_ids4, __qt_severities5, __qt_lengths6, __qt_messageLog7);
        __java_return_value = jint(__qt_return_value);
        int offset = 0;
        for(jsize i=0; i<jsize(__qt_return_value); ++i){
            jstring result = qtjambi_cast<jstring>(__jni_env, QString::fromLocal8Bit(__qt_messageLog7+offset, __qt_lengths6[i]));
            offset += __qt_lengths6[i];
            __jni_env->SetObjectArrayElement(messageLog7, i, result);
        }
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glGetFragDataLocation(GLuint,const GLchar*)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetFragDataLocation_1native_1GLuint_1const_1GLchar_1ptr__JILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jstring name1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetFragDataLocation(GLuint,const GLchar*)", __this_nativeId)
        J2CStringBuffer __qt_name1(__jni_env, jstring(name1));
        GLint __qt_return_value = __qt_this->glGetFragDataLocation(static_cast<GLuint>(program0), __qt_name1);
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glGetFramebufferParameteriv(GLenum,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetFramebufferParameteriv_1native_1GLenum_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetFramebufferParameteriv(GLenum,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetFramebufferParameteriv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetGraphicsResetStatus()
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetGraphicsResetStatus_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetGraphicsResetStatus()", __this_nativeId)
        GLenum __qt_return_value = __qt_this->glGetGraphicsResetStatus();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glGetInteger64i_v(GLenum,GLuint,GLint64*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetInteger64i_1v_1native_1GLenum_1GLuint_1GLint64_1ptr__JIILjava_nio_LongBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint index1,
 jobject data2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetInteger64i_v(GLenum,GLuint,GLint64*)", __this_nativeId)
        JBufferData __qt_data2_buffer(__jni_env, data2);
        GLint64* __qt_data2 = __qt_data2_buffer.data<GLint64>();
        __qt_this->glGetInteger64i_v(static_cast<GLenum>(target0), static_cast<GLuint>(index1), __qt_data2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetInteger64v(GLenum,GLint64*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetInteger64v_1native_1GLenum_1GLint64_1ptr__JILjava_nio_LongBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pname0,
 jobject data1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetInteger64v(GLenum,GLint64*)", __this_nativeId)
        JBufferData __qt_data1_buffer(__jni_env, data1);
        GLint64* __qt_data1 = __qt_data1_buffer.data<GLint64>();
        __qt_this->glGetInteger64v(static_cast<GLenum>(pname0), __qt_data1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetIntegeri_v(GLenum,GLuint,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetIntegeri_1v_1native_1GLenum_1GLuint_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint index1,
 jobject data2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetIntegeri_v(GLenum,GLuint,GLint*)", __this_nativeId)
        JBufferData __qt_data2_buffer(__jni_env, data2);
        GLint* __qt_data2 = __qt_data2_buffer.data<GLint>();
        __qt_this->glGetIntegeri_v(static_cast<GLenum>(target0), static_cast<GLuint>(index1), __qt_data2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetInternalformativ(GLenum,GLenum,GLenum,GLsizei,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetInternalformativ_1native_1GLenum_1GLenum_1GLenum_1GLsizei_1GLint_1ptr__JIIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint internalformat1,
 jint pname2,
 jint bufSize3,
 jobject params4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetInternalformativ(GLenum,GLenum,GLenum,GLsizei,GLint*)", __this_nativeId)
        JBufferData __qt_params4_buffer(__jni_env, params4);
        GLint* __qt_params4 = __qt_params4_buffer.data<GLint>();
        __qt_this->glGetInternalformativ(static_cast<GLenum>(target0), static_cast<GLenum>(internalformat1), static_cast<GLenum>(pname2), static_cast<GLsizei>(bufSize3), __qt_params4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetMultisamplefv(GLenum,GLuint,GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetMultisamplefv_1native_1GLenum_1GLuint_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pname0,
 jint index1,
 jobject val2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetMultisamplefv(GLenum,GLuint,GLfloat*)", __this_nativeId)
        JBufferData __qt_val2_buffer(__jni_env, val2);
        GLfloat* __qt_val2 = __qt_val2_buffer.data<GLfloat>();
        __qt_this->glGetMultisamplefv(static_cast<GLenum>(pname0), static_cast<GLuint>(index1), __qt_val2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetObjectLabel(GLenum,GLuint,GLsizei,GLsizei*,GLchar*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetObjectLabel_1native_1GLenum_1GLuint_1GLsizei_1GLsizei_1ptr_1GLchar_1ptr__JII_3Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint identifier0,
 jint name1,
 jobjectArray label4)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetObjectLabel(GLenum,GLuint,GLsizei,GLsizei*,GLchar*)", __this_nativeId)
        GLsizei __qt_bufSize2 = GL_MAX_LABEL_LENGTH;
        GLsizei length3 = 0;
        GLsizei* __qt_length3 = &length3;
        QByteArray __qt_label4_buffer(GL_MAX_LABEL_LENGTH, '\0');
        char* __qt_label4 = __qt_label4_buffer.data();
        __qtjambi_scope.addFinalAction([&](){
            jstring result = qtjambi_cast<jstring>(__jni_env, QString::fromLocal8Bit(__qt_label4, length3));
            __jni_env->SetObjectArrayElement(label4, 0, result);
        });
        __qt_this->glGetObjectLabel(static_cast<GLenum>(identifier0), static_cast<GLuint>(name1), GLsizei(__qt_bufSize2), __qt_length3, __qt_label4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetObjectPtrLabel(const void*,GLsizei,GLsizei*,GLchar*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetObjectPtrLabel_1native_1const_1void_1ptr_1GLsizei_1GLsizei_1ptr_1GLchar_1ptr__JLio_qt_gui_gl_GLsync_2_3Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject ptr0,
 jobjectArray label3)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetObjectPtrLabel(const void*,GLsizei,GLsizei*,GLchar*)", __this_nativeId)
        const void* __qt_ptr0 = QtJambiAPI::convertJavaObjectToNative(__jni_env, ptr0);
        GLsizei __qt_bufSize1 = GL_MAX_LABEL_LENGTH;
        GLsizei length2 = 0;
        GLsizei* __qt_length2 = &length2;
        QByteArray __qt_label3_buffer(GL_MAX_LABEL_LENGTH, '\0');
        char* __qt_label3 = __qt_label3_buffer.data();
        __qtjambi_scope.addFinalAction([&](){
            jstring result = qtjambi_cast<jstring>(__jni_env, QString::fromLocal8Bit(__qt_label3, length2));
            __jni_env->SetObjectArrayElement(label3, 0, result);
        });
        __qt_this->glGetObjectPtrLabel(__qt_ptr0, GLsizei(__qt_bufSize1), __qt_length2, __qt_label3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetPointerv(GLenum,void**)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetPointerv_1native_1GLenum_1void_1ptr_1ptr__JI_3Ljava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pname0,
 jobjectArray params1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetPointerv(GLenum,void**)", __this_nativeId)
        JObjectArrayPointer<void*> __qt_params1(__jni_env, jobjectArray(params1),
                                        [](void* & pointer,JNIEnv *, jobject){
                                            pointer = nullptr;
                                        },
                                        [](JNIEnv * env, void* const& ptr) -> jobject {
                                            return DataJBuffer(env, ptr, INT_MAX).take();
                                        }
                                    );
        if(__qt_params1.size()==0){
            JavaException::raiseIllegalArgumentException(__jni_env, "Array length is 0." QTJAMBI_STACKTRACEINFO );
        }
        __qt_this->glGetPointerv(static_cast<GLenum>(pname0), __qt_params1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetProgramBinary(GLuint,GLsizei,GLsizei*,GLenum*,void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetProgramBinary_1native_1GLuint_1GLsizei_1GLsizei_1ptr_1GLenum_1ptr_1void_1ptr__JIILjava_nio_IntBuffer_2Ljava_nio_IntBuffer_2Ljava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint bufSize1,
 jobject length2,
 jobject binaryFormat3,
 jobject binary4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetProgramBinary(GLuint,GLsizei,GLsizei*,GLenum*,void*)", __this_nativeId)
        JBufferData __qt_length2_buffer(__jni_env, length2);
        GLsizei* __qt_length2 = __qt_length2_buffer.data<GLsizei>();
        JBufferData __qt_binaryFormat3_buffer(__jni_env, binaryFormat3);
        GLenum* __qt_binaryFormat3 = __qt_binaryFormat3_buffer.data<GLenum>();
        JBufferData __qt_binary4_buffer(__jni_env, binary4);
        void* __qt_binary4 = __qt_binary4_buffer.data<void>();
        __qt_this->glGetProgramBinary(static_cast<GLuint>(program0), static_cast<GLsizei>(bufSize1), __qt_length2, __qt_binaryFormat3, __qt_binary4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetProgramInterfaceiv(GLuint,GLenum,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetProgramInterfaceiv_1native_1GLuint_1GLenum_1GLenum_1GLint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint programInterface1,
 jint pname2,
 jobject params3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetProgramInterfaceiv(GLuint,GLenum,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params3_buffer(__jni_env, params3);
        GLint* __qt_params3 = __qt_params3_buffer.data<GLint>();
        __qt_this->glGetProgramInterfaceiv(static_cast<GLuint>(program0), static_cast<GLenum>(programInterface1), static_cast<GLenum>(pname2), __qt_params3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetProgramPipelineInfoLog(GLuint,GLsizei,GLsizei*,GLchar*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetProgramPipelineInfoLog_1native_1GLuint_1GLsizei_1GLsizei_1ptr_1GLchar_1ptr__JI_3Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pipeline0,
 jobjectArray infoLog3)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetProgramPipelineInfoLog(GLuint,GLsizei,GLsizei*,GLchar*)", __this_nativeId)
        GLsizei __qt_bufSize1 = GL_MAX_LABEL_LENGTH;
        GLsizei length2 = 0;
        GLsizei* __qt_length2 = &length2;
        QByteArray __qt_infoLog3_buffer(GL_MAX_LABEL_LENGTH, '\0');
        char* __qt_infoLog3 = __qt_infoLog3_buffer.data();
        __qtjambi_scope.addFinalAction([&](){
            jstring result = qtjambi_cast<jstring>(__jni_env, QString::fromLocal8Bit(__qt_infoLog3, length2));
            __jni_env->SetObjectArrayElement(infoLog3, 0, result);
        });
        __qt_this->glGetProgramPipelineInfoLog(static_cast<GLuint>(pipeline0), GLsizei(__qt_bufSize1), __qt_length2, __qt_infoLog3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetProgramPipelineiv(GLuint,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetProgramPipelineiv_1native_1GLuint_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pipeline0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetProgramPipelineiv(GLuint,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetProgramPipelineiv(static_cast<GLuint>(pipeline0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetProgramResourceIndex(GLuint,GLenum,const GLchar*)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetProgramResourceIndex_1native_1GLuint_1GLenum_1const_1GLchar_1ptr__JIILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint programInterface1,
 jstring name2)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetProgramResourceIndex(GLuint,GLenum,const GLchar*)", __this_nativeId)
        J2CStringBuffer __qt_name2(__jni_env, jstring(name2));
        GLuint __qt_return_value = __qt_this->glGetProgramResourceIndex(static_cast<GLuint>(program0), static_cast<GLenum>(programInterface1), __qt_name2);
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glGetProgramResourceLocation(GLuint,GLenum,const GLchar*)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetProgramResourceLocation_1native_1GLuint_1GLenum_1const_1GLchar_1ptr__JIILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint programInterface1,
 jstring name2)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetProgramResourceLocation(GLuint,GLenum,const GLchar*)", __this_nativeId)
        J2CStringBuffer __qt_name2(__jni_env, jstring(name2));
        GLint __qt_return_value = __qt_this->glGetProgramResourceLocation(static_cast<GLuint>(program0), static_cast<GLenum>(programInterface1), __qt_name2);
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glGetProgramResourceName(GLuint,GLenum,GLuint,GLsizei,GLsizei*,GLchar*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetProgramResourceName_1native_1GLuint_1GLenum_1GLuint_1GLsizei_1GLsizei_1ptr_1GLchar_1ptr__JIII_3Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint programInterface1,
 jint index2,
 jobjectArray name5)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetProgramResourceName(GLuint,GLenum,GLuint,GLsizei,GLsizei*,GLchar*)", __this_nativeId)
        GLsizei __qt_bufSize3 = GL_MAX_LABEL_LENGTH;
        GLsizei length4 = 0;
        GLsizei* __qt_length4 = &length4;
        QByteArray __qt_name5_buffer(GL_MAX_LABEL_LENGTH, '\0');
        char* __qt_name5 = __qt_name5_buffer.data();
        __qtjambi_scope.addFinalAction([&](){
            jstring result = qtjambi_cast<jstring>(__jni_env, QString::fromLocal8Bit(__qt_name5, length4));
            __jni_env->SetObjectArrayElement(name5, 0, result);
        });
        __qt_this->glGetProgramResourceName(static_cast<GLuint>(program0), static_cast<GLenum>(programInterface1), static_cast<GLuint>(index2), GLsizei(__qt_bufSize3), __qt_length4, __qt_name5);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetProgramResourceiv(GLuint,GLenum,GLuint,GLsizei,const GLenum*,GLsizei,GLsizei*,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetProgramResourceiv_1native_1GLuint_1GLenum_1GLuint_1GLsizei_1const_1GLenum_1ptr_1GLsizei_1GLsizei_1ptr_1GLint_1ptr__JIIIILjava_nio_IntBuffer_2ILjava_nio_IntBuffer_2Ljava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint programInterface1,
 jint index2,
 jint propCount3,
 jobject props4,
 jint bufSize5,
 jobject length6,
 jobject params7)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetProgramResourceiv(GLuint,GLenum,GLuint,GLsizei,const GLenum*,GLsizei,GLsizei*,GLint*)", __this_nativeId)
        JBufferConstData __qt_props4_buffer(__jni_env, props4);
        const GLenum* __qt_props4 = __qt_props4_buffer.data<GLenum>();
        JBufferData __qt_length6_buffer(__jni_env, length6);
        GLsizei* __qt_length6 = __qt_length6_buffer.data<GLsizei>();
        JBufferData __qt_params7_buffer(__jni_env, params7);
        GLint* __qt_params7 = __qt_params7_buffer.data<GLint>();
        __qt_this->glGetProgramResourceiv(static_cast<GLuint>(program0), static_cast<GLenum>(programInterface1), static_cast<GLuint>(index2), static_cast<GLsizei>(propCount3), __qt_props4, static_cast<GLsizei>(bufSize5), __qt_length6, __qt_params7);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetQueryObjectuiv(GLuint,GLenum,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetQueryObjectuiv_1native_1GLuint_1GLenum_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint id0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetQueryObjectuiv(GLuint,GLenum,GLuint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLuint* __qt_params2 = __qt_params2_buffer.data<GLuint>();
        __qt_this->glGetQueryObjectuiv(static_cast<GLuint>(id0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetQueryiv(GLenum,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetQueryiv_1native_1GLenum_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetQueryiv(GLenum,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetQueryiv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetSamplerParameterIiv(GLuint,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetSamplerParameterIiv_1native_1GLuint_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampler0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetSamplerParameterIiv(GLuint,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetSamplerParameterIiv(static_cast<GLuint>(sampler0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetSamplerParameterIuiv(GLuint,GLenum,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetSamplerParameterIuiv_1native_1GLuint_1GLenum_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampler0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetSamplerParameterIuiv(GLuint,GLenum,GLuint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLuint* __qt_params2 = __qt_params2_buffer.data<GLuint>();
        __qt_this->glGetSamplerParameterIuiv(static_cast<GLuint>(sampler0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetSamplerParameterfv(GLuint,GLenum,GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetSamplerParameterfv_1native_1GLuint_1GLenum_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampler0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetSamplerParameterfv(GLuint,GLenum,GLfloat*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLfloat* __qt_params2 = __qt_params2_buffer.data<GLfloat>();
        __qt_this->glGetSamplerParameterfv(static_cast<GLuint>(sampler0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetSamplerParameteriv(GLuint,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetSamplerParameteriv_1native_1GLuint_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampler0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetSamplerParameteriv(GLuint,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetSamplerParameteriv(static_cast<GLuint>(sampler0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetStringi(GLenum,GLuint)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetStringi_1native_1GLenum_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint name0,
 jint index1)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetStringi(GLenum,GLuint)", __this_nativeId)
        const GLubyte* __qt_return_value = __qt_this->glGetStringi(static_cast<GLenum>(name0), static_cast<GLuint>(index1));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, QLatin1String(reinterpret_cast<const char *>(__qt_return_value)));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glGetSynciv(GLsync,GLenum,GLsizei,GLsizei*,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetSynciv_1native_1_1_1GLsync_1ptr_1GLenum_1GLsizei_1GLsizei_1ptr_1GLint_1ptr__JJI_3ILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID sync0,
 jint pname1,
 jintArray length3,
 jobject values4)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetSynciv(GLsync,GLenum,GLsizei,GLsizei*,GLint*)", __this_nativeId)
        __GLsync* __qt_sync0 = QtJambiAPI::objectFromNativeId<__GLsync>(sync0);
        GLsizei* __qt_length3 = qtjambi_array_cast<GLsizei*>(__jni_env, __qtjambi_scope, length3, 1);
        JBufferData __qt_values4(__jni_env, values4);
        GLsizei bufSize2 = GLsizei(__qt_values4.size());
        __qt_this->glGetSynciv(__qt_sync0, static_cast<GLenum>(pname1), static_cast<GLsizei>(bufSize2), __qt_length3, __qt_values4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetTexLevelParameterfv(GLenum,GLint,GLenum,GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetTexLevelParameterfv_1native_1GLenum_1GLint_1GLenum_1GLfloat_1ptr__JIIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint pname2,
 jobject params3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetTexLevelParameterfv(GLenum,GLint,GLenum,GLfloat*)", __this_nativeId)
        JBufferData __qt_params3_buffer(__jni_env, params3);
        GLfloat* __qt_params3 = __qt_params3_buffer.data<GLfloat>();
        __qt_this->glGetTexLevelParameterfv(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLenum>(pname2), __qt_params3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetTexLevelParameteriv(GLenum,GLint,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetTexLevelParameteriv_1native_1GLenum_1GLint_1GLenum_1GLint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint pname2,
 jobject params3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetTexLevelParameteriv(GLenum,GLint,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params3_buffer(__jni_env, params3);
        GLint* __qt_params3 = __qt_params3_buffer.data<GLint>();
        __qt_this->glGetTexLevelParameteriv(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLenum>(pname2), __qt_params3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetTexParameterIiv(GLenum,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetTexParameterIiv_1native_1GLenum_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetTexParameterIiv(GLenum,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetTexParameterIiv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetTexParameterIuiv(GLenum,GLenum,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetTexParameterIuiv_1native_1GLenum_1GLenum_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetTexParameterIuiv(GLenum,GLenum,GLuint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLuint* __qt_params2 = __qt_params2_buffer.data<GLuint>();
        __qt_this->glGetTexParameterIuiv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetTransformFeedbackVarying(GLuint,GLuint,GLsizei,GLsizei*,GLsizei*,GLenum*,GLchar*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetTransformFeedbackVarying_1native_1GLuint_1GLuint_1GLsizei_1GLsizei_1ptr_1GLsizei_1ptr_1GLenum_1ptr_1GLchar_1ptr__JII_3I_3I_3Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint index1,
 jintArray size4,
 jintArray type5,
 jobjectArray name6)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetTransformFeedbackVarying(GLuint,GLuint,GLsizei,GLsizei*,GLsizei*,GLenum*,GLchar*)", __this_nativeId)
        GLsizei __qt_bufSize2 = GL_MAX_LABEL_LENGTH;
        GLsizei length3 = 0;
        GLsizei* __qt_length3 = &length3;
        GLsizei* __qt_size4 = qtjambi_array_cast<GLsizei*>(__jni_env, __qtjambi_scope, size4, 1);
        GLenum* __qt_type5 = qtjambi_array_cast<GLenum*>(__jni_env, __qtjambi_scope, type5, 1);
        QByteArray __qt_name6_buffer(GL_MAX_LABEL_LENGTH, '\0');
        char* __qt_name6 = __qt_name6_buffer.data();
        __qtjambi_scope.addFinalAction([&](){
            jstring result = qtjambi_cast<jstring>(__jni_env, QString::fromLocal8Bit(__qt_name6, length3));
            __jni_env->SetObjectArrayElement(name6, 0, result);
        });
        __qt_this->glGetTransformFeedbackVarying(static_cast<GLuint>(program0), static_cast<GLuint>(index1), GLsizei(__qt_bufSize2), __qt_length3, __qt_size4, __qt_type5, __qt_name6);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetUniformBlockIndex(GLuint,const GLchar*)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetUniformBlockIndex_1native_1GLuint_1const_1GLchar_1ptr__JILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jstring uniformBlockName1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetUniformBlockIndex(GLuint,const GLchar*)", __this_nativeId)
        J2CStringBuffer __qt_uniformBlockName1(__jni_env, jstring(uniformBlockName1));
        GLuint __qt_return_value = __qt_this->glGetUniformBlockIndex(static_cast<GLuint>(program0), __qt_uniformBlockName1);
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glGetUniformIndices(GLuint,GLsizei,const GLchar*const*,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetUniformIndices_1native_1GLuint_1GLsizei_1const_1GLchar_1cptr_1ptr_1GLuint_1ptr__JI_3Ljava_lang_String_2_3I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jobjectArray uniformNames2,
 jintArray uniformIndices3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetUniformIndices(GLuint,GLsizei,const GLchar*const*,GLuint*)", __this_nativeId)
        jsize __qt_uniformCount1 = qMin(__jni_env->GetArrayLength(jarray(uniformNames2)), __jni_env->GetArrayLength(jarray(uniformIndices3)));
        QVector<QSharedPointer<J2CStringBuffer>> uniformNames2Vec;
        const char** __qt_uniformNames2 = nullptr;
        QScopedArrayPointer<const char*> __qt_uniformNames2Ptr(__qt_uniformNames2 = new const char*[quint32(__qt_uniformCount1)]);
        for(jsize i=0; i<__qt_uniformCount1; ++i){
            J2CStringBuffer* b = new J2CStringBuffer(__jni_env, jstring(__jni_env->GetObjectArrayElement(jobjectArray(uniformNames2), i)));
            __qt_uniformNames2[i] = *b;
            uniformNames2Vec << QSharedPointer<J2CStringBuffer>(b);
        }
        JIntArrayPointer __qt_uniformIndices3(__jni_env, uniformIndices3);
        __qt_this->glGetUniformIndices(static_cast<GLuint>(program0), GLsizei(__qt_uniformCount1), __qt_uniformNames2, __qt_uniformIndices3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetUniformuiv(GLuint,GLint,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetUniformuiv_1native_1GLuint_1GLint_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetUniformuiv(GLuint,GLint,GLuint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLuint* __qt_params2 = __qt_params2_buffer.data<GLuint>();
        __qt_this->glGetUniformuiv(static_cast<GLuint>(program0), static_cast<GLint>(location1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetVertexAttribIiv(GLuint,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetVertexAttribIiv_1native_1GLuint_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetVertexAttribIiv(GLuint,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2(__jni_env, params2);
        __qt_this->glGetVertexAttribIiv(static_cast<GLuint>(index0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetVertexAttribIuiv(GLuint,GLenum,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetVertexAttribIuiv_1native_1GLuint_1GLenum_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetVertexAttribIuiv(GLuint,GLenum,GLuint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLuint* __qt_params2 = __qt_params2_buffer.data<GLuint>();
        __qt_this->glGetVertexAttribIuiv(static_cast<GLuint>(index0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetnUniformfv(GLuint,GLint,GLsizei,GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetnUniformfv_1native_1GLuint_1GLint_1GLsizei_1GLfloat_1ptr__JIIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint bufSize2,
 jobject params3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetnUniformfv(GLuint,GLint,GLsizei,GLfloat*)", __this_nativeId)
        JBufferData __qt_params3_buffer(__jni_env, params3);
        GLfloat* __qt_params3 = __qt_params3_buffer.data<GLfloat>();
        __qt_this->glGetnUniformfv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(bufSize2), __qt_params3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetnUniformiv(GLuint,GLint,GLsizei,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetnUniformiv_1native_1GLuint_1GLint_1GLsizei_1GLint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint bufSize2,
 jobject params3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetnUniformiv(GLuint,GLint,GLsizei,GLint*)", __this_nativeId)
        JBufferData __qt_params3_buffer(__jni_env, params3);
        GLint* __qt_params3 = __qt_params3_buffer.data<GLint>();
        __qt_this->glGetnUniformiv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(bufSize2), __qt_params3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glGetnUniformuiv(GLuint,GLint,GLsizei,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glGetnUniformuiv_1native_1GLuint_1GLint_1GLsizei_1GLuint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint bufSize2,
 jobject params3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glGetnUniformuiv(GLuint,GLint,GLsizei,GLuint*)", __this_nativeId)
        JBufferData __qt_params3_buffer(__jni_env, params3);
        GLuint* __qt_params3 = __qt_params3_buffer.data<GLuint>();
        __qt_this->glGetnUniformuiv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(bufSize2), __qt_params3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glInvalidateFramebuffer(GLenum,GLsizei,const GLenum*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glInvalidateFramebuffer_1native_1GLenum_1GLsizei_1const_1GLenum_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint numAttachments1,
 jobject attachments2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glInvalidateFramebuffer(GLenum,GLsizei,const GLenum*)", __this_nativeId)
        JBufferConstData __qt_attachments2_buffer(__jni_env, attachments2);
        const GLenum* __qt_attachments2 = __qt_attachments2_buffer.data<GLenum>();
        __qt_this->glInvalidateFramebuffer(static_cast<GLenum>(target0), static_cast<GLsizei>(numAttachments1), __qt_attachments2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glInvalidateSubFramebuffer(GLenum,GLsizei,const GLenum*,GLint,GLint,GLsizei,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glInvalidateSubFramebuffer_1native_1GLenum_1GLsizei_1const_1GLenum_1ptr_1GLint_1GLint_1GLsizei_1GLsizei__JIILjava_nio_IntBuffer_2IIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint numAttachments1,
 jobject attachments2,
 jint x3,
 jint y4,
 jint width5,
 jint height6)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glInvalidateSubFramebuffer(GLenum,GLsizei,const GLenum*,GLint,GLint,GLsizei,GLsizei)", __this_nativeId)
        JBufferConstData __qt_attachments2_buffer(__jni_env, attachments2);
        const GLenum* __qt_attachments2 = __qt_attachments2_buffer.data<GLenum>();
        __qt_this->glInvalidateSubFramebuffer(static_cast<GLenum>(target0), static_cast<GLsizei>(numAttachments1), __qt_attachments2, static_cast<GLint>(x3), static_cast<GLint>(y4), static_cast<GLsizei>(width5), static_cast<GLsizei>(height6));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glIsEnabledi(GLenum,GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glIsEnabledi_1native_1GLenum_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint index1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glIsEnabledi(GLenum,GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsEnabledi(static_cast<GLenum>(target0), static_cast<GLuint>(index1));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glIsProgramPipeline(GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glIsProgramPipeline_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pipeline0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glIsProgramPipeline(GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsProgramPipeline(static_cast<GLuint>(pipeline0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glIsQuery(GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glIsQuery_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint id0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glIsQuery(GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsQuery(static_cast<GLuint>(id0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glIsSampler(GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glIsSampler_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampler0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glIsSampler(GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsSampler(static_cast<GLuint>(sampler0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glIsSync(GLsync)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glIsSync_1native_1_1_1GLsync_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID sync0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glIsSync(GLsync)", __this_nativeId)
        __GLsync* __qt_sync0 = QtJambiAPI::objectFromNativeId<__GLsync>(sync0);
        GLboolean __qt_return_value = __qt_this->glIsSync(__qt_sync0);
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glIsTransformFeedback(GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glIsTransformFeedback_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint id0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glIsTransformFeedback(GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsTransformFeedback(static_cast<GLuint>(id0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glIsVertexArray(GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glIsVertexArray_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint array0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glIsVertexArray(GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsVertexArray(static_cast<GLuint>(array0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glMapBufferRange(GLenum,GLintptr,GLsizeiptr,GLbitfield)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glMapBufferRange_1native_1GLenum_1GLintptr_1GLsizeiptr_1GLbitfield__JIJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jlong offset1,
 jint access3)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glMapBufferRange(GLenum,GLintptr,GLsizeiptr,GLbitfield)", __this_nativeId)
        GLsizeiptr length2{0};
        void* __qt_return_value = __qt_this->glMapBufferRange(static_cast<GLenum>(target0), static_cast<GLintptr>(offset1), static_cast<GLsizeiptr>(length2), static_cast<GLbitfield>(access3));
        DataJBuffer __java_return_value_buffer(__jni_env, __qt_return_value, length2);
        __java_return_value = __java_return_value_buffer.take();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glMemoryBarrier(GLbitfield)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glMemoryBarrier_1native_1GLbitfield__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint barriers0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glMemoryBarrier(GLbitfield)", __this_nativeId)
        __qt_this->glMemoryBarrier(static_cast<GLbitfield>(barriers0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glMemoryBarrierByRegion(GLbitfield)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glMemoryBarrierByRegion_1native_1GLbitfield__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint barriers0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glMemoryBarrierByRegion(GLbitfield)", __this_nativeId)
        __qt_this->glMemoryBarrierByRegion(static_cast<GLbitfield>(barriers0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glMinSampleShading(GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glMinSampleShading_1native_1GLfloat__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat value0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glMinSampleShading(GLfloat)", __this_nativeId)
        __qt_this->glMinSampleShading(static_cast<GLfloat>(value0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glObjectLabel(GLenum,GLuint,GLsizei,const GLchar*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glObjectLabel_1native_1GLenum_1GLuint_1GLsizei_1const_1GLchar_1ptr__JIIILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint identifier0,
 jint name1,
 jint length2,
 jstring label3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glObjectLabel(GLenum,GLuint,GLsizei,const GLchar*)", __this_nativeId)
        J2CStringBuffer __qt_label3(__jni_env, jstring(label3));
        __qt_this->glObjectLabel(static_cast<GLenum>(identifier0), static_cast<GLuint>(name1), static_cast<GLsizei>(length2), __qt_label3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glObjectPtrLabel(const void*,GLsizei,const GLchar*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glObjectPtrLabel_1native_1const_1void_1ptr_1GLsizei_1const_1GLchar_1ptr__JLio_qt_gui_gl_GLsync_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject ptr0,
 jstring label2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glObjectPtrLabel(const void*,GLsizei,const GLchar*)", __this_nativeId)
        const void* __qt_ptr0 = QtJambiAPI::convertJavaObjectToNative(__jni_env, ptr0);
        J2CStringBuffer __qt_label2(__jni_env, label2);
        GLsizei length1(-1);
        __qt_this->glObjectPtrLabel(__qt_ptr0, static_cast<GLsizei>(length1), __qt_label2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glPatchParameteri(GLenum,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glPatchParameteri_1native_1GLenum_1GLint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pname0,
 jint value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glPatchParameteri(GLenum,GLint)", __this_nativeId)
        __qt_this->glPatchParameteri(static_cast<GLenum>(pname0), static_cast<GLint>(value1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glPauseTransformFeedback()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glPauseTransformFeedback_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glPauseTransformFeedback()", __this_nativeId)
        __qt_this->glPauseTransformFeedback();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glPopDebugGroup()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glPopDebugGroup_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glPopDebugGroup()", __this_nativeId)
        __qt_this->glPopDebugGroup();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glPrimitiveBoundingBox(GLfloat,GLfloat,GLfloat,GLfloat,GLfloat,GLfloat,GLfloat,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glPrimitiveBoundingBox_1native_1GLfloat_1GLfloat_1GLfloat_1GLfloat_1GLfloat_1GLfloat_1GLfloat_1GLfloat__JFFFFFFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat minX0,
 jfloat minY1,
 jfloat minZ2,
 jfloat minW3,
 jfloat maxX4,
 jfloat maxY5,
 jfloat maxZ6,
 jfloat maxW7)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glPrimitiveBoundingBox(GLfloat,GLfloat,GLfloat,GLfloat,GLfloat,GLfloat,GLfloat,GLfloat)", __this_nativeId)
        __qt_this->glPrimitiveBoundingBox(static_cast<GLfloat>(minX0), static_cast<GLfloat>(minY1), static_cast<GLfloat>(minZ2), static_cast<GLfloat>(minW3), static_cast<GLfloat>(maxX4), static_cast<GLfloat>(maxY5), static_cast<GLfloat>(maxZ6), static_cast<GLfloat>(maxW7));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramBinary(GLuint,GLenum,const void*,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramBinary_1native_1GLuint_1GLenum_1const_1void_1ptr_1GLsizei__JIILjava_nio_Buffer_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint binaryFormat1,
 jobject binary2,
 jint length3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramBinary(GLuint,GLenum,const void*,GLsizei)", __this_nativeId)
        JBufferConstData __qt_binary2_buffer(__jni_env, binary2);
        const void* __qt_binary2 = __qt_binary2_buffer.data<void>();
        __qt_this->glProgramBinary(static_cast<GLuint>(program0), static_cast<GLenum>(binaryFormat1), __qt_binary2, static_cast<GLsizei>(length3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramParameteri(GLuint,GLenum,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramParameteri_1native_1GLuint_1GLenum_1GLint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint pname1,
 jint value2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramParameteri(GLuint,GLenum,GLint)", __this_nativeId)
        __qt_this->glProgramParameteri(static_cast<GLuint>(program0), static_cast<GLenum>(pname1), static_cast<GLint>(value2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform1f(GLuint,GLint,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform1f_1native_1GLuint_1GLint_1GLfloat__JIIF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jfloat v02)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform1f(GLuint,GLint,GLfloat)", __this_nativeId)
        __qt_this->glProgramUniform1f(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLfloat>(v02));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform1fv(GLuint,GLint,GLsizei,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform1fv_1native_1GLuint_1GLint_1GLsizei_1const_1GLfloat_1ptr__JIIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform1fv(GLuint,GLint,GLsizei,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glProgramUniform1fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform1i(GLuint,GLint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform1i_1native_1GLuint_1GLint_1GLint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint v02)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform1i(GLuint,GLint,GLint)", __this_nativeId)
        __qt_this->glProgramUniform1i(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLint>(v02));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform1iv(GLuint,GLint,GLsizei,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform1iv_1native_1GLuint_1GLint_1GLsizei_1const_1GLint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform1iv(GLuint,GLint,GLsizei,const GLint*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLint* __qt_value3 = __qt_value3_buffer.data<GLint>();
        __qt_this->glProgramUniform1iv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform1ui(GLuint,GLint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform1ui_1native_1GLuint_1GLint_1GLuint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint v02)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform1ui(GLuint,GLint,GLuint)", __this_nativeId)
        __qt_this->glProgramUniform1ui(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLuint>(v02));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform1uiv(GLuint,GLint,GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform1uiv_1native_1GLuint_1GLint_1GLsizei_1const_1GLuint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform1uiv(GLuint,GLint,GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLuint* __qt_value3 = __qt_value3_buffer.data<GLuint>();
        __qt_this->glProgramUniform1uiv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform2f(GLuint,GLint,GLfloat,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform2f_1native_1GLuint_1GLint_1GLfloat_1GLfloat__JIIFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jfloat v02,
 jfloat v13)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform2f(GLuint,GLint,GLfloat,GLfloat)", __this_nativeId)
        __qt_this->glProgramUniform2f(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLfloat>(v02), static_cast<GLfloat>(v13));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform2fv(GLuint,GLint,GLsizei,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform2fv_1native_1GLuint_1GLint_1GLsizei_1const_1GLfloat_1ptr__JIIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform2fv(GLuint,GLint,GLsizei,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glProgramUniform2fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform2i(GLuint,GLint,GLint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform2i_1native_1GLuint_1GLint_1GLint_1GLint__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint v02,
 jint v13)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform2i(GLuint,GLint,GLint,GLint)", __this_nativeId)
        __qt_this->glProgramUniform2i(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLint>(v02), static_cast<GLint>(v13));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform2iv(GLuint,GLint,GLsizei,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform2iv_1native_1GLuint_1GLint_1GLsizei_1const_1GLint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform2iv(GLuint,GLint,GLsizei,const GLint*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLint* __qt_value3 = __qt_value3_buffer.data<GLint>();
        __qt_this->glProgramUniform2iv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform2ui(GLuint,GLint,GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform2ui_1native_1GLuint_1GLint_1GLuint_1GLuint__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint v02,
 jint v13)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform2ui(GLuint,GLint,GLuint,GLuint)", __this_nativeId)
        __qt_this->glProgramUniform2ui(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLuint>(v02), static_cast<GLuint>(v13));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform2uiv(GLuint,GLint,GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform2uiv_1native_1GLuint_1GLint_1GLsizei_1const_1GLuint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform2uiv(GLuint,GLint,GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLuint* __qt_value3 = __qt_value3_buffer.data<GLuint>();
        __qt_this->glProgramUniform2uiv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform3f(GLuint,GLint,GLfloat,GLfloat,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform3f_1native_1GLuint_1GLint_1GLfloat_1GLfloat_1GLfloat__JIIFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jfloat v02,
 jfloat v13,
 jfloat v24)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform3f(GLuint,GLint,GLfloat,GLfloat,GLfloat)", __this_nativeId)
        __qt_this->glProgramUniform3f(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLfloat>(v02), static_cast<GLfloat>(v13), static_cast<GLfloat>(v24));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform3fv(GLuint,GLint,GLsizei,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform3fv_1native_1GLuint_1GLint_1GLsizei_1const_1GLfloat_1ptr__JIIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform3fv(GLuint,GLint,GLsizei,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glProgramUniform3fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform3i(GLuint,GLint,GLint,GLint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform3i_1native_1GLuint_1GLint_1GLint_1GLint_1GLint__JIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint v02,
 jint v13,
 jint v24)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform3i(GLuint,GLint,GLint,GLint,GLint)", __this_nativeId)
        __qt_this->glProgramUniform3i(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLint>(v02), static_cast<GLint>(v13), static_cast<GLint>(v24));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform3iv(GLuint,GLint,GLsizei,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform3iv_1native_1GLuint_1GLint_1GLsizei_1const_1GLint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform3iv(GLuint,GLint,GLsizei,const GLint*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLint* __qt_value3 = __qt_value3_buffer.data<GLint>();
        __qt_this->glProgramUniform3iv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform3ui(GLuint,GLint,GLuint,GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform3ui_1native_1GLuint_1GLint_1GLuint_1GLuint_1GLuint__JIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint v02,
 jint v13,
 jint v24)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform3ui(GLuint,GLint,GLuint,GLuint,GLuint)", __this_nativeId)
        __qt_this->glProgramUniform3ui(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLuint>(v02), static_cast<GLuint>(v13), static_cast<GLuint>(v24));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform3uiv(GLuint,GLint,GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform3uiv_1native_1GLuint_1GLint_1GLsizei_1const_1GLuint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform3uiv(GLuint,GLint,GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLuint* __qt_value3 = __qt_value3_buffer.data<GLuint>();
        __qt_this->glProgramUniform3uiv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform4f(GLuint,GLint,GLfloat,GLfloat,GLfloat,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform4f_1native_1GLuint_1GLint_1GLfloat_1GLfloat_1GLfloat_1GLfloat__JIIFFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jfloat v02,
 jfloat v13,
 jfloat v24,
 jfloat v35)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform4f(GLuint,GLint,GLfloat,GLfloat,GLfloat,GLfloat)", __this_nativeId)
        __qt_this->glProgramUniform4f(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLfloat>(v02), static_cast<GLfloat>(v13), static_cast<GLfloat>(v24), static_cast<GLfloat>(v35));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform4fv(GLuint,GLint,GLsizei,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform4fv_1native_1GLuint_1GLint_1GLsizei_1const_1GLfloat_1ptr__JIIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform4fv(GLuint,GLint,GLsizei,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glProgramUniform4fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform4i(GLuint,GLint,GLint,GLint,GLint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform4i_1native_1GLuint_1GLint_1GLint_1GLint_1GLint_1GLint__JIIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint v02,
 jint v13,
 jint v24,
 jint v35)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform4i(GLuint,GLint,GLint,GLint,GLint,GLint)", __this_nativeId)
        __qt_this->glProgramUniform4i(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLint>(v02), static_cast<GLint>(v13), static_cast<GLint>(v24), static_cast<GLint>(v35));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform4iv(GLuint,GLint,GLsizei,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform4iv_1native_1GLuint_1GLint_1GLsizei_1const_1GLint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform4iv(GLuint,GLint,GLsizei,const GLint*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLint* __qt_value3 = __qt_value3_buffer.data<GLint>();
        __qt_this->glProgramUniform4iv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform4ui(GLuint,GLint,GLuint,GLuint,GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform4ui_1native_1GLuint_1GLint_1GLuint_1GLuint_1GLuint_1GLuint__JIIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint v02,
 jint v13,
 jint v24,
 jint v35)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform4ui(GLuint,GLint,GLuint,GLuint,GLuint,GLuint)", __this_nativeId)
        __qt_this->glProgramUniform4ui(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLuint>(v02), static_cast<GLuint>(v13), static_cast<GLuint>(v24), static_cast<GLuint>(v35));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniform4uiv(GLuint,GLint,GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniform4uiv_1native_1GLuint_1GLint_1GLsizei_1const_1GLuint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniform4uiv(GLuint,GLint,GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLuint* __qt_value3 = __qt_value3_buffer.data<GLuint>();
        __qt_this->glProgramUniform4uiv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniformMatrix2fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniformMatrix2fv_1native_1GLuint_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jboolean transpose3,
 jobject value4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniformMatrix2fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value4_buffer(__jni_env, value4);
        const GLfloat* __qt_value4 = __qt_value4_buffer.data<GLfloat>();
        __qt_this->glProgramUniformMatrix2fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), static_cast<GLboolean>(transpose3), __qt_value4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniformMatrix2x3fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniformMatrix2x3fv_1native_1GLuint_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jboolean transpose3,
 jobject value4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniformMatrix2x3fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value4_buffer(__jni_env, value4);
        const GLfloat* __qt_value4 = __qt_value4_buffer.data<GLfloat>();
        __qt_this->glProgramUniformMatrix2x3fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), static_cast<GLboolean>(transpose3), __qt_value4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniformMatrix2x4fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniformMatrix2x4fv_1native_1GLuint_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jboolean transpose3,
 jobject value4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniformMatrix2x4fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value4_buffer(__jni_env, value4);
        const GLfloat* __qt_value4 = __qt_value4_buffer.data<GLfloat>();
        __qt_this->glProgramUniformMatrix2x4fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), static_cast<GLboolean>(transpose3), __qt_value4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniformMatrix3fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniformMatrix3fv_1native_1GLuint_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jboolean transpose3,
 jobject value4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniformMatrix3fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value4_buffer(__jni_env, value4);
        const GLfloat* __qt_value4 = __qt_value4_buffer.data<GLfloat>();
        __qt_this->glProgramUniformMatrix3fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), static_cast<GLboolean>(transpose3), __qt_value4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniformMatrix3x2fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniformMatrix3x2fv_1native_1GLuint_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jboolean transpose3,
 jobject value4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniformMatrix3x2fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value4_buffer(__jni_env, value4);
        const GLfloat* __qt_value4 = __qt_value4_buffer.data<GLfloat>();
        __qt_this->glProgramUniformMatrix3x2fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), static_cast<GLboolean>(transpose3), __qt_value4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniformMatrix3x4fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniformMatrix3x4fv_1native_1GLuint_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jboolean transpose3,
 jobject value4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniformMatrix3x4fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value4_buffer(__jni_env, value4);
        const GLfloat* __qt_value4 = __qt_value4_buffer.data<GLfloat>();
        __qt_this->glProgramUniformMatrix3x4fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), static_cast<GLboolean>(transpose3), __qt_value4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniformMatrix4fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniformMatrix4fv_1native_1GLuint_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jboolean transpose3,
 jobject value4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniformMatrix4fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value4_buffer(__jni_env, value4);
        const GLfloat* __qt_value4 = __qt_value4_buffer.data<GLfloat>();
        __qt_this->glProgramUniformMatrix4fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), static_cast<GLboolean>(transpose3), __qt_value4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniformMatrix4x2fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniformMatrix4x2fv_1native_1GLuint_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jboolean transpose3,
 jobject value4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniformMatrix4x2fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value4_buffer(__jni_env, value4);
        const GLfloat* __qt_value4 = __qt_value4_buffer.data<GLfloat>();
        __qt_this->glProgramUniformMatrix4x2fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), static_cast<GLboolean>(transpose3), __qt_value4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glProgramUniformMatrix4x3fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glProgramUniformMatrix4x3fv_1native_1GLuint_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jint count2,
 jboolean transpose3,
 jobject value4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glProgramUniformMatrix4x3fv(GLuint,GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value4_buffer(__jni_env, value4);
        const GLfloat* __qt_value4 = __qt_value4_buffer.data<GLfloat>();
        __qt_this->glProgramUniformMatrix4x3fv(static_cast<GLuint>(program0), static_cast<GLint>(location1), static_cast<GLsizei>(count2), static_cast<GLboolean>(transpose3), __qt_value4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glPushDebugGroup(GLenum,GLuint,GLsizei,const GLchar*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glPushDebugGroup_1native_1GLenum_1GLuint_1GLsizei_1const_1GLchar_1ptr__JIILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint source0,
 jint id1,
 jstring message3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glPushDebugGroup(GLenum,GLuint,GLsizei,const GLchar*)", __this_nativeId)
        J2CStringBuffer __qt_message3(__jni_env, jstring(message3));
        GLsizei length2 = GLsizei(__qt_message3.length());
        __qt_this->glPushDebugGroup(static_cast<GLenum>(source0), static_cast<GLuint>(id1), static_cast<GLsizei>(length2), __qt_message3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glReadBuffer(GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glReadBuffer_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glReadBuffer(GLenum)", __this_nativeId)
        __qt_this->glReadBuffer(static_cast<GLenum>(mode0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glReadnPixels(GLint,GLint,GLsizei,GLsizei,GLenum,GLenum,GLsizei,void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glReadnPixels_1native_1GLint_1GLint_1GLsizei_1GLsizei_1GLenum_1GLenum_1GLsizei_1void_1ptr__JIIIIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x0,
 jint y1,
 jint width2,
 jint height3,
 jint format4,
 jint type5,
 jint bufSize6,
 jobject data7)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glReadnPixels(GLint,GLint,GLsizei,GLsizei,GLenum,GLenum,GLsizei,void*)", __this_nativeId)
        JBufferData __qt_data7_buffer(__jni_env, data7);
        void* __qt_data7 = __qt_data7_buffer.data<void>();
        __qt_this->glReadnPixels(static_cast<GLint>(x0), static_cast<GLint>(y1), static_cast<GLsizei>(width2), static_cast<GLsizei>(height3), static_cast<GLenum>(format4), static_cast<GLenum>(type5), static_cast<GLsizei>(bufSize6), __qt_data7);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glRenderbufferStorageMultisample(GLenum,GLsizei,GLenum,GLsizei,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glRenderbufferStorageMultisample_1native_1GLenum_1GLsizei_1GLenum_1GLsizei_1GLsizei__JIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint samples1,
 jint internalformat2,
 jint width3,
 jint height4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glRenderbufferStorageMultisample(GLenum,GLsizei,GLenum,GLsizei,GLsizei)", __this_nativeId)
        __qt_this->glRenderbufferStorageMultisample(static_cast<GLenum>(target0), static_cast<GLsizei>(samples1), static_cast<GLenum>(internalformat2), static_cast<GLsizei>(width3), static_cast<GLsizei>(height4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glResumeTransformFeedback()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glResumeTransformFeedback_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glResumeTransformFeedback()", __this_nativeId)
        __qt_this->glResumeTransformFeedback();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glSampleMaski(GLuint,GLbitfield)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glSampleMaski_1native_1GLuint_1GLbitfield__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint maskNumber0,
 jint mask1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glSampleMaski(GLuint,GLbitfield)", __this_nativeId)
        __qt_this->glSampleMaski(static_cast<GLuint>(maskNumber0), static_cast<GLbitfield>(mask1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glSamplerParameterIiv(GLuint,GLenum,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glSamplerParameterIiv_1native_1GLuint_1GLenum_1const_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampler0,
 jint pname1,
 jobject param2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glSamplerParameterIiv(GLuint,GLenum,const GLint*)", __this_nativeId)
        JBufferConstData __qt_param2_buffer(__jni_env, param2);
        const GLint* __qt_param2 = __qt_param2_buffer.data<GLint>();
        __qt_this->glSamplerParameterIiv(static_cast<GLuint>(sampler0), static_cast<GLenum>(pname1), __qt_param2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glSamplerParameterIuiv(GLuint,GLenum,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glSamplerParameterIuiv_1native_1GLuint_1GLenum_1const_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampler0,
 jint pname1,
 jobject param2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glSamplerParameterIuiv(GLuint,GLenum,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_param2_buffer(__jni_env, param2);
        const GLuint* __qt_param2 = __qt_param2_buffer.data<GLuint>();
        __qt_this->glSamplerParameterIuiv(static_cast<GLuint>(sampler0), static_cast<GLenum>(pname1), __qt_param2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glSamplerParameterf(GLuint,GLenum,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glSamplerParameterf_1native_1GLuint_1GLenum_1GLfloat__JIIF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampler0,
 jint pname1,
 jfloat param2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glSamplerParameterf(GLuint,GLenum,GLfloat)", __this_nativeId)
        __qt_this->glSamplerParameterf(static_cast<GLuint>(sampler0), static_cast<GLenum>(pname1), static_cast<GLfloat>(param2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glSamplerParameterfv(GLuint,GLenum,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glSamplerParameterfv_1native_1GLuint_1GLenum_1const_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampler0,
 jint pname1,
 jobject param2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glSamplerParameterfv(GLuint,GLenum,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_param2_buffer(__jni_env, param2);
        const GLfloat* __qt_param2 = __qt_param2_buffer.data<GLfloat>();
        __qt_this->glSamplerParameterfv(static_cast<GLuint>(sampler0), static_cast<GLenum>(pname1), __qt_param2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glSamplerParameteri(GLuint,GLenum,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glSamplerParameteri_1native_1GLuint_1GLenum_1GLint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampler0,
 jint pname1,
 jint param2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glSamplerParameteri(GLuint,GLenum,GLint)", __this_nativeId)
        __qt_this->glSamplerParameteri(static_cast<GLuint>(sampler0), static_cast<GLenum>(pname1), static_cast<GLint>(param2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glSamplerParameteriv(GLuint,GLenum,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glSamplerParameteriv_1native_1GLuint_1GLenum_1const_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sampler0,
 jint pname1,
 jobject param2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glSamplerParameteriv(GLuint,GLenum,const GLint*)", __this_nativeId)
        JBufferConstData __qt_param2_buffer(__jni_env, param2);
        const GLint* __qt_param2 = __qt_param2_buffer.data<GLint>();
        __qt_this->glSamplerParameteriv(static_cast<GLuint>(sampler0), static_cast<GLenum>(pname1), __qt_param2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glTexBuffer(GLenum,GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glTexBuffer_1native_1GLenum_1GLenum_1GLuint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint internalformat1,
 jint buffer2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glTexBuffer(GLenum,GLenum,GLuint)", __this_nativeId)
        __qt_this->glTexBuffer(static_cast<GLenum>(target0), static_cast<GLenum>(internalformat1), static_cast<GLuint>(buffer2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glTexBufferRange(GLenum,GLenum,GLuint,GLintptr,GLsizeiptr)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glTexBufferRange_1native_1GLenum_1GLenum_1GLuint_1GLintptr_1GLsizeiptr__JIIIJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint internalformat1,
 jint buffer2,
 jlong offset3,
 jlong size4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glTexBufferRange(GLenum,GLenum,GLuint,GLintptr,GLsizeiptr)", __this_nativeId)
        __qt_this->glTexBufferRange(static_cast<GLenum>(target0), static_cast<GLenum>(internalformat1), static_cast<GLuint>(buffer2), static_cast<GLintptr>(offset3), static_cast<GLsizeiptr>(size4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glTexImage3D(GLenum,GLint,GLint,GLsizei,GLsizei,GLsizei,GLint,GLenum,GLenum,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glTexImage3D_1native_1GLenum_1GLint_1GLint_1GLsizei_1GLsizei_1GLsizei_1GLint_1GLenum_1GLenum_1const_1void_1ptr__JIIIIIIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint internalformat2,
 jint width3,
 jint height4,
 jint depth5,
 jint border6,
 jint format7,
 jint type8,
 jobject pixels9)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glTexImage3D(GLenum,GLint,GLint,GLsizei,GLsizei,GLsizei,GLint,GLenum,GLenum,const void*)", __this_nativeId)
        JBufferConstData __qt_pixels9_buffer(__jni_env, pixels9);
        const void* __qt_pixels9 = __qt_pixels9_buffer.data<void>();
        __qt_this->glTexImage3D(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLint>(internalformat2), static_cast<GLsizei>(width3), static_cast<GLsizei>(height4), static_cast<GLsizei>(depth5), static_cast<GLint>(border6), static_cast<GLenum>(format7), static_cast<GLenum>(type8), __qt_pixels9);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glTexParameterIiv(GLenum,GLenum,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glTexParameterIiv_1native_1GLenum_1GLenum_1const_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glTexParameterIiv(GLenum,GLenum,const GLint*)", __this_nativeId)
        JBufferConstData __qt_params2_buffer(__jni_env, params2);
        const GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glTexParameterIiv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glTexParameterIuiv(GLenum,GLenum,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glTexParameterIuiv_1native_1GLenum_1GLenum_1const_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glTexParameterIuiv(GLenum,GLenum,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_params2_buffer(__jni_env, params2);
        const GLuint* __qt_params2 = __qt_params2_buffer.data<GLuint>();
        __qt_this->glTexParameterIuiv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glTexStorage2D(GLenum,GLsizei,GLenum,GLsizei,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glTexStorage2D_1native_1GLenum_1GLsizei_1GLenum_1GLsizei_1GLsizei__JIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint levels1,
 jint internalformat2,
 jint width3,
 jint height4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glTexStorage2D(GLenum,GLsizei,GLenum,GLsizei,GLsizei)", __this_nativeId)
        __qt_this->glTexStorage2D(static_cast<GLenum>(target0), static_cast<GLsizei>(levels1), static_cast<GLenum>(internalformat2), static_cast<GLsizei>(width3), static_cast<GLsizei>(height4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glTexStorage2DMultisample(GLenum,GLsizei,GLenum,GLsizei,GLsizei,GLboolean)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glTexStorage2DMultisample_1native_1GLenum_1GLsizei_1GLenum_1GLsizei_1GLsizei_1GLboolean__JIIIIIZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint samples1,
 jint internalformat2,
 jint width3,
 jint height4,
 jboolean fixedsamplelocations5)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glTexStorage2DMultisample(GLenum,GLsizei,GLenum,GLsizei,GLsizei,GLboolean)", __this_nativeId)
        __qt_this->glTexStorage2DMultisample(static_cast<GLenum>(target0), static_cast<GLsizei>(samples1), static_cast<GLenum>(internalformat2), static_cast<GLsizei>(width3), static_cast<GLsizei>(height4), static_cast<GLboolean>(fixedsamplelocations5));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glTexStorage3D(GLenum,GLsizei,GLenum,GLsizei,GLsizei,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glTexStorage3D_1native_1GLenum_1GLsizei_1GLenum_1GLsizei_1GLsizei_1GLsizei__JIIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint levels1,
 jint internalformat2,
 jint width3,
 jint height4,
 jint depth5)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glTexStorage3D(GLenum,GLsizei,GLenum,GLsizei,GLsizei,GLsizei)", __this_nativeId)
        __qt_this->glTexStorage3D(static_cast<GLenum>(target0), static_cast<GLsizei>(levels1), static_cast<GLenum>(internalformat2), static_cast<GLsizei>(width3), static_cast<GLsizei>(height4), static_cast<GLsizei>(depth5));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glTexStorage3DMultisample(GLenum,GLsizei,GLenum,GLsizei,GLsizei,GLsizei,GLboolean)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glTexStorage3DMultisample_1native_1GLenum_1GLsizei_1GLenum_1GLsizei_1GLsizei_1GLsizei_1GLboolean__JIIIIIIZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint samples1,
 jint internalformat2,
 jint width3,
 jint height4,
 jint depth5,
 jboolean fixedsamplelocations6)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glTexStorage3DMultisample(GLenum,GLsizei,GLenum,GLsizei,GLsizei,GLsizei,GLboolean)", __this_nativeId)
        __qt_this->glTexStorage3DMultisample(static_cast<GLenum>(target0), static_cast<GLsizei>(samples1), static_cast<GLenum>(internalformat2), static_cast<GLsizei>(width3), static_cast<GLsizei>(height4), static_cast<GLsizei>(depth5), static_cast<GLboolean>(fixedsamplelocations6));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glTexSubImage3D(GLenum,GLint,GLint,GLint,GLint,GLsizei,GLsizei,GLsizei,GLenum,GLenum,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glTexSubImage3D_1native_1GLenum_1GLint_1GLint_1GLint_1GLint_1GLsizei_1GLsizei_1GLsizei_1GLenum_1GLenum_1const_1void_1ptr__JIIIIIIIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint xoffset2,
 jint yoffset3,
 jint zoffset4,
 jint width5,
 jint height6,
 jint depth7,
 jint format8,
 jint type9,
 jobject pixels10)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glTexSubImage3D(GLenum,GLint,GLint,GLint,GLint,GLsizei,GLsizei,GLsizei,GLenum,GLenum,const void*)", __this_nativeId)
        JBufferConstData __qt_pixels10_buffer(__jni_env, pixels10);
        const void* __qt_pixels10 = __qt_pixels10_buffer.data<void>();
        __qt_this->glTexSubImage3D(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLint>(xoffset2), static_cast<GLint>(yoffset3), static_cast<GLint>(zoffset4), static_cast<GLsizei>(width5), static_cast<GLsizei>(height6), static_cast<GLsizei>(depth7), static_cast<GLenum>(format8), static_cast<GLenum>(type9), __qt_pixels10);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glTransformFeedbackVaryings(GLuint,GLsizei,const GLchar*const*,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glTransformFeedbackVaryings_1native_1GLuint_1GLsizei_1const_1GLchar_1cptr_1ptr_1GLenum__JI_3Ljava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jobjectArray varyings2,
 jint bufferMode3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glTransformFeedbackVaryings(GLuint,GLsizei,const GLchar*const*,GLenum)", __this_nativeId)
        jsize __qt_count1 = __jni_env->GetArrayLength(jarray(varyings2));
        QVector<QSharedPointer<J2CStringBuffer>> varyings2Vec;
        const GLchar** __qt_varyings2 = nullptr;
        QScopedArrayPointer<const GLchar*> __qt_varyings2Ptr(__qt_varyings2 = new const GLchar*[quint32(__qt_count1)]);
        for(jsize i=0; i<__qt_count1; ++i){
            J2CStringBuffer* b = new J2CStringBuffer(__jni_env, jstring(__jni_env->GetObjectArrayElement(jobjectArray(varyings2), i)));
            __qt_varyings2[i] = *b;
            varyings2Vec << QSharedPointer<J2CStringBuffer>(b);
        }
        __qt_this->glTransformFeedbackVaryings(static_cast<GLuint>(program0), GLsizei(__qt_count1), __qt_varyings2, static_cast<GLenum>(bufferMode3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniform1ui(GLint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniform1ui_1native_1GLint_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint v01)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniform1ui(GLint,GLuint)", __this_nativeId)
        __qt_this->glUniform1ui(static_cast<GLint>(location0), static_cast<GLuint>(v01));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniform1uiv(GLint,GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniform1uiv_1native_1GLint_1GLsizei_1const_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject value2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniform1uiv(GLint,GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_value2_buffer(__jni_env, value2);
        const GLuint* __qt_value2 = __qt_value2_buffer.data<GLuint>();
        __qt_this->glUniform1uiv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_value2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniform2ui(GLint,GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniform2ui_1native_1GLint_1GLuint_1GLuint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint v01,
 jint v12)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniform2ui(GLint,GLuint,GLuint)", __this_nativeId)
        __qt_this->glUniform2ui(static_cast<GLint>(location0), static_cast<GLuint>(v01), static_cast<GLuint>(v12));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniform2uiv(GLint,GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniform2uiv_1native_1GLint_1GLsizei_1const_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject value2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniform2uiv(GLint,GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_value2_buffer(__jni_env, value2);
        const GLuint* __qt_value2 = __qt_value2_buffer.data<GLuint>();
        __qt_this->glUniform2uiv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_value2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniform3ui(GLint,GLuint,GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniform3ui_1native_1GLint_1GLuint_1GLuint_1GLuint__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint v01,
 jint v12,
 jint v23)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniform3ui(GLint,GLuint,GLuint,GLuint)", __this_nativeId)
        __qt_this->glUniform3ui(static_cast<GLint>(location0), static_cast<GLuint>(v01), static_cast<GLuint>(v12), static_cast<GLuint>(v23));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniform3uiv(GLint,GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniform3uiv_1native_1GLint_1GLsizei_1const_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject value2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniform3uiv(GLint,GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_value2_buffer(__jni_env, value2);
        const GLuint* __qt_value2 = __qt_value2_buffer.data<GLuint>();
        __qt_this->glUniform3uiv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_value2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniform4ui(GLint,GLuint,GLuint,GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniform4ui_1native_1GLint_1GLuint_1GLuint_1GLuint_1GLuint__JIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint v01,
 jint v12,
 jint v23,
 jint v34)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniform4ui(GLint,GLuint,GLuint,GLuint,GLuint)", __this_nativeId)
        __qt_this->glUniform4ui(static_cast<GLint>(location0), static_cast<GLuint>(v01), static_cast<GLuint>(v12), static_cast<GLuint>(v23), static_cast<GLuint>(v34));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniform4uiv(GLint,GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniform4uiv_1native_1GLint_1GLsizei_1const_1GLuint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject value2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniform4uiv(GLint,GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_value2_buffer(__jni_env, value2);
        const GLuint* __qt_value2 = __qt_value2_buffer.data<GLuint>();
        __qt_this->glUniform4uiv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_value2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniformBlockBinding(GLuint,GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniformBlockBinding_1native_1GLuint_1GLuint_1GLuint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint uniformBlockIndex1,
 jint uniformBlockBinding2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniformBlockBinding(GLuint,GLuint,GLuint)", __this_nativeId)
        __qt_this->glUniformBlockBinding(static_cast<GLuint>(program0), static_cast<GLuint>(uniformBlockIndex1), static_cast<GLuint>(uniformBlockBinding2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniformMatrix2x3fv(GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniformMatrix2x3fv_1native_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jboolean transpose2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniformMatrix2x3fv(GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glUniformMatrix2x3fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), static_cast<GLboolean>(transpose2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniformMatrix2x4fv(GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniformMatrix2x4fv_1native_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jboolean transpose2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniformMatrix2x4fv(GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glUniformMatrix2x4fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), static_cast<GLboolean>(transpose2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniformMatrix3x2fv(GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniformMatrix3x2fv_1native_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jboolean transpose2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniformMatrix3x2fv(GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glUniformMatrix3x2fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), static_cast<GLboolean>(transpose2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniformMatrix3x4fv(GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniformMatrix3x4fv_1native_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jboolean transpose2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniformMatrix3x4fv(GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glUniformMatrix3x4fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), static_cast<GLboolean>(transpose2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniformMatrix4x2fv(GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniformMatrix4x2fv_1native_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jboolean transpose2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniformMatrix4x2fv(GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glUniformMatrix4x2fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), static_cast<GLboolean>(transpose2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUniformMatrix4x3fv(GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUniformMatrix4x3fv_1native_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jboolean transpose2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUniformMatrix4x3fv(GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glUniformMatrix4x3fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), static_cast<GLboolean>(transpose2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glUnmapBuffer(GLenum)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUnmapBuffer_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUnmapBuffer(GLenum)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glUnmapBuffer(static_cast<GLenum>(target0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLExtraFunctions::glUseProgramStages(GLuint,GLbitfield,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glUseProgramStages_1native_1GLuint_1GLbitfield_1GLuint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pipeline0,
 jint stages1,
 jint program2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glUseProgramStages(GLuint,GLbitfield,GLuint)", __this_nativeId)
        __qt_this->glUseProgramStages(static_cast<GLuint>(pipeline0), static_cast<GLbitfield>(stages1), static_cast<GLuint>(program2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glValidateProgramPipeline(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glValidateProgramPipeline_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pipeline0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glValidateProgramPipeline(GLuint)", __this_nativeId)
        __qt_this->glValidateProgramPipeline(static_cast<GLuint>(pipeline0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glVertexAttribBinding(GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glVertexAttribBinding_1native_1GLuint_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint attribindex0,
 jint bindingindex1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glVertexAttribBinding(GLuint,GLuint)", __this_nativeId)
        __qt_this->glVertexAttribBinding(static_cast<GLuint>(attribindex0), static_cast<GLuint>(bindingindex1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glVertexAttribDivisor(GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glVertexAttribDivisor_1native_1GLuint_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint divisor1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glVertexAttribDivisor(GLuint,GLuint)", __this_nativeId)
        __qt_this->glVertexAttribDivisor(static_cast<GLuint>(index0), static_cast<GLuint>(divisor1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glVertexAttribFormat(GLuint,GLint,GLenum,GLboolean,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glVertexAttribFormat_1native_1GLuint_1GLint_1GLenum_1GLboolean_1GLuint__JIIIZI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint attribindex0,
 jint size1,
 jint type2,
 jboolean normalized3,
 jint relativeoffset4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glVertexAttribFormat(GLuint,GLint,GLenum,GLboolean,GLuint)", __this_nativeId)
        __qt_this->glVertexAttribFormat(static_cast<GLuint>(attribindex0), static_cast<GLint>(size1), static_cast<GLenum>(type2), static_cast<GLboolean>(normalized3), static_cast<GLuint>(relativeoffset4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glVertexAttribI4i(GLuint,GLint,GLint,GLint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glVertexAttribI4i_1native_1GLuint_1GLint_1GLint_1GLint_1GLint__JIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint x1,
 jint y2,
 jint z3,
 jint w4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glVertexAttribI4i(GLuint,GLint,GLint,GLint,GLint)", __this_nativeId)
        __qt_this->glVertexAttribI4i(static_cast<GLuint>(index0), static_cast<GLint>(x1), static_cast<GLint>(y2), static_cast<GLint>(z3), static_cast<GLint>(w4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glVertexAttribI4iv(GLuint,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glVertexAttribI4iv_1native_1GLuint_1const_1GLint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jobject v1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glVertexAttribI4iv(GLuint,const GLint*)", __this_nativeId)
        JBufferConstData __qt_v1_buffer(__jni_env, v1);
        const GLint* __qt_v1 = __qt_v1_buffer.data<GLint>();
        __qt_this->glVertexAttribI4iv(static_cast<GLuint>(index0), __qt_v1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glVertexAttribI4ui(GLuint,GLuint,GLuint,GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glVertexAttribI4ui_1native_1GLuint_1GLuint_1GLuint_1GLuint_1GLuint__JIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint x1,
 jint y2,
 jint z3,
 jint w4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glVertexAttribI4ui(GLuint,GLuint,GLuint,GLuint,GLuint)", __this_nativeId)
        __qt_this->glVertexAttribI4ui(static_cast<GLuint>(index0), static_cast<GLuint>(x1), static_cast<GLuint>(y2), static_cast<GLuint>(z3), static_cast<GLuint>(w4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glVertexAttribI4uiv(GLuint,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glVertexAttribI4uiv_1native_1GLuint_1const_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jobject v1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glVertexAttribI4uiv(GLuint,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_v1_buffer(__jni_env, v1);
        const GLuint* __qt_v1 = __qt_v1_buffer.data<GLuint>();
        __qt_this->glVertexAttribI4uiv(static_cast<GLuint>(index0), __qt_v1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glVertexAttribIFormat(GLuint,GLint,GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glVertexAttribIFormat_1native_1GLuint_1GLint_1GLenum_1GLuint__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint attribindex0,
 jint size1,
 jint type2,
 jint relativeoffset3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glVertexAttribIFormat(GLuint,GLint,GLenum,GLuint)", __this_nativeId)
        __qt_this->glVertexAttribIFormat(static_cast<GLuint>(attribindex0), static_cast<GLint>(size1), static_cast<GLenum>(type2), static_cast<GLuint>(relativeoffset3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glVertexAttribIPointer(GLuint,GLint,GLenum,GLsizei,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glVertexAttribIPointer_1native_1GLuint_1GLint_1GLenum_1GLsizei_1const_1void_1ptr__JIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint size1,
 jint type2,
 jint stride3,
 jobject pointer4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glVertexAttribIPointer(GLuint,GLint,GLenum,GLsizei,const void*)", __this_nativeId)
        JBufferConstData __qt_pointer4_buffer(__jni_env, pointer4);
        const void* __qt_pointer4 = __qt_pointer4_buffer.data<void>();
        __qt_this->glVertexAttribIPointer(static_cast<GLuint>(index0), static_cast<GLint>(size1), static_cast<GLenum>(type2), static_cast<GLsizei>(stride3), __qt_pointer4);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glVertexBindingDivisor(GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glVertexBindingDivisor_1native_1GLuint_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint bindingindex0,
 jint divisor1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glVertexBindingDivisor(GLuint,GLuint)", __this_nativeId)
        __qt_this->glVertexBindingDivisor(static_cast<GLuint>(bindingindex0), static_cast<GLuint>(divisor1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLExtraFunctions::glWaitSync(GLsync,GLbitfield,GLuint64)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_glWaitSync_1native_1_1_1GLsync_1ptr_1GLbitfield_1GLuint64__JJIJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID sync0,
 jint flags1,
 jlong timeout2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLExtraFunctions::glWaitSync(GLsync,GLbitfield,GLuint64)", __this_nativeId)
        __GLsync* __qt_sync0 = QtJambiAPI::objectFromNativeId<__GLsync>(sync0);
        __qt_this->glWaitSync(__qt_sync0, static_cast<GLbitfield>(flags1), static_cast<GLuint64>(timeout2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLExtraFunctions_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QOpenGLExtraFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLExtraFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QOpenGLExtraFunctions(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QOpenGLExtraFunctions>("QOpenGLExtraFunctions", "io/qt/gui/QOpenGLExtraFunctions");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QOpenGLExtraFunctions, {
        ConstructorInfo(&__qt_construct_QOpenGLExtraFunctions, nullptr)
       ,ConstructorInfo(&__qt_construct_QOpenGLExtraFunctions_QOpenGLContext_ptr, "Lio/qt/gui/QOpenGLContext;")
       ,ConstructorInfo(&__qt_construct_QOpenGLExtraFunctions_cref_QOpenGLExtraFunctions, "Lio/qt/gui/QOpenGLExtraFunctions;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QOpenGLExtraFunctions);
    registerMetaType<QOpenGLExtraFunctions>("QOpenGLExtraFunctions");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
