#include <QtCore/QtGlobal>
#include <QtGui/qopenglfunctions.h>
#include <QtCore/QSharedPointer>
#include <QtCore/QVariant>
#include <QtGui/qopenglcontext.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
#ifndef GL_MAX_LABEL_LENGTH
#define GL_MAX_LABEL_LENGTH 0x82E8
#endif

void deleter_QOpenGLFunctions(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QOpenGLFunctions")
    QOpenGLFunctions *_ptr = reinterpret_cast<QOpenGLFunctions *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QOpenGLFunctions()
void __qt_construct_QOpenGLFunctions(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLFunctions()")
    Q_UNUSED(__java_arguments)
    QOpenGLFunctions *__qt_this = new(__qtjambi_ptr) QOpenGLFunctions();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QOpenGLFunctions::QOpenGLFunctions()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_initialize_1native__Lio_qt_gui_QOpenGLFunctions_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLFunctions::QOpenGLFunctions()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLFunctions, sizeof(QOpenGLFunctions), typeid(QOpenGLFunctions), 0, false, &deleter_QOpenGLFunctions, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QOpenGLFunctions(QOpenGLContext*)
void __qt_construct_QOpenGLFunctions_QOpenGLContext_ptr(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLFunctions(QOpenGLContext*)")
    jobject context0 = __java_arguments[0].l;
    QOpenGLContext* __qt_context0 = qtjambi_cast<QOpenGLContext*>(__jni_env, context0);
    QOpenGLFunctions *__qt_this = new(__qtjambi_ptr) QOpenGLFunctions(__qt_context0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QOpenGLFunctions::QOpenGLFunctions(QOpenGLContext*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_initialize_1native__Lio_qt_gui_QOpenGLFunctions_2Lio_qt_gui_QOpenGLContext_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject context0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLFunctions::QOpenGLFunctions(QOpenGLContext*)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = context0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLFunctions_QOpenGLContext_ptr, sizeof(QOpenGLFunctions), typeid(QOpenGLFunctions), 0, false, &deleter_QOpenGLFunctions, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QOpenGLFunctions(QOpenGLFunctions)
void __qt_construct_QOpenGLFunctions_cref_QOpenGLFunctions(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QOpenGLFunctions(QOpenGLFunctions)")
    jobject other0 = __java_arguments[0].l;
    const QOpenGLFunctions& __qt_other0 = qtjambi_cast<const QOpenGLFunctions&>(__jni_env, other0);
    QOpenGLFunctions *__qt_this = new(__qtjambi_ptr) QOpenGLFunctions(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QOpenGLFunctions::QOpenGLFunctions(QOpenGLFunctions)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_initialize_1native__Lio_qt_gui_QOpenGLFunctions_2Lio_qt_gui_QOpenGLFunctions_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QOpenGLFunctions::QOpenGLFunctions(QOpenGLFunctions)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QOpenGLFunctions_cref_QOpenGLFunctions, sizeof(QOpenGLFunctions), typeid(QOpenGLFunctions), 0, false, &deleter_QOpenGLFunctions, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QOpenGLFunctions
void __qt_destruct_QOpenGLFunctions(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QOpenGLFunctions")
    reinterpret_cast<QOpenGLFunctions*>(ptr)->~QOpenGLFunctions();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QOpenGLFunctions::glActiveTexture(GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glActiveTexture_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint texture0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glActiveTexture(GLenum)", __this_nativeId)
        __qt_this->glActiveTexture(static_cast<GLenum>(texture0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glAttachShader(GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glAttachShader_1native_1GLuint_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint shader1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glAttachShader(GLuint,GLuint)", __this_nativeId)
        __qt_this->glAttachShader(static_cast<GLuint>(program0), static_cast<GLuint>(shader1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBindAttribLocation(GLuint,GLuint,const char*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBindAttribLocation_1native_1GLuint_1GLuint_1const_1char_1ptr__JIILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint index1,
 jstring name2)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBindAttribLocation(GLuint,GLuint,const char*)", __this_nativeId)
        const char*  __qt_name2 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, name2);
        __qt_this->glBindAttribLocation(static_cast<GLuint>(program0), static_cast<GLuint>(index1), __qt_name2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBindBuffer(GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBindBuffer_1native_1GLenum_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint buffer1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBindBuffer(GLenum,GLuint)", __this_nativeId)
        __qt_this->glBindBuffer(static_cast<GLenum>(target0), static_cast<GLuint>(buffer1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBindFramebuffer(GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBindFramebuffer_1native_1GLenum_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint framebuffer1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBindFramebuffer(GLenum,GLuint)", __this_nativeId)
        __qt_this->glBindFramebuffer(static_cast<GLenum>(target0), static_cast<GLuint>(framebuffer1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBindRenderbuffer(GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBindRenderbuffer_1native_1GLenum_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint renderbuffer1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBindRenderbuffer(GLenum,GLuint)", __this_nativeId)
        __qt_this->glBindRenderbuffer(static_cast<GLenum>(target0), static_cast<GLuint>(renderbuffer1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBindTexture(GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBindTexture_1native_1GLenum_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint texture1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBindTexture(GLenum,GLuint)", __this_nativeId)
        __qt_this->glBindTexture(static_cast<GLenum>(target0), static_cast<GLuint>(texture1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBlendColor(GLclampf,GLclampf,GLclampf,GLclampf)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBlendColor_1native_1GLclampf_1GLclampf_1GLclampf_1GLclampf__JFFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat red0,
 jfloat green1,
 jfloat blue2,
 jfloat alpha3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBlendColor(GLclampf,GLclampf,GLclampf,GLclampf)", __this_nativeId)
        __qt_this->glBlendColor(static_cast<GLclampf>(red0), static_cast<GLclampf>(green1), static_cast<GLclampf>(blue2), static_cast<GLclampf>(alpha3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBlendEquation(GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBlendEquation_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBlendEquation(GLenum)", __this_nativeId)
        __qt_this->glBlendEquation(static_cast<GLenum>(mode0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBlendEquationSeparate(GLenum,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBlendEquationSeparate_1native_1GLenum_1GLenum__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint modeRGB0,
 jint modeAlpha1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBlendEquationSeparate(GLenum,GLenum)", __this_nativeId)
        __qt_this->glBlendEquationSeparate(static_cast<GLenum>(modeRGB0), static_cast<GLenum>(modeAlpha1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBlendFunc(GLenum,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBlendFunc_1native_1GLenum_1GLenum__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint sfactor0,
 jint dfactor1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBlendFunc(GLenum,GLenum)", __this_nativeId)
        __qt_this->glBlendFunc(static_cast<GLenum>(sfactor0), static_cast<GLenum>(dfactor1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBlendFuncSeparate(GLenum,GLenum,GLenum,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBlendFuncSeparate_1native_1GLenum_1GLenum_1GLenum_1GLenum__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint srcRGB0,
 jint dstRGB1,
 jint srcAlpha2,
 jint dstAlpha3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBlendFuncSeparate(GLenum,GLenum,GLenum,GLenum)", __this_nativeId)
        __qt_this->glBlendFuncSeparate(static_cast<GLenum>(srcRGB0), static_cast<GLenum>(dstRGB1), static_cast<GLenum>(srcAlpha2), static_cast<GLenum>(dstAlpha3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBufferData(GLenum,qopengl_GLsizeiptr,const void*,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBufferData_1native_1GLenum_1qopengl_1GLsizeiptr_1const_1void_1ptr_1GLenum__JIJLjava_nio_Buffer_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jlong size1,
 jobject data2,
 jint usage3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBufferData(GLenum,qopengl_GLsizeiptr,const void*,GLenum)", __this_nativeId)
        JBufferConstData __qt_data2_buffer(__jni_env, data2);
        const void* __qt_data2 = __qt_data2_buffer.data<void>();
        __qt_this->glBufferData(static_cast<GLenum>(target0), static_cast<qopengl_GLsizeiptr>(size1), __qt_data2, static_cast<GLenum>(usage3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glBufferSubData(GLenum,qopengl_GLintptr,qopengl_GLsizeiptr,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glBufferSubData_1native_1GLenum_1qopengl_1GLintptr_1qopengl_1GLsizeiptr_1const_1void_1ptr__JIJJLjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jlong offset1,
 jlong size2,
 jobject data3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glBufferSubData(GLenum,qopengl_GLintptr,qopengl_GLsizeiptr,const void*)", __this_nativeId)
        JBufferConstData __qt_data3_buffer(__jni_env, data3);
        const void* __qt_data3 = __qt_data3_buffer.data<void>();
        __qt_this->glBufferSubData(static_cast<GLenum>(target0), static_cast<qopengl_GLintptr>(offset1), static_cast<qopengl_GLsizeiptr>(size2), __qt_data3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glCheckFramebufferStatus(GLenum)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glCheckFramebufferStatus_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glCheckFramebufferStatus(GLenum)", __this_nativeId)
        GLenum __qt_return_value = __qt_this->glCheckFramebufferStatus(static_cast<GLenum>(target0));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glClear(GLbitfield)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glClear_1native_1GLbitfield__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mask0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glClear(GLbitfield)", __this_nativeId)
        __qt_this->glClear(static_cast<GLbitfield>(mask0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glClearColor(GLclampf,GLclampf,GLclampf,GLclampf)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glClearColor_1native_1GLclampf_1GLclampf_1GLclampf_1GLclampf__JFFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat red0,
 jfloat green1,
 jfloat blue2,
 jfloat alpha3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glClearColor(GLclampf,GLclampf,GLclampf,GLclampf)", __this_nativeId)
        __qt_this->glClearColor(static_cast<GLclampf>(red0), static_cast<GLclampf>(green1), static_cast<GLclampf>(blue2), static_cast<GLclampf>(alpha3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glClearDepthf(GLclampf)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glClearDepthf_1native_1GLclampf__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat depth0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glClearDepthf(GLclampf)", __this_nativeId)
        __qt_this->glClearDepthf(static_cast<GLclampf>(depth0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glClearStencil(GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glClearStencil_1native_1GLint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint s0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glClearStencil(GLint)", __this_nativeId)
        __qt_this->glClearStencil(static_cast<GLint>(s0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glColorMask(GLboolean,GLboolean,GLboolean,GLboolean)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glColorMask_1native_1GLboolean_1GLboolean_1GLboolean_1GLboolean__JZZZZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean red0,
 jboolean green1,
 jboolean blue2,
 jboolean alpha3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glColorMask(GLboolean,GLboolean,GLboolean,GLboolean)", __this_nativeId)
        __qt_this->glColorMask(static_cast<GLboolean>(red0), static_cast<GLboolean>(green1), static_cast<GLboolean>(blue2), static_cast<GLboolean>(alpha3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glCompileShader(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glCompileShader_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint shader0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glCompileShader(GLuint)", __this_nativeId)
        __qt_this->glCompileShader(static_cast<GLuint>(shader0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glCompressedTexImage2D(GLenum,GLint,GLenum,GLsizei,GLsizei,GLint,GLsizei,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glCompressedTexImage2D_1native_1GLenum_1GLint_1GLenum_1GLsizei_1GLsizei_1GLint_1GLsizei_1const_1void_1ptr__JIIIIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint internalformat2,
 jint width3,
 jint height4,
 jint border5,
 jint imageSize6,
 jobject data7)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glCompressedTexImage2D(GLenum,GLint,GLenum,GLsizei,GLsizei,GLint,GLsizei,const void*)", __this_nativeId)
        JBufferConstData __qt_data7_buffer(__jni_env, data7);
        const void* __qt_data7 = __qt_data7_buffer.data<void>();
        __qt_this->glCompressedTexImage2D(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLenum>(internalformat2), static_cast<GLsizei>(width3), static_cast<GLsizei>(height4), static_cast<GLint>(border5), static_cast<GLsizei>(imageSize6), __qt_data7);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glCompressedTexSubImage2D(GLenum,GLint,GLint,GLint,GLsizei,GLsizei,GLenum,GLsizei,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glCompressedTexSubImage2D_1native_1GLenum_1GLint_1GLint_1GLint_1GLsizei_1GLsizei_1GLenum_1GLsizei_1const_1void_1ptr__JIIIIIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint xoffset2,
 jint yoffset3,
 jint width4,
 jint height5,
 jint format6,
 jint imageSize7,
 jobject data8)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glCompressedTexSubImage2D(GLenum,GLint,GLint,GLint,GLsizei,GLsizei,GLenum,GLsizei,const void*)", __this_nativeId)
        JBufferConstData __qt_data8_buffer(__jni_env, data8);
        const void* __qt_data8 = __qt_data8_buffer.data<void>();
        __qt_this->glCompressedTexSubImage2D(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLint>(xoffset2), static_cast<GLint>(yoffset3), static_cast<GLsizei>(width4), static_cast<GLsizei>(height5), static_cast<GLenum>(format6), static_cast<GLsizei>(imageSize7), __qt_data8);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glCopyTexImage2D(GLenum,GLint,GLenum,GLint,GLint,GLsizei,GLsizei,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glCopyTexImage2D_1native_1GLenum_1GLint_1GLenum_1GLint_1GLint_1GLsizei_1GLsizei_1GLint__JIIIIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint internalformat2,
 jint x3,
 jint y4,
 jint width5,
 jint height6,
 jint border7)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glCopyTexImage2D(GLenum,GLint,GLenum,GLint,GLint,GLsizei,GLsizei,GLint)", __this_nativeId)
        __qt_this->glCopyTexImage2D(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLenum>(internalformat2), static_cast<GLint>(x3), static_cast<GLint>(y4), static_cast<GLsizei>(width5), static_cast<GLsizei>(height6), static_cast<GLint>(border7));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glCopyTexSubImage2D(GLenum,GLint,GLint,GLint,GLint,GLint,GLsizei,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glCopyTexSubImage2D_1native_1GLenum_1GLint_1GLint_1GLint_1GLint_1GLint_1GLsizei_1GLsizei__JIIIIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint xoffset2,
 jint yoffset3,
 jint x4,
 jint y5,
 jint width6,
 jint height7)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glCopyTexSubImage2D(GLenum,GLint,GLint,GLint,GLint,GLint,GLsizei,GLsizei)", __this_nativeId)
        __qt_this->glCopyTexSubImage2D(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLint>(xoffset2), static_cast<GLint>(yoffset3), static_cast<GLint>(x4), static_cast<GLint>(y5), static_cast<GLsizei>(width6), static_cast<GLsizei>(height7));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glCreateProgram()
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glCreateProgram_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glCreateProgram()", __this_nativeId)
        GLuint __qt_return_value = __qt_this->glCreateProgram();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glCreateShader(GLenum)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glCreateShader_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint type0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glCreateShader(GLenum)", __this_nativeId)
        GLuint __qt_return_value = __qt_this->glCreateShader(static_cast<GLenum>(type0));
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glCullFace(GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glCullFace_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glCullFace(GLenum)", __this_nativeId)
        __qt_this->glCullFace(static_cast<GLenum>(mode0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDeleteBuffers(GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDeleteBuffers_1native_1GLsizei_1const_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject buffers1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDeleteBuffers(GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_buffers1_buffer(__jni_env, buffers1);
        const GLuint* __qt_buffers1 = __qt_buffers1_buffer.data<GLuint>();
        __qt_this->glDeleteBuffers(static_cast<GLsizei>(n0), __qt_buffers1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDeleteFramebuffers(GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDeleteFramebuffers_1native_1GLsizei_1const_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject framebuffers1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDeleteFramebuffers(GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_framebuffers1_buffer(__jni_env, framebuffers1);
        const GLuint* __qt_framebuffers1 = __qt_framebuffers1_buffer.data<GLuint>();
        __qt_this->glDeleteFramebuffers(static_cast<GLsizei>(n0), __qt_framebuffers1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDeleteProgram(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDeleteProgram_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDeleteProgram(GLuint)", __this_nativeId)
        __qt_this->glDeleteProgram(static_cast<GLuint>(program0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDeleteRenderbuffers(GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDeleteRenderbuffers_1native_1GLsizei_1const_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject renderbuffers1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDeleteRenderbuffers(GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_renderbuffers1_buffer(__jni_env, renderbuffers1);
        const GLuint* __qt_renderbuffers1 = __qt_renderbuffers1_buffer.data<GLuint>();
        __qt_this->glDeleteRenderbuffers(static_cast<GLsizei>(n0), __qt_renderbuffers1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDeleteShader(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDeleteShader_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint shader0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDeleteShader(GLuint)", __this_nativeId)
        __qt_this->glDeleteShader(static_cast<GLuint>(shader0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDeleteTextures(GLsizei,const GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDeleteTextures_1native_1GLsizei_1const_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject textures1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDeleteTextures(GLsizei,const GLuint*)", __this_nativeId)
        JBufferConstData __qt_textures1_buffer(__jni_env, textures1);
        const GLuint* __qt_textures1 = __qt_textures1_buffer.data<GLuint>();
        __qt_this->glDeleteTextures(static_cast<GLsizei>(n0), __qt_textures1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDepthFunc(GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDepthFunc_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint func0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDepthFunc(GLenum)", __this_nativeId)
        __qt_this->glDepthFunc(static_cast<GLenum>(func0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDepthMask(GLboolean)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDepthMask_1native_1GLboolean__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean flag0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDepthMask(GLboolean)", __this_nativeId)
        __qt_this->glDepthMask(static_cast<GLboolean>(flag0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDepthRangef(GLclampf,GLclampf)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDepthRangef_1native_1GLclampf_1GLclampf__JFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat zNear0,
 jfloat zFar1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDepthRangef(GLclampf,GLclampf)", __this_nativeId)
        __qt_this->glDepthRangef(static_cast<GLclampf>(zNear0), static_cast<GLclampf>(zFar1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDetachShader(GLuint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDetachShader_1native_1GLuint_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint shader1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDetachShader(GLuint,GLuint)", __this_nativeId)
        __qt_this->glDetachShader(static_cast<GLuint>(program0), static_cast<GLuint>(shader1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDisable(GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDisable_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint cap0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDisable(GLenum)", __this_nativeId)
        __qt_this->glDisable(static_cast<GLenum>(cap0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDisableVertexAttribArray(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDisableVertexAttribArray_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDisableVertexAttribArray(GLuint)", __this_nativeId)
        __qt_this->glDisableVertexAttribArray(static_cast<GLuint>(index0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDrawArrays(GLenum,GLint,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDrawArrays_1native_1GLenum_1GLint_1GLsizei__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0,
 jint first1,
 jint count2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDrawArrays(GLenum,GLint,GLsizei)", __this_nativeId)
        __qt_this->glDrawArrays(static_cast<GLenum>(mode0), static_cast<GLint>(first1), static_cast<GLsizei>(count2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glDrawElements(GLenum,GLsizei,GLenum,const GLvoid*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glDrawElements_1native_1GLenum_1GLsizei_1GLenum_1const_1GLvoid_1ptr__JIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0,
 jint count1,
 jint type2,
 jobject indices3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glDrawElements(GLenum,GLsizei,GLenum,const GLvoid*)", __this_nativeId)
        JBufferConstData __qt_indices3_buffer(__jni_env, indices3);
        const GLvoid* __qt_indices3 = __qt_indices3_buffer.data<GLvoid>();
        __qt_this->glDrawElements(static_cast<GLenum>(mode0), static_cast<GLsizei>(count1), static_cast<GLenum>(type2), __qt_indices3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glEnable(GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glEnable_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint cap0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glEnable(GLenum)", __this_nativeId)
        __qt_this->glEnable(static_cast<GLenum>(cap0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glEnableVertexAttribArray(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glEnableVertexAttribArray_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glEnableVertexAttribArray(GLuint)", __this_nativeId)
        __qt_this->glEnableVertexAttribArray(static_cast<GLuint>(index0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glFinish()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glFinish_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glFinish()", __this_nativeId)
        __qt_this->glFinish();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glFlush()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glFlush_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glFlush()", __this_nativeId)
        __qt_this->glFlush();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glFramebufferRenderbuffer(GLenum,GLenum,GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glFramebufferRenderbuffer_1native_1GLenum_1GLenum_1GLenum_1GLuint__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint attachment1,
 jint renderbuffertarget2,
 jint renderbuffer3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glFramebufferRenderbuffer(GLenum,GLenum,GLenum,GLuint)", __this_nativeId)
        __qt_this->glFramebufferRenderbuffer(static_cast<GLenum>(target0), static_cast<GLenum>(attachment1), static_cast<GLenum>(renderbuffertarget2), static_cast<GLuint>(renderbuffer3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glFramebufferTexture2D(GLenum,GLenum,GLenum,GLuint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glFramebufferTexture2D_1native_1GLenum_1GLenum_1GLenum_1GLuint_1GLint__JIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint attachment1,
 jint textarget2,
 jint texture3,
 jint level4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glFramebufferTexture2D(GLenum,GLenum,GLenum,GLuint,GLint)", __this_nativeId)
        __qt_this->glFramebufferTexture2D(static_cast<GLenum>(target0), static_cast<GLenum>(attachment1), static_cast<GLenum>(textarget2), static_cast<GLuint>(texture3), static_cast<GLint>(level4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glFrontFace(GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glFrontFace_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mode0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glFrontFace(GLenum)", __this_nativeId)
        __qt_this->glFrontFace(static_cast<GLenum>(mode0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGenBuffers(GLsizei,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGenBuffers_1native_1GLsizei_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject buffers1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGenBuffers(GLsizei,GLuint*)", __this_nativeId)
        JBufferData __qt_buffers1_buffer(__jni_env, buffers1);
        GLuint* __qt_buffers1 = __qt_buffers1_buffer.data<GLuint>();
        __qt_this->glGenBuffers(static_cast<GLsizei>(n0), __qt_buffers1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGenFramebuffers(GLsizei,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGenFramebuffers_1native_1GLsizei_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject framebuffers1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGenFramebuffers(GLsizei,GLuint*)", __this_nativeId)
        JBufferData __qt_framebuffers1_buffer(__jni_env, framebuffers1);
        GLuint* __qt_framebuffers1 = __qt_framebuffers1_buffer.data<GLuint>();
        __qt_this->glGenFramebuffers(static_cast<GLsizei>(n0), __qt_framebuffers1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGenRenderbuffers(GLsizei,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGenRenderbuffers_1native_1GLsizei_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject renderbuffers1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGenRenderbuffers(GLsizei,GLuint*)", __this_nativeId)
        JBufferData __qt_renderbuffers1_buffer(__jni_env, renderbuffers1);
        GLuint* __qt_renderbuffers1 = __qt_renderbuffers1_buffer.data<GLuint>();
        __qt_this->glGenRenderbuffers(static_cast<GLsizei>(n0), __qt_renderbuffers1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGenTextures(GLsizei,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGenTextures_1native_1GLsizei_1GLuint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject textures1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGenTextures(GLsizei,GLuint*)", __this_nativeId)
        JBufferData __qt_textures1_buffer(__jni_env, textures1);
        GLuint* __qt_textures1 = __qt_textures1_buffer.data<GLuint>();
        __qt_this->glGenTextures(static_cast<GLsizei>(n0), __qt_textures1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGenerateMipmap(GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGenerateMipmap_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGenerateMipmap(GLenum)", __this_nativeId)
        __qt_this->glGenerateMipmap(static_cast<GLenum>(target0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetActiveAttrib(GLuint,GLuint,GLsizei,GLsizei*,GLint*,GLenum*,char*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetActiveAttrib_1native_1GLuint_1GLuint_1GLsizei_1GLsizei_1ptr_1GLint_1ptr_1GLenum_1ptr_1char_1ptr__JIIILjava_nio_IntBuffer_2Ljava_nio_IntBuffer_2Ljava_nio_IntBuffer_2Ljava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint index1,
 jint bufsize2,
 jobject length3,
 jobject size4,
 jobject type5,
 jobject name6)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetActiveAttrib(GLuint,GLuint,GLsizei,GLsizei*,GLint*,GLenum*,char*)", __this_nativeId)
        JBufferData __qt_length3_buffer(__jni_env, length3);
        GLsizei* __qt_length3 = __qt_length3_buffer.data<GLsizei>();
        JBufferData __qt_size4_buffer(__jni_env, size4);
        GLint* __qt_size4 = __qt_size4_buffer.data<GLint>();
        JBufferData __qt_type5_buffer(__jni_env, type5);
        GLenum* __qt_type5 = __qt_type5_buffer.data<GLenum>();
        JBufferData __qt_name6_buffer(__jni_env, name6);
        char* __qt_name6 = __qt_name6_buffer.data<char>();
        __qt_this->glGetActiveAttrib(static_cast<GLuint>(program0), static_cast<GLuint>(index1), static_cast<GLsizei>(bufsize2), __qt_length3, __qt_size4, __qt_type5, __qt_name6);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetActiveUniform(GLuint,GLuint,GLsizei,GLsizei*,GLint*,GLenum*,char*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetActiveUniform_1native_1GLuint_1GLuint_1GLsizei_1GLsizei_1ptr_1GLint_1ptr_1GLenum_1ptr_1char_1ptr__JIIILjava_nio_IntBuffer_2Ljava_nio_IntBuffer_2Ljava_nio_IntBuffer_2Ljava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint index1,
 jint bufsize2,
 jobject length3,
 jobject size4,
 jobject type5,
 jobject name6)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetActiveUniform(GLuint,GLuint,GLsizei,GLsizei*,GLint*,GLenum*,char*)", __this_nativeId)
        JBufferData __qt_length3_buffer(__jni_env, length3);
        GLsizei* __qt_length3 = __qt_length3_buffer.data<GLsizei>();
        JBufferData __qt_size4_buffer(__jni_env, size4);
        GLint* __qt_size4 = __qt_size4_buffer.data<GLint>();
        JBufferData __qt_type5_buffer(__jni_env, type5);
        GLenum* __qt_type5 = __qt_type5_buffer.data<GLenum>();
        JBufferData __qt_name6_buffer(__jni_env, name6);
        char* __qt_name6 = __qt_name6_buffer.data<char>();
        __qt_this->glGetActiveUniform(static_cast<GLuint>(program0), static_cast<GLuint>(index1), static_cast<GLsizei>(bufsize2), __qt_length3, __qt_size4, __qt_type5, __qt_name6);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetAttachedShaders(GLuint,GLsizei,GLsizei*,GLuint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetAttachedShaders_1native_1GLuint_1GLsizei_1GLsizei_1ptr_1GLuint_1ptr__JIILjava_nio_IntBuffer_2Ljava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint maxcount1,
 jobject count2,
 jobject shaders3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetAttachedShaders(GLuint,GLsizei,GLsizei*,GLuint*)", __this_nativeId)
        JBufferData __qt_count2_buffer(__jni_env, count2);
        GLsizei* __qt_count2 = __qt_count2_buffer.data<GLsizei>();
        JBufferData __qt_shaders3_buffer(__jni_env, shaders3);
        GLuint* __qt_shaders3 = __qt_shaders3_buffer.data<GLuint>();
        __qt_this->glGetAttachedShaders(static_cast<GLuint>(program0), static_cast<GLsizei>(maxcount1), __qt_count2, __qt_shaders3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetAttribLocation(GLuint,const char*)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetAttribLocation_1native_1GLuint_1const_1char_1ptr__JILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jstring name1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetAttribLocation(GLuint,const char*)", __this_nativeId)
        const char*  __qt_name1 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, name1);
        GLint __qt_return_value = __qt_this->glGetAttribLocation(static_cast<GLuint>(program0), __qt_name1);
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glGetBooleanv(GLenum,GLboolean*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetBooleanv_1native_1GLenum_1GLboolean_1ptr__JILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pname0,
 jobject params1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetBooleanv(GLenum,GLboolean*)", __this_nativeId)
        JBufferData __qt_params1_buffer(__jni_env, params1);
        GLboolean* __qt_params1 = __qt_params1_buffer.data<GLboolean>();
        __qt_this->glGetBooleanv(static_cast<GLenum>(pname0), __qt_params1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetBufferParameteriv(GLenum,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetBufferParameteriv_1native_1GLenum_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetBufferParameteriv(GLenum,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetBufferParameteriv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetError()
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetError_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetError()", __this_nativeId)
        GLenum __qt_return_value = __qt_this->glGetError();
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glGetFloatv(GLenum,GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetFloatv_1native_1GLenum_1GLfloat_1ptr__JILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pname0,
 jobject params1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetFloatv(GLenum,GLfloat*)", __this_nativeId)
        JBufferData __qt_params1_buffer(__jni_env, params1);
        GLfloat* __qt_params1 = __qt_params1_buffer.data<GLfloat>();
        __qt_this->glGetFloatv(static_cast<GLenum>(pname0), __qt_params1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetFramebufferAttachmentParameteriv(GLenum,GLenum,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetFramebufferAttachmentParameteriv_1native_1GLenum_1GLenum_1GLenum_1GLint_1ptr__JIIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint attachment1,
 jint pname2,
 jobject params3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetFramebufferAttachmentParameteriv(GLenum,GLenum,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params3_buffer(__jni_env, params3);
        GLint* __qt_params3 = __qt_params3_buffer.data<GLint>();
        __qt_this->glGetFramebufferAttachmentParameteriv(static_cast<GLenum>(target0), static_cast<GLenum>(attachment1), static_cast<GLenum>(pname2), __qt_params3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetIntegerv(GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetIntegerv_1native_1GLenum_1GLint_1ptr__JILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pname0,
 jobject params1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetIntegerv(GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params1_buffer(__jni_env, params1);
        GLint* __qt_params1 = __qt_params1_buffer.data<GLint>();
        __qt_this->glGetIntegerv(static_cast<GLenum>(pname0), __qt_params1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetProgramInfoLog(GLuint,GLsizei,GLsizei*,char*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetProgramInfoLog_1native_1GLuint_1GLsizei_1GLsizei_1ptr_1char_1ptr__JIILjava_nio_IntBuffer_2Ljava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint bufsize1,
 jobject length2,
 jobject infolog3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetProgramInfoLog(GLuint,GLsizei,GLsizei*,char*)", __this_nativeId)
        JBufferData __qt_length2_buffer(__jni_env, length2);
        GLsizei* __qt_length2 = __qt_length2_buffer.data<GLsizei>();
        JBufferData __qt_infolog3_buffer(__jni_env, infolog3);
        char* __qt_infolog3 = __qt_infolog3_buffer.data<char>();
        __qt_this->glGetProgramInfoLog(static_cast<GLuint>(program0), static_cast<GLsizei>(bufsize1), __qt_length2, __qt_infolog3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetProgramiv(GLuint,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetProgramiv_1native_1GLuint_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetProgramiv(GLuint,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetProgramiv(static_cast<GLuint>(program0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetRenderbufferParameteriv(GLenum,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetRenderbufferParameteriv_1native_1GLenum_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetRenderbufferParameteriv(GLenum,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetRenderbufferParameteriv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetShaderInfoLog(GLuint,GLsizei,GLsizei*,char*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetShaderInfoLog_1native_1GLuint_1GLsizei_1GLsizei_1ptr_1char_1ptr__JIILjava_nio_IntBuffer_2Ljava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint shader0,
 jint bufsize1,
 jobject length2,
 jobject infolog3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetShaderInfoLog(GLuint,GLsizei,GLsizei*,char*)", __this_nativeId)
        JBufferData __qt_length2_buffer(__jni_env, length2);
        GLsizei* __qt_length2 = __qt_length2_buffer.data<GLsizei>();
        JBufferData __qt_infolog3_buffer(__jni_env, infolog3);
        char* __qt_infolog3 = __qt_infolog3_buffer.data<char>();
        __qt_this->glGetShaderInfoLog(static_cast<GLuint>(shader0), static_cast<GLsizei>(bufsize1), __qt_length2, __qt_infolog3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetShaderPrecisionFormat(GLenum,GLenum,GLint*,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetShaderPrecisionFormat_1native_1GLenum_1GLenum_1GLint_1ptr_1GLint_1ptr__JIILjava_nio_IntBuffer_2Ljava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint shadertype0,
 jint precisiontype1,
 jobject range2,
 jobject precision3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetShaderPrecisionFormat(GLenum,GLenum,GLint*,GLint*)", __this_nativeId)
        JBufferData __qt_range2_buffer(__jni_env, range2);
        GLint* __qt_range2 = __qt_range2_buffer.data<GLint>();
        JBufferData __qt_precision3_buffer(__jni_env, precision3);
        GLint* __qt_precision3 = __qt_precision3_buffer.data<GLint>();
        __qt_this->glGetShaderPrecisionFormat(static_cast<GLenum>(shadertype0), static_cast<GLenum>(precisiontype1), __qt_range2, __qt_precision3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetShaderSource(GLuint,GLsizei,GLsizei*,char*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetShaderSource_1native_1GLuint_1GLsizei_1GLsizei_1ptr_1char_1ptr__JIILjava_nio_IntBuffer_2Ljava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint shader0,
 jint bufsize1,
 jobject length2,
 jobject source3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetShaderSource(GLuint,GLsizei,GLsizei*,char*)", __this_nativeId)
        JBufferData __qt_length2_buffer(__jni_env, length2);
        GLsizei* __qt_length2 = __qt_length2_buffer.data<GLsizei>();
        JBufferData __qt_source3_buffer(__jni_env, source3);
        char* __qt_source3 = __qt_source3_buffer.data<char>();
        __qt_this->glGetShaderSource(static_cast<GLuint>(shader0), static_cast<GLsizei>(bufsize1), __qt_length2, __qt_source3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetShaderiv(GLuint,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetShaderiv_1native_1GLuint_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint shader0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetShaderiv(GLuint,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetShaderiv(static_cast<GLuint>(shader0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetString(GLenum)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetString_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint name0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetString(GLenum)", __this_nativeId)
        const GLubyte* __qt_return_value = __qt_this->glGetString(static_cast<GLenum>(name0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, QLatin1String(reinterpret_cast<const char *>(__qt_return_value)));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glGetTexParameterfv(GLenum,GLenum,GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetTexParameterfv_1native_1GLenum_1GLenum_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetTexParameterfv(GLenum,GLenum,GLfloat*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLfloat* __qt_params2 = __qt_params2_buffer.data<GLfloat>();
        __qt_this->glGetTexParameterfv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetTexParameteriv(GLenum,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetTexParameteriv_1native_1GLenum_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetTexParameteriv(GLenum,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetTexParameteriv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetUniformLocation(GLuint,const char*)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetUniformLocation_1native_1GLuint_1const_1char_1ptr__JILjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jstring name1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetUniformLocation(GLuint,const char*)", __this_nativeId)
        const char*  __qt_name1 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, name1);
        GLint __qt_return_value = __qt_this->glGetUniformLocation(static_cast<GLuint>(program0), __qt_name1);
        __java_return_value = jint(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glGetUniformfv(GLuint,GLint,GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetUniformfv_1native_1GLuint_1GLint_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetUniformfv(GLuint,GLint,GLfloat*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLfloat* __qt_params2 = __qt_params2_buffer.data<GLfloat>();
        __qt_this->glGetUniformfv(static_cast<GLuint>(program0), static_cast<GLint>(location1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetUniformiv(GLuint,GLint,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetUniformiv_1native_1GLuint_1GLint_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0,
 jint location1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetUniformiv(GLuint,GLint,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetUniformiv(static_cast<GLuint>(program0), static_cast<GLint>(location1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetVertexAttribPointerv(GLuint,GLenum,void**)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetVertexAttribPointerv_1native_1GLuint_1GLenum_1void_1ptr_1ptr__JII_3Ljava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint pname1,
 jobjectArray pointer2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetVertexAttribPointerv(GLuint,GLenum,void**)", __this_nativeId)
        JObjectArrayPointer<void*> __qt_pointer2(__jni_env, jobjectArray(pointer2),
                                        [](void* & pointer,JNIEnv *, jobject){
                                            pointer = nullptr;
                                        },
                                        [](JNIEnv * env, void* const& ptr) -> jobject {
                                            return DataJBuffer(env, ptr, INT_MAX).take();
                                        }
                                    );
        __qt_this->glGetVertexAttribPointerv(static_cast<GLuint>(index0), static_cast<GLenum>(pname1), __qt_pointer2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetVertexAttribfv(GLuint,GLenum,GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetVertexAttribfv_1native_1GLuint_1GLenum_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetVertexAttribfv(GLuint,GLenum,GLfloat*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLfloat* __qt_params2 = __qt_params2_buffer.data<GLfloat>();
        __qt_this->glGetVertexAttribfv(static_cast<GLuint>(index0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glGetVertexAttribiv(GLuint,GLenum,GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glGetVertexAttribiv_1native_1GLuint_1GLenum_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint index0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glGetVertexAttribiv(GLuint,GLenum,GLint*)", __this_nativeId)
        JBufferData __qt_params2_buffer(__jni_env, params2);
        GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glGetVertexAttribiv(static_cast<GLuint>(index0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glHint(GLenum,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glHint_1native_1GLenum_1GLenum__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint mode1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glHint(GLenum,GLenum)", __this_nativeId)
        __qt_this->glHint(static_cast<GLenum>(target0), static_cast<GLenum>(mode1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glIsBuffer(GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glIsBuffer_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint buffer0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glIsBuffer(GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsBuffer(static_cast<GLuint>(buffer0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glIsEnabled(GLenum)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glIsEnabled_1native_1GLenum__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint cap0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glIsEnabled(GLenum)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsEnabled(static_cast<GLenum>(cap0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glIsFramebuffer(GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glIsFramebuffer_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint framebuffer0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glIsFramebuffer(GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsFramebuffer(static_cast<GLuint>(framebuffer0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glIsProgram(GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glIsProgram_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glIsProgram(GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsProgram(static_cast<GLuint>(program0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glIsRenderbuffer(GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glIsRenderbuffer_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint renderbuffer0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glIsRenderbuffer(GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsRenderbuffer(static_cast<GLuint>(renderbuffer0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glIsShader(GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glIsShader_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint shader0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glIsShader(GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsShader(static_cast<GLuint>(shader0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glIsTexture(GLuint)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glIsTexture_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint texture0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glIsTexture(GLuint)", __this_nativeId)
        GLboolean __qt_return_value = __qt_this->glIsTexture(static_cast<GLuint>(texture0));
        __java_return_value = jboolean(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::glLineWidth(GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glLineWidth_1native_1GLfloat__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat width0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glLineWidth(GLfloat)", __this_nativeId)
        __qt_this->glLineWidth(static_cast<GLfloat>(width0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glLinkProgram(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glLinkProgram_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glLinkProgram(GLuint)", __this_nativeId)
        __qt_this->glLinkProgram(static_cast<GLuint>(program0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glPixelStorei(GLenum,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glPixelStorei_1native_1GLenum_1GLint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint pname0,
 jint param1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glPixelStorei(GLenum,GLint)", __this_nativeId)
        __qt_this->glPixelStorei(static_cast<GLenum>(pname0), static_cast<GLint>(param1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glPolygonOffset(GLfloat,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glPolygonOffset_1native_1GLfloat_1GLfloat__JFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat factor0,
 jfloat units1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glPolygonOffset(GLfloat,GLfloat)", __this_nativeId)
        __qt_this->glPolygonOffset(static_cast<GLfloat>(factor0), static_cast<GLfloat>(units1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glReadPixels(GLint,GLint,GLsizei,GLsizei,GLenum,GLenum,GLvoid*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glReadPixels_1native_1GLint_1GLint_1GLsizei_1GLsizei_1GLenum_1GLenum_1GLvoid_1ptr__JIIIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x0,
 jint y1,
 jint width2,
 jint height3,
 jint format4,
 jint type5,
 jobject pixels6)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glReadPixels(GLint,GLint,GLsizei,GLsizei,GLenum,GLenum,GLvoid*)", __this_nativeId)
        JBufferData __qt_pixels6_buffer(__jni_env, pixels6);
        GLvoid* __qt_pixels6 = __qt_pixels6_buffer.data<GLvoid>();
        __qt_this->glReadPixels(static_cast<GLint>(x0), static_cast<GLint>(y1), static_cast<GLsizei>(width2), static_cast<GLsizei>(height3), static_cast<GLenum>(format4), static_cast<GLenum>(type5), __qt_pixels6);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glReleaseShaderCompiler()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glReleaseShaderCompiler_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glReleaseShaderCompiler()", __this_nativeId)
        __qt_this->glReleaseShaderCompiler();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glRenderbufferStorage(GLenum,GLenum,GLsizei,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glRenderbufferStorage_1native_1GLenum_1GLenum_1GLsizei_1GLsizei__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint internalformat1,
 jint width2,
 jint height3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glRenderbufferStorage(GLenum,GLenum,GLsizei,GLsizei)", __this_nativeId)
        __qt_this->glRenderbufferStorage(static_cast<GLenum>(target0), static_cast<GLenum>(internalformat1), static_cast<GLsizei>(width2), static_cast<GLsizei>(height3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glSampleCoverage(GLclampf,GLboolean)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glSampleCoverage_1native_1GLclampf_1GLboolean__JFZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat value0,
 jboolean invert1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glSampleCoverage(GLclampf,GLboolean)", __this_nativeId)
        __qt_this->glSampleCoverage(static_cast<GLclampf>(value0), static_cast<GLboolean>(invert1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glScissor(GLint,GLint,GLsizei,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glScissor_1native_1GLint_1GLint_1GLsizei_1GLsizei__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x0,
 jint y1,
 jint width2,
 jint height3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glScissor(GLint,GLint,GLsizei,GLsizei)", __this_nativeId)
        __qt_this->glScissor(static_cast<GLint>(x0), static_cast<GLint>(y1), static_cast<GLsizei>(width2), static_cast<GLsizei>(height3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glShaderBinary(GLint,const GLuint*,GLenum,const void*,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glShaderBinary_1native_1GLint_1const_1GLuint_1ptr_1GLenum_1const_1void_1ptr_1GLint__JILjava_nio_IntBuffer_2ILjava_nio_Buffer_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint n0,
 jobject shaders1,
 jint binaryformat2,
 jobject binary3,
 jint length4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glShaderBinary(GLint,const GLuint*,GLenum,const void*,GLint)", __this_nativeId)
        JBufferConstData __qt_shaders1_buffer(__jni_env, shaders1);
        const GLuint* __qt_shaders1 = __qt_shaders1_buffer.data<GLuint>();
        JBufferConstData __qt_binary3_buffer(__jni_env, binary3);
        const void* __qt_binary3 = __qt_binary3_buffer.data<void>();
        __qt_this->glShaderBinary(static_cast<GLint>(n0), __qt_shaders1, static_cast<GLenum>(binaryformat2), __qt_binary3, static_cast<GLint>(length4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glShaderSource(GLuint,GLsizei,const char**,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glShaderSource_1native_1GLuint_1GLsizei_1const_1char_1ptr_1ptr_1const_1GLint_1ptr__JI_3Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint shader0,
 jobjectArray string2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glShaderSource(GLuint,GLsizei,const char**,const GLint*)", __this_nativeId)
        jsize __qt_count1 = __jni_env->GetArrayLength(jarray(string2));
        QVector<QSharedPointer<J2CStringBuffer>> string2Vec;
        const char** __qt_string2 = nullptr;
        QScopedArrayPointer<const char*> __qt_string2Ptr(__qt_string2 = new const char*[quint32(__qt_count1)]);
        for(jsize i=0; i<__qt_count1; ++i){
            J2CStringBuffer* b = new J2CStringBuffer(__jni_env, jstring(__jni_env->GetObjectArrayElement(jobjectArray(string2), i)));
            __qt_string2[i] = *b;
            string2Vec << QSharedPointer<J2CStringBuffer>(b);
        }
        const GLint * __qt_length3 = nullptr;
        __qt_this->glShaderSource(static_cast<GLuint>(shader0), GLsizei(__qt_count1), __qt_string2, __qt_length3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glStencilFunc(GLenum,GLint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glStencilFunc_1native_1GLenum_1GLint_1GLuint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint func0,
 jint ref1,
 jint mask2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glStencilFunc(GLenum,GLint,GLuint)", __this_nativeId)
        __qt_this->glStencilFunc(static_cast<GLenum>(func0), static_cast<GLint>(ref1), static_cast<GLuint>(mask2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glStencilFuncSeparate(GLenum,GLenum,GLint,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glStencilFuncSeparate_1native_1GLenum_1GLenum_1GLint_1GLuint__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint face0,
 jint func1,
 jint ref2,
 jint mask3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glStencilFuncSeparate(GLenum,GLenum,GLint,GLuint)", __this_nativeId)
        __qt_this->glStencilFuncSeparate(static_cast<GLenum>(face0), static_cast<GLenum>(func1), static_cast<GLint>(ref2), static_cast<GLuint>(mask3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glStencilMask(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glStencilMask_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint mask0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glStencilMask(GLuint)", __this_nativeId)
        __qt_this->glStencilMask(static_cast<GLuint>(mask0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glStencilMaskSeparate(GLenum,GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glStencilMaskSeparate_1native_1GLenum_1GLuint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint face0,
 jint mask1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glStencilMaskSeparate(GLenum,GLuint)", __this_nativeId)
        __qt_this->glStencilMaskSeparate(static_cast<GLenum>(face0), static_cast<GLuint>(mask1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glStencilOp(GLenum,GLenum,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glStencilOp_1native_1GLenum_1GLenum_1GLenum__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint fail0,
 jint zfail1,
 jint zpass2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glStencilOp(GLenum,GLenum,GLenum)", __this_nativeId)
        __qt_this->glStencilOp(static_cast<GLenum>(fail0), static_cast<GLenum>(zfail1), static_cast<GLenum>(zpass2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glStencilOpSeparate(GLenum,GLenum,GLenum,GLenum)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glStencilOpSeparate_1native_1GLenum_1GLenum_1GLenum_1GLenum__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint face0,
 jint fail1,
 jint zfail2,
 jint zpass3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glStencilOpSeparate(GLenum,GLenum,GLenum,GLenum)", __this_nativeId)
        __qt_this->glStencilOpSeparate(static_cast<GLenum>(face0), static_cast<GLenum>(fail1), static_cast<GLenum>(zfail2), static_cast<GLenum>(zpass3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glTexImage2D(GLenum,GLint,GLint,GLsizei,GLsizei,GLint,GLenum,GLenum,const GLvoid*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glTexImage2D_1native_1GLenum_1GLint_1GLint_1GLsizei_1GLsizei_1GLint_1GLenum_1GLenum_1const_1GLvoid_1ptr__JIIIIIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint internalformat2,
 jint width3,
 jint height4,
 jint border5,
 jint format6,
 jint type7,
 jobject pixels8)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glTexImage2D(GLenum,GLint,GLint,GLsizei,GLsizei,GLint,GLenum,GLenum,const GLvoid*)", __this_nativeId)
        JBufferConstData __qt_pixels8_buffer(__jni_env, pixels8);
        const GLvoid* __qt_pixels8 = __qt_pixels8_buffer.data<GLvoid>();
        __qt_this->glTexImage2D(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLint>(internalformat2), static_cast<GLsizei>(width3), static_cast<GLsizei>(height4), static_cast<GLint>(border5), static_cast<GLenum>(format6), static_cast<GLenum>(type7), __qt_pixels8);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glTexParameterf(GLenum,GLenum,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glTexParameterf_1native_1GLenum_1GLenum_1GLfloat__JIIF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jfloat param2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glTexParameterf(GLenum,GLenum,GLfloat)", __this_nativeId)
        __qt_this->glTexParameterf(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), static_cast<GLfloat>(param2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glTexParameterfv(GLenum,GLenum,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glTexParameterfv_1native_1GLenum_1GLenum_1const_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glTexParameterfv(GLenum,GLenum,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_params2_buffer(__jni_env, params2);
        const GLfloat* __qt_params2 = __qt_params2_buffer.data<GLfloat>();
        __qt_this->glTexParameterfv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glTexParameteri(GLenum,GLenum,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glTexParameteri_1native_1GLenum_1GLenum_1GLint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jint param2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glTexParameteri(GLenum,GLenum,GLint)", __this_nativeId)
        __qt_this->glTexParameteri(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), static_cast<GLint>(param2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glTexParameteriv(GLenum,GLenum,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glTexParameteriv_1native_1GLenum_1GLenum_1const_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint pname1,
 jobject params2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glTexParameteriv(GLenum,GLenum,const GLint*)", __this_nativeId)
        JBufferConstData __qt_params2_buffer(__jni_env, params2);
        const GLint* __qt_params2 = __qt_params2_buffer.data<GLint>();
        __qt_this->glTexParameteriv(static_cast<GLenum>(target0), static_cast<GLenum>(pname1), __qt_params2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glTexSubImage2D(GLenum,GLint,GLint,GLint,GLsizei,GLsizei,GLenum,GLenum,const GLvoid*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glTexSubImage2D_1native_1GLenum_1GLint_1GLint_1GLint_1GLsizei_1GLsizei_1GLenum_1GLenum_1const_1GLvoid_1ptr__JIIIIIIIILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint target0,
 jint level1,
 jint xoffset2,
 jint yoffset3,
 jint width4,
 jint height5,
 jint format6,
 jint type7,
 jobject pixels8)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glTexSubImage2D(GLenum,GLint,GLint,GLint,GLsizei,GLsizei,GLenum,GLenum,const GLvoid*)", __this_nativeId)
        JBufferConstData __qt_pixels8_buffer(__jni_env, pixels8);
        const GLvoid* __qt_pixels8 = __qt_pixels8_buffer.data<GLvoid>();
        __qt_this->glTexSubImage2D(static_cast<GLenum>(target0), static_cast<GLint>(level1), static_cast<GLint>(xoffset2), static_cast<GLint>(yoffset3), static_cast<GLsizei>(width4), static_cast<GLsizei>(height5), static_cast<GLenum>(format6), static_cast<GLenum>(type7), __qt_pixels8);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform1f(GLint,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform1f_1native_1GLint_1GLfloat__JIF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jfloat x1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform1f(GLint,GLfloat)", __this_nativeId)
        __qt_this->glUniform1f(static_cast<GLint>(location0), static_cast<GLfloat>(x1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform1fv(GLint,GLsizei,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform1fv_1native_1GLint_1GLsizei_1const_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject v2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform1fv(GLint,GLsizei,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_v2_buffer(__jni_env, v2);
        const GLfloat* __qt_v2 = __qt_v2_buffer.data<GLfloat>();
        __qt_this->glUniform1fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_v2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform1i(GLint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform1i_1native_1GLint_1GLint__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint x1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform1i(GLint,GLint)", __this_nativeId)
        __qt_this->glUniform1i(static_cast<GLint>(location0), static_cast<GLint>(x1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform1iv(GLint,GLsizei,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform1iv_1native_1GLint_1GLsizei_1const_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject v2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform1iv(GLint,GLsizei,const GLint*)", __this_nativeId)
        JBufferConstData __qt_v2_buffer(__jni_env, v2);
        const GLint* __qt_v2 = __qt_v2_buffer.data<GLint>();
        __qt_this->glUniform1iv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_v2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform2f(GLint,GLfloat,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform2f_1native_1GLint_1GLfloat_1GLfloat__JIFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jfloat x1,
 jfloat y2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform2f(GLint,GLfloat,GLfloat)", __this_nativeId)
        __qt_this->glUniform2f(static_cast<GLint>(location0), static_cast<GLfloat>(x1), static_cast<GLfloat>(y2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform2fv(GLint,GLsizei,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform2fv_1native_1GLint_1GLsizei_1const_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject v2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform2fv(GLint,GLsizei,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_v2_buffer(__jni_env, v2);
        const GLfloat* __qt_v2 = __qt_v2_buffer.data<GLfloat>();
        __qt_this->glUniform2fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_v2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform2i(GLint,GLint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform2i_1native_1GLint_1GLint_1GLint__JIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint x1,
 jint y2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform2i(GLint,GLint,GLint)", __this_nativeId)
        __qt_this->glUniform2i(static_cast<GLint>(location0), static_cast<GLint>(x1), static_cast<GLint>(y2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform2iv(GLint,GLsizei,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform2iv_1native_1GLint_1GLsizei_1const_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject v2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform2iv(GLint,GLsizei,const GLint*)", __this_nativeId)
        JBufferConstData __qt_v2_buffer(__jni_env, v2);
        const GLint* __qt_v2 = __qt_v2_buffer.data<GLint>();
        __qt_this->glUniform2iv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_v2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform3f(GLint,GLfloat,GLfloat,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform3f_1native_1GLint_1GLfloat_1GLfloat_1GLfloat__JIFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jfloat x1,
 jfloat y2,
 jfloat z3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform3f(GLint,GLfloat,GLfloat,GLfloat)", __this_nativeId)
        __qt_this->glUniform3f(static_cast<GLint>(location0), static_cast<GLfloat>(x1), static_cast<GLfloat>(y2), static_cast<GLfloat>(z3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform3fv(GLint,GLsizei,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform3fv_1native_1GLint_1GLsizei_1const_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject v2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform3fv(GLint,GLsizei,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_v2_buffer(__jni_env, v2);
        const GLfloat* __qt_v2 = __qt_v2_buffer.data<GLfloat>();
        __qt_this->glUniform3fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_v2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform3i(GLint,GLint,GLint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform3i_1native_1GLint_1GLint_1GLint_1GLint__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint x1,
 jint y2,
 jint z3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform3i(GLint,GLint,GLint,GLint)", __this_nativeId)
        __qt_this->glUniform3i(static_cast<GLint>(location0), static_cast<GLint>(x1), static_cast<GLint>(y2), static_cast<GLint>(z3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform3iv(GLint,GLsizei,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform3iv_1native_1GLint_1GLsizei_1const_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject v2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform3iv(GLint,GLsizei,const GLint*)", __this_nativeId)
        JBufferConstData __qt_v2_buffer(__jni_env, v2);
        const GLint* __qt_v2 = __qt_v2_buffer.data<GLint>();
        __qt_this->glUniform3iv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_v2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform4f(GLint,GLfloat,GLfloat,GLfloat,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform4f_1native_1GLint_1GLfloat_1GLfloat_1GLfloat_1GLfloat__JIFFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jfloat x1,
 jfloat y2,
 jfloat z3,
 jfloat w4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform4f(GLint,GLfloat,GLfloat,GLfloat,GLfloat)", __this_nativeId)
        __qt_this->glUniform4f(static_cast<GLint>(location0), static_cast<GLfloat>(x1), static_cast<GLfloat>(y2), static_cast<GLfloat>(z3), static_cast<GLfloat>(w4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform4fv(GLint,GLsizei,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform4fv_1native_1GLint_1GLsizei_1const_1GLfloat_1ptr__JIILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject v2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform4fv(GLint,GLsizei,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_v2_buffer(__jni_env, v2);
        const GLfloat* __qt_v2 = __qt_v2_buffer.data<GLfloat>();
        __qt_this->glUniform4fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_v2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform4i(GLint,GLint,GLint,GLint,GLint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform4i_1native_1GLint_1GLint_1GLint_1GLint_1GLint__JIIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint x1,
 jint y2,
 jint z3,
 jint w4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform4i(GLint,GLint,GLint,GLint,GLint)", __this_nativeId)
        __qt_this->glUniform4i(static_cast<GLint>(location0), static_cast<GLint>(x1), static_cast<GLint>(y2), static_cast<GLint>(z3), static_cast<GLint>(w4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniform4iv(GLint,GLsizei,const GLint*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniform4iv_1native_1GLint_1GLsizei_1const_1GLint_1ptr__JIILjava_nio_IntBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jobject v2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniform4iv(GLint,GLsizei,const GLint*)", __this_nativeId)
        JBufferConstData __qt_v2_buffer(__jni_env, v2);
        const GLint* __qt_v2 = __qt_v2_buffer.data<GLint>();
        __qt_this->glUniform4iv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), __qt_v2);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniformMatrix2fv(GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniformMatrix2fv_1native_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jboolean transpose2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniformMatrix2fv(GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glUniformMatrix2fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), static_cast<GLboolean>(transpose2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniformMatrix3fv(GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniformMatrix3fv_1native_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jboolean transpose2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniformMatrix3fv(GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glUniformMatrix3fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), static_cast<GLboolean>(transpose2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUniformMatrix4fv(GLint,GLsizei,GLboolean,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUniformMatrix4fv_1native_1GLint_1GLsizei_1GLboolean_1const_1GLfloat_1ptr__JIIZLjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint location0,
 jint count1,
 jboolean transpose2,
 jobject value3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUniformMatrix4fv(GLint,GLsizei,GLboolean,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_value3_buffer(__jni_env, value3);
        const GLfloat* __qt_value3 = __qt_value3_buffer.data<GLfloat>();
        __qt_this->glUniformMatrix4fv(static_cast<GLint>(location0), static_cast<GLsizei>(count1), static_cast<GLboolean>(transpose2), __qt_value3);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glUseProgram(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glUseProgram_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glUseProgram(GLuint)", __this_nativeId)
        __qt_this->glUseProgram(static_cast<GLuint>(program0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glValidateProgram(GLuint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glValidateProgram_1native_1GLuint__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint program0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glValidateProgram(GLuint)", __this_nativeId)
        __qt_this->glValidateProgram(static_cast<GLuint>(program0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glVertexAttrib1f(GLuint,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glVertexAttrib1f_1native_1GLuint_1GLfloat__JIF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint indx0,
 jfloat x1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glVertexAttrib1f(GLuint,GLfloat)", __this_nativeId)
        __qt_this->glVertexAttrib1f(static_cast<GLuint>(indx0), static_cast<GLfloat>(x1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glVertexAttrib1fv(GLuint,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glVertexAttrib1fv_1native_1GLuint_1const_1GLfloat_1ptr__JILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint indx0,
 jobject values1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glVertexAttrib1fv(GLuint,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_values1_buffer(__jni_env, values1);
        const GLfloat* __qt_values1 = __qt_values1_buffer.data<GLfloat>();
        __qt_this->glVertexAttrib1fv(static_cast<GLuint>(indx0), __qt_values1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glVertexAttrib2f(GLuint,GLfloat,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glVertexAttrib2f_1native_1GLuint_1GLfloat_1GLfloat__JIFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint indx0,
 jfloat x1,
 jfloat y2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glVertexAttrib2f(GLuint,GLfloat,GLfloat)", __this_nativeId)
        __qt_this->glVertexAttrib2f(static_cast<GLuint>(indx0), static_cast<GLfloat>(x1), static_cast<GLfloat>(y2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glVertexAttrib2fv(GLuint,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glVertexAttrib2fv_1native_1GLuint_1const_1GLfloat_1ptr__JILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint indx0,
 jobject values1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glVertexAttrib2fv(GLuint,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_values1_buffer(__jni_env, values1);
        const GLfloat* __qt_values1 = __qt_values1_buffer.data<GLfloat>();
        __qt_this->glVertexAttrib2fv(static_cast<GLuint>(indx0), __qt_values1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glVertexAttrib3f(GLuint,GLfloat,GLfloat,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glVertexAttrib3f_1native_1GLuint_1GLfloat_1GLfloat_1GLfloat__JIFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint indx0,
 jfloat x1,
 jfloat y2,
 jfloat z3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glVertexAttrib3f(GLuint,GLfloat,GLfloat,GLfloat)", __this_nativeId)
        __qt_this->glVertexAttrib3f(static_cast<GLuint>(indx0), static_cast<GLfloat>(x1), static_cast<GLfloat>(y2), static_cast<GLfloat>(z3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glVertexAttrib3fv(GLuint,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glVertexAttrib3fv_1native_1GLuint_1const_1GLfloat_1ptr__JILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint indx0,
 jobject values1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glVertexAttrib3fv(GLuint,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_values1_buffer(__jni_env, values1);
        const GLfloat* __qt_values1 = __qt_values1_buffer.data<GLfloat>();
        __qt_this->glVertexAttrib3fv(static_cast<GLuint>(indx0), __qt_values1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glVertexAttrib4f(GLuint,GLfloat,GLfloat,GLfloat,GLfloat)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glVertexAttrib4f_1native_1GLuint_1GLfloat_1GLfloat_1GLfloat_1GLfloat__JIFFFF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint indx0,
 jfloat x1,
 jfloat y2,
 jfloat z3,
 jfloat w4)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glVertexAttrib4f(GLuint,GLfloat,GLfloat,GLfloat,GLfloat)", __this_nativeId)
        __qt_this->glVertexAttrib4f(static_cast<GLuint>(indx0), static_cast<GLfloat>(x1), static_cast<GLfloat>(y2), static_cast<GLfloat>(z3), static_cast<GLfloat>(w4));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glVertexAttrib4fv(GLuint,const GLfloat*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glVertexAttrib4fv_1native_1GLuint_1const_1GLfloat_1ptr__JILjava_nio_FloatBuffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint indx0,
 jobject values1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glVertexAttrib4fv(GLuint,const GLfloat*)", __this_nativeId)
        JBufferConstData __qt_values1_buffer(__jni_env, values1);
        const GLfloat* __qt_values1 = __qt_values1_buffer.data<GLfloat>();
        __qt_this->glVertexAttrib4fv(static_cast<GLuint>(indx0), __qt_values1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glVertexAttribPointer(GLuint,GLint,GLenum,GLboolean,GLsizei,const void*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glVertexAttribPointer_1native_1GLuint_1GLint_1GLenum_1GLboolean_1GLsizei_1const_1void_1ptr__JIIIZILjava_nio_Buffer_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint indx0,
 jint size1,
 jint type2,
 jboolean normalized3,
 jint stride4,
 jobject ptr5)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glVertexAttribPointer(GLuint,GLint,GLenum,GLboolean,GLsizei,const void*)", __this_nativeId)
        JBufferConstData __qt_ptr5_buffer(__jni_env, ptr5);
        const void* __qt_ptr5 = __qt_ptr5_buffer.data<void>();
        __qt_this->glVertexAttribPointer(static_cast<GLuint>(indx0), static_cast<GLint>(size1), static_cast<GLenum>(type2), static_cast<GLboolean>(normalized3), static_cast<GLsizei>(stride4), __qt_ptr5);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::glViewport(GLint,GLint,GLsizei,GLsizei)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_glViewport_1native_1GLint_1GLint_1GLsizei_1GLsizei__JIIII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint x0,
 jint y1,
 jint width2,
 jint height3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::glViewport(GLint,GLint,GLsizei,GLsizei)", __this_nativeId)
        __qt_this->glViewport(static_cast<GLint>(x0), static_cast<GLint>(y1), static_cast<GLsizei>(width2), static_cast<GLsizei>(height3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::hasOpenGLFeature(QOpenGLFunctions::OpenGLFeature)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_hasOpenGLFeature_1native_1QOpenGLFunctions_1OpenGLFeature_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint feature0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::hasOpenGLFeature(QOpenGLFunctions::OpenGLFeature)const", __this_nativeId)
        QOpenGLFunctions::OpenGLFeature __qt_feature0 = qtjambi_cast<QOpenGLFunctions::OpenGLFeature>(__jni_env, feature0);
        __java_return_value = __qt_this->hasOpenGLFeature(QOpenGLFunctions::OpenGLFeature(__qt_feature0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QOpenGLFunctions::initializeOpenGLFunctions()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_initializeOpenGLFunctions_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::initializeOpenGLFunctions()", __this_nativeId)
        __qt_this->initializeOpenGLFunctions();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QOpenGLFunctions::openGLFeatures()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_openGLFeatures_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QOpenGLFunctions::openGLFeatures()const", __this_nativeId)
        QOpenGLFunctions::OpenGLFeatures __qt_return_value = __qt_this->openGLFeatures();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_gui_QOpenGLFunctions_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QOpenGLFunctions *__qt_this = QtJambiAPI::objectFromNativeId<QOpenGLFunctions>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QOpenGLFunctions(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QOpenGLFunctions>("QOpenGLFunctions", "io/qt/gui/QOpenGLFunctions");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QOpenGLFunctions, {
        ConstructorInfo(&__qt_construct_QOpenGLFunctions, nullptr)
       ,ConstructorInfo(&__qt_construct_QOpenGLFunctions_QOpenGLContext_ptr, "Lio/qt/gui/QOpenGLContext;")
       ,ConstructorInfo(&__qt_construct_QOpenGLFunctions_cref_QOpenGLFunctions, "Lio/qt/gui/QOpenGLFunctions;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QOpenGLFunctions);
    registerMetaType<QOpenGLFunctions>("QOpenGLFunctions");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QOpenGLFunctions::OpenGLFeature>("QOpenGLFunctions::OpenGLFeature", "io/qt/gui/QOpenGLFunctions$OpenGLFeature", "QOpenGLFunctions::OpenGLFeatures", "QFlags<QOpenGLFunctions::OpenGLFeature>", "io/qt/gui/QOpenGLFunctions$OpenGLFeatures");
// END: enums and flags
}
