#ifndef QTEXTOBJECTINTERFACE_IMPL_SHELL_H
#define QTEXTOBJECTINTERFACE_IMPL_SHELL_H

#include <QtCore/QtGlobal>
#include <QtGui/qabstracttextdocumentlayout.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qrect.h>
#include <QtCore/qsize.h>
#include <QtGui/qpainter.h>
#include <QtGui/qtextdocument.h>
#include <QtGui/qtextformat.h>
#include <QtJambi/RegistryAPI>


class QTextObjectInterface_shell : public QTextObjectInterface, public QtJambiShellInterface
{
public:
    QTextObjectInterface_shell();
    ~QTextObjectInterface_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QTextObjectInterface_oshell;
};


class QTextObjectInterface_oshell : public QTextObjectInterface_shell
{
public:
    using QTextObjectInterface_shell::QTextObjectInterface_shell;
    void drawObject(QPainter* painter0, const QRectF& rect1, QTextDocument* doc2, int posInDocument3, const QTextFormat& format4) override;
    QSizeF intrinsicSize(QTextDocument* doc0, int posInDocument1, const QTextFormat& format2) override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QTextObjectInterface_access : public QTextObjectInterface
{
    void __qt_drawObject_QPainter_ptr_cref_QRectF_QTextDocument_ptr_int_cref_QTextFormat(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID painter0, QtJambiNativeID rect1, QtJambiNativeID doc2, jint posInDocument3, QtJambiNativeID format4);
    jobject __qt_intrinsicSize_QTextDocument_ptr_int_cref_QTextFormat(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID doc0, jint posInDocument1, QtJambiNativeID format2);
};

#endif // QTEXTOBJECTINTERFACE_IMPL_SHELL_H
