#ifndef QUTIMIMECONVERTER_SHELL_H
#define QUTIMIMECONVERTER_SHELL_H

#include <QtCore/QtGlobal>
#include <QtCore/qcompilerdetection.h>

QT_WARNING_DISABLE_DEPRECATED
QT_WARNING_DISABLE_GCC("-Wdeprecated-declarations")

#if __has_include(<QtGui/qutimimeconverter.h>)
#include <QtGui/qutimimeconverter.h>
#endif
#include <QtJambi/QtJambiAPI>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qmimedata.h>
#include <QtJambi/RegistryAPI>


#if defined(Q_OS_MACOS)

class QUtiMimeConverter_shell : public QUtiMimeConverter, public QtJambiShellInterface
{
public:
    QUtiMimeConverter_shell();
    ~QUtiMimeConverter_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QUtiMimeConverter_oshell;
};


class QUtiMimeConverter_oshell : public QUtiMimeConverter_shell
{
public:
    using QUtiMimeConverter_shell::QUtiMimeConverter_shell;
    QList<QByteArray> convertFromMime(const QString& mime0, const QVariant& data1, const QString& uti2) const override;
    QVariant convertToMime(const QString& mime0, const QList<QByteArray>& data1, const QString& uti2) const override;
    int count(const QMimeData* mimeData0) const override;
    QString mimeForUti(const QString& uti0) const override;
    QString utiForMime(const QString& mime0) const override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QUtiMimeConverter_access : public QUtiMimeConverter
{
    jobject __qt_convertFromMime_cref_QString_cref_QVariant_cref_QString_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring mime0, jobject data1, jstring uti2) const;
    jobject __qt_convertToMime_cref_QString_cref_QList_cref_QString_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring mime0, jobject data1, jstring uti2) const;
    jint __qt_count_const_QMimeData_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID mimeData0) const;
    jstring __qt_mimeForUti_cref_QString_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring uti0) const;
    jstring __qt_utiForMime_cref_QString_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring mime0) const;
};

#endif // defined(Q_OS_MACOS)
#endif // QUTIMIMECONVERTER_SHELL_H
