#include <QtCore/QtGlobal>
#include <QtCore/qbitarray.h>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qhashfunctions.h>
#include <QtCore/qsysinfo.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/JavaAPI>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QBitArray(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QBitArray")
    QBitArray *_ptr = reinterpret_cast<QBitArray *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QBitArray()
void __qt_construct_QBitArray(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBitArray()")
    Q_UNUSED(__java_arguments)
    QBitArray *__qt_this = new(__qtjambi_ptr) QBitArray();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QBitArray::QBitArray()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_initialize_1native__Lio_qt_core_QBitArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBitArray::QBitArray()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBitArray, sizeof(QBitArray), typeid(QBitArray), false, &deleter_QBitArray, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBitArray(QBitArray)
void __qt_construct_QBitArray_cref_QBitArray(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBitArray(QBitArray)")
    jobject other0 = __java_arguments[0].l;
    const QBitArray& __qt_other0 = qtjambi_cast<const QBitArray& >(__jni_env, other0);
    QBitArray *__qt_this = new(__qtjambi_ptr) QBitArray(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QBitArray::QBitArray(QBitArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_initialize_1native__Lio_qt_core_QBitArray_2Lio_qt_core_QBitArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBitArray::QBitArray(QBitArray)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBitArray_cref_QBitArray, sizeof(QBitArray), typeid(QBitArray), false, &deleter_QBitArray, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QBitArray(qsizetype,bool)
void __qt_construct_QBitArray_qsizetype(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBitArray(qsizetype,bool)")
    jlong size0 = __java_arguments[0].j;
    Q_UNUSED(size0)
    QBitArray *__qt_this = new(__qtjambi_ptr) QBitArray(static_cast<qsizetype>(size0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QBitArray(qsizetype,bool)
void __qt_construct_QBitArray_qsizetype_bool(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QBitArray(qsizetype,bool)")
    jlong size0 = __java_arguments[0].j;
    Q_UNUSED(size0)
    jboolean val1 = __java_arguments[1].z;
    Q_UNUSED(val1)
    QBitArray *__qt_this = new(__qtjambi_ptr) QBitArray(static_cast<qsizetype>(size0), static_cast<bool>(val1));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QBitArray::QBitArray(qsizetype,bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_initialize_1native__Lio_qt_core_QBitArray_2JZ)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jlong size0,
 jboolean val1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBitArray::QBitArray(qsizetype,bool)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].j = size0;
        arguments[1].z = val1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QBitArray_qsizetype_bool, sizeof(QBitArray), typeid(QBitArray), false, &deleter_QBitArray, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QBitArray
void __qt_destruct_QBitArray(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QBitArray")
    reinterpret_cast<QBitArray*>(ptr)->~QBitArray();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QBitArray::at(qsizetype)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_at_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong i0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::at(qsizetype)const", __qt_this)
        __java_return_value = __qt_this->at(static_cast<qsizetype>(i0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::bits()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_bits_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::bits()const", __qt_this)
        const char* __qt_return_value = __qt_this->bits();
        DataJBuffer __java_return_value_buffer(__jni_env, __qt_return_value, __qt_this->size()/8 + ( __qt_this->size() % 8 == 0 ? 0 : 1 ));
        __java_return_value = __java_return_value_buffer.take();
        QtJambiAPI::registerDependency(__jni_env, __java_return_value, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::clear()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_clear_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::clear()", __qt_this)
        __qt_this->clear();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::clearBit(qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_clearBit_1native_1qsizetype__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong i0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::clearBit(qsizetype)", __qt_this)
        __qt_this->clearBit(static_cast<qsizetype>(i0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::count()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_count_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::count()const", __qt_this)
        qsizetype __qt_return_value = __qt_this->count();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::count(bool)const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_count_1native_1bool_1constfct__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean on0)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::count(bool)const", __qt_this)
        qsizetype __qt_return_value = __qt_this->count(static_cast<bool>(on0));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::detach()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_detach_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::detach()", __qt_this)
        __qt_this->detach();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::fill(bool,qsizetype)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_fill_1native_1bool_1qsizetype__JZJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean val0,
 jlong size1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::fill(bool,qsizetype)", __qt_this)
        __java_return_value = __qt_this->fill(static_cast<bool>(val0), static_cast<qsizetype>(size1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::fill(bool,qsizetype,qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_fill_1native_1bool_1qsizetype_1qsizetype__JZJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean val0,
 jlong first1,
 jlong last2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::fill(bool,qsizetype,qsizetype)", __qt_this)
        __qt_this->fill(static_cast<bool>(val0), static_cast<qsizetype>(first1), static_cast<qsizetype>(last2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::isDetached()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_isDetached_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::isDetached()const", __qt_this)
        __java_return_value = __qt_this->isDetached();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::isEmpty()const", __qt_this)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::operator&(QBitArray,QBitArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_and_1native_1cref_1QBitArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::operator&(QBitArray,QBitArray)", __qt_this)
        const QBitArray& __qt_arg__2 = QtJambiAPI::valueReferenceFromNativeId<QBitArray>(arg__2);
        QBitArray __qt_return_value = (*__qt_this) & __qt_arg__2;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::operator<<(QDataStream&,QBitArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::operator<<(QDataStream&,QBitArray)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::operator=(QBitArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_assign_1native_1cref_1QBitArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::operator=(QBitArray)", __qt_this)
        const QBitArray& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QBitArray>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::operator==(QBitArray)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_equals_1native_1cref_1QBitArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::operator==(QBitArray)const", __qt_this)
        const QBitArray& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QBitArray>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::operator>>(QDataStream&,QBitArray&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::operator>>(QDataStream&,QBitArray&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::operator[](qsizetype)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_get_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong i0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::operator[](qsizetype)const", __qt_this)
        __java_return_value = (*__qt_this)[static_cast<qsizetype>(i0)];
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::operator[](qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_set_1native_1qsizetype_1bool__JJZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong i0,
 jboolean value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::operator[](qsizetype)", __qt_this)
        (*__qt_this)[static_cast<qsizetype>(i0)] = static_cast<bool>(value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::operator^(QBitArray,QBitArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_xor_1native_1cref_1QBitArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::operator^(QBitArray,QBitArray)", __qt_this)
        const QBitArray& __qt_arg__2 = QtJambiAPI::valueReferenceFromNativeId<QBitArray>(arg__2);
        QBitArray __qt_return_value = (*__qt_this) ^ __qt_arg__2;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::operator|(QBitArray,QBitArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_or_1native_1cref_1QBitArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::operator|(QBitArray,QBitArray)", __qt_this)
        const QBitArray& __qt_arg__2 = QtJambiAPI::valueReferenceFromNativeId<QBitArray>(arg__2);
        QBitArray __qt_return_value = (*__qt_this) | __qt_arg__2;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::operator~()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_inverted_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::operator~()const", __qt_this)
        QBitArray __qt_return_value = ~(*__qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::resize(qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_resize_1native_1qsizetype__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong size0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::resize(qsizetype)", __qt_this)
        __qt_this->resize(static_cast<qsizetype>(size0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::setBit(qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_setBit_1native_1qsizetype__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong i0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::setBit(qsizetype)", __qt_this)
        __qt_this->setBit(static_cast<qsizetype>(i0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::setBit(qsizetype,bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_setBit_1native_1qsizetype_1bool__JJZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong i0,
 jboolean val1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::setBit(qsizetype,bool)", __qt_this)
        __qt_this->setBit(static_cast<qsizetype>(i0), static_cast<bool>(val1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::size()const
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::size()const", __qt_this)
        qsizetype __qt_return_value = __qt_this->size();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::swap(QBitArray&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_swap_1native_1ref_1QBitArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::swap(QBitArray&)", __qt_this)
        QBitArray& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QBitArray>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::testBit(qsizetype)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_testBit_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong i0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::testBit(qsizetype)const", __qt_this)
        __java_return_value = __qt_this->testBit(static_cast<qsizetype>(i0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::toUInt32(QSysInfo::Endian,bool*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_toInteger_1native_1QSysInfo_1Endian_1bool_1ptr_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint endianness0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::toUInt32(QSysInfo::Endian,bool*)const", __qt_this)
        QSysInfo::Endian __qt_endianness0 = qtjambi_cast<QSysInfo::Endian>(__jni_env, endianness0);
        bool ok = false;
        bool* __qt_ok1 = &ok;
        quint32 __qt_return_value = __qt_this->toUInt32(QSysInfo::Endian(__qt_endianness0), __qt_ok1);
        __java_return_value = ok ? qtjambi_cast<jobject>(__jni_env, __qt_return_value) : nullptr;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::toggleBit(qsizetype)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_toggleBit_1native_1qsizetype__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong i0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::toggleBit(qsizetype)", __qt_this)
        __java_return_value = __qt_this->toggleBit(static_cast<qsizetype>(i0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QBitArray::truncate(qsizetype)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_truncate_1native_1qsizetype__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QBitArray::truncate(qsizetype)", __qt_this)
        __qt_this->truncate(static_cast<qsizetype>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QBitArray::fromBits(const char*,qsizetype)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_fromBits__Ljava_nio_ByteBuffer_2)
(JNIEnv *__jni_env,
 jclass,
 jstring data0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QBitArray::fromBits(const char*,qsizetype)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        qsizetype len1{0};
        JBufferConstData __qt_data0_buffer(__jni_env, data0);
        const char* __qt_data0 = __qt_data0_buffer.data<char>();
        len1 = __qt_data0_buffer.size<char>();
        QBitArray __qt_return_value = QBitArray::fromBits(__qt_data0, static_cast<qsizetype>(len1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QBitArray_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QBitArray *__qt_this = QtJambiAPI::objectFromNativeId<QBitArray>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QBitArray(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QBitArray>("QBitArray", "io/qt/core/QBitArray");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QBitArray, {
        ConstructorInfo(&__qt_construct_QBitArray, nullptr)
       ,ConstructorInfo(&__qt_construct_QBitArray_cref_QBitArray, "Lio/qt/core/QBitArray;")
       ,ConstructorInfo(&__qt_construct_QBitArray_qsizetype, "J")
       ,ConstructorInfo(&__qt_construct_QBitArray_qsizetype_bool, "JZ")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QBitArray);
    registerMetaType<QBitArray>("QBitArray");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
