#include <QtCore/QtGlobal>
#include <QtCore/qdebug.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qbytearrayview.h>
#include <QtCore/qiodevice.h>
#include <QtCore/qlogging.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QDebug(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QDebug")
    QDebug *_ptr = reinterpret_cast<QDebug *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QDebug(QDebug)
void __qt_construct_QDebug_cref_QDebug(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDebug(QDebug)")
    jobject o0 = __java_arguments[0].l;
    const QDebug& __qt_o0 = qtjambi_cast<const QDebug& >(__jni_env, o0);
    QDebug *__qt_this = new(__qtjambi_ptr) QDebug(__qt_o0);
    if(__qtjambi_is_generic){

        Java::QtJambi::ReferenceUtility::copyReferenceCount(__jni_env, __jni_object, nullptr, __jni_env->NewStringUTF("__rcDevice"), o0);
    }
    Q_UNUSED(__qt_this)
}

// QDebug::QDebug(QDebug)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_initialize_1native__Lio_qt_core_QDebug_2Lio_qt_core_QDebug_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject o0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDebug::QDebug(QDebug)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = o0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDebug_cref_QDebug, sizeof(QDebug), typeid(QDebug), false, &deleter_QDebug, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDebug(QIODevice*)
void __qt_construct_QDebug_QIODevice_ptr(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDebug(QIODevice*)")
    jobject device0 = __java_arguments[0].l;
    QIODevice* __qt_device0 = qtjambi_cast<QIODevice* >(__jni_env, device0);
    QDebug *__qt_this = new(__qtjambi_ptr) QDebug(__qt_device0);
    if(__qtjambi_is_generic){
        Java::QtJambi::ReferenceUtility::setReferenceCount(__jni_env, __jni_object, nullptr, __jni_env->NewStringUTF("__rcDevice"), false, false, device0);
    }
    Q_UNUSED(__qt_this)
}

// QDebug::QDebug(QIODevice*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_initialize_1native__Lio_qt_core_QDebug_2Lio_qt_core_QIODevice_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject device0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDebug::QDebug(QIODevice*)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = device0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDebug_QIODevice_ptr, sizeof(QDebug), typeid(QDebug), false, &deleter_QDebug, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDebug(QtMsgType)
void __qt_construct_QDebug_QtMsgType(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDebug(QtMsgType)")
    jobject t0 = __java_arguments[0].l;
    QtMsgType __qt_t0 = qtjambi_cast<QtMsgType>(__jni_env, t0);
    QDebug *__qt_this = new(__qtjambi_ptr) QDebug(QtMsgType(__qt_t0));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QDebug::QDebug(QtMsgType)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_initialize_1native__Lio_qt_core_QDebug_2Lio_qt_core_QtMsgType_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject t0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDebug::QDebug(QtMsgType)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = t0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDebug_QtMsgType, sizeof(QDebug), typeid(QDebug), false, &deleter_QDebug, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QDebug
void __qt_destruct_QDebug(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QDebug")
    reinterpret_cast<QDebug*>(ptr)->~QDebug();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QDebug::autoInsertSpaces()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_autoInsertSpaces_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::autoInsertSpaces()const", __qt_this)
        __java_return_value = __qt_this->autoInsertSpaces();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::maybeQuote(char)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_maybeQuote_1native_1char__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte c0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::maybeQuote(char)", __qt_this)
        __qt_this->maybeQuote(static_cast<char>(c0));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::maybeSpace()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_maybeSpace_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::maybeSpace()", __qt_this)
        __qt_this->maybeSpace();
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::noquote()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_noquote_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::noquote()", __qt_this)
        __qt_this->noquote();
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::nospace()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_nospace_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::nospace()", __qt_this)
        __qt_this->nospace();
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1cref_1QByteArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(QByteArray)", __qt_this)
        const QByteArray& __qt_t0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(t0);
        (*__qt_this) << __qt_t0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(QByteArrayView)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1QByteArrayView__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(QByteArrayView)", __qt_this)
        QByteArrayView __qt_t0 = QtJambiAPI::valueReferenceFromNativeId<QByteArrayView>(t0);
        (*__qt_this) << __qt_t0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(QChar)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1QChar__JC)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jchar t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(QChar)", __qt_this)
        QChar __qt_t0 = qtjambi_cast<QChar>(__jni_env, t0);
        (*__qt_this) << __qt_t0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1cref_1QString__JLjava_lang_CharSequence_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(QString)", __qt_this)
        QString __qt_t0 = qtjambi_cast<QString>(__jni_env, t0);
        (*__qt_this) << __qt_t0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(bool)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(bool)", __qt_this)
        (*__qt_this) << static_cast<bool>(t0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(char)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1char__JB)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jbyte t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(char)", __qt_this)
        (*__qt_this) << static_cast<char>(t0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(const char*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1const_1char_1ptr__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring t0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(const char*)", __qt_this)
        const char*  __qt_t0 = qtjambi_cast<const char* >(__jni_env, __qtjambi_scope, t0);
        (*__qt_this) << __qt_t0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(double)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1double__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(double)", __qt_this)
        (*__qt_this) << static_cast<double>(t0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(float)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1float__JF)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jfloat t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(float)", __qt_this)
        (*__qt_this) << static_cast<float>(t0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1signed_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(int)", __qt_this)
        (*__qt_this) << static_cast<signed int>(t0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(qint64)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1qint64__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(qint64)", __qt_this)
        (*__qt_this) << static_cast<qint64>(t0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::operator<<(short)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_append_1native_1signed_1short__JS)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jshort t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::operator<<(short)", __qt_this)
        (*__qt_this) << static_cast<signed short>(t0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::quote()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_quote_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::quote()", __qt_this)
        __qt_this->quote();
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::resetFormat()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_resetFormat_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::resetFormat()", __qt_this)
        __qt_this->resetFormat();
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::setAutoInsertSpaces(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_setAutoInsertSpaces_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean b0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::setAutoInsertSpaces(bool)", __qt_this)
        __qt_this->setAutoInsertSpaces(static_cast<bool>(b0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDebug::setVerbosity(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_setVerbosity_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint verbosityLevel0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::setVerbosity(int)", __qt_this)
        __qt_this->setVerbosity(static_cast<int>(verbosityLevel0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDebug::space()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_space_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::space()", __qt_this)
        __qt_this->space();
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::swap(QDebug&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_swap_1native_1ref_1QDebug__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::swap(QDebug&)", __qt_this)
        QDebug& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QDebug>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDebug::verbosity()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_verbosity_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::verbosity()const", __qt_this)
        __java_return_value = __qt_this->verbosity();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDebug::verbosity(int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_verbosity_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint verbosityLevel0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDebug::verbosity(int)", __qt_this)
        __qt_this->verbosity(static_cast<int>(verbosityLevel0));
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeCustomStructors)
void custom_default_constructor_QDebug(const QtPrivate::QMetaTypeInterface *metaTypeInterface, void* placement)
{
    Q_UNUSED(metaTypeInterface)
    Q_UNUSED(placement)
    new(placement) QDebug(QtDebugMsg);
}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QDebug_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QDebug *__qt_this = QtJambiAPI::objectFromNativeId<QDebug>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QDebug(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QDebug>("QDebug", "io/qt/core/QDebug");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QDebug, {
        ConstructorInfo(&__qt_construct_QDebug_cref_QDebug, "Lio/qt/core/QDebug;")
       ,ConstructorInfo(&__qt_construct_QDebug_QIODevice_ptr, "Lio/qt/core/QIODevice;")
       ,ConstructorInfo(&__qt_construct_QDebug_QtMsgType, "Lio/qt/core/QtMsgType;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QDebug);
    registerMetaType<QDebug>("QDebug", &custom_default_constructor_QDebug, QtJambiPrivate::QMetaTypeInterfaceFunctions<QDebug>::copyCtr, QtJambiPrivate::QMetaTypeInterfaceFunctions<QDebug>::moveCtr);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids

    registerInterfaceOffset(typeId, typeid(QIODeviceBase), int(reinterpret_cast<quintptr>(static_cast<QIODeviceBase *>(reinterpret_cast<QDebug *>(0x10000000)))) - 0x10000000);

// BEGIN: enums and flags
    registerEnumTypeInfo<QDebug::VerbosityLevel>("QDebug::VerbosityLevel", "io/qt/core/QDebug$VerbosityLevel");
// END: enums and flags
}
