#include <QtCore/QtGlobal>
#include <QtCore/qjsondocument.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qdatastream.h>
#include <QtCore/qjsonarray.h>
#include <QtCore/qjsonobject.h>
#include <QtCore/qjsonvalue.h>
#include "utils_p.h"

#include <QtJambi/QtJambiAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QJsonDocument(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QJsonDocument")
    QJsonDocument *_ptr = reinterpret_cast<QJsonDocument *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QJsonDocument()
void __qt_construct_QJsonDocument(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonDocument()")
    Q_UNUSED(__java_arguments)
    QJsonDocument *__qt_this = new(__qtjambi_ptr) QJsonDocument();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QJsonDocument::QJsonDocument()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_initialize_1native__Lio_qt_core_QJsonDocument_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonDocument::QJsonDocument()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonDocument, sizeof(QJsonDocument), typeid(QJsonDocument), false, &deleter_QJsonDocument, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QJsonDocument(QJsonArray)
void __qt_construct_QJsonDocument_cref_QJsonArray(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonDocument(QJsonArray)")
    jobject array0 = __java_arguments[0].l;
    const QJsonArray& __qt_array0 = qtjambi_cast<const QJsonArray& >(__jni_env, array0);
    QJsonDocument *__qt_this = new(__qtjambi_ptr) QJsonDocument(__qt_array0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QJsonDocument::QJsonDocument(QJsonArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_initialize_1native__Lio_qt_core_QJsonDocument_2Lio_qt_core_QJsonArray_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject array0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonDocument::QJsonDocument(QJsonArray)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = array0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonDocument_cref_QJsonArray, sizeof(QJsonDocument), typeid(QJsonDocument), false, &deleter_QJsonDocument, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QJsonDocument(QJsonDocument)
void __qt_construct_QJsonDocument_cref_QJsonDocument(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonDocument(QJsonDocument)")
    jobject other0 = __java_arguments[0].l;
    const QJsonDocument& __qt_other0 = qtjambi_cast<const QJsonDocument& >(__jni_env, other0);
    QJsonDocument *__qt_this = new(__qtjambi_ptr) QJsonDocument(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QJsonDocument::QJsonDocument(QJsonDocument)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_initialize_1native__Lio_qt_core_QJsonDocument_2Lio_qt_core_QJsonDocument_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonDocument::QJsonDocument(QJsonDocument)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonDocument_cref_QJsonDocument, sizeof(QJsonDocument), typeid(QJsonDocument), false, &deleter_QJsonDocument, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QJsonDocument(QJsonObject)
void __qt_construct_QJsonDocument_cref_QJsonObject(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QJsonDocument(QJsonObject)")
    jobject object0 = __java_arguments[0].l;
    const QJsonObject& __qt_object0 = qtjambi_cast<const QJsonObject& >(__jni_env, object0);
    QJsonDocument *__qt_this = new(__qtjambi_ptr) QJsonDocument(__qt_object0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QJsonDocument::QJsonDocument(QJsonObject)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_initialize_1native__Lio_qt_core_QJsonDocument_2Lio_qt_core_QJsonObject_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject object0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonDocument::QJsonDocument(QJsonObject)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = object0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QJsonDocument_cref_QJsonObject, sizeof(QJsonDocument), typeid(QJsonDocument), false, &deleter_QJsonDocument, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QJsonDocument
void __qt_destruct_QJsonDocument(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QJsonDocument")
    reinterpret_cast<QJsonDocument*>(ptr)->~QJsonDocument();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QJsonDocument::array()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_array_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::array()const", __qt_this)
        QJsonArray __qt_return_value = __qt_this->array();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::isArray()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_isArray_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::isArray()const", __qt_this)
        __java_return_value = __qt_this->isArray();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::isEmpty()const", __qt_this)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::isObject()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_isObject_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::isObject()const", __qt_this)
        __java_return_value = __qt_this->isObject();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::object()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_object_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::object()const", __qt_this)
        QJsonObject __qt_return_value = __qt_this->object();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::operator<<(QDataStream&,QJsonDocument)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::operator<<(QDataStream&,QJsonDocument)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonDocument::operator=(QJsonDocument)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_assign_1native_1cref_1QJsonDocument__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::operator=(QJsonDocument)", __qt_this)
        const QJsonDocument& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QJsonDocument>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonDocument::operator==(QJsonDocument)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_equals_1native_1cref_1QJsonDocument_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::operator==(QJsonDocument)const", __qt_this)
        const QJsonDocument& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QJsonDocument>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::operator>>(QDataStream&,QJsonDocument&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::operator>>(QDataStream&,QJsonDocument&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonDocument::operator[](QStringView)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_get_1native_1QStringView_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::operator[](QStringView)const", __qt_this)
        QStringView  __qt_key0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, key0);
        const QJsonValue __qt_return_value = (*__qt_this)[__qt_key0];
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::operator[](qsizetype)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_get_1native_1qsizetype_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jlong i0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::operator[](qsizetype)const", __qt_this)
        const QJsonValue __qt_return_value = (*__qt_this)[static_cast<qsizetype>(i0)];
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::setArray(QJsonArray)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_setArray_1native_1cref_1QJsonArray__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID array0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::setArray(QJsonArray)", __qt_this)
        const QJsonArray& __qt_array0 = QtJambiAPI::valueReferenceFromNativeId<QJsonArray>(array0);
        __qt_this->setArray(__qt_array0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonDocument::setObject(QJsonObject)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_setObject_1native_1cref_1QJsonObject__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID object0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::setObject(QJsonObject)", __qt_this)
        const QJsonObject& __qt_object0 = QtJambiAPI::valueReferenceFromNativeId<QJsonObject>(object0);
        __qt_this->setObject(__qt_object0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonDocument::swap(QJsonDocument&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_swap_1native_1ref_1QJsonDocument__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::swap(QJsonDocument&)", __qt_this)
        QJsonDocument& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QJsonDocument>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QJsonDocument::toJson(QJsonDocument::JsonFormat)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_toJson_1native_1QJsonDocument_1JsonFormat_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint format0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::toJson(QJsonDocument::JsonFormat)const", __qt_this)
        QJsonDocument::JsonFormat __qt_format0 = qtjambi_cast<QJsonDocument::JsonFormat>(__jni_env, format0);
        QByteArray __qt_return_value = __qt_this->toJson(QJsonDocument::JsonFormat(__qt_format0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::toVariant()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_toVariant_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QJsonDocument::toVariant()const", __qt_this)
        QVariant __qt_return_value = __qt_this->toVariant();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::fromJson(QByteArray,QJsonParseError*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_fromJson_1native_1cref_1QByteArray_1QJsonParseError_1ptr__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID json0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonDocument::fromJson(QByteArray,QJsonParseError*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_json0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(json0);
        QJsonParseError error;
        QJsonParseError* __qt_error1 = &error;
        QJsonDocument __qt_return_value = QJsonDocument::fromJson(__qt_json0, __qt_error1);
        __java_return_value = Java::QtCore::QJsonDocument$FromJsonResult::newInstance(__jni_env, qtjambi_cast<jobject>(__jni_env, __qt_return_value), qtjambi_cast<jobject>(__jni_env, error));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QJsonDocument::fromVariant(QVariant)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_fromVariant__Ljava_lang_Object_2)
(JNIEnv *__jni_env,
 jclass,
 jobject variant0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QJsonDocument::fromVariant(QVariant)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QVariant  __qt_variant0 = qtjambi_cast<QVariant >(__jni_env, variant0);
        QJsonDocument __qt_return_value = QJsonDocument::fromVariant(__qt_variant0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting Field accessors (writeFieldAccessors)
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_BinaryFormatTag__)
(JNIEnv *__jni_env,
 jclass)
{
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const uint  __qt_value = QJsonDocument::BinaryFormatTag;
        __java_return_value = jint(__qt_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QJsonDocument_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QJsonDocument *__qt_this = QtJambiAPI::objectFromNativeId<QJsonDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QJsonDocument(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QJsonDocument>("QJsonDocument", "io/qt/core/QJsonDocument");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QJsonDocument, {
        ConstructorInfo(&__qt_construct_QJsonDocument, nullptr)
       ,ConstructorInfo(&__qt_construct_QJsonDocument_cref_QJsonArray, "Lio/qt/core/QJsonArray;")
       ,ConstructorInfo(&__qt_construct_QJsonDocument_cref_QJsonDocument, "Lio/qt/core/QJsonDocument;")
       ,ConstructorInfo(&__qt_construct_QJsonDocument_cref_QJsonObject, "Lio/qt/core/QJsonObject;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QJsonDocument);
    registerMetaType<QJsonDocument>("QJsonDocument");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QJsonDocument::JsonFormat>("QJsonDocument::JsonFormat", "io/qt/core/QJsonDocument$JsonFormat");
// END: enums and flags
}
