#include <QtCore/QtGlobal>
#include <QtCore/qline.h>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qpoint.h>
#include <QtGui/qtransform.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QLineF(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QLineF")
    QLineF *_ptr = reinterpret_cast<QLineF *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QLineF()
void __qt_construct_QLineF(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QLineF()")
    Q_UNUSED(__java_arguments)
    QLineF *__qt_this = new(__qtjambi_ptr) QLineF();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QLineF::QLineF()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_initialize_1native__Lio_qt_core_QLineF_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QLineF::QLineF()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QLineF, sizeof(QLineF), typeid(QLineF), false, &deleter_QLineF, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QLineF(QLine)
void __qt_construct_QLineF_cref_QLine(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QLineF(QLine)")
    jobject line0 = __java_arguments[0].l;
    const QLine& __qt_line0 = qtjambi_cast<const QLine& >(__jni_env, line0);
    QLineF *__qt_this = new(__qtjambi_ptr) QLineF(__qt_line0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QLineF::QLineF(QLine)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_initialize_1native__Lio_qt_core_QLineF_2Lio_qt_core_QLine_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject line0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QLineF::QLineF(QLine)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = line0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QLineF_cref_QLine, sizeof(QLineF), typeid(QLineF), false, &deleter_QLineF, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QLineF(QLineF)
void __qt_construct_QLineF_cref_QLineF(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QLineF(QLineF)")
    jobject other0 = __java_arguments[0].l;
    const QLineF& __qt_other0 = qtjambi_cast<const QLineF& >(__jni_env, other0);
    QLineF *__qt_this = new(__qtjambi_ptr) QLineF(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QLineF::QLineF(QLineF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_initialize_1native__Lio_qt_core_QLineF_2Lio_qt_core_QLineF_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QLineF::QLineF(QLineF)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QLineF_cref_QLineF, sizeof(QLineF), typeid(QLineF), false, &deleter_QLineF, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QLineF(QPointF,QPointF)
void __qt_construct_QLineF_cref_QPointF_cref_QPointF(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QLineF(QPointF,QPointF)")
    jobject pt10 = __java_arguments[0].l;
    const QPointF& __qt_pt10 = qtjambi_cast<const QPointF& >(__jni_env, pt10);
    jobject pt21 = __java_arguments[1].l;
    const QPointF& __qt_pt21 = qtjambi_cast<const QPointF& >(__jni_env, pt21);
    QLineF *__qt_this = new(__qtjambi_ptr) QLineF(__qt_pt10, __qt_pt21);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QLineF::QLineF(QPointF,QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_initialize_1native__Lio_qt_core_QLineF_2Lio_qt_core_QPointF_2Lio_qt_core_QPointF_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject pt10,
 jobject pt21)
{
    QTJAMBI_NATIVE_METHOD_CALL("QLineF::QLineF(QPointF,QPointF)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = pt10;
        arguments[1].l = pt21;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QLineF_cref_QPointF_cref_QPointF, sizeof(QLineF), typeid(QLineF), false, &deleter_QLineF, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QLineF(qreal,qreal,qreal,qreal)
void __qt_construct_QLineF_qreal_qreal_qreal_qreal(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QLineF(qreal,qreal,qreal,qreal)")
    jdouble x10 = __java_arguments[0].d;
    Q_UNUSED(x10)
    jdouble y11 = __java_arguments[1].d;
    Q_UNUSED(y11)
    jdouble x22 = __java_arguments[2].d;
    Q_UNUSED(x22)
    jdouble y23 = __java_arguments[3].d;
    Q_UNUSED(y23)
    QLineF *__qt_this = new(__qtjambi_ptr) QLineF(static_cast<qreal>(x10), static_cast<qreal>(y11), static_cast<qreal>(x22), static_cast<qreal>(y23));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QLineF::QLineF(qreal,qreal,qreal,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_initialize_1native__Lio_qt_core_QLineF_2DDDD)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jdouble x10,
 jdouble y11,
 jdouble x22,
 jdouble y23)
{
    QTJAMBI_NATIVE_METHOD_CALL("QLineF::QLineF(qreal,qreal,qreal,qreal)")
    QTJAMBI_TRY {
        jvalue arguments[4];
        arguments[0].d = x10;
        arguments[1].d = y11;
        arguments[2].d = x22;
        arguments[3].d = y23;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QLineF_qreal_qreal_qreal_qreal, sizeof(QLineF), typeid(QLineF), false, &deleter_QLineF, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QLineF
void __qt_destruct_QLineF(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QLineF")
    reinterpret_cast<QLineF*>(ptr)->~QLineF();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QLineF::angle()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_angle_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::angle()const", __qt_this)
        qreal __qt_return_value = __qt_this->angle();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::angleTo(QLineF)const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_angleTo_1native_1cref_1QLineF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID l0)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::angleTo(QLineF)const", __qt_this)
        const QLineF& __qt_l0 = QtJambiAPI::valueReferenceFromNativeId<QLineF>(l0);
        qreal __qt_return_value = __qt_this->angleTo(__qt_l0);
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::center()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_center_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::center()const", __qt_this)
        QPointF __qt_return_value = __qt_this->center();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::dx()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_dx_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::dx()const", __qt_this)
        qreal __qt_return_value = __qt_this->dx();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::dy()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_dy_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::dy()const", __qt_this)
        qreal __qt_return_value = __qt_this->dy();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::intersects(QLineF,QPointF*)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_intersects_1native_1cref_1QLineF_1QPointF_1ptr_1constfct__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID l0,
 QtJambiNativeID intersectionPoint1)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::intersects(QLineF,QPointF*)const", __qt_this)
        const QLineF& __qt_l0 = QtJambiAPI::valueReferenceFromNativeId<QLineF>(l0);
        QPointF* __qt_intersectionPoint1 = QtJambiAPI::objectFromNativeId<QPointF>(intersectionPoint1);
        QLineF::IntersectionType __qt_return_value = __qt_this->intersects(__qt_l0, __qt_intersectionPoint1);
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::length()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_length_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::length()const", __qt_this)
        qreal __qt_return_value = __qt_this->length();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::normalVector()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_normalVector_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::normalVector()const", __qt_this)
        QLineF __qt_return_value = __qt_this->normalVector();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::operator<<(QDataStream&,QLineF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::operator<<(QDataStream&,QLineF)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLineF::operator==(QLineF)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_equals_1native_1cref_1QLineF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID d0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::operator==(QLineF)const", __qt_this)
        const QLineF& __qt_d0 = QtJambiAPI::valueReferenceFromNativeId<QLineF>(d0);
        __java_return_value = (*__qt_this) == __qt_d0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::operator>>(QDataStream&,QLineF&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::operator>>(QDataStream&,QLineF&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLineF::p1()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_p1_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::p1()const", __qt_this)
        QPointF __qt_return_value = __qt_this->p1();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::p2()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_p2_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::p2()const", __qt_this)
        QPointF __qt_return_value = __qt_this->p2();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::pointAt(qreal)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_pointAt_1native_1qreal_1constfct__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble t0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::pointAt(qreal)const", __qt_this)
        QPointF __qt_return_value = __qt_this->pointAt(static_cast<qreal>(t0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::setAngle(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_setAngle_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble angle0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::setAngle(qreal)", __qt_this)
        __qt_this->setAngle(static_cast<qreal>(angle0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLineF::setLength(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_setLength_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble len0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::setLength(qreal)", __qt_this)
        __qt_this->setLength(static_cast<qreal>(len0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLineF::setLine(qreal,qreal,qreal,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_setLine_1native_1qreal_1qreal_1qreal_1qreal__JDDDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble x10,
 jdouble y11,
 jdouble x22,
 jdouble y23)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::setLine(qreal,qreal,qreal,qreal)", __qt_this)
        __qt_this->setLine(static_cast<qreal>(x10), static_cast<qreal>(y11), static_cast<qreal>(x22), static_cast<qreal>(y23));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLineF::setP1(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_setP1_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p10)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::setP1(QPointF)", __qt_this)
        const QPointF& __qt_p10 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p10);
        __qt_this->setP1(__qt_p10);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLineF::setP2(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_setP2_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p20)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::setP2(QPointF)", __qt_this)
        const QPointF& __qt_p20 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p20);
        __qt_this->setP2(__qt_p20);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLineF::setPoints(QPointF,QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_setPoints_1native_1cref_1QPointF_1cref_1QPointF__JJJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p10,
 QtJambiNativeID p21)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::setPoints(QPointF,QPointF)", __qt_this)
        const QPointF& __qt_p10 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p10);
        const QPointF& __qt_p21 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p21);
        __qt_this->setPoints(__qt_p10, __qt_p21);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLineF::toLine()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_toLine_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::toLine()const", __qt_this)
        QLine __qt_return_value = __qt_this->toLine();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::translate(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_translate_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::translate(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->translate(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLineF::translate(qreal,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_translate_1native_1qreal_1qreal__JDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble dx0,
 jdouble dy1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::translate(qreal,qreal)", __qt_this)
        __qt_this->translate(static_cast<qreal>(dx0), static_cast<qreal>(dy1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QLineF::translated(QPointF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_translated_1native_1cref_1QPointF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::translated(QPointF)const", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        QLineF __qt_return_value = __qt_this->translated(__qt_p0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::translated(qreal,qreal)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_translated_1native_1qreal_1qreal_1constfct__JDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble dx0,
 jdouble dy1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::translated(qreal,qreal)const", __qt_this)
        QLineF __qt_return_value = __qt_this->translated(static_cast<qreal>(dx0), static_cast<qreal>(dy1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::unitVector()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_unitVector_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::unitVector()const", __qt_this)
        QLineF __qt_return_value = __qt_this->unitVector();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::x1()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_x1_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::x1()const", __qt_this)
        qreal __qt_return_value = __qt_this->x1();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::x2()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_x2_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::x2()const", __qt_this)
        qreal __qt_return_value = __qt_this->x2();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::y1()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_y1_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::y1()const", __qt_this)
        qreal __qt_return_value = __qt_this->y1();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::y2()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_y2_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QLineF::y2()const", __qt_this)
        qreal __qt_return_value = __qt_this->y2();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QLineF::fromPolar(qreal,qreal)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_fromPolar__DD)
(JNIEnv *__jni_env,
 jclass,
 jdouble length0,
 jdouble angle1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QLineF::fromPolar(qreal,qreal)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QLineF __qt_return_value = QLineF::fromPolar(static_cast<qreal>(length0), static_cast<qreal>(angle1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QLineF_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QLineF *__qt_this = QtJambiAPI::objectFromNativeId<QLineF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QLineF(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QLineF>("QLineF", "io/qt/core/QLineF");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QLineF, {
        ConstructorInfo(&__qt_construct_QLineF, nullptr)
       ,ConstructorInfo(&__qt_construct_QLineF_cref_QLine, "Lio/qt/core/QLine;")
       ,ConstructorInfo(&__qt_construct_QLineF_cref_QLineF, "Lio/qt/core/QLineF;")
       ,ConstructorInfo(&__qt_construct_QLineF_cref_QPointF_cref_QPointF, "Lio/qt/core/QPointF;Lio/qt/core/QPointF;")
       ,ConstructorInfo(&__qt_construct_QLineF_qreal_qreal_qreal_qreal, "DDDD")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QLineF);
    registerMetaType<QLineF>("QLineF");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QLineF::IntersectionType>("QLineF::IntersectionType", "io/qt/core/QLineF$IntersectionType");
// END: enums and flags
}
