#include <QtCore/QtGlobal>
#include <qtcore-config.h>
#if QT_CONFIG(mimetype)
#include <QtCore/qmimedatabase.h>
#endif //QT_CONFIG(mimetype)
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qfileinfo.h>
#include <QtCore/qiodevice.h>
#if QT_CONFIG(mimetype)
#include <QtCore/qmimetype.h>
#endif //QT_CONFIG(mimetype)
#include <QtCore/qurl.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

#if QT_CONFIG(mimetype)


void deleter_QMimeDatabase(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QMimeDatabase")
    QMimeDatabase *_ptr = reinterpret_cast<QMimeDatabase *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}


#endif // QT_CONFIG(mimetype)

// emitting (writeConstructors)
// new QMimeDatabase()
void __qt_construct_QMimeDatabase(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QMimeDatabase()")
#if QT_CONFIG(mimetype)
    Q_UNUSED(__java_arguments)
    QMimeDatabase *__qt_this = new(__qtjambi_ptr) QMimeDatabase();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
#else
    Q_UNUSED(__jni_object)
    Q_UNUSED(__java_arguments)
    Q_UNUSED(__qtjambi_ptr)
    Q_UNUSED(__qtjambi_is_generic)
    JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
}

// QMimeDatabase::QMimeDatabase()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_initialize_1native__Lio_qt_core_QMimeDatabase_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QMimeDatabase::QMimeDatabase()")
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QMimeDatabase, sizeof(QMimeDatabase), typeid(QMimeDatabase), false, &deleter_QMimeDatabase, nullptr);
#else
        Q_UNUSED(__jni_object)
        Q_UNUSED(__jni_class)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QMimeDatabase
void __qt_destruct_QMimeDatabase(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QMimeDatabase")

#if QT_CONFIG(mimetype)

    reinterpret_cast<QMimeDatabase*>(ptr)->~QMimeDatabase();

#else
    Q_UNUSED(ptr)

#endif // QT_CONFIG(mimetype)

}

// emitting  (functionsInTargetLang writeFinalFunction)
// QMimeDatabase::allMimeTypes()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_allMimeTypes_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        const QMimeDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QMimeDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMimeDatabase::allMimeTypes()const", __qt_this)
        QList<QMimeType> __qt_return_value = __qt_this->allMimeTypes();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMimeDatabase::mimeTypeForData(QByteArray)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_mimeTypeForData_1native_1cref_1QByteArray_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID data0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        const QMimeDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QMimeDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMimeDatabase::mimeTypeForData(QByteArray)const", __qt_this)
        const QByteArray& __qt_data0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data0);
        QMimeType __qt_return_value = __qt_this->mimeTypeForData(__qt_data0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(data0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMimeDatabase::mimeTypeForData(QIODevice*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_mimeTypeForData_1native_1QIODevice_1ptr_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID device0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        const QMimeDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QMimeDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMimeDatabase::mimeTypeForData(QIODevice*)const", __qt_this)
        QIODevice* __qt_device0 = QtJambiAPI::objectFromNativeId<QIODevice>(device0);
        QMimeType __qt_return_value = __qt_this->mimeTypeForData(__qt_device0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(device0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMimeDatabase::mimeTypeForFile(QFileInfo,QMimeDatabase::MatchMode)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_mimeTypeForFile_1native_1cref_1QFileInfo_1QMimeDatabase_1MatchMode_1constfct__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID fileInfo0,
 jint mode1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        const QMimeDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QMimeDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMimeDatabase::mimeTypeForFile(QFileInfo,QMimeDatabase::MatchMode)const", __qt_this)
        const QFileInfo& __qt_fileInfo0 = QtJambiAPI::valueReferenceFromNativeId<QFileInfo>(fileInfo0);
        QMimeDatabase::MatchMode __qt_mode1 = qtjambi_cast<QMimeDatabase::MatchMode>(__jni_env, mode1);
        QMimeType __qt_return_value = __qt_this->mimeTypeForFile(__qt_fileInfo0, QMimeDatabase::MatchMode(__qt_mode1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(fileInfo0)
        Q_UNUSED(mode1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMimeDatabase::mimeTypeForFile(QString,QMimeDatabase::MatchMode)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_mimeTypeForFile_1native_1cref_1QString_1QMimeDatabase_1MatchMode_1constfct__JLjava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0,
 jint mode1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        const QMimeDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QMimeDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMimeDatabase::mimeTypeForFile(QString,QMimeDatabase::MatchMode)const", __qt_this)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        QMimeDatabase::MatchMode __qt_mode1 = qtjambi_cast<QMimeDatabase::MatchMode>(__jni_env, mode1);
        QMimeType __qt_return_value = __qt_this->mimeTypeForFile(__qt_fileName0, QMimeDatabase::MatchMode(__qt_mode1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(fileName0)
        Q_UNUSED(mode1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMimeDatabase::mimeTypeForFileNameAndData(QString,QByteArray)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_mimeTypeForFileNameAndData_1native_1cref_1QString_1cref_1QByteArray_1constfct__JLjava_lang_String_2J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0,
 QtJambiNativeID data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        const QMimeDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QMimeDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMimeDatabase::mimeTypeForFileNameAndData(QString,QByteArray)const", __qt_this)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        const QByteArray& __qt_data1 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data1);
        QMimeType __qt_return_value = __qt_this->mimeTypeForFileNameAndData(__qt_fileName0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(fileName0)
        Q_UNUSED(data1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMimeDatabase::mimeTypeForFileNameAndData(QString,QIODevice*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_mimeTypeForFileNameAndData_1native_1cref_1QString_1QIODevice_1ptr_1constfct__JLjava_lang_String_2J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0,
 QtJambiNativeID device1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        const QMimeDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QMimeDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMimeDatabase::mimeTypeForFileNameAndData(QString,QIODevice*)const", __qt_this)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        QIODevice* __qt_device1 = QtJambiAPI::objectFromNativeId<QIODevice>(device1);
        QMimeType __qt_return_value = __qt_this->mimeTypeForFileNameAndData(__qt_fileName0, __qt_device1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(fileName0)
        Q_UNUSED(device1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMimeDatabase::mimeTypeForName(QString)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_mimeTypeForName_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring nameOrAlias0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        const QMimeDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QMimeDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMimeDatabase::mimeTypeForName(QString)const", __qt_this)
        QString  __qt_nameOrAlias0 = qtjambi_cast<QString>(__jni_env, nameOrAlias0);
        QMimeType __qt_return_value = __qt_this->mimeTypeForName(__qt_nameOrAlias0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(nameOrAlias0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMimeDatabase::mimeTypeForUrl(QUrl)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_mimeTypeForUrl_1native_1cref_1QUrl_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID url0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        const QMimeDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QMimeDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMimeDatabase::mimeTypeForUrl(QUrl)const", __qt_this)
        const QUrl& __qt_url0 = QtJambiAPI::valueReferenceFromNativeId<QUrl>(url0);
        QMimeType __qt_return_value = __qt_this->mimeTypeForUrl(__qt_url0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(url0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMimeDatabase::mimeTypesForFileName(QString)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_mimeTypesForFileName_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        const QMimeDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QMimeDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMimeDatabase::mimeTypesForFileName(QString)const", __qt_this)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        QList<QMimeType> __qt_return_value = __qt_this->mimeTypesForFileName(__qt_fileName0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(fileName0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QMimeDatabase::suffixForFileName(QString)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QMimeDatabase_suffixForFileName_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring fileName0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(mimetype)
        const QMimeDatabase *__qt_this = QtJambiAPI::objectFromNativeId<QMimeDatabase>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QMimeDatabase::suffixForFileName(QString)const", __qt_this)
        QString  __qt_fileName0 = qtjambi_cast<QString>(__jni_env, fileName0);
        QString __qt_return_value = __qt_this->suffixForFileName(__qt_fileName0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(__this)
        Q_UNUSED(__this_nativeId)
        Q_UNUSED(fileName0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(mimetype)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QMimeDatabase(){
    using namespace RegistryAPI;

#if QT_CONFIG(mimetype)

    const std::type_info& typeId = registerObjectTypeInfo<QMimeDatabase>("QMimeDatabase", "io/qt/core/QMimeDatabase");
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QMimeDatabase, {
        ConstructorInfo(&__qt_construct_QMimeDatabase, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QMimeDatabase);
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags

#if QT_CONFIG(mimetype)
    registerEnumTypeInfo<QMimeDatabase::MatchMode>("QMimeDatabase::MatchMode", "io/qt/core/QMimeDatabase$MatchMode");
#endif //QT_CONFIG(mimetype)
// END: enums and flags

#endif //QT_CONFIG(mimetype)

}
