#include <QtCore/QtGlobal>
#include <QtCore/qpoint.h>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtGui/qmatrix4x4.h>
#include <QtGui/qtransform.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
namespace QtJambiPrivate {
template<>
struct RegistryHelper<QPointF, false>{
    static void registerHashFunction(){ RegistryAPI::registerHashFunction(typeid(QPointF), [](const void* ptr, hash_type seed)->hash_type{ return !ptr ? 0 : qHash(*reinterpret_cast<const QPointF*>(ptr), QHashDummyValue(), seed); }); }
};
}

void deleter_QPointF(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QPointF")
    QPointF *_ptr = reinterpret_cast<QPointF *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QPointF()
void __qt_construct_QPointF(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPointF()")
    Q_UNUSED(__java_arguments)
    QPointF *__qt_this = new(__qtjambi_ptr) QPointF();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QPointF::QPointF()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_initialize_1native__Lio_qt_core_QPointF_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPointF::QPointF()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QPointF, sizeof(QPointF), typeid(QPointF), false, &deleter_QPointF, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QPointF(QPoint)
void __qt_construct_QPointF_cref_QPoint(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPointF(QPoint)")
    jobject p0 = __java_arguments[0].l;
    const QPoint& __qt_p0 = qtjambi_cast<const QPoint& >(__jni_env, p0);
    QPointF *__qt_this = new(__qtjambi_ptr) QPointF(__qt_p0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QPointF::QPointF(QPoint)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_initialize_1native__Lio_qt_core_QPointF_2Lio_qt_core_QPoint_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject p0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPointF::QPointF(QPoint)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = p0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QPointF_cref_QPoint, sizeof(QPointF), typeid(QPointF), false, &deleter_QPointF, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QPointF(QPointF)
void __qt_construct_QPointF_cref_QPointF(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPointF(QPointF)")
    jobject other0 = __java_arguments[0].l;
    const QPointF& __qt_other0 = qtjambi_cast<const QPointF& >(__jni_env, other0);
    QPointF *__qt_this = new(__qtjambi_ptr) QPointF(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QPointF::QPointF(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_initialize_1native__Lio_qt_core_QPointF_2Lio_qt_core_QPointF_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPointF::QPointF(QPointF)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QPointF_cref_QPointF, sizeof(QPointF), typeid(QPointF), false, &deleter_QPointF, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QPointF(qreal,qreal)
void __qt_construct_QPointF_qreal_qreal(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QPointF(qreal,qreal)")
    jdouble xpos0 = __java_arguments[0].d;
    Q_UNUSED(xpos0)
    jdouble ypos1 = __java_arguments[1].d;
    Q_UNUSED(ypos1)
    QPointF *__qt_this = new(__qtjambi_ptr) QPointF(static_cast<qreal>(xpos0), static_cast<qreal>(ypos1));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QPointF::QPointF(qreal,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_initialize_1native__Lio_qt_core_QPointF_2DD)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jdouble xpos0,
 jdouble ypos1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPointF::QPointF(qreal,qreal)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].d = xpos0;
        arguments[1].d = ypos1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QPointF_qreal_qreal, sizeof(QPointF), typeid(QPointF), false, &deleter_QPointF, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QPointF
void __qt_destruct_QPointF(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QPointF")
    reinterpret_cast<QPointF*>(ptr)->~QPointF();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QPointF::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::manhattanLength()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_manhattanLength_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::manhattanLength()const", __qt_this)
        qreal __qt_return_value = __qt_this->manhattanLength();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator*(QPointF,qreal)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_times_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble c1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator*(QPointF,qreal)", __qt_this)
        QPointF __qt_return_value = (*__qt_this) * static_cast<qreal>(c1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator*=(qreal)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_multiply_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble c0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator*=(qreal)", __qt_this)
        (*__qt_this) *= static_cast<qreal>(c0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator+(QPointF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_unaryPlus_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator+(QPointF)", __qt_this)
        QPointF __qt_return_value = +(*__qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator+(QPointF,QPointF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_plus_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator+(QPointF,QPointF)", __qt_this)
        const QPointF& __qt_p21 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p21);
        QPointF __qt_return_value = (*__qt_this) + __qt_p21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator+=(QPointF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_add_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator+=(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        (*__qt_this) += __qt_p0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator-(QPointF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_unaryMinus_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator-(QPointF)", __qt_this)
        QPointF __qt_return_value = -(*__qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator-(QPointF,QPointF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_minus_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator-(QPointF,QPointF)", __qt_this)
        const QPointF& __qt_p21 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p21);
        QPointF __qt_return_value = (*__qt_this) - __qt_p21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator-=(QPointF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_subtract_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator-=(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        (*__qt_this) -= __qt_p0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator/(QPointF,qreal)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_div_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble divisor1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator/(QPointF,qreal)", __qt_this)
        QPointF __qt_return_value = (*__qt_this) / static_cast<qreal>(divisor1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator/=(qreal)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_divide_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble c0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator/=(qreal)", __qt_this)
        (*__qt_this) /= static_cast<qreal>(c0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator<<(QDataStream&,QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator<<(QDataStream&,QPointF)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPointF::operator==(QPointF,QPointF)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_equals_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p21)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator==(QPointF,QPointF)", __qt_this)
        const QPointF& __qt_p21 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p21);
        __java_return_value = (*__qt_this) == __qt_p21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::operator>>(QDataStream&,QPointF&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::operator>>(QDataStream&,QPointF&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPointF::setX(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_setX_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble x0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::setX(qreal)", __qt_this)
        __qt_this->setX(static_cast<qreal>(x0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPointF::setY(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_setY_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble y0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::setY(qreal)", __qt_this)
        __qt_this->setY(static_cast<qreal>(y0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QPointF::toPoint()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_toPoint_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::toPoint()const", __qt_this)
        QPoint __qt_return_value = __qt_this->toPoint();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::transposed()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_transposed_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::transposed()const", __qt_this)
        QPointF __qt_return_value = __qt_this->transposed();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::x()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_x_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::x()const", __qt_this)
        qreal __qt_return_value = __qt_this->x();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::y()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_y_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QPointF::y()const", __qt_this)
        qreal __qt_return_value = __qt_this->y();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QPointF::dotProduct(QPointF,QPointF)
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_dotProduct_1native_1cref_1QPointF_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID p10,
 QtJambiNativeID p21)
{
    QTJAMBI_NATIVE_METHOD_CALL("QPointF::dotProduct(QPointF,QPointF)")
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QPointF& __qt_p10 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p10);
        const QPointF& __qt_p21 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p21);
        qreal __qt_return_value = QPointF::dotProduct(__qt_p10, __qt_p21);
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this, QHashDummyValue());
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QPointF_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QPointF *__qt_this = QtJambiAPI::objectFromNativeId<QPointF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QPointF(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QPointF>("QPointF", "io/qt/core/QPointF");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QPointF, {
        ConstructorInfo(&__qt_construct_QPointF, nullptr)
       ,ConstructorInfo(&__qt_construct_QPointF_cref_QPoint, "Lio/qt/core/QPoint;")
       ,ConstructorInfo(&__qt_construct_QPointF_cref_QPointF, "Lio/qt/core/QPointF;")
       ,ConstructorInfo(&__qt_construct_QPointF_qreal_qreal, "DD")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QPointF);
    registerMetaType<QPointF>("QPointF");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
