#include <QtCore/QtGlobal>
#include <QtCore/qrect.h>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qmargins.h>
#include <QtCore/qpoint.h>
#include <QtCore/qsize.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QRectF(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QRectF")
    QRectF *_ptr = reinterpret_cast<QRectF *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QRectF()
void __qt_construct_QRectF(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRectF()")
    Q_UNUSED(__java_arguments)
    QRectF *__qt_this = new(__qtjambi_ptr) QRectF();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QRectF::QRectF()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_initialize_1native__Lio_qt_core_QRectF_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRectF::QRectF()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRectF, sizeof(QRectF), typeid(QRectF), false, &deleter_QRectF, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRectF(QPointF,QPointF)
void __qt_construct_QRectF_cref_QPointF_cref_QPointF(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRectF(QPointF,QPointF)")
    jobject topleft0 = __java_arguments[0].l;
    const QPointF& __qt_topleft0 = qtjambi_cast<const QPointF& >(__jni_env, topleft0);
    jobject bottomRight1 = __java_arguments[1].l;
    const QPointF& __qt_bottomRight1 = qtjambi_cast<const QPointF& >(__jni_env, bottomRight1);
    QRectF *__qt_this = new(__qtjambi_ptr) QRectF(__qt_topleft0, __qt_bottomRight1);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QRectF::QRectF(QPointF,QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_initialize_1native__Lio_qt_core_QRectF_2Lio_qt_core_QPointF_2Lio_qt_core_QPointF_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject topleft0,
 jobject bottomRight1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRectF::QRectF(QPointF,QPointF)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = topleft0;
        arguments[1].l = bottomRight1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRectF_cref_QPointF_cref_QPointF, sizeof(QRectF), typeid(QRectF), false, &deleter_QRectF, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRectF(QPointF,QSizeF)
void __qt_construct_QRectF_cref_QPointF_cref_QSizeF(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRectF(QPointF,QSizeF)")
    jobject topleft0 = __java_arguments[0].l;
    const QPointF& __qt_topleft0 = qtjambi_cast<const QPointF& >(__jni_env, topleft0);
    jobject size1 = __java_arguments[1].l;
    const QSizeF& __qt_size1 = qtjambi_cast<const QSizeF& >(__jni_env, size1);
    QRectF *__qt_this = new(__qtjambi_ptr) QRectF(__qt_topleft0, __qt_size1);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QRectF::QRectF(QPointF,QSizeF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_initialize_1native__Lio_qt_core_QRectF_2Lio_qt_core_QPointF_2Lio_qt_core_QSizeF_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject topleft0,
 jobject size1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRectF::QRectF(QPointF,QSizeF)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = topleft0;
        arguments[1].l = size1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRectF_cref_QPointF_cref_QSizeF, sizeof(QRectF), typeid(QRectF), false, &deleter_QRectF, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRectF(QRect)
void __qt_construct_QRectF_cref_QRect(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRectF(QRect)")
    jobject rect0 = __java_arguments[0].l;
    const QRect& __qt_rect0 = qtjambi_cast<const QRect& >(__jni_env, rect0);
    QRectF *__qt_this = new(__qtjambi_ptr) QRectF(__qt_rect0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QRectF::QRectF(QRect)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_initialize_1native__Lio_qt_core_QRectF_2Lio_qt_core_QRect_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject rect0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRectF::QRectF(QRect)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = rect0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRectF_cref_QRect, sizeof(QRectF), typeid(QRectF), false, &deleter_QRectF, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRectF(QRectF)
void __qt_construct_QRectF_cref_QRectF(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRectF(QRectF)")
    jobject other0 = __java_arguments[0].l;
    const QRectF& __qt_other0 = qtjambi_cast<const QRectF& >(__jni_env, other0);
    QRectF *__qt_this = new(__qtjambi_ptr) QRectF(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QRectF::QRectF(QRectF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_initialize_1native__Lio_qt_core_QRectF_2Lio_qt_core_QRectF_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRectF::QRectF(QRectF)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRectF_cref_QRectF, sizeof(QRectF), typeid(QRectF), false, &deleter_QRectF, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QRectF(qreal,qreal,qreal,qreal)
void __qt_construct_QRectF_qreal_qreal_qreal_qreal(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QRectF(qreal,qreal,qreal,qreal)")
    jdouble left0 = __java_arguments[0].d;
    Q_UNUSED(left0)
    jdouble top1 = __java_arguments[1].d;
    Q_UNUSED(top1)
    jdouble width2 = __java_arguments[2].d;
    Q_UNUSED(width2)
    jdouble height3 = __java_arguments[3].d;
    Q_UNUSED(height3)
    QRectF *__qt_this = new(__qtjambi_ptr) QRectF(static_cast<qreal>(left0), static_cast<qreal>(top1), static_cast<qreal>(width2), static_cast<qreal>(height3));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QRectF::QRectF(qreal,qreal,qreal,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_initialize_1native__Lio_qt_core_QRectF_2DDDD)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jdouble left0,
 jdouble top1,
 jdouble width2,
 jdouble height3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QRectF::QRectF(qreal,qreal,qreal,qreal)")
    QTJAMBI_TRY {
        jvalue arguments[4];
        arguments[0].d = left0;
        arguments[1].d = top1;
        arguments[2].d = width2;
        arguments[3].d = height3;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QRectF_qreal_qreal_qreal_qreal, sizeof(QRectF), typeid(QRectF), false, &deleter_QRectF, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QRectF
void __qt_destruct_QRectF(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QRectF")
    reinterpret_cast<QRectF*>(ptr)->~QRectF();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QRectF::adjust(qreal,qreal,qreal,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_adjust_1native_1qreal_1qreal_1qreal_1qreal__JDDDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble x10,
 jdouble y11,
 jdouble x22,
 jdouble y23)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::adjust(qreal,qreal,qreal,qreal)", __qt_this)
        __qt_this->adjust(static_cast<qreal>(x10), static_cast<qreal>(y11), static_cast<qreal>(x22), static_cast<qreal>(y23));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::adjusted(qreal,qreal,qreal,qreal)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_adjusted_1native_1qreal_1qreal_1qreal_1qreal_1constfct__JDDDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble x10,
 jdouble y11,
 jdouble x22,
 jdouble y23)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::adjusted(qreal,qreal,qreal,qreal)const", __qt_this)
        QRectF __qt_return_value = __qt_this->adjusted(static_cast<qreal>(x10), static_cast<qreal>(y11), static_cast<qreal>(x22), static_cast<qreal>(y23));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::bottom()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_bottom_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::bottom()const", __qt_this)
        qreal __qt_return_value = __qt_this->bottom();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::bottomLeft()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_bottomLeft_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::bottomLeft()const", __qt_this)
        QPointF __qt_return_value = __qt_this->bottomLeft();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::bottomRight()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_bottomRight_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::bottomRight()const", __qt_this)
        QPointF __qt_return_value = __qt_this->bottomRight();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::center()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_center_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::center()const", __qt_this)
        QPointF __qt_return_value = __qt_this->center();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::contains(QPointF)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_contains_1native_1cref_1QPointF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::contains(QPointF)const", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __java_return_value = __qt_this->contains(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::contains(QRectF)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_contains_1native_1cref_1QRectF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::contains(QRectF)const", __qt_this)
        const QRectF& __qt_r0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(r0);
        __java_return_value = __qt_this->contains(__qt_r0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::contains(qreal,qreal)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_contains_1native_1qreal_1qreal_1constfct__JDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble x0,
 jdouble y1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::contains(qreal,qreal)const", __qt_this)
        __java_return_value = __qt_this->contains(static_cast<qreal>(x0), static_cast<qreal>(y1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::height()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_height_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::height()const", __qt_this)
        qreal __qt_return_value = __qt_this->height();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::intersected(QRectF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_intersected_1native_1cref_1QRectF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::intersected(QRectF)const", __qt_this)
        const QRectF& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(other0);
        QRectF __qt_return_value = __qt_this->intersected(__qt_other0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::intersects(QRectF)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_intersects_1native_1cref_1QRectF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::intersects(QRectF)const", __qt_this)
        const QRectF& __qt_r0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(r0);
        __java_return_value = __qt_this->intersects(__qt_r0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::isEmpty()const", __qt_this)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::left()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_left_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::left()const", __qt_this)
        qreal __qt_return_value = __qt_this->left();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::marginsAdded(QMarginsF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_marginsAdded_1native_1cref_1QMarginsF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID margins0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::marginsAdded(QMarginsF)const", __qt_this)
        const QMarginsF& __qt_margins0 = QtJambiAPI::valueReferenceFromNativeId<QMarginsF>(margins0);
        QRectF __qt_return_value = __qt_this->marginsAdded(__qt_margins0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::marginsRemoved(QMarginsF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_marginsRemoved_1native_1cref_1QMarginsF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID margins0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::marginsRemoved(QMarginsF)const", __qt_this)
        const QMarginsF& __qt_margins0 = QtJambiAPI::valueReferenceFromNativeId<QMarginsF>(margins0);
        QRectF __qt_return_value = __qt_this->marginsRemoved(__qt_margins0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::moveBottom(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_moveBottom_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::moveBottom(qreal)", __qt_this)
        __qt_this->moveBottom(static_cast<qreal>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::moveBottomLeft(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_moveBottomLeft_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::moveBottomLeft(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->moveBottomLeft(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::moveBottomRight(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_moveBottomRight_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::moveBottomRight(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->moveBottomRight(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::moveCenter(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_moveCenter_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::moveCenter(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->moveCenter(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::moveLeft(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_moveLeft_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::moveLeft(qreal)", __qt_this)
        __qt_this->moveLeft(static_cast<qreal>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::moveRight(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_moveRight_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::moveRight(qreal)", __qt_this)
        __qt_this->moveRight(static_cast<qreal>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::moveTo(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_moveTo_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::moveTo(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->moveTo(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::moveTo(qreal,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_moveTo_1native_1qreal_1qreal__JDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble x0,
 jdouble y1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::moveTo(qreal,qreal)", __qt_this)
        __qt_this->moveTo(static_cast<qreal>(x0), static_cast<qreal>(y1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::moveTop(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_moveTop_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::moveTop(qreal)", __qt_this)
        __qt_this->moveTop(static_cast<qreal>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::moveTopLeft(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_moveTopLeft_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::moveTopLeft(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->moveTopLeft(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::moveTopRight(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_moveTopRight_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::moveTopRight(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->moveTopRight(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::normalized()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_normalized_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::normalized()const", __qt_this)
        QRectF __qt_return_value = __qt_this->normalized();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::operator+(QRectF,QMarginsF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_plus_1native_1cref_1QMarginsF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::operator+(QRectF,QMarginsF)", __qt_this)
        const QMarginsF& __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QMarginsF>(rhs1);
        QRectF __qt_return_value = (*__qt_this) + __qt_rhs1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::operator+=(QMarginsF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_add_1native_1cref_1QMarginsF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID margins0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::operator+=(QMarginsF)", __qt_this)
        const QMarginsF& __qt_margins0 = QtJambiAPI::valueReferenceFromNativeId<QMarginsF>(margins0);
        (*__qt_this) += __qt_margins0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::operator-(QRectF,QMarginsF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_minus_1native_1cref_1QMarginsF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::operator-(QRectF,QMarginsF)", __qt_this)
        const QMarginsF& __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QMarginsF>(rhs1);
        QRectF __qt_return_value = (*__qt_this) - __qt_rhs1;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::operator-=(QMarginsF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_subtract_1native_1cref_1QMarginsF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID margins0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::operator-=(QMarginsF)", __qt_this)
        const QMarginsF& __qt_margins0 = QtJambiAPI::valueReferenceFromNativeId<QMarginsF>(margins0);
        (*__qt_this) -= __qt_margins0;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::operator<<(QDataStream&,QRectF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::operator<<(QDataStream&,QRectF)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::operator==(QRectF,QRectF)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_equals_1native_1cref_1QRectF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID r21)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::operator==(QRectF,QRectF)", __qt_this)
        const QRectF& __qt_r21 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(r21);
        __java_return_value = (*__qt_this) == __qt_r21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::operator>>(QDataStream&,QRectF&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::operator>>(QDataStream&,QRectF&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::right()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_right_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::right()const", __qt_this)
        qreal __qt_return_value = __qt_this->right();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::setBottom(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setBottom_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setBottom(qreal)", __qt_this)
        __qt_this->setBottom(static_cast<qreal>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setBottomLeft(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setBottomLeft_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setBottomLeft(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->setBottomLeft(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setBottomRight(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setBottomRight_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setBottomRight(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->setBottomRight(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setCoords(qreal,qreal,qreal,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setCoords_1native_1qreal_1qreal_1qreal_1qreal__JDDDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble x10,
 jdouble y11,
 jdouble x22,
 jdouble y23)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setCoords(qreal,qreal,qreal,qreal)", __qt_this)
        __qt_this->setCoords(static_cast<qreal>(x10), static_cast<qreal>(y11), static_cast<qreal>(x22), static_cast<qreal>(y23));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setHeight(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setHeight_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble h0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setHeight(qreal)", __qt_this)
        __qt_this->setHeight(static_cast<qreal>(h0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setLeft(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setLeft_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setLeft(qreal)", __qt_this)
        __qt_this->setLeft(static_cast<qreal>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setRect(qreal,qreal,qreal,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setRect_1native_1qreal_1qreal_1qreal_1qreal__JDDDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble x0,
 jdouble y1,
 jdouble w2,
 jdouble h3)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setRect(qreal,qreal,qreal,qreal)", __qt_this)
        __qt_this->setRect(static_cast<qreal>(x0), static_cast<qreal>(y1), static_cast<qreal>(w2), static_cast<qreal>(h3));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setRight(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setRight_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setRight(qreal)", __qt_this)
        __qt_this->setRight(static_cast<qreal>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setSize(QSizeF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setSize_1native_1cref_1QSizeF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID s0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setSize(QSizeF)", __qt_this)
        const QSizeF& __qt_s0 = QtJambiAPI::valueReferenceFromNativeId<QSizeF>(s0);
        __qt_this->setSize(__qt_s0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setTop(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setTop_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setTop(qreal)", __qt_this)
        __qt_this->setTop(static_cast<qreal>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setTopLeft(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setTopLeft_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setTopLeft(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->setTopLeft(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setTopRight(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setTopRight_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setTopRight(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->setTopRight(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setWidth(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setWidth_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble w0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setWidth(qreal)", __qt_this)
        __qt_this->setWidth(static_cast<qreal>(w0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setX(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setX_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setX(qreal)", __qt_this)
        __qt_this->setX(static_cast<qreal>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::setY(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_setY_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble pos0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::setY(qreal)", __qt_this)
        __qt_this->setY(static_cast<qreal>(pos0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::size()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_size_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::size()const", __qt_this)
        QSizeF __qt_return_value = __qt_this->size();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::toAlignedRect()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_toAlignedRect_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::toAlignedRect()const", __qt_this)
        QRect __qt_return_value = __qt_this->toAlignedRect();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::toRect()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_toRect_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::toRect()const", __qt_this)
        QRect __qt_return_value = __qt_this->toRect();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::top()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_top_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::top()const", __qt_this)
        qreal __qt_return_value = __qt_this->top();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::topLeft()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_topLeft_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::topLeft()const", __qt_this)
        QPointF __qt_return_value = __qt_this->topLeft();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::topRight()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_topRight_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::topRight()const", __qt_this)
        QPointF __qt_return_value = __qt_this->topRight();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::translate(QPointF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_translate_1native_1cref_1QPointF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::translate(QPointF)", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        __qt_this->translate(__qt_p0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::translate(qreal,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_translate_1native_1qreal_1qreal__JDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble dx0,
 jdouble dy1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::translate(qreal,qreal)", __qt_this)
        __qt_this->translate(static_cast<qreal>(dx0), static_cast<qreal>(dy1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QRectF::translated(QPointF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_translated_1native_1cref_1QPointF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID p0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::translated(QPointF)const", __qt_this)
        const QPointF& __qt_p0 = QtJambiAPI::valueReferenceFromNativeId<QPointF>(p0);
        QRectF __qt_return_value = __qt_this->translated(__qt_p0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::translated(qreal,qreal)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_translated_1native_1qreal_1qreal_1constfct__JDD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble dx0,
 jdouble dy1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::translated(qreal,qreal)const", __qt_this)
        QRectF __qt_return_value = __qt_this->translated(static_cast<qreal>(dx0), static_cast<qreal>(dy1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::transposed()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_transposed_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::transposed()const", __qt_this)
        QRectF __qt_return_value = __qt_this->transposed();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::united(QRectF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_united_1native_1cref_1QRectF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::united(QRectF)const", __qt_this)
        const QRectF& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QRectF>(other0);
        QRectF __qt_return_value = __qt_this->united(__qt_other0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::width()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::width()const", __qt_this)
        qreal __qt_return_value = __qt_this->width();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::x()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_x_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::x()const", __qt_this)
        qreal __qt_return_value = __qt_this->x();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QRectF::y()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_y_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QRectF::y()const", __qt_this)
        qreal __qt_return_value = __qt_this->y();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QRectF_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QRectF *__qt_this = QtJambiAPI::objectFromNativeId<QRectF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QRectF(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QRectF>("QRectF", "io/qt/core/QRectF");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QRectF, {
        ConstructorInfo(&__qt_construct_QRectF, nullptr)
       ,ConstructorInfo(&__qt_construct_QRectF_cref_QPointF_cref_QPointF, "Lio/qt/core/QPointF;Lio/qt/core/QPointF;")
       ,ConstructorInfo(&__qt_construct_QRectF_cref_QPointF_cref_QSizeF, "Lio/qt/core/QPointF;Lio/qt/core/QSizeF;")
       ,ConstructorInfo(&__qt_construct_QRectF_cref_QRect, "Lio/qt/core/QRect;")
       ,ConstructorInfo(&__qt_construct_QRectF_cref_QRectF, "Lio/qt/core/QRectF;")
       ,ConstructorInfo(&__qt_construct_QRectF_qreal_qreal_qreal_qreal, "DDDD")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QRectF);
    registerMetaType<QRectF>("QRectF");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
