#include <QtCore/QtGlobal>
#include <QtCore/qsize.h>
#include <QtCore/QVariant>
#include <QtCore/qdatastream.h>
#include <QtCore/qmargins.h>
#include <QtCore/qnamespace.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QSizeF(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QSizeF")
    QSizeF *_ptr = reinterpret_cast<QSizeF *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QSizeF()
void __qt_construct_QSizeF(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSizeF()")
    Q_UNUSED(__java_arguments)
    QSizeF *__qt_this = new(__qtjambi_ptr) QSizeF();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QSizeF::QSizeF()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_initialize_1native__Lio_qt_core_QSizeF_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSizeF::QSizeF()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSizeF, sizeof(QSizeF), typeid(QSizeF), false, &deleter_QSizeF, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QSizeF(QSize)
void __qt_construct_QSizeF_cref_QSize(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSizeF(QSize)")
    jobject sz0 = __java_arguments[0].l;
    const QSize& __qt_sz0 = qtjambi_cast<const QSize& >(__jni_env, sz0);
    QSizeF *__qt_this = new(__qtjambi_ptr) QSizeF(__qt_sz0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QSizeF::QSizeF(QSize)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_initialize_1native__Lio_qt_core_QSizeF_2Lio_qt_core_QSize_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject sz0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSizeF::QSizeF(QSize)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = sz0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSizeF_cref_QSize, sizeof(QSizeF), typeid(QSizeF), false, &deleter_QSizeF, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QSizeF(QSizeF)
void __qt_construct_QSizeF_cref_QSizeF(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSizeF(QSizeF)")
    jobject other0 = __java_arguments[0].l;
    const QSizeF& __qt_other0 = qtjambi_cast<const QSizeF& >(__jni_env, other0);
    QSizeF *__qt_this = new(__qtjambi_ptr) QSizeF(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QSizeF::QSizeF(QSizeF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_initialize_1native__Lio_qt_core_QSizeF_2Lio_qt_core_QSizeF_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSizeF::QSizeF(QSizeF)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSizeF_cref_QSizeF, sizeof(QSizeF), typeid(QSizeF), false, &deleter_QSizeF, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QSizeF(qreal,qreal)
void __qt_construct_QSizeF_qreal_qreal(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QSizeF(qreal,qreal)")
    jdouble w0 = __java_arguments[0].d;
    Q_UNUSED(w0)
    jdouble h1 = __java_arguments[1].d;
    Q_UNUSED(h1)
    QSizeF *__qt_this = new(__qtjambi_ptr) QSizeF(static_cast<qreal>(w0), static_cast<qreal>(h1));
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QSizeF::QSizeF(qreal,qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_initialize_1native__Lio_qt_core_QSizeF_2DD)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jdouble w0,
 jdouble h1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QSizeF::QSizeF(qreal,qreal)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].d = w0;
        arguments[1].d = h1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QSizeF_qreal_qreal, sizeof(QSizeF), typeid(QSizeF), false, &deleter_QSizeF, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QSizeF
void __qt_destruct_QSizeF(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QSizeF")
    reinterpret_cast<QSizeF*>(ptr)->~QSizeF();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QSizeF::boundedTo(QSizeF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_boundedTo_1native_1cref_1QSizeF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::boundedTo(QSizeF)const", __qt_this)
        const QSizeF& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QSizeF>(arg__1);
        QSizeF __qt_return_value = __qt_this->boundedTo(__qt_arg__1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::expandedTo(QSizeF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_expandedTo_1native_1cref_1QSizeF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::expandedTo(QSizeF)const", __qt_this)
        const QSizeF& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QSizeF>(arg__1);
        QSizeF __qt_return_value = __qt_this->expandedTo(__qt_arg__1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::grownBy(QMarginsF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_grownBy_1native_1QMarginsF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID m0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::grownBy(QMarginsF)const", __qt_this)
        QMarginsF __qt_m0 = QtJambiAPI::valueReferenceFromNativeId<QMarginsF>(m0);
        QSizeF __qt_return_value = __qt_this->grownBy(__qt_m0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::height()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_height_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::height()const", __qt_this)
        qreal __qt_return_value = __qt_this->height();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::isEmpty()const", __qt_this)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::isValid()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_isValid_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::isValid()const", __qt_this)
        __java_return_value = __qt_this->isValid();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::operator*(QSizeF,qreal)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_times_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble c1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::operator*(QSizeF,qreal)", __qt_this)
        QSizeF __qt_return_value = (*__qt_this) * static_cast<qreal>(c1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::operator*=(qreal)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_multiply_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble c0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::operator*=(qreal)", __qt_this)
        (*__qt_this) *= static_cast<qreal>(c0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::operator+(QSizeF,QSizeF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_plus_1native_1cref_1QSizeF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID s21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::operator+(QSizeF,QSizeF)", __qt_this)
        const QSizeF& __qt_s21 = QtJambiAPI::valueReferenceFromNativeId<QSizeF>(s21);
        QSizeF __qt_return_value = (*__qt_this) + __qt_s21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::operator+=(QSizeF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_add_1native_1cref_1QSizeF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::operator+=(QSizeF)", __qt_this)
        const QSizeF& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QSizeF>(arg__1);
        (*__qt_this) += __qt_arg__1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::operator-(QSizeF,QSizeF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_minus_1native_1cref_1QSizeF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID s21)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::operator-(QSizeF,QSizeF)", __qt_this)
        const QSizeF& __qt_s21 = QtJambiAPI::valueReferenceFromNativeId<QSizeF>(s21);
        QSizeF __qt_return_value = (*__qt_this) - __qt_s21;
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::operator-=(QSizeF)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_subtract_1native_1cref_1QSizeF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::operator-=(QSizeF)", __qt_this)
        const QSizeF& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QSizeF>(arg__1);
        (*__qt_this) -= __qt_arg__1;
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::operator/(QSizeF,qreal)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_div_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble c1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::operator/(QSizeF,qreal)", __qt_this)
        QSizeF __qt_return_value = (*__qt_this) / static_cast<qreal>(c1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::operator/=(qreal)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_divide_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble c0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::operator/=(qreal)", __qt_this)
        (*__qt_this) /= static_cast<qreal>(c0);
        __java_return_value = __this;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::operator<<(QDataStream&,QSizeF)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_writeTo_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::operator<<(QDataStream&,QSizeF)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 << (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSizeF::operator==(QSizeF,QSizeF)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_equals_1native_1cref_1QSizeF__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID s21)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::operator==(QSizeF,QSizeF)", __qt_this)
        const QSizeF& __qt_s21 = QtJambiAPI::valueReferenceFromNativeId<QSizeF>(s21);
        __java_return_value = (*__qt_this) == __qt_s21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::operator>>(QDataStream&,QSizeF&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_readFrom_1native_1ref_1QDataStream__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::operator>>(QDataStream&,QSizeF&)", __qt_this)
        QDataStream& __qt_arg__1 = QtJambiAPI::objectReferenceFromNativeId<QDataStream>(__jni_env, arg__1);
        __qt_arg__1 >> (*__qt_this);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSizeF::scale(QSizeF,Qt::AspectRatioMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_scale_1native_1cref_1QSizeF_1Qt_1AspectRatioMode__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID s0,
 jint mode1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::scale(QSizeF,Qt::AspectRatioMode)", __qt_this)
        const QSizeF& __qt_s0 = QtJambiAPI::valueReferenceFromNativeId<QSizeF>(s0);
        Qt::AspectRatioMode __qt_mode1 = qtjambi_cast<Qt::AspectRatioMode>(__jni_env, mode1);
        __qt_this->scale(__qt_s0, Qt::AspectRatioMode(__qt_mode1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSizeF::scale(qreal,qreal,Qt::AspectRatioMode)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_scale_1native_1qreal_1qreal_1Qt_1AspectRatioMode__JDDI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble w0,
 jdouble h1,
 jint mode2)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::scale(qreal,qreal,Qt::AspectRatioMode)", __qt_this)
        Qt::AspectRatioMode __qt_mode2 = qtjambi_cast<Qt::AspectRatioMode>(__jni_env, mode2);
        __qt_this->scale(static_cast<qreal>(w0), static_cast<qreal>(h1), Qt::AspectRatioMode(__qt_mode2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSizeF::scaled(QSizeF,Qt::AspectRatioMode)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_scaled_1native_1cref_1QSizeF_1Qt_1AspectRatioMode_1constfct__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID s0,
 jint mode1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::scaled(QSizeF,Qt::AspectRatioMode)const", __qt_this)
        const QSizeF& __qt_s0 = QtJambiAPI::valueReferenceFromNativeId<QSizeF>(s0);
        Qt::AspectRatioMode __qt_mode1 = qtjambi_cast<Qt::AspectRatioMode>(__jni_env, mode1);
        QSizeF __qt_return_value = __qt_this->scaled(__qt_s0, Qt::AspectRatioMode(__qt_mode1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::scaled(qreal,qreal,Qt::AspectRatioMode)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_scaled_1native_1qreal_1qreal_1Qt_1AspectRatioMode_1constfct__JDDI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble w0,
 jdouble h1,
 jint mode2)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::scaled(qreal,qreal,Qt::AspectRatioMode)const", __qt_this)
        Qt::AspectRatioMode __qt_mode2 = qtjambi_cast<Qt::AspectRatioMode>(__jni_env, mode2);
        QSizeF __qt_return_value = __qt_this->scaled(static_cast<qreal>(w0), static_cast<qreal>(h1), Qt::AspectRatioMode(__qt_mode2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::setHeight(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_setHeight_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble h0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::setHeight(qreal)", __qt_this)
        __qt_this->setHeight(static_cast<qreal>(h0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSizeF::setWidth(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_setWidth_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble w0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::setWidth(qreal)", __qt_this)
        __qt_this->setWidth(static_cast<qreal>(w0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSizeF::shrunkBy(QMarginsF)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_shrunkBy_1native_1QMarginsF_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID m0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::shrunkBy(QMarginsF)const", __qt_this)
        QMarginsF __qt_m0 = QtJambiAPI::valueReferenceFromNativeId<QMarginsF>(m0);
        QSizeF __qt_return_value = __qt_this->shrunkBy(__qt_m0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::toSize()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_toSize_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::toSize()const", __qt_this)
        QSize __qt_return_value = __qt_this->toSize();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::transpose()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_transpose_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::transpose()", __qt_this)
        __qt_this->transpose();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QSizeF::transposed()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_transposed_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::transposed()const", __qt_this)
        QSizeF __qt_return_value = __qt_this->transposed();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QSizeF::width()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_width_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QSizeF::width()const", __qt_this)
        qreal __qt_return_value = __qt_this->width();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QSizeF_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QSizeF *__qt_this = QtJambiAPI::objectFromNativeId<QSizeF>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QSizeF(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QSizeF>("QSizeF", "io/qt/core/QSizeF");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QSizeF, {
        ConstructorInfo(&__qt_construct_QSizeF, nullptr)
       ,ConstructorInfo(&__qt_construct_QSizeF_cref_QSize, "Lio/qt/core/QSize;")
       ,ConstructorInfo(&__qt_construct_QSizeF_cref_QSizeF, "Lio/qt/core/QSizeF;")
       ,ConstructorInfo(&__qt_construct_QSizeF_qreal_qreal, "DD")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QSizeF);
    registerMetaType<QSizeF>("QSizeF");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
