#include <QtCore/QtGlobal>
#include <QtCore/QStringList>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qnamespace.h>
#include <qtcore-config.h>
#if QT_CONFIG(regularexpression)
#include <QtCore/qregularexpression.h>
#endif //QT_CONFIG(regularexpression)

#include <QtJambi/QtJambiAPI>
#include <QtJambiCore/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QStringList(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QStringList")
    QStringList *_ptr = reinterpret_cast<QStringList *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QStringList()
void __qt_construct_QStringList(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QStringList()")
    Q_UNUSED(__java_arguments)
    QList<QString> *__qt_this = new(__qtjambi_ptr) QList<QString>();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QList<QString>::QStringList()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_initialize_1native__Lio_qt_core_QStringList_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QList<QString>::QStringList()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QStringList, sizeof(QStringList), typeid(QStringList), false, QtJambiPrivate::QListAccess<QString>::newInstance(), &deleter_QStringList, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QtJambiStringList(QList<QString>)
void __qt_construct_QStringList_QList(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QtJambiStringList(QList<QString>)")
    QtJambiScope __qtjambi_scope;
    jobject arg__1 = __java_arguments[0].l;
    QList<QString>  __qt_arg__1 = qtjambi_cast<QList<QString> >(__jni_env, __qtjambi_scope, arg__1);
    QList<QString> *__qt_this = new(__qtjambi_ptr) QList<QString>(__qt_arg__1);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QList<QString>::QtJambiStringList(QList<QString>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_initialize_1native__Lio_qt_core_QStringList_2Ljava_util_Collection_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QList<QString>::QtJambiStringList(QList<QString>)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = arg__1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QStringList_QList, sizeof(QStringList), typeid(QStringList), false, QtJambiPrivate::QListAccess<QString>::newInstance(), &deleter_QStringList, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QtJambiStringList(std::initializer_list<QString>)
void __qt_construct_QStringList_std_initializer_list(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QtJambiStringList(std::initializer_list<QString>)")
    QtJambiScope __qtjambi_scope;
    jobjectArray arg__1 = static_cast<jobjectArray>(__java_arguments[0].l);
    std::initializer_list<QString> __qt_arg__1 = qtjambi_cast<std::initializer_list<QString>>(__jni_env, __qtjambi_scope, arg__1);
    QList<QString> *__qt_this = new(__qtjambi_ptr) QList<QString>(__qt_arg__1);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QList<QString>::QtJambiStringList(std::initializer_list<QString>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_initialize_1native__Lio_qt_core_QStringList_2_3Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobjectArray arg__1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QList<QString>::QtJambiStringList(std::initializer_list<QString>)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = arg__1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QStringList_std_initializer_list, sizeof(QStringList), typeid(QStringList), false, QtJambiPrivate::QListAccess<QString>::newInstance(), &deleter_QStringList, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QList<QString>
void __qt_destruct_QStringList(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QList<QString>")
    reinterpret_cast<QList<QString>*>(ptr)->~QList();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QList<QString>::contains(QStringView,Qt::CaseSensitivity)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_contains_1native_1const_1QStringView_1Qt_1CaseSensitivity__Ljava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 jstring str0,
 jint cs1)
{
    QtJambiScope __qtjambi_scope(__jni_env, __this);
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QList<QString> *__qt_this = QtJambiAPI::convertJavaObjectToNative<QList<QString>>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QList<QString>::contains(QStringView,Qt::CaseSensitivity)", __qt_this)
        const QStringView  __qt_str0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, str0);
        Qt::CaseSensitivity __qt_cs1 = qtjambi_cast<Qt::CaseSensitivity>(__jni_env, cs1);
        __java_return_value = __qt_this->contains(__qt_str0, Qt::CaseSensitivity(__qt_cs1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QList<QString>::filter(QRegularExpression)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_filter_1native_1cref_1QRegularExpression__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID re0)
{
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QList<QString> *__qt_this = QtJambiAPI::convertJavaObjectToNative<QList<QString>>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QList<QString>::filter(QRegularExpression)", __qt_this)
        const QRegularExpression& __qt_re0 = QtJambiAPI::valueReferenceFromNativeId<QRegularExpression>(re0);
        QStringList __qt_return_value = __qt_this->filter(__qt_re0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QList<QString>::filter(QStringView,Qt::CaseSensitivity)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_filter_1native_1const_1QStringView_1Qt_1CaseSensitivity__Ljava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 jstring str0,
 jint cs1)
{
    QtJambiScope __qtjambi_scope(__jni_env, __this);
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QList<QString> *__qt_this = QtJambiAPI::convertJavaObjectToNative<QList<QString>>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QList<QString>::filter(QStringView,Qt::CaseSensitivity)", __qt_this)
        const QStringView  __qt_str0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, str0);
        Qt::CaseSensitivity __qt_cs1 = qtjambi_cast<Qt::CaseSensitivity>(__jni_env, cs1);
        QStringList __qt_return_value = __qt_this->filter(__qt_str0, Qt::CaseSensitivity(__qt_cs1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QList<QString>::indexOf(QRegularExpression,qsizetype)
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_indexOf_1native_1cref_1QRegularExpression_1qsizetype__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID re0,
 jlong from1)
{
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        QList<QString> *__qt_this = QtJambiAPI::convertJavaObjectToNative<QList<QString>>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QList<QString>::indexOf(QRegularExpression,qsizetype)", __qt_this)
        const QRegularExpression& __qt_re0 = QtJambiAPI::valueReferenceFromNativeId<QRegularExpression>(re0);
        qsizetype __qt_return_value = __qt_this->indexOf(__qt_re0, static_cast<qsizetype>(from1));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QList<QString>::join(QChar)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_join__C)
(JNIEnv *__jni_env,
 jobject __this,
 jchar sep0)
{
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QList<QString> *__qt_this = QtJambiAPI::convertJavaObjectToNative<QList<QString>>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QList<QString>::join(QChar)", __qt_this)
        QChar __qt_sep0 = qtjambi_cast<QChar>(__jni_env, sep0);
        QString __qt_return_value = __qt_this->join(__qt_sep0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QList<QString>::join(QStringView)
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_join__Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 jstring sep0)
{
    QtJambiScope __qtjambi_scope(__jni_env, __this);
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        QList<QString> *__qt_this = QtJambiAPI::convertJavaObjectToNative<QList<QString>>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QList<QString>::join(QStringView)", __qt_this)
        QStringView  __qt_sep0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, sep0);
        QString __qt_return_value = __qt_this->join(__qt_sep0);
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QList<QString>::lastIndexOf(QRegularExpression,qsizetype)
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_lastIndexOf_1native_1cref_1QRegularExpression_1qsizetype__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID re0,
 jlong from1)
{
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        QList<QString> *__qt_this = QtJambiAPI::convertJavaObjectToNative<QList<QString>>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QList<QString>::lastIndexOf(QRegularExpression,qsizetype)", __qt_this)
        const QRegularExpression& __qt_re0 = QtJambiAPI::valueReferenceFromNativeId<QRegularExpression>(re0);
        qsizetype __qt_return_value = __qt_this->lastIndexOf(__qt_re0, static_cast<qsizetype>(from1));
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QList<QString>::removeDuplicates()
extern "C" Q_DECL_EXPORT jlong JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_removeDuplicates__)
(JNIEnv *__jni_env,
 jobject __this)
{
    jlong __java_return_value{0};
    QTJAMBI_TRY {
        QList<QString> *__qt_this = QtJambiAPI::convertJavaObjectToNative<QList<QString>>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QList<QString>::removeDuplicates()", __qt_this)
        qsizetype __qt_return_value = __qt_this->removeDuplicates();
        __java_return_value = jlong(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QList<QString>::replaceInStrings(QRegularExpression,QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_replaceInStrings_1native_1cref_1QRegularExpression_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID re0,
 jstring after1)
{
    QTJAMBI_TRY {
        QList<QString> *__qt_this = QtJambiAPI::convertJavaObjectToNative<QList<QString>>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QList<QString>::replaceInStrings(QRegularExpression,QString)", __qt_this)
        const QRegularExpression& __qt_re0 = QtJambiAPI::valueReferenceFromNativeId<QRegularExpression>(re0);
        QString  __qt_after1 = qtjambi_cast<QString>(__jni_env, after1);
        __qt_this->replaceInStrings(__qt_re0, __qt_after1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QList<QString>::replaceInStrings(QStringView,QStringView,Qt::CaseSensitivity)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_replaceInStrings_1native_1QStringView_1QStringView_1Qt_1CaseSensitivity__Ljava_lang_String_2Ljava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 jstring before0,
 jstring after1,
 jint cs2)
{
    QtJambiScope __qtjambi_scope(__jni_env, __this);
    QTJAMBI_TRY {
        QList<QString> *__qt_this = QtJambiAPI::convertJavaObjectToNative<QList<QString>>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QList<QString>::replaceInStrings(QStringView,QStringView,Qt::CaseSensitivity)", __qt_this)
        QStringView  __qt_before0 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, before0);
        QStringView  __qt_after1 = qtjambi_cast<QStringView>(__jni_env, __qtjambi_scope, after1);
        Qt::CaseSensitivity __qt_cs2 = qtjambi_cast<Qt::CaseSensitivity>(__jni_env, cs2);
        __qt_this->replaceInStrings(__qt_before0, __qt_after1, Qt::CaseSensitivity(__qt_cs2));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QList<QString>::sort(Qt::CaseSensitivity)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_sort_1native_1Qt_1CaseSensitivity__I)
(JNIEnv *__jni_env,
 jobject __this,
 jint cs0)
{
    QTJAMBI_TRY {
        QList<QString> *__qt_this = QtJambiAPI::convertJavaObjectToNative<QList<QString>>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QList<QString>::sort(Qt::CaseSensitivity)", __qt_this)
        Qt::CaseSensitivity __qt_cs0 = qtjambi_cast<Qt::CaseSensitivity>(__jni_env, cs0);
        __qt_this->sort(Qt::CaseSensitivity(__qt_cs0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QStringList_clone)
(JNIEnv *__jni_env, jobject __this)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QStringList *__qt_this = QtJambiAPI::convertJavaObjectToNative<QStringList>(__jni_env, __this);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QStringList(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QStringList>("QStringList", "io/qt/core/QStringList");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QStringList, {
        ConstructorInfo(&__qt_construct_QStringList, nullptr)
       ,ConstructorInfo(&__qt_construct_QStringList_QList, "Ljava/util/Collection;")
       ,ConstructorInfo(&__qt_construct_QStringList_std_initializer_list, "[Ljava/lang/String;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QStringList);
    registerMetaType<QStringList>("QStringList");
    registerContainerAccessFactory(typeId, NewContainerAccessFunction(&QtJambiPrivate::QListAccess<QString>::newInstance));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
