#include <QtCore/QtGlobal>
#include <QtCore/qurlquery.h>
#include <QtCore/QList>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtCore/qcontainerfwd.h>
#include <QtCore/qurl.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QUrlQuery(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QUrlQuery")
    QUrlQuery *_ptr = reinterpret_cast<QUrlQuery *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QUrlQuery()
void __qt_construct_QUrlQuery(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QUrlQuery()")
    Q_UNUSED(__java_arguments)
    QUrlQuery *__qt_this = new(__qtjambi_ptr) QUrlQuery();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QUrlQuery::QUrlQuery()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_initialize_1native__Lio_qt_core_QUrlQuery_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUrlQuery::QUrlQuery()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QUrlQuery, sizeof(QUrlQuery), typeid(QUrlQuery), false, &deleter_QUrlQuery, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QUrlQuery(QString)
void __qt_construct_QUrlQuery_cref_QString(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QUrlQuery(QString)")
    jstring queryString0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_queryString0 = qtjambi_cast<QString>(__jni_env, queryString0);
    QUrlQuery *__qt_this = new(__qtjambi_ptr) QUrlQuery(__qt_queryString0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QUrlQuery::QUrlQuery(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_initialize_1native__Lio_qt_core_QUrlQuery_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring queryString0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUrlQuery::QUrlQuery(QString)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = queryString0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QUrlQuery_cref_QString, sizeof(QUrlQuery), typeid(QUrlQuery), false, &deleter_QUrlQuery, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QUrlQuery(QUrl)
void __qt_construct_QUrlQuery_cref_QUrl(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QUrlQuery(QUrl)")
    jobject url0 = __java_arguments[0].l;
    const QUrl& __qt_url0 = qtjambi_cast<const QUrl& >(__jni_env, url0);
    QUrlQuery *__qt_this = new(__qtjambi_ptr) QUrlQuery(__qt_url0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QUrlQuery::QUrlQuery(QUrl)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_initialize_1native__Lio_qt_core_QUrlQuery_2Lio_qt_core_QUrl_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject url0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUrlQuery::QUrlQuery(QUrl)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = url0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QUrlQuery_cref_QUrl, sizeof(QUrlQuery), typeid(QUrlQuery), false, &deleter_QUrlQuery, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QUrlQuery(QUrlQuery)
void __qt_construct_QUrlQuery_cref_QUrlQuery(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QUrlQuery(QUrlQuery)")
    jobject other0 = __java_arguments[0].l;
    const QUrlQuery& __qt_other0 = qtjambi_cast<const QUrlQuery& >(__jni_env, other0);
    QUrlQuery *__qt_this = new(__qtjambi_ptr) QUrlQuery(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QUrlQuery::QUrlQuery(QUrlQuery)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_initialize_1native__Lio_qt_core_QUrlQuery_2Lio_qt_core_QUrlQuery_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUrlQuery::QUrlQuery(QUrlQuery)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QUrlQuery_cref_QUrlQuery, sizeof(QUrlQuery), typeid(QUrlQuery), false, &deleter_QUrlQuery, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QUrlQuery(std::initializer_list<std::pair<QString,QString>>)
void __qt_construct_QUrlQuery_std_initializer_list(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QUrlQuery(std::initializer_list<std::pair<QString,QString>>)")
    QtJambiScope __qtjambi_scope;
    jobjectArray list0 = static_cast<jobjectArray>(__java_arguments[0].l);
    std::initializer_list<QPair<QString, QString> > __qt_list0 = qtjambi_cast<std::initializer_list<QPair<QString, QString> >>(__jni_env, __qtjambi_scope, list0);
    QUrlQuery *__qt_this = new(__qtjambi_ptr) QUrlQuery(__qt_list0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QUrlQuery::QUrlQuery(std::initializer_list<std::pair<QString,QString>>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_initialize_1native__Lio_qt_core_QUrlQuery_2_3Lio_qt_core_QPair_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobjectArray list0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUrlQuery::QUrlQuery(std::initializer_list<std::pair<QString,QString>>)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = list0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QUrlQuery_std_initializer_list, sizeof(QUrlQuery), typeid(QUrlQuery), false, &deleter_QUrlQuery, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QUrlQuery
void __qt_destruct_QUrlQuery(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QUrlQuery")
    reinterpret_cast<QUrlQuery*>(ptr)->~QUrlQuery();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QUrlQuery::addQueryItem(QString,QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_addQueryItem_1native_1cref_1QString_1cref_1QString__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0,
 jstring value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::addQueryItem(QString,QString)", __qt_this)
        QString  __qt_key0 = qtjambi_cast<QString>(__jni_env, key0);
        QString  __qt_value1 = qtjambi_cast<QString>(__jni_env, value1);
        __qt_this->addQueryItem(__qt_key0, __qt_value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUrlQuery::allQueryItemValues(QString,QUrl::ComponentFormattingOptions)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_allQueryItemValues_1native_1cref_1QString_1QUrl_1ComponentFormattingOptions_1constfct__JLjava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0,
 jint encoding1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::allQueryItemValues(QString,QUrl::ComponentFormattingOptions)const", __qt_this)
        QString  __qt_key0 = qtjambi_cast<QString>(__jni_env, key0);
        QUrl::ComponentFormattingOptions __qt_encoding1 = qtjambi_cast<QUrl::ComponentFormattingOptions>(__jni_env, encoding1);
        QStringList __qt_return_value = __qt_this->allQueryItemValues(__qt_key0, QUrl::ComponentFormattingOptions(__qt_encoding1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::clear()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_clear_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::clear()", __qt_this)
        __qt_this->clear();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUrlQuery::hasQueryItem(QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_hasQueryItem_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::hasQueryItem(QString)const", __qt_this)
        QString  __qt_key0 = qtjambi_cast<QString>(__jni_env, key0);
        __java_return_value = __qt_this->hasQueryItem(__qt_key0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::isDetached()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_isDetached_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::isDetached()const", __qt_this)
        __java_return_value = __qt_this->isDetached();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::isEmpty()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_isEmpty_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::isEmpty()const", __qt_this)
        __java_return_value = __qt_this->isEmpty();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::operator=(QUrlQuery)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_assign_1native_1cref_1QUrlQuery__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::operator=(QUrlQuery)", __qt_this)
        const QUrlQuery& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QUrlQuery>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUrlQuery::operator==(QUrlQuery)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_equals_1native_1cref_1QUrlQuery_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::operator==(QUrlQuery)const", __qt_this)
        const QUrlQuery& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QUrlQuery>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::query(QUrl::ComponentFormattingOptions)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_query_1native_1QUrl_1ComponentFormattingOptions_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint encoding0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::query(QUrl::ComponentFormattingOptions)const", __qt_this)
        QUrl::ComponentFormattingOptions __qt_encoding0 = qtjambi_cast<QUrl::ComponentFormattingOptions>(__jni_env, encoding0);
        QString __qt_return_value = __qt_this->query(QUrl::ComponentFormattingOptions(__qt_encoding0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::queryItemValue(QString,QUrl::ComponentFormattingOptions)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_queryItemValue_1native_1cref_1QString_1QUrl_1ComponentFormattingOptions_1constfct__JLjava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0,
 jint encoding1)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::queryItemValue(QString,QUrl::ComponentFormattingOptions)const", __qt_this)
        QString  __qt_key0 = qtjambi_cast<QString>(__jni_env, key0);
        QUrl::ComponentFormattingOptions __qt_encoding1 = qtjambi_cast<QUrl::ComponentFormattingOptions>(__jni_env, encoding1);
        QString __qt_return_value = __qt_this->queryItemValue(__qt_key0, QUrl::ComponentFormattingOptions(__qt_encoding1));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::queryItems(QUrl::ComponentFormattingOptions)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_queryItems_1native_1QUrl_1ComponentFormattingOptions_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint encoding0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::queryItems(QUrl::ComponentFormattingOptions)const", __qt_this)
        QUrl::ComponentFormattingOptions __qt_encoding0 = qtjambi_cast<QUrl::ComponentFormattingOptions>(__jni_env, encoding0);
        QList<QPair<QString, QString> > __qt_return_value = __qt_this->queryItems(QUrl::ComponentFormattingOptions(__qt_encoding0));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::queryPairDelimiter()const
extern "C" Q_DECL_EXPORT jchar JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_queryPairDelimiter_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jchar __java_return_value{0};
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::queryPairDelimiter()const", __qt_this)
        QChar __qt_return_value = __qt_this->queryPairDelimiter();
        __java_return_value = __qt_return_value.unicode();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::queryValueDelimiter()const
extern "C" Q_DECL_EXPORT jchar JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_queryValueDelimiter_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jchar __java_return_value{0};
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::queryValueDelimiter()const", __qt_this)
        QChar __qt_return_value = __qt_this->queryValueDelimiter();
        __java_return_value = __qt_return_value.unicode();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::removeAllQueryItems(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_removeAllQueryItems_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::removeAllQueryItems(QString)", __qt_this)
        QString  __qt_key0 = qtjambi_cast<QString>(__jni_env, key0);
        __qt_this->removeAllQueryItems(__qt_key0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUrlQuery::removeQueryItem(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_removeQueryItem_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring key0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::removeQueryItem(QString)", __qt_this)
        QString  __qt_key0 = qtjambi_cast<QString>(__jni_env, key0);
        __qt_this->removeQueryItem(__qt_key0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUrlQuery::setQuery(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_setQuery_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring queryString0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::setQuery(QString)", __qt_this)
        QString  __qt_queryString0 = qtjambi_cast<QString>(__jni_env, queryString0);
        __qt_this->setQuery(__qt_queryString0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUrlQuery::setQueryDelimiters(QChar,QChar)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_setQueryDelimiters_1native_1QChar_1QChar__JCC)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jchar valueDelimiter0,
 jchar pairDelimiter1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::setQueryDelimiters(QChar,QChar)", __qt_this)
        QChar __qt_valueDelimiter0 = qtjambi_cast<QChar>(__jni_env, valueDelimiter0);
        QChar __qt_pairDelimiter1 = qtjambi_cast<QChar>(__jni_env, pairDelimiter1);
        __qt_this->setQueryDelimiters(__qt_valueDelimiter0, __qt_pairDelimiter1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUrlQuery::setQueryItems(QList<std::pair<QString,QString>>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_setQueryItems_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject query0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::setQueryItems(QList<std::pair<QString,QString>>)", __qt_this)
        const QList<QPair<QString, QString> >&  __qt_query0 = qtjambi_cast<const QList<QPair<QString, QString> >& >(__jni_env, __qtjambi_scope, query0);
        __qt_this->setQueryItems(__qt_query0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUrlQuery::swap(QUrlQuery&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_swap_1native_1ref_1QUrlQuery__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::swap(QUrlQuery&)", __qt_this)
        QUrlQuery& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QUrlQuery>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QUrlQuery::toString(QUrl::ComponentFormattingOptions)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_toString_1native_1QUrl_1ComponentFormattingOptions_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint encoding0)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QUrlQuery::toString(QUrl::ComponentFormattingOptions)const", __qt_this)
        QUrl::ComponentFormattingOptions __qt_encoding0 = qtjambi_cast<QUrl::ComponentFormattingOptions>(__jni_env, encoding0);
        QString __qt_return_value = __qt_this->toString(QUrl::ComponentFormattingOptions(__qt_encoding0));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::defaultQueryPairDelimiter()
extern "C" Q_DECL_EXPORT jchar JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_defaultQueryPairDelimiter__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUrlQuery::defaultQueryPairDelimiter()")
    jchar __java_return_value{0};
    QTJAMBI_TRY {
        char16_t __qt_return_value = QUrlQuery::defaultQueryPairDelimiter();
        __java_return_value = jchar(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QUrlQuery::defaultQueryValueDelimiter()
extern "C" Q_DECL_EXPORT jchar JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_defaultQueryValueDelimiter__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QUrlQuery::defaultQueryValueDelimiter()")
    jchar __java_return_value{0};
    QTJAMBI_TRY {
        char16_t __qt_return_value = QUrlQuery::defaultQueryValueDelimiter();
        __java_return_value = jchar(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_core_QUrlQuery_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QUrlQuery *__qt_this = QtJambiAPI::objectFromNativeId<QUrlQuery>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QUrlQuery(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QUrlQuery>("QUrlQuery", "io/qt/core/QUrlQuery");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QUrlQuery, {
        ConstructorInfo(&__qt_construct_QUrlQuery, nullptr)
       ,ConstructorInfo(&__qt_construct_QUrlQuery_cref_QString, "Ljava/lang/String;")
       ,ConstructorInfo(&__qt_construct_QUrlQuery_cref_QUrl, "Lio/qt/core/QUrl;")
       ,ConstructorInfo(&__qt_construct_QUrlQuery_cref_QUrlQuery, "Lio/qt/core/QUrlQuery;")
       ,ConstructorInfo(&__qt_construct_QUrlQuery_std_initializer_list, "[Lio/qt/core/QPair;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QUrlQuery);
    registerMetaType<QUrlQuery>("QUrlQuery");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
